
 ;======================================
 ;    
 ;           MORPHINE
 ;      (C)1997 illusion works
 ;           Written by A.Pichugin
 ;    
 ;              Source is protected by
 ;      russian & international
 ;           copyright laws.
 ;      You can use it in any
 ;           way only with permission
 ;      from copyright holder.
 ;======================================

 			DEVICE	ZXSPECTRUM48

StartBinary=24576

POINTS  EQU  84   ;85 is max!!!
CENTERX EQU  160		+16
CENTERY EQU  96

WINDA   EQU  %01000110
BORDA   EQU  %01000101
PNTRA   EQU  %01001111
SQUAA   EQU  %01000111
SHCOLOR EQU  %00000101

stX0    EQU  15
stY0    EQU  20
stGY0   EQU  4
stGA0   EQU  20480
stH     EQU  3
stW     EQU  16

lsX0    EQU  0
lsY0    EQU  8
lsGY0   EQU  0
lsGA0   EQU  18432
lsH     EQU  15
lsW     EQU  14			-1
lsAG0   EQU  1*32+1+18432
lsAG1   EQU  2*32+1+18432
lsAGN1  EQU  4*32+1+20480
lsAGN   EQU  5*32+1+20480

dnX0    EQU  3
dnY0    EQU  3
dnGY0   EQU  3
dnGA0   EQU  16384
dnH     EQU  3
dnW     EQU  9

KTEMPO  EQU  3

        ;ORG  24573
        ;JP   STARTUP

 ;=====================================
 ; BUFFERS, TABLES AND ARRAYS
 ;=====================================

        ORG  StartBinary;24576;2048
TRASH   DS   256
TRASHH  EQU  TRASH/256
SECT9   EQU  TRASH
DNAME   EQU  SECT9+#F5
FIGURE  DS   768
CUR3D   EQU  FIGURE+128
Y2SCRL  DS   256
Y2SCRA  DS   256
Y2SCRH  DS   256
X2SCRL  DS   256

        ORG  26624;1536
CAT     DS   1536
CATENDH EQU  $/256
CATLEN  EQU  $-CAT

        ORG  28160;768
FIGUREADR
CREEP   DB   0
FLY     DB   0
MAGNIFY DB   0
CREEPSPD DB  0
FLYSPEED DB  0
MAGSPEED DB  0
PITCH   DB   0
YAW     DB   0
ROLL    DB   0
PITCHSPD DB  0
YAWSPEED DB  0
ROLSPEED DB  0
SPACE   DB   0
MORPHSPD DB  0
FASES   DW   0
EXTSTR  EQU  $

        ORG  28928;1280
FIGSIZE EQU  POINTS*3
PNT1    EQU  0*FIGSIZE+$
PNT2    EQU  1*FIGSIZE+$
PNT3    EQU  2*FIGSIZE+$
PNT4    EQU  3*FIGSIZE+$
PNT5    EQU  4*FIGSIZE+$

 ;=====================================
 ; OVERLAY CODE: EXECUTE ONCE
 ;=====================================

OVERLAY
MYUDG   DB   0,255,255,170,0,0,85,0,112
        DB   98,112,98,112,98,112,98,255
        DB   252,194,192,194,192,170,128

UDGH    EQU  MYUDG/256

STARTUP 		DISPLAY	"entry point: ", /D, $
	EI
        LD   A,1
        OUT  (254),A 
        LD   HL,16384
        LD   DE,16385
        LD   BC,6144
        LD   (HL),L
        LDIR
        LD   BC,767
        LD   (HL),%00001001
        LDIR 
        ;LD   HL,CAT
        ;LD   DE,(23796)
        ;LD   (EXTCAT),DE 
        ;LD   BC,(CATLEN/256)*256+#05
        ;CALL 15635
        CALL DSKNAME
        LD   HL,TRASH
        LD   DE,#0000
        LD   BC,#0805
        CALL 15635
        CALL MUSFILE
        CALL FIGFILE
        ;CALL EXTDIR
        LD   HL,X2SCRL
        LD   B,0
TBL0    LD   A,L 
        RRA
        RRA
        RRA
        AND  31
        LD   (HL),A 
        INC  L 
        DJNZ TBL0
        LD   DE,16384
        LD   B,192
TBL1    LD   H,Y2SCRL/256
        LD   A,E 
        LD   (HL),A
        LD   H,Y2SCRA/256
        LD   A,D
        AND  24
        RRA 
        RRA
        RRA
        AND  3
        ADD  A,88
        LD   (HL),A 
        LD   H,Y2SCRH/256
        LD   A,D
        LD   (HL),A
        INC  D
        LD   A,D
        AND  7
        JR   NZ,TBL2
        DEC  L 
        LD   A,(HL) 
        INC  L 
        LD   (HL),A 
        LD   H,Y2SCRL/256
        DEC  L 
        LD   A,(HL) 
        INC  L 
        LD   (HL),A 
        LD   A,E
        ADD  A,32
        LD   E,A
        JR   C,TBL2
        LD   A,D
        SUB  8
        LD   D,A
TBL2    INC  L 
        DJNZ TBL1
        LD   B,64
TBL3    LD   (HL),TRASHH
        INC  L 
        DJNZ TBL3
        CALL PRLOGO
        LD   HL,22528
        LD   DE,22529
        LD   BC,767
        LD   (HL),%00001111
        LDIR 
        LD   HL,dnY0*32+dnX0+22528
        LD   BC,(dnW-2)*256+dnH-2
        CALL FRAME
        LD   DE,dnGY0*32+dnX0+dnGA0
        CALL BORDER
        LD   HL,(dnY0+1)*32+dnX0+dnW+22528
        LD   BC,(dnH-1)*256+dnW
        CALL SHADOW
        LD   HL,(lsY0*32)+lsX0+22528
        LD   BC,(lsW-2)*256+lsH-2
        CALL FRAME
        LD   DE,lsGY0*32+lsX0+lsGA0
        CALL BORDER
        LD   HL,(lsY0+1)*32+lsX0+lsW+22528
        LD   BC,(lsH-1)*256+lsW
        CALL SHADOW
        LD   HL,(stY0*32)+stX0+22528
        LD   BC,(stW-2)*256+stH-2
        CALL FRAME
        LD   DE,stGY0*32+stX0+stGA0
        CALL BORDER
        LD   HL,(stY0+1)*32+stX0+stW+22528
        LD   BC,(stH-1)*256+stW
        CALL SHADOW
			call	CHDISK
        ;CALL SHOWCAT
        CALL MUSINIT
        CALL MORPHIN
        JP   START

MUSFILE LD   DE,MFNAME
        CALL FINDF
        JR   Z,MSF0
        LD   A,B 
        CP   25
        JR   NC,MSF0
        LD   HL,SONGADR
        LD   C,#05
        JP   15635
MSF0    LD   A,201
        LD   (MUSINIT),A
        LD   (MUSPLAY),A
        RET 

FIGFILE LD   DE,FFNAME
        CALL FINDF
        JR   Z,FGF0
        LD   A,B 
        CP   4
        JR   NC,FGF0
        LD   HL,FIGUREADR
        LD   C,#05
        JP   15635
FGF0    LD   A,201
        LD   (MORPHIN),A 
        LD   (ROTATE),A 
        LD   (PROJECT),A 
        LD   (SETBIG),A
        LD   (RESBIG),A
        LD   (RESALL),A
        LD   A,255
        LD   (GOFSTR),A 
        RET 

FINDF   LD   HL,TRASH    ;DE-sample
        LD   A,(FILES)
        LD   C,A 
FIF0    PUSH DE
        PUSH HL 
        LD   B,9
FIF1    LD   A,(DE)
        CP   (HL)
        JR   NZ,FIF2
        INC  DE
        INC  HL
        DJNZ FIF1
        POP  IX
        POP  DE
        LD   B,(IX+#0D)
        LD   E,(IX+#0E)
        LD   D,(IX+#0F)
        OR   #FF
        RET 
FIF2    POP  HL
        LD   DE,16
        ADD  HL,DE 
        POP  DE
        DEC  C
        JR   NZ,FIF0
        XOR  A 
        RET 

MFNAME  DB   "music   C"
FFNAME  DB   "figure  C"

FRAME   LD   DE,256*BORDA+SQUAA
        CALL FRSUB
        PUSH BC 
FRM0    LD   DE,256*WINDA+BORDA
        CALL FRSUB
        DEC  C
        JR   NZ,FRM0
        POP  BC 
        LD   DE,256*BORDA+SQUAA
FRSUB   PUSH BC 
        PUSH HL
        LD   (HL),E
        INC  L 
FRS0    LD   (HL),D 
        INC  L 
        DJNZ FRS0
        LD   (HL),E
        POP  HL
        LD   DE,32
        ADD  HL,DE
        POP  BC 
        RET 

BORDER  LD   HL,256*0+2
        CALL BORDSUB
BRD0    LD   HL,256*#FF+1
        CALL BORDSUB
        DEC  C
        JR   NZ,BRD0
        LD   HL,256*0+2
BORDSUB PUSH BC 
        PUSH DE
        LD   A,L 
        CALL PRC8
BRS0    LD   A,H 
        CALL PRC8
        DJNZ BRS0
        LD   A,L 
        CALL PRC8
        POP  DE 
        CALL NEXTT
        POP  BC 
        RET 

PRC8    CP   #FF
        JR   Z,PRC81
        PUSH BC 
        PUSH HL
        ADD  A,A
        ADD  A,A
        ADD  A,A
        LD   L,A
        LD   H,UDGH
        LD   B,8
        LD   C,D 
PRC80   LD   A,(HL)
        LD   (DE),A
        INC  L
        INC  D
        DJNZ PRC80
        LD   D,C 
        POP  HL 
        POP  BC
PRC81   INC  E 
        RET 

SHADOW  LD   A,SHCOLOR
SHW0    LD   DE,32
        LD   (HL),A 
        ADD  HL,DE
        DJNZ SHW0
        LD   B,C 
SHW1    LD   (HL),A 
        DEC  L 
        DJNZ SHW1
        RET 

;EXTDIR  LD   IX,TRASH
;        LD   A,(ENTRIES)
;        LD   B,A
;        LD   C,0
;EXD0    LD   A,(IX+8)
;        CP   "B"
;        JP   NZ,EXD1
;        LD   A,(IX+0)
;        CP   32
;        JP   C,EXD1
;        CP   "b"
;        JR   NZ,EXD2
;        LD   A,"o"
;        CP   (IX+1)
;        JR   NZ,EXD2
;        CP   (IX+2)
;        JR   NZ,EXD2
;        LD   A,"t"
;        CP   (IX+3)
;        JR   NZ,EXD2
;        LD   A," "
;        CP   (IX+4)
;        JR   NZ,EXD2
;        CP   (IX+5)
;        JR   NZ,EXD2
;        CP   (IX+6)
;        JR   NZ,EXD2
;        CP   (IX+7)
;        JR   Z,EXD1
;EXD2    PUSH BC 
;        PUSH IX 
;        POP  HL 
;        LD   B,4
;        XOR  A 
;EXD3    RRCA 
;        XOR  (HL) 
;        INC  L 
;        DJNZ EXD3
;        LD   C,A 
;        LD   B,4
;EXD4    RRCA 
;        XOR  (HL) 
;        INC  L 
;        DJNZ EXD4
;        LD   B,A 
;        LD   HL,(CUREF)
;        LD   DE,21
;        ADD  HL,DE 
;EXD5    PUSH BC 
;        LD   A,(HL) 
;        CP   C 
;        JR   NZ,EXD6
;        INC  HL 
;        LD   A,(HL) 
;        DEC  HL 
;        CP   B 
;        JR   NZ,EXD6
;        LD   DE,21
;        OR   A 
;        SBC  HL,DE 
;        LD   DE,(CUREF)
;        LD   BC,24
;        LDIR 
;        LD   (CUREF),DE 
;        DEC  DE
;        POP  BC 
;        POP  BC 
;        LD   A,(ENTRIES)
;        SUB  B
;        LD   (DE),A 
;        INC  C 
;        JR   EXD1
;EXD6    POP  BC 
;        LD   DE,24
;        ADD  HL,DE 
;        LD   A,H 
;        CP   CATENDH
;        JR   C,EXD5
;        PUSH BC 
;        LD   DE,(CUREF)
;        PUSH IX 
;        POP  HL
;        LD   BC,8
;        LDIR
;        LD   H,D
;        LD   L,E
;        INC  DE 
;        LD   (HL)," "
;        LD   C,12
;        LDIR
;        LD   (HL),0
;        INC  HL
;        POP  BC
;        LD   (HL),C
;        INC  HL
;        LD   (HL),B
;        INC  HL 
;        POP  BC
;        INC  C 
;        LD   A,(ENTRIES)
;        SUB  B
;        LD   (HL),A 
;        INC  HL
;        LD   (CUREF),HL 
;EXD1    LD   DE,16
;        ADD  IX,DE 
;        LD   A,C 
;        CP   CATLEN/24
;        JR   NC,EXD8
;        DEC  B
;        JP   NZ,EXD0
;EXD8    LD   A,C 
;        LD   (FILES),A 
;        RET 

CUREF   DW   CAT

PRLOGO  LD   HL,LOGO
        LD   DE,4*256+16384+15
        LD   B,29
PRL0    PUSH BC
        PUSH DE
        LD   BC,12
        LDIR
        POP  DE 
        INC  D
        LD   A,D
        AND  7
        JR   NZ,PRL1
        LD   A,E
        ADD  A,32
        LD   E,A
        LD   A,D 
        SUB  8
        LD   D,A 
PRL1    POP  BC 
        DJNZ PRL0
        RET 

LOGO    INSERT "morf.spr"

OVLSIZE EQU  $-OVERLAY

 ;=====================================
 ; MAIN BLOCK
 ;=====================================

        ORG  30208
BEGIN   EQU  $
SINTAB  INSERT "rota.tab"
PROJTAB INSERT "proj.tab"
X2SCRM  DB   128,64,32,16,8,4,2,2
LINEAR  DB   0,1,1,2,3,3,4,4,5,6,6,7,8,8
        DB   9,10,10,11,12,12,13,14,14
        DB   15,16,16,17,18,18,19,20,21
        DB   21,22,23,24,24,25,26,27,28
        DB   28,29,30,31,32,33,34,35,36
        DB   37,38,39,40,41,42,43,45,46
        DB   48,50,51,54,57

kbTRUEV EQU  1
kbINVV  EQU  2
kbEDIT  EQU  3
kbEMODE EQU  4
kbBREAK EQU  27
kbUP    EQU  11
kbDOWN  EQU  10
kbLEFT  EQU  8
kbRIGHT EQU  9
kbENTER EQU  13
kbDEL   EQU  12
 ;  0 - no keys       1 - true video
 ;  2 - inv video     3 - edit
 ;  4 - ext mode      5 - caps/lock
 ;  6 - graph         7 - ss+space
 ;  8 - cursor left   9 - cursor right
 ; 10 - cursor down  11 - cursor up
 ; 12 - delete       13 - enter
 ; 27 - break
KEYTAB  DB   "b","h","y","6","5","t"
        DB   "g","v","n","j","u","7"
        DB   "4","r","f","c","m","k"
        DB   "i","8","3","e","d","x"
        DB     0,"l","o","9","2","w"
        DB   "s","z"," ", 13,"p","0"
        DB   "1","q","a",  0
TABCAPS DB   "B","H","Y", 10,  8,"T"
        DB   "G","V","N","J","U", 11
        DB     2,"R","F","C","M","K"
        DB   "I",  9,  1,"E","D","X"
        DB     4,"L","O",  6,  5,"W"
        DB   "S","Z", 27,  0,"P", 12
        DB     3,"Q","A",  0
TABSHFT DB   "*","^","[","&","%",">"
        DB   "}","/",",","-","]","'"
        DB   "$","<","{","?",".","+"
        DB     0,"(","#",  0,"\\",  0
        DB     0,"=",";",")","@",""
        DB   "|",":",  7,  0, 34,"_"
        DB   "!",  0,"~",  4

FONTOFS INSERT "morf.fnt"
FONT    EQU  FONTOFS+192

OLDPNT  DW   PNT1
CURPNT  DW   PNT2
PREVPNT DW   PNT3
TRACEP  DW   TRACE+6
TRACE   DW   PNT1,PNT2,PNT3,PNT4,PNT5,0

CHARPOS DW   FONT
STRPOS  DW   STRTXT1

KEYCNT  DB   0
CURKEY  DB   0
LASTKEY DB   0

CSHAPE  DB   "_"
CHANGED DB   0
CURCHAR DW   0
CURSOR  DB   0

PNTINFO
SCRPNTA DW   0
MEMPNTA DW   0
CURFILE DB   0
PNTSIZE EQU  $-PNTINFO
PNTINIT DW   (lsY0+1)*32+lsX0+1+22528,CAT
        DB   0

;EXTCAT  DW   0
ENTRIES DB   0
FILES   DB   0

MORPH   DB   0

STRTXT1 DB   "Morphine 1997 ` illusion"
        DB   " works.  Written by A.Pic"
        DB   "hugin.  "
        DB   "Use keys Q, A or Cursor/"
        DB   "Sinclair joystick to sel"
        DB   "ect file; M, ENTER or "
        DB   "Fire - to launch it; "
			db	"SPACE - to re-read the disk catalogue.  "
        ;DB   "Morphine supports long"
        ;DB   " file names (20 character"
        ;DB   "s) on master disk, so use"
        ;DB   " R key to rename.  Read "
        ;DB   "~morphine.W~ to find out "
        ;DB   "futher details.  "
GOFSTR  DB   0
STRTXT2 DB   "Thanks to my brother, my "
        DB   "family and all my friends"
        DB   " for their support.  "
        DB   "Have fun!!!               ",254

 ;=====================================
 ; ENTRY POINT OF MAIN EXECUTION
 ;=====================================
START   LD   HL,PNT1
        LD   DE,PNT1+1
        LD   BC,FIGSIZE*5-1
        LD   (HL),TRASHH
        LDIR 

WAIT    HALT     ;Tick one: rotation
			;xor	a
			;out	(254), a
        CALL MUSPLAY
        CALL STRING
			ld	a, (PRLINE)
			or	a
			jr	z, SkipFewThings
			CALL MORPHIN

        CALL DOMORPH
        CALL DANCE
        CALL ROTATE
        CALL MOVE

SkipFewThings:		call	ScrollUp
			call	ScrollDown
			CALL PRLINE

        ;CALL RESALL
			;ld	a, 0
			;out	(254), a

        ;HALT     ;Tick two: project,reset
;			xor	a
;			out	(254), a
        ;CALL DIALOG
        ;CALL MUSPLAY
        ;CALL STRING
        ;CALL PROJECT
;			ld	a, 2
;			out	(254), a

        HALT     ;Tick three: draw & such
			;xor	a
			;out	(254), a
        CALL KBOARD
        CALL HILITE
        CALL MUSPLAY
        CALL STRING
		        CALL RESALL
			CALL PROJECT
        CALL SETBIG
        CALL RESBIG
        ;CALL MORPHIN
        ;CALL PRLINE
		        CALL DIALOG
        LD   HL,(CURPNT)
        LD   (PREVPNT),HL 
        LD   HL,(OLDPNT)
        LD   (CURPNT),HL 
        LD   HL,(TRACEP)
MRETR   LD   E,(HL) 
        INC  HL 
        LD   D,(HL) 
        INC  HL 
        LD   A,D 
        OR   E 
        JR   NZ,MOK
        LD   HL,TRACE
        JR   MRETR
MOK     LD   (TRACEP),HL 
        LD   (OLDPNT),DE 

			;ld	a, 1
			;out	(254), a
        JR   WAIT
        ;CALL GETKEY
        ;CP   kbBREAK
        ;JR   NZ,WAIT
        ;CALL MUSINIT
        ;XOR  A 
        ;OUT  (254),A 
        ;LD   HL,23295
        ;LD   DE,23294
        ;LD   BC,6911
        ;LD   (HL),A 
        ;LDDR 
        ;RET 

;SAVECAT NOP
;        LD   A,(CHANGED)
;        OR   A 
;        RET  Z
;        LD   HL,CAT
;        LD   DE,(EXTCAT)
;        LD   BC,(CATLEN/256)*256+#06
;        JP   15635

HILITE  LD   A,(FILES)
        OR   A
        RET  Z 
        LD   HL,(lsY0+1)*32+lsX0+1+22528
        LD   DE,32-lsW+2
        LD   C,lsH-2
        LD   A,WINDA
HLT0    LD   B,lsW-2
HLT1    LD   (HL),A
        INC  L
        DJNZ HLT1
        ADD  HL,DE
        DEC  C
        JR   NZ,HLT0
        LD   HL,(SCRPNTA)
        LD   B,lsW-2
HLT2    LD   (HL),PNTRA
        INC  L
        DJNZ HLT2
        RET

TRYUP   CP   "Q"
        RET  Z 
        CP   kbUP
        RET  Z 
        CP   "4"
        RET  Z 
        CP   "9"
        RET

TRYDOWN CP   "A"
        RET  Z 
        CP   kbDOWN
        RET  Z 
        CP   "3"
        RET  Z 
        CP   "8"
        RET 

DIALOG  ;LD   A,0
;EDITING EQU  $-1
        ;OR   A 
        ;JR   Z,NOEDIT
        ;LD   HL,(CURCHAR)
        ;LD   A,(CURSOR)
        ;LD   C,A 
        ;LD   A,(CURKEY)
        ;LD   B,A 
        ;OR   A
        ;JR   Z,ED0
        ;CP   32
        ;JR   C,ED1
        ;LD   A,C 
        ;CP   20
        ;JR   NC,ED0
        ;INC  C 
        ;LD   (HL),B 
        ;INC  HL
        ;JR   ED0
ED1     ;CP   kbDEL
        ;JR   NZ,ED2
        ;LD   A,C 
        ;OR   A
        ;JR   Z,ED0
        ;DEC  C 
        ;CP   20
        ;JR   NC,ED3
        ;LD   (HL)," "
ED3     ;DEC  HL
        ;JR   ED0
ED2     ;CP   kbENTER
        ;JR   NZ,ED0
        ;XOR  A 
        ;LD   (EDITING),A
        ;LD   A,C 
        ;CP   20
        ;JR   Z,ED01
        ;LD   (HL)," "
        ;JR   ED01
ED0     ;LD   A,C 
        ;CP   20
        ;JR   Z,ED01
        ;LD   A,(CSHAPE)
        ;XOR  #7F
        ;LD   (CSHAPE),A
        ;LD   (HL),A 
ED01    ;LD   A,C
        ;LD   (CURSOR),A
        ;LD   (CURCHAR),HL 
        ;LD   HL,(CURLINE)
        ;CALL CLLINE
        ;JP   PRLINE+1
NOEDIT  LD   A,(CURKEY)
        OR   A 
        RET  Z 
        CP   "a"
        JR   C,DIA1
        CP   "z"+1
        JR   NC,DIA1
        SUB  32
DIA1    CP   " "
        JP   Z,CHDISK
        CP   kbEDIT
        JP   Z,CHDISK
        EX   AF,AF'
        LD   A,(FILES)
        OR   A
        RET  Z
        EX   AF,AF'
        CALL TRYUP
        JP   Z,MOVUP
        CALL TRYDOWN
        JP   Z,MOVDOWN
        ;CP   "R"
        ;JR   Z,RENAME
        CP   "M"
        JR   Z,DIA0
        CP   "5"
        JR   Z,DIA0
        CP   "0"
        JR   Z,DIA0
        CP   kbENTER
        RET  NZ 
DIA0
        CALL MUSINIT
        ;CALL SAVECAT
        LD   HL,(MEMPNTA)
        LD   BC,23
        ADD  HL,BC
        LD   A,(HL)
        LD   C,#08
        CALL 15635
			ld	a, 7
        OUT  (254),A
        LD   HL,23295
        LD   DE,23294
        LD   BC,6911
        LD   (HL), %00111111
        LDDR 
			pop	hl
        LD   HL,23773
        ;LD   DE,23963
        ;LD   BC,8
        ;LDIR
        ;POP  HL 
        RET 

;RENAME  NOP
        ;LD   HL,(MEMPNTA)
        ;LD   (CURCHAR),HL
        ;LD   D,H
        ;LD   E,L
        ;INC  DE
        ;LD   BC,19
        ;LD   (HL)," "
        ;LDIR 
        ;LD   HL,(SCRPNTA)
        ;LD   A,H
        ;AND  3
        ;RLCA 
        ;RLCA 
        ;RLCA
        ;OR   64
        ;LD   H,A
        ;LD   (CURLINE),HL 
        ;XOR  A
        ;LD   (CURSOR),A 
        ;DEC  A 
        ;LD   (EDITING),A
        ;LD   (CHANGED),A 
        ;RET 

MOVUP   LD   HL,CURFILE
        LD   A,(HL)
        OR   A
        RET  Z
        DEC  (HL)
        LD   HL,(MEMPNTA)
        LD   DE,24
        OR   A
        SBC  HL,DE
        LD   (MEMPNTA),HL 
        LD   HL,(lsY0+1)*32+lsX0+1+22528
        LD   DE,(SCRPNTA)
        OR   A
        SBC  HL,DE 
        JR   NZ,MVU1

;        LD   DE,lsAGN
;        LD   A,lsH-3
;MVU2    EX   AF,AF'
;        LD   H,D 
;        LD   A,E 
;        SUB  32
;        LD   L,A
;        JR   NC,MVU3
;        LD   A,H
;        SUB  8
;        LD   H,A 
;MVU3    PUSH HL 
;        LD   XL,E
;        LD   A,L
;        LD   BC,#08FF
;MVU4    LDI 
;        LDI
;        LDI
;        LDI
;        LDI         ;5
;        LDI
;        LDI
;        LDI
;        LDI
;        LDI         ;10
;        LDI
;        LDI         ;12
;        LD   E,XL
;        LD   L,A
;        INC  D
;        INC  H
;        DJNZ MVU4
;        POP  DE
;        EX   AF,AF'
;        DEC  A
;        JR   NZ,MVU2

        XOR  A 
        LD   (PRLINE),A 
			ld	(ScrollDown), a
			ret
;        JR   CLLINE
MVU1    EX   DE,HL
        LD   DE,32
        OR   A
        SBC  HL,DE 
        LD   (SCRPNTA),HL 
        RET 

MOVDOWN ;LD   HL,CURFILE
        ;LD   A,(FILES)
        ;SUB  2
        ;CP   (HL) 
        ;RET  C 
			ld	a, (FILES)
			cp	2
			ret	c
			dec	a
			ld	hl, CURFILE
			cp	(hl)		; a bug in directory listings
			ret	z
        INC  (HL) 
        LD   HL,(MEMPNTA)
        LD   DE,24
        ADD  HL,DE 
        LD   (MEMPNTA),HL 
        LD   HL,(lsY0+lsH-2)*32+lsX0+1+22528
        LD   DE,(SCRPNTA)
        OR   A 
        SBC  HL,DE
        JR   NZ,MVD1

;        LD   DE,lsAG0
;        LD   A,lsH-3
;MVD2    EX   AF,AF'
;        LD   H,D 
;        LD   A,E 
;        ADD  A,32
;        LD   L,A
;        JR   NC,MVD3
;        LD   A,H
;        ADD  A,8
;        LD   H,A 
;MVD3    PUSH HL
;        LD   XL,E
;        LD   A,L
;        LD   BC,#08FF
;MVD4    LDI 
;        LDI
;        LDI
;        LDI
;        LDI         ;5
;        LDI
;        LDI
;        LDI
;        LDI
;        LDI         ;10
;        LDI
;        LDI         ;12
;        LD   E,XL
;        LD   L,A
;        INC  D
;        INC  H
;        DJNZ MVD4
;        POP  DE
;        EX   AF,AF'
;        DEC  A
;        JR   NZ,MVD2

        XOR  A 
        LD   (PRLINE),A
			ld	(ScrollUp), a
			ret
;        JR   CLLINE
MVD1    LD   HL,32
        ADD  HL,DE 
        LD   (SCRPNTA),HL 
        RET 

CLLINE  PUSH BC
        PUSH HL 
        LD   B,8
CLL0    XOR  A 
        LD   C,L 
        LD   (HL),A 
        INC  L 
        LD   (HL),A 
        INC  L 
        LD   (HL),A 
        INC  L 
        LD   (HL),A 
        INC  L 
        LD   (HL),A    ;5
        INC  L 
        LD   (HL),A 
        INC  L 
        LD   (HL),A 
        INC  L 
        LD   (HL),A 
        INC  L 
        LD   (HL),A 
        INC  L 
        LD   (HL),A    ;10
        INC  L 
        LD   (HL),A 
        ;INC  L 
        ;LD   (HL),A    ;12
        LD   L,C 
        INC  H
        DJNZ CLL0
        POP  HL
        POP  BC 
        RET 

ScrollUp:		ret
			ld	a, 201
			ld	(ScrollUp), a
        LD   DE,lsAG0
        LD   A,lsH-3
MVD2    EX   AF,AF'
        LD   H,D 
        LD   A,E 
        ADD  A,32
        LD   L,A
        JR   NC,MVD3
        LD   A,H
        ADD  A,8
        LD   H,A 
MVD3    PUSH HL
        LD   XL,E
        LD   A,L
        LD   BC,#08FF
MVD4    LDI 
        LDI
        LDI
        LDI
        LDI         ;5
        LDI
        LDI
        LDI
        LDI
        LDI         ;10
        LDI
        LDI         ;12
        LD   E,XL
        LD   L,A
        INC  D
        INC  H
        DJNZ MVD4
        POP  DE
        EX   AF,AF'
        DEC  A
        JR   NZ,MVD2
        LD   HL,lsAGN
        LD   (CURLINE),HL 
			jp	CLLINE

ScrollDown:		ret
			ld	a, 201
			ld	(ScrollDown), a
        LD   DE,lsAGN
        LD   A,lsH-3
MVU2    EX   AF,AF'
        LD   H,D 
        LD   A,E 
        SUB  32
        LD   L,A
        JR   NC,MVU3
        LD   A,H
        SUB  8
        LD   H,A 
MVU3    PUSH HL 
        LD   XL,E
        LD   A,L
        LD   BC,#08FF
MVU4    LDI 
        LDI
        LDI
        LDI
        LDI         ;5
        LDI
        LDI
        LDI
        LDI
        LDI         ;10
        LDI
        LDI         ;12
        LD   E,XL
        LD   L,A
        INC  D
        INC  H
        DJNZ MVU4
        POP  DE
        EX   AF,AF'
        DEC  A
        JR   NZ,MVU2
        LD   HL,lsAG0
        LD   (CURLINE),HL 
			jp	CLLINE

KBOARD  LD   HL,KEYCNT
        CALL GETKEY
        JR   NZ,KBD0
        LD   (LASTKEY),A ;no keys
        LD   (CURKEY),A 
        LD   (HL),A
        RET
KBD0    LD   C,A
        LD   A,(HL)
        OR   A 
        JR   Z,KBD1
        DEC  (HL) 
        LD   A,(LASTKEY)
        SUB  C 
        JR   NZ,KBD2
        LD   (CURKEY),A 
        RET 
KBD1    LD   A,(LASTKEY)
        OR   A
        JR   NZ,KBD3     ;auto repeat
KBD2    LD   (HL),KTEMPO ;first press
KBD3    LD   A,C 
        LD   (LASTKEY),A
        LD   (CURKEY),A 
        RET 

GETKEY  PUSH BC 
        PUSH HL 
        CALL GETSCAN  ;copy of 654
        LD   BC,40
        LD   A,B 
        JR   NZ,GTK0
        LD   A,E 
        CP   C 
        LD   A,B 
        JR   NC,GTK0
        LD   HL,KEYTAB
        LD   A,D 
        INC  A 
        JR   Z,GTK1
        ADD  HL,BC 
        SUB  25
        JR   NZ,GTK1
        ADD  HL,BC 
GTK1    LD   A,E 
        ADD  A,L 
        LD   L,A 
        ADC  A,H 
        SUB  L 
        LD   H,A 
        LD   A,(HL) 
GTK0    OR   A 
        POP  HL 
        POP  BC 
        RET 

GETSCAN LD   L,47
        LD   DE,65535
        LD   BC,65278
GTS0    IN   A,(C) 
        CPL 
        AND  31
        JR   Z,GTS3
        LD   H,A 
        LD   A,L 
GTS1    INC  D 
        RET  NZ 
GTS2    SUB  8
        SRL  H 
        JR   NC,GTS2
        LD   D,E 
        LD   E,A 
        JR   NZ,GTS1
GTS3    DEC  L 
        RLC  B 
        JR   C,GTS0
        LD   A,D 
        INC  A 
        RET  Z 
        CP   40
        RET  Z 
        CP   25
        RET  Z 
        LD   A,E 
        LD   E,D 
        LD   D,A 
        CP   24
        RET 

CHDISK  ;LD   A,201
        ;LD   (RENAME),A
        ;LD   (SAVECAT),A
        LD   BC,#FFFD
        LD   A,7
        OUT  (C),A
        IN   A,(C)
        LD   (MIXER),A
        LD   B,#BF
        LD   A,%00111111
        OUT  (C),A 
        LD   C,#18
        CALL 15635
        CALL DSKNAME

DIRLIST LD   HL,lsAG0
        LD   B,lsH-2
DLS0    CALL CLLINE
        LD   A,L
        ADD  A,32
        LD   L,A
        JR   NC,DLS1
        LD   A,H
        ADD  A,8
        LD   H,A
DLS1    DJNZ DLS0
        LD   A,(ENTRIES)
        LD   C,A        ;C-files num
        LD   B,0        ;B-sec
        LD   DE,CAT     ;DE-dest
LST0    PUSH BC 
        PUSH DE 
        LD   D,0
        LD   E,B
        LD   HL,TRASH
        LD   BC,#0105
        CALL 15635
        POP  DE 
        POP  BC 
        LD   IX,TRASH   ;sec ofs
LST1    LD   A,(IX+8)
        CP   "B"
        JR   NZ,LST2
        LD   A,(IX+0)
        CP   " "
        JR   C,LST2
        PUSH BC 
        PUSH IX
        POP  HL
        LD   BC,8
        LDIR 
        LD   H,D
        LD   L,E
        INC  DE
        LD   (HL)," "
        LD   C,12
        LDIR
        LD   (HL),0
        INC  DE
        INC  DE
        POP  BC 
        LD   A,(ENTRIES)
        SUB  C
        LD   (DE),A 
        INC  DE 
        LD   A,D 
        CP   CATENDH
        JR   NC,LST3
LST2    DEC  C          ;files num
        JR   Z,LST3
        LD   A,XL 
        ADD  A,16
        LD   XL,A       ;sec ofs +=16
        JR   NZ,LST1
        INC  B
        JR   LST0       ;next sec
LST3    EX   DE,HL
        LD   DE,24
        LD   C,D
LST4    LD   A,L 
        OR   A 
        JR   NZ,LST5
        LD   A,H
        CP   CAT/256
        JR   Z,LST6
LST5    OR   A
        SBC  HL,DE 
        INC  C 
        JR   LST4
LST6    LD   A,C
        LD   (FILES),A

SHOWCAT LD   A,(FILES)
        OR   A 
        RET  Z 
        LD   B,13
        CP   B
        JR   NC,SHC0
        LD   B,A
SHC0    LD   HL,CAT
        LD   DE,(lsGY0+1)*32+lsX0+1+lsGA0
SHC1    PUSH BC 
        PUSH DE
        PUSH HL 
        LD   BC,#5E80
        CALL PRSTR
        POP  HL
        LD   DE,24
        ADD  HL,DE 
        POP  DE 
        CALL NEXTT
        POP  BC 
        DJNZ SHC1
        LD   HL,PNTINIT
        LD   DE,PNTINFO
        LD   BC,PNTSIZE
        LDIR 
        LD   BC,#FFFD
        LD   A,7
        OUT  (C),A
        LD   B,#BF
        LD   A,%00111111
MIXER   EQU  $-1
        OUT  (C),A 
        RET 

DSKNAME LD   HL,SECT9
        LD   DE,#0008
        LD   BC,#0105
        CALL 15635
        LD   A,(SECT9+#E4)
        LD   (ENTRIES),A 
        LD   HL,(dnGY0+1)*32+dnX0+1+dnGA0
        LD   C,8
        XOR  A
DNM4    LD   E,L 
        LD   B,dnW-2
DNM5    LD   (HL),A
        INC  L 
        DJNZ DNM5
        LD   L,E
        INC  H
        DEC  C
        JR   NZ,DNM4
        XOR  A 
        LD   (DNAME+8),A
        LD   IX,0
        LD   HL,DNAME
        PUSH HL 
        LD   B,8
DNM0    LD   A,(HL)
        SUB  32
        INC  L 
        PUSH HL 
        ADD  A,A 
        LD   L,A
        LD   H,0
        LD   DE,FONTOFS
        ADD  HL,DE 
        LD   E,(HL)
        INC  HL
        LD   D,(HL)
        INC  HL
        LD   A,(HL)
        INC  HL
        LD   H,(HL)
        LD   L,A 
        OR   A
        SBC  HL,DE
        EX   DE,HL
        ADD  IX,DE 
        POP  HL
        DJNZ DNM0
        LD   DE,(dnGY0+1)*32+dnX0+1+dnGA0
        LD   A,(dnW-2)*8-4
        SUB  XL 
        JR   NC,DNM1
        XOR  A 
DNM1    SRL  A 
        ADD  A,2
DNM2    CP   8
        JR   C,DNM3
        SUB  8
        INC  E
        JR   DNM2
DNM3    LD   L,A
        LD   H,X2SCRM/256
        LD   C,(HL) 
        POP  HL 
        LD   B,(dnW-2)*8-4
        JR   PRSTR

NEXTT   LD   A,E 
        ADD  A,32
        LD   E,A 
        RET  NC
        LD   A,D
        ADD  A,8
        LD   D,A
        RET 

PRLINE  NOP 
        LD   A,201
        LD   (PRLINE),A
        LD   HL,(MEMPNTA)
        LD   DE,0
CURLINE EQU  $-2
        LD   BC,#5E80

PRSTR   LD   A,(HL)
        INC  HL
        OR   A
        RET  Z
        SUB  32
        PUSH HL
        PUSH BC 
        ADD  A,A
        LD   L,A
        LD   H,0
        LD   BC,FONTOFS
        ADD  HL,BC
        LD   A,(HL)
        INC  HL
        LD   H,(HL)
        LD   L,A
        LD   BC,FONT
        ADD  HL,BC
        POP  BC
PRS1    RRC  C
        JR   NC,PRS2
        INC  E 
PRS2    LD   A,(HL) 
        INC  HL 
        CP   255
        JR   Z,PRS0
        RLCA 
        JR   NC,$+7
        EX   AF,AF'
        LD   A,(DE)
        OR   C
        LD   (DE),A
        EX   AF,AF'
        INC  D 
        RLCA 
        JR   NC,$+7
        EX   AF,AF'
        LD   A,(DE)
        OR   C
        LD   (DE),A
        EX   AF,AF'
        INC  D 
        RLCA 
        JR   NC,$+7
        EX   AF,AF'
        LD   A,(DE)
        OR   C
        LD   (DE),A
        EX   AF,AF'
        INC  D 
        RLCA 
        JR   NC,$+7
        EX   AF,AF'
        LD   A,(DE)
        OR   C
        LD   (DE),A
        EX   AF,AF'
        INC  D 
        RLCA 
        JR   NC,$+7
        EX   AF,AF'
        LD   A,(DE)
        OR   C
        LD   (DE),A
        EX   AF,AF'
        INC  D 
        RLCA 
        JR   NC,$+7
        EX   AF,AF'
        LD   A,(DE)
        OR   C
        LD   (DE),A
        EX   AF,AF'
        INC  D 
        RLCA 
        JR   NC,$+7
        EX   AF,AF'
        LD   A,(DE)
        OR   C
        LD   (DE),A
        EX   AF,AF'
        INC  D 
        RLCA 
        JR   NC,$+7
        EX   AF,AF'
        LD   A,(DE)
        OR   C
        LD   (DE),A
        EX   AF,AF'
        LD   A,D 
        SUB  7
        LD   D,A 
        DJNZ PRS1
        POP  HL
        RET 
PRS0    POP  HL 
        DJNZ PRSTR
        RET 

STRING  LD   HL,(CHARPOS)
        LD   A,(HL)
        INC  HL
        CP   255
        JR   NZ,STR1
        LD   HL,(STRPOS)
STR00   LD   A,(HL) 
        INC  HL 
        OR   A 
        JR   NZ,STR01
        LD   HL,EXTSTR
        JR   STR00
STR01   CP   255
        JR   NZ,STR02
        LD   HL,STRTXT2
        JR   STR00
STR02   CP   254
        JR   NZ,STR03
        LD   HL,STRTXT1
        JR   STR00
STR03   LD   (STRPOS),HL 
        SUB  32
        ADD  A,A
        LD   L,A
        LD   H,0
        LD   BC,FONTOFS
        ADD  HL,BC
        LD   A,(HL)
        INC  HL
        LD   H,(HL) 
        LD   L,A
        LD   BC,FONT
        ADD  HL,BC 
        XOR  A 
STR1    LD   (CHARPOS),HL 
        LD   HL,(stGY0+1)*32+stX0+stW-2+stGA0
        LD   B,8
STR2    RLA 
        LD   C,L 
        RL   (HL)
        DEC  L 
        RL   (HL)
        DEC  L 
        RL   (HL) 
        DEC  L 
        RL   (HL) 
        DEC  L 
        RL   (HL) ;5
        DEC  L 
        RL   (HL) 
        DEC  L 
        RL   (HL) 
        DEC  L 
        RL   (HL) 
        DEC  L 
        RL   (HL) 
        DEC  L 
        RL   (HL) ;10
        DEC  L 
        RL   (HL) 
        DEC  L 
        RL   (HL) 
        DEC  L 
        RL   (HL) ;13
			dec	l
			rl	(hl) ;14
        LD   L,C 
        INC  H 
        DJNZ STR2
        RET 

GETSIN  PUSH HL 
        LD   L,B   ;B - factor
        LD   C,#7E
        BIT  7,A   ;A - angle
        JR   Z,GSN0
        LD   C,#96
GSN0    AND  127
        CP   64
        JR   C,GSN1
        NEG
        ADD  A,127
GSN1    ADD  A,SINTAB/256
        LD   H,A
        LD   A,C
        LD   (GSN2),A
        XOR  A 
GSN2    NOP
        POP  HL 
        RET 

SETPITCH PUSH BC 
        LD   C,A 
        LD   B,#7E ;LD A,(HL) for +
        BIT  7,A 
        JR   Z,SPCH0
        LD   B,#96 ;SUB (HL) for -
SPCH0   AND  127
        CP   64
        JR   C,SPCH1
        NEG 
        ADD  A,127
SPCH1   ADD  A,SINTAB/256
        LD   (pitch2),A 
        LD   A,B 
        LD   (pitch3),A 
        LD   (pitch4),A 
        LD   A,C
        ADD  A,64
        LD   B,#7E
        BIT  7,A 
        JR   Z,SPCH2
        LD   B,#96
SPCH2   AND  127
        CP   64
        JR   C,SPCH3
        NEG
        ADD  A,127
SPCH3   ADD  A,SINTAB/256
        LD   (pitch0),A 
        LD   (pitch5),A 
        LD   A,B
        LD   (pitch1),A 
        LD   (pitch6),A 
        POP  BC 
        RET 

SETYAW  PUSH BC 
        LD   C,A 
        LD   B,#7E
        BIT  7,A 
        JR   Z,STY0
        LD   B,#96
STY0    AND  127
        CP   64
        JR   C,STY1
        NEG 
        ADD  A,127
STY1    ADD  A,SINTAB/256
        LD   (yaw2),A 
        LD   A,B 
        LD   (yaw3),A 
        LD   (yaw4),A 
        LD   A,C
        ADD  A,64
        LD   B,#7E
        BIT  7,A 
        JR   Z,STY2
        LD   B,#96
STY2    AND  127
        CP   64
        JR   C,STY3
        NEG
        ADD  A,127
STY3    ADD  A,SINTAB/256
        LD   (yaw0),A
        LD   (yaw5),A 
        LD   A,B
        LD   (yaw1),A 
        LD   (yaw6),A 
        POP  BC 
        RET 

SETROLL PUSH BC 
        LD   C,A 
        LD   B,#7E
        BIT  7,A 
        JR   Z,STRL0
        LD   B,#96
STRL0   AND  127
        CP   64
        JR   C,STRL1
        NEG 
        ADD  A,127
STRL1   ADD  A,SINTAB/256
        LD   (roll2),A 
        LD   A,B 
        LD   (roll3),A 
        LD   (roll4),A 
        LD   A,C
        ADD  A,64
        LD   B,#7E
        BIT  7,A 
        JR   Z,STRL2
        LD   B,#96
STRL2   AND  127
        CP   64
        JR   C,STRL3
        NEG
        ADD  A,127
STRL3   ADD  A,SINTAB/256
        LD   (roll0),A 
        LD   (roll5),A 
        LD   A,B 
        LD   (roll1),A 
        LD   (roll6),A 
        POP  BC 
        RET 

ROTATE  NOP 
        EXX 
        PUSH HL 
        LD   HL,FIGURE
        LD   DE,CUR3D
        LD   B,POINTS
ROT0    LD   A,(HL)
        INC  H
        INC  H
        INC  D
        INC  D
        EXX
        LD   L,A
        LD   H,64
yaw0    EQU  $-1
        XOR  A
yaw1    NOP
        LD   D,A
        LD   H,0
yaw2    EQU  $-1
        XOR  A
yaw3    NOP 
        LD   E,A
        EXX
        LD   A,(HL)
        DEC  H
        EXX
        LD   L,A
        XOR  A
yaw4    NOP
        ADD  A,D
        LD   C,A
        LD   H,64
yaw5    EQU  $-1
        XOR  A 
yaw6    NOP
        SUB  E
        LD   L,A
        LD   H,64
pitch0  EQU  $-1
        XOR  A
pitch1  NOP
        LD   E,A 
        LD   H,0
pitch2  EQU  $-1
        XOR  A
pitch3  NOP
        LD   D,A
        EXX
        LD   A,(HL)
        DEC  H
        EXX
        LD   L,A
        XOR  A
pitch4  NOP
        ADD  A,E
        EXX
        LD   (DE),A 
        DEC  D
        EXX
        LD   H,64
pitch5  EQU  $-1
        XOR  A
pitch6  NOP
        SUB  D
        LD   L,A
        LD   H,64
roll0   EQU  $-1
        XOR  A
roll1   NOP
        LD   D,A
        LD   H,0
roll2   EQU  $-1
        XOR  A
roll3   NOP
        LD   E,A
        LD   L,C
        XOR  A
roll4   NOP
        ADD  A,D
        EXX 
        LD   (DE),A
        DEC  D
        EXX 
        LD   H,64
roll5   EQU  $-1
        XOR  A
roll6   NOP
        SUB  E
        EXX 
        LD   (DE),A 
        INC  L 
        INC  E 
        DJNZ ROT0
        POP  HL
        EXX 
        RET 

MOVE    LD   A,(SPACE)
        LD   B,A 
        LD   HL,CREEP
        LD   A,(CREEPSPD)
        ADD  A,(HL) 
        LD   (HL),A 
        CALL GETSIN
        LD   (shiftx),A
        INC  HL 
        LD   A,(FLYSPEED)
        ADD  A,(HL) 
        LD   (HL),A 
        CALL GETSIN
        LD   (shifty),A
        INC  HL 
        LD   A,(MAGSPEED)
        ADD  A,(HL) 
        LD   (HL),A 
        CALL GETSIN
        ADD  A,128
        LD   (magnify),A 
        RET 

DANCE   LD   HL,PITCH
        LD   A,(PITCHSPD)
        ADD  A,(HL) 
        LD   (HL),A 
        CALL SETPITCH
        INC  HL 
        LD   A,(YAWSPEED)
        ADD  A,(HL) 
        LD   (HL),A 
        CALL SETYAW
        INC  HL 
        LD   A,(ROLSPEED)
        ADD  A,(HL) 
        LD   (HL),A 
        JP   SETROLL

PROJECT NOP 
        EXX 
        PUSH HL
        LD   DE,(CURPNT)
        EXX
        LD   HL,CUR3D
        LD   B,POINTS
PRJ0    INC  H
        INC  H
        LD   A,(HL) 
        ADD  A,128
magnify EQU  $-1
        RRA
        RRA
        RRA
        AND  31
        ADD  A,PROJTAB/256
        LD   D,A
        DEC  H
        LD   A,(HL)
        ADD  A,0
shifty  EQU  $-1
        LD   E,A
        LD   A,(DE)
        ADD  A,CENTERY
        EXX
        LD   H,Y2SCRL/256
        LD   L,A
        LD   C,(HL)
        INC  H
        LD   B,(HL)
        INC  H
        LD   A,(HL)
        INC  H
        EX   AF,AF'
        EXX
        DEC  H
        LD   A,(HL)
        ADD  A,0
shiftx  EQU  $-1
        LD   E,A
        LD   A,(DE)
        ADD  A,CENTERX
        EXX
        LD   L,A 
        LD   A,(HL)
        OR   C
        LD   C,A
        LD   A,(BC)
        AND  64
        JR   Z,PRJ1
        LD   A,TRASHH
        EX   AF,AF'
PRJ1    LD   A,C 
        LD   (DE),A 
        INC  DE
        EX   AF,AF'
        LD   (DE),A
        INC  DE
        LD   H,X2SCRM/256
        LD   A,L 
        AND  7
        LD   L,A 
        LD   A,(HL)
        LD   (DE),A 
        INC  DE
        EXX
        INC  L
        DJNZ PRJ0
        POP  HL
        EXX
        RET 

SETBIG  NOP 
        DI 
        LD   (SBSTACK),SP 
        LD   SP,(CURPNT)
        LD   BC,POINTS*256+TRASHH
STB0    POP  HL 
        DEC  SP
        POP  DE 
        LD   A,D
        RRCA
        OR   D
        LD   D,A 
        XOR  (HL) 
        LD   (HL),A
        LD   A,H 
        CP   C 
        JR   Z,STB1
        INC  H 
        LD   A,(HL)
        XOR  D 
        LD   (HL),A 
STB1    DJNZ STB0
        LD   SP,0
SBSTACK EQU  $-2
        EI
        RET 

RESBIG  NOP 
        DI 
        LD   (RBSTACK),SP 
        LD   SP,(PREVPNT)
        LD   BC,POINTS*256+TRASHH
RSB0    POP  HL 
        DEC  SP
        POP  DE 
        LD   A,D
        RRCA
        XOR  (HL)
        LD   (HL),A
        LD   A,H 
        CP   C 
        JR   Z,RSB1
        INC  H 
        LD   A,D
        RRCA
        OR   D 
        XOR  (HL) 
        LD   (HL),A 
RSB1    DJNZ RSB0
        LD   SP,0
RBSTACK EQU  $-2
        EI 
        RET 

RESALL  NOP 
        DI 
        LD   (RASTACK),SP 
        LD   SP,(OLDPNT)
        LD   B,POINTS/4
RSA0    POP  HL 
        DEC  SP 
        POP  AF 
        XOR  (HL)
        LD   (HL),A 
        POP  HL 
        DEC  SP
        POP  AF 
        XOR  (HL)
        LD   (HL),A 
        POP  HL 
        DEC  SP
        POP  AF 
        XOR  (HL)
        LD   (HL),A 
        POP  HL 
        DEC  SP
        POP  AF 
        XOR  (HL)
        LD   (HL),A 
        DJNZ RSA0
        LD   SP,0
RASTACK EQU  $-2
        EI
        RET 

DOMORPH LD   HL,MORPH
        LD   A,(MORPHSPD)
        ADD  A,(HL)
        LD   (HL),A
        RRA
        RRA
        AND  63
        ADD  A,8
        LD   L,A
        LD   H,LINEAR/256
        LD   A,(HL)
        ADD  A,SINTAB/256
        LD   (MFASE),A
        RET 

MORPHIN NOP 
        LD   A,(PRLINE)
        OR   A
        RET  Z
        DI
        LD   (MFSTACK),SP
        LD   HL,FIGUREADR
        LD   SP,(FASES)
        ADD  HL,SP
        LD   SP,HL 
        LD   BC,FIGURE
        LD   H,SINTAB/256
MFASE   EQU  $-1
        LD   XL,POINTS
MRF0    POP  DE 
        LD   A,D
        SUB  E
        LD   L,A
        LD   A,E
        ADD  A,(HL) 
        LD   (BC),A
        INC  B 
        POP  DE 
        LD   A,D
        SUB  E
        LD   L,A
        LD   A,E
        ADD  A,(HL)
        LD   (BC),A
        INC  B 
        POP  DE 
        LD   A,D
        SUB  E
        LD   L,A
        LD   A,E
        ADD  A,(HL)
        LD   (BC),A
        DEC  B 
        DEC  B
        INC  C 
        DEC  XL 
        JR   NZ,MRF0
        LD   SP,0
MFSTACK EQU  $-2
        EI
        RET 

MUSINIT NOP 
        JP   STMINIT

MUSPLAY NOP
        JP   STMPLAY

PROGEND EQU  $
PROGLEN EQU  $-BEGIN

        ORG  58300
FREE    EQU  $-PROGEND
STMINIT INSERT "stp.bin"
STMPLAY EQU  STMINIT+6
        ORG  59392
SONGADR EQU  $

			SAVEBIN	"morphine.bin", StartBinary, $-StartBinary





