﻿;basic loader creator 3.1 (tr-dos/tape editions) for Alasm 5.x only!
;© 2010-2011, 2013 all rights reserved by faster/hlm

LoaderVersion	EQU	1				;0/1 - формат бейсик-строки в бейсик-программе
							;0 - RUN USR "28.04.2013" для (TR-DOS)
							;1 - RUN USR (PEEK 0*0+PEEK 0+0) для (TR-DOS/TAPE)
FalseLength	EQU	0				;0/1 - флаг значения длины бейсик-программы в дескрипторе файла
							;0 - действительная длина, 1 - фальшивая (нулевая) длина
CopyrightLine	EQU	1				;0/1 - не использовать/использовать текст сообщения в бейсик-строке
MessageLine	EQU	1				;0/1 - не использовать/использовать пространство до конца сектора
;-
NumberLine	EQU	0				;номер бейсик-строки (от 16384-65535 - защита от команды MERGE "")
StartLine	EQU	NumberLine			;номер строки автостарта

		ORG	#5CDD				;системная переменная TR-DOS - имя файла в ASCII, тип файла (для подпрограммы #1BC8)
		DB	"BLC v3.1","B"			;имя файла с расширением "B"

		MACRO	ReleaseDate			;дата релиза программы
		DB	"28.04.2013"			;или прочий текст (обязательно должен начинаться с цифры!)
		ENDM
		
		MACRO	CopyrightText			;текст сообщения в бейсик-строке
		DB	AT,0,0				;адрес вывода сообщения на экран
		DB	BRIGHT,1,PAPER,0,INK,4
		DB   "    Basic Loader Creator 3.1    " ;первая строка
		DB	INK,6
		DB   "  (c) 28.o4.2o13 by faster/hlm  " ;вторая строка
		DB	INK,#FF				;вводим ошибочное значение, чтобы скрыть дальнейшее отображение бейсик-программы
		ENDM

		MACRO	UnusedSpace			;свободное пространство до конца сектора (UNUSED SPACE)
		DB   ":: (c) 2010-2011,2013 Basic Load" ;строка 64 байта, но размер зависит от свободного места
		DB   "er Creator v3.1 by Faster/HLM ::"	;надо после первого прохода ассемблера проверять!
		ENDM

		MACRO	CodeLoader			;код загрузчика
		LOCAL					;локальные метки

		LD	A,(PROG)			;проверяем запущена ли программа в TR-DOS
		CP	#3B
		JR	Z,Tr-Dos			;запущена в TR-DOS
		...	...				;запущена не в TR-DOS, например в TAPE

		ENDL
		ENDM
;-
INK		EQU	#10				;управляющие коды для использования в бейсик-программе
PAPER		EQU	#11
FLASH		EQU	#12
BRIGHT		EQU	#13
INVERSE		EQU	#14
OVER		EQU	#15
AT		EQU	#16
TAB		EQU	#17
;-
VARS		EQU	#5C4B				;адрес начала области переменных бейсик-программы
PROG		EQU	#5C53				;адрес начала бейсик-программы
E_LINE		EQU	#5C59				;адрес начала редактируемой строки
;-
		ORG	VARS				;системная переменная Basic 48 для подпрограммы #1BC8
		IF0	FalseLength
		DW	BasicLineEnd			;устанавливем действительную длину файла в дескрипторе или
		ELSE
		DW	BasicLine			;обнуляем длину файла в дескрипторе
		ENDIF

		ORG	#5CE8				;системная переменная TR-DOS
		DW	BasicLineEnd-BasicLine		;устанавливаем длину файла

		ORG	#8000

		DI
		LD	HL,BasicLine			;начало программы
		LD	DE,BasicLineEnd-BasicLine	;вычисляем длину программы
		SCF
		ADC	HL,DE
		LD	(E_LINE),HL			;системная переменная Basic 48 для подпрограммы #1BC8
		LD	HL,BasicStart			;начало программы
		LD	C,#B				;код функции записи файла
		CALL	#3D13
		RET
;-
BasicStart	DISP	#5D3B				;начало бейсик-программы (#5D3B - для TR-DOS, #5CCB - для +3DOS и TAPE)

BasicLine	DB	'NumberLine,.NumberLine		;2 байта номера строки
		DW	BasicLineEnd-BasicLoader	;2 байта длины бейсик-строки

BasicLoader	DB	#F7,#C0				;RUN USR
		IF0	LoaderVersion
		ReleaseDate				;то, что отображается после USR (обязательно должно начинаться с цифры!)
		DB	#E				;префикс, разделяющий символьную форму
		DB	0,0,.Code,'Code,0		;и пять байт цифрового значения 
		ELSE
		DB	"(",#BE				;(PEEK
		DB	"0",#E,0,0,#54,#5C,0		;23636
		DB	"*","0",#E,0,0,0,#1,0		;*256
		DB	"+",#BE				;+PEEK
		DB	"0",#E,0,0,#53,#5C,0		;23635
		DB	"+"				;+
		DB	"0"				;смещение от начала бейсик-строки до непосредственно кода
		DB	#E				;префикс, разделяющий символьную форму
		DB	0,0,.Code,'Code,0		;и пять байт цифрового значения
		DB	")"				;)
		ENDIF
		IFN
		CopyrightText
		ELSE
		DB	INK,#FF
		ENDIF
;-
		IFN	LoaderVersion
Code		EQU	$-BasicLine
		CodeLoader
		ELSE
Code		CodeLoader
		ENDIF
;-		
		DB	#D				;конец бейсик-строки
BasicLineEnd	DB	#80,#AA				;2 байта префикса конца бейсик-файла
		DW	StartLine			;2 байта номера строки автостарта
;-
		IFN	MessageLine
		UnusedSpace	
		ENDIF		

		DS	#100				;заполняем 0, чтобы не было мусора
;-	
		Length=(BasicLineEnd-BasicLine)
		LengthSec=.Length/#100+#1
		DISPLAY
		DISPLAY	"Длина бейсик-программы:",/D,Length," байт(а/ов),",/D,LengthSec," сектор(а/ов)"
		IF0	FalseLength
		DISPLAY	"В дескрипторе файла указана реальная длина!"
		ELSE
		DISPLAY	"В дескрипторе файла указана фальшивая (нулевая) длина!"
		ENDIF
		DISPLAY	"Свободное место до конца сектора:",/D,LengthSec*#100-Length," байт(а/ов)"