	DEVICE ZXSPECTRUM48

	macro EXEC fun
	LD HL, COMMAND
	INC HL
	LD DE, fun
	LD (HL), E
	INC HL
	LD (HL), D
	CALL EXEC_COMMAND
	.endm
	
START	EQU #8000
RDATA	EQU #9C40

	ORG START
	
	EXEC command0
	EXEC command1
	EXEC command2
	EXEC command3
	EXEC command4
	EXEC command5
	RET
	
BETA_DATA        EQU #83; порт данных ВГ93 на Кворуме
BETA_COMMAND     EQU #80; порт состояния/команд ВГ93 на Кворуме
BETA_FDD    EQU #85; порт управления дисководом
	
EXEC_COMMAND
	
	DI

	LD HL, RDATA
	
	; включаем мотор
	LD BC, BETA_FDD
	LD A, 32
	OUT (C), A
	
	LD BC, BETA_COMMAND
	XOR A
	OUT (C), A ; команда на восстановление

COMMAND ; адрес перехода по этому CALL меняется в макросе EXEC
	CALL 0000

	OUT (C), A

READ_STATUS
	IN A, (C) ; в A - статус
	LD (HL), A
	INC HL
	XOR A
	CP H
	JP NZ, READ_STATUS
	
	; выключаем мотор
	LD BC, BETA_FDD
	XOR A
	OUT (C), A
	
	LD HL, RDATA
	LD C, (HL)
	CALL PRINT_CURRENT
	INC HL
	
PRINT_LOOP
	LD B, (HL)
	LD A, C
	CP B
	CALL NZ, PRINT_LOOP_2
	
	INC HL
	XOR A
	CP H
	JP NZ, PRINT_LOOP

	; перевод строки
	LD A, #0D
	RST #10

	EI
	RET

PRINT_LOOP_2
	CALL PRINT_CURRENT
	LD C, B
	RET

PRINT_CURRENT ; печать в hex пары чисел HL:(HL)
	CALL PHEX_W
	LD A, ':'
	RST #10
	LD A, (HL)
	CALL PHEX_B
	LD A, ' '
	RST #10
	RET

	
COMMAND_COUNT EQU 1
	
	;--- print in HEX system ---
;
PHEX_W  ;Печать шестнадцатеричного числа в HL3 (0000..FFFF)
        LD      A,H           ;печать старшего байта числа
        CALL    PHEX_B        ;вызов процедуры HEX-печати байта
        LD      A,L           ;печать младшего байта числа
;
PHEX_B  ;Печать шестнадцатеричного числа в A3 (00..FF)
        CALL    PHEX_HB       ;печать по полубайтам
;
PHEX_HB ;Печать старшего полубайта в A3 (0..F)
        RRCA                  ;меняем
        RRCA                  ; местами
        RRCA                  ; старший
        RRCA                  ; и младший полубайты
;
PHEX_LB ;Печать младшего полубайта в A3 (0..F)
        PUSH    AF            ;сохранили A на стеке
        AND     #0F           ;отбросили лишние старшие биты
        CP      #0A           ;если A<10,
        JR      C,GO_PHL      ; то перепрыгнули
        ADD     A,"A"-"9"-1   ;корректировка: после "9" идет "A"
GO_PHL  ADD     A,"0"         ;перевод в ASCII-код
        RST     #10           ;печать HEX-цифры ("0".."F")
        POP     AF            ;восстановили A со стека
        RET                   ;выход из процедуры
	
; тестируемые команды

; восстановление
command0
	LD BC, BETA_COMMAND
	XOR A ; восстановление
	RET

; прерывание
command1
	LD BC, BETA_DATA
	LD A, 80
	OUT (C), A ; 80 дорожка
	LD BC, BETA_COMMAND
	LD A, #10 ; команда на поиск дорожки
	OUT (C), A
	LD BC, BETA_COMMAND
	LD A, #D1 ; немедленное прерывание
	RET

; переход на дорожку
command2
	LD BC, BETA_DATA
	LD A, 20
	OUT (C), A ; 20 дорожка
	LD BC, BETA_COMMAND
	LD A, #10 ; команда на поиск дорожки
	RET
	
; шаг вперед
command3
	LD BC, BETA_COMMAND
	LD A, #40 ; команда на шаг вперед
	RET

; шаг назад
command4
	LD BC, BETA_COMMAND
	LD A, #60 ; команда на шаг назад
	RET

;шаг (предыдущий был вперед)
command5
	LD BC, BETA_COMMAND
	LD A, #40 ; команда на шаг вперед
	OUT (C), A
	LD A, #20 ; шаг
	RET
	
	
	
	
END

	savebin "main.bin", START, END-START
