	DEVICE ZXSPECTRUM48

	macro EXEC fun
	LD HL, COMMAND
	INC HL
	LD DE, fun
	LD (HL), E
	INC HL
	LD (HL), D
	CALL EXEC_COMMAND
	.endm
	
	macro WAIT_VG93_READY
.rloop ; ждем выполнения команды
	IN A, (C)
	AND #01
	JP NZ, .rloop
	CALL WAIT_A_LOT
	.endm
	
START	EQU #8000

	ORG START
	
	EXEC command0
	EXEC command1
	EXEC command2
	EXEC command3
	EXEC command4
	EXEC command5
	EXEC command6
	RET
	
BETA_DATA        EQU #83; порт данных ВГ93 на Кворуме
BETA_COMMAND     EQU #80; порт состояния/команд ВГ93 на Кворуме
BETA_FDD         EQU #85; порт управления дисководом
	
EXEC_COMMAND
	
	DI

	LD HL, RDATA
	
	; включаем мотор, выбираем диск A
	LD BC, BETA_FDD
	LD A, #21
	OUT (C), A
	
	LD BC, BETA_COMMAND
	XOR A
	OUT (C), A ; команда на восстановление

	WAIT_VG93_READY

COMMAND ; адрес перехода по этому CALL меняется в макросе EXEC
	CALL 0000

	OUT (C), A

READ_STATUS
	IN A, (C) ; в A - статус
	LD (HL), A
	INC HL
	XOR A
	CP H
	JP NZ, READ_STATUS
	
	WAIT_VG93_READY
	; пишем в ячейку FFFF текущее значение порта состояния (после длительной паузы)
	LD BC, BETA_COMMAND
	IN A, (C)
	LD (#FFFF), A
	
	; выключаем мотор
	LD BC, BETA_FDD
	XOR A
	OUT (C), A
	
	LD HL, RDATA
	CALL PRINT_STATUS_LINE

	EI
	RET

PRINT_LOOP_2
	CALL PRINT_CURRENT
	LD C, B
	RET

; тестируемые команды

; восстановление
command0
	LD BC, BETA_COMMAND
	XOR A ; восстановление
	RET

; прерывание
command1
	LD BC, BETA_DATA
	LD A, 80
	OUT (C), A ; 80 дорожка
	
	WAIT_VG93_READY
	
	LD BC, BETA_COMMAND
	LD A, #10 ; команда на поиск дорожки
	OUT (C), A
	LD BC, BETA_COMMAND
	LD A, #D1 ; немедленное прерывание
	RET

; переход на дорожку
command2
	LD BC, BETA_DATA
	LD A, 20
	OUT (C), A ; 20 дорожка
	
	WAIT_VG93_READY
	
	LD BC, BETA_COMMAND
	LD A, #10 ; команда на поиск дорожки
	RET
	
; шаг вперед
command3
	LD BC, BETA_COMMAND
	LD A, #40 ; команда на шаг вперед
	RET

; шаг назад
command4
	LD BC, BETA_COMMAND
	LD A, #60 ; команда на шаг назад
	RET

;шаг (предыдущий был вперед)
command5
	LD BC, BETA_COMMAND
	LD A, #40 ; команда на шаг вперед
	OUT (C), A
	
	WAIT_VG93_READY
	LD BC, BETA_COMMAND
	
	LD A, #20 ; шаг
	RET

; чтение сектора
command6
	LD BC, BETA_COMMAND
	LD A, #80 ; команда на чтение
	RET

	include "print.asm"
	include "hex_print.asm"
	
	LD BC, #FFFF
WAIT_A_LOT
	LD A, (BC)
	DEC BC
	LD A, B
	OR C
	JP NZ, WAIT_A_LOT
	RET
	
END
RDATA
	savebin "main.bin", START, END-START
