using System;
using System.IO;

class Program
{
    static void Main()
    {
        using (var ifs = new FileStream("SprinterHDD.img", FileMode.Open, FileAccess.Read, FileShare.Read))
        using (var ofs = new FileStream("SprinterHDD-Mod2.hdd", FileMode.Create, FileAccess.Write, FileShare.Read))
        {
            var mbr = new byte[0x200];
            mbr[0x1FE] = 0x55;
            mbr[0x1FF] = 0xAA;
            mbr[0x1BE + 0] = 0x80;  // 0x80=active, 0x00=inactive
            mbr[0x1BE + 1] = 0x01;  // First H
            mbr[0x1BE + 2] = 0x01;  // First S (with high C)
            mbr[0x1BE + 3] = 0x00;  // First C
            mbr[0x1BE + 4] = 0x06;  // Partition type FAT16 > 65536 sectors
            mbr[0x1BE + 5] = 0xFE;  // Last H
            mbr[0x1BE + 6] = 0x3F;  // Last S (with high C)
            mbr[0x1BE + 7] = 0x81;  // Last C 
            mbr[0x1BE + 8] = 0x01;  // First sector
            mbr[0x1BE + 9] = 0x00;
            mbr[0x1BE + 10] = 0x00;
            mbr[0x1BE + 11] = 0x00;
            mbr[0x1BE + 12] = (byte)(((ifs.Length / 512) >> 0) & 0xFF); // sector count
            mbr[0x1BE + 13] = (byte)(((ifs.Length / 512) >> 8) & 0xFF);
            mbr[0x1BE + 14] = (byte)(((ifs.Length / 512) >> 16) & 0xFF);
            mbr[0x1BE + 15] = (byte)(((ifs.Length / 512) >> 24) & 0xFF);
            ofs.Write(mbr, 0, mbr.Length);
            var data = new byte[(int)ifs.Length];
            ifs.Read(data, 0, data.Length);
            ofs.Write(data, 0, data.Length);
        }
    }
}
