;
; QUORUM IFF2 tester v2 by Alex Makeev
;

	device zxspectrum128
;------------------------------------------------------------------------------
	org	#0000
start:
	push	af
	push	bc
	push	de
	push	hl

; save current IFF1/IFF2 into #8000 (may be unstable)
	ld	a,i
	push	af
	pop	bc
	ld	a,c
	and	#04
	rrc	a
	rrc	a
	ld	e,a
	ld	a,r
	push	af
	pop	bc
	ld	a,c
	and	#04
	rrc	a
	or	e
	ld	(#8000),a

; wait INT...
WAIT_INT:
	ld	a,i
	jp	pe,WAIT_INT
	
	ld	b,#80
	djnz	$

; save IFF1/IFF2 into #8001 (stable)
	ld	a,i
	push	af
	pop	bc
	ld	a,c
	and	#04
	rrc	a
	rrc	a
	ld	e,a
	ld	a,r
	push	af
	pop	bc
	ld	a,c
	and	#04
	rrc	a
	or	e
	ld	(#8001),a

	di
	nop

; save IFF1/IFF2 into #8002
	ld	a,i
	push	af
	pop	bc
	ld	a,c
	and	#04
	rrc	a
	rrc	a
	ld	e,a
	ld	a,r
	push	af
	pop	bc
	ld	a,c
	and	#04
	rrc	a
	or	e
	ld	(#8002),a

; restore regs
	pop	hl
	pop	de
	pop	bc
	ld	a,#60
	jp	EXIT

	org	#0064
	db	#c1,#f1
	jp	#start

	org	#006F
EXIT:
	out 	(0),a
	halt		; <- should be never executed

;------------------------------------------------------------------------------
	;savesna "iff2-v2.sna",start

	;emptytrd "iff2-v2.trd"
	;savetrd "iff2-v2.trd", "iff2test.C", start, $-start

	savebin "iff2-v2.bin", start, $-start
