﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using ZXMAK2.Engine;
using ZXMAK2.Interfaces;

namespace ZXMAK2.Controls.Configuration
{
    public partial class CtlSettingsJoystick : ConfigScreenControl
    {
        private BusManager m_bmgr;
        private IJoystickDevice m_device;

        public CtlSettingsJoystick()
        {
            InitializeComponent();
        }

        private void BindJoysticks()
        {
            var selectedJoystickId = m_device.AssignedHostJoystick;
            var list = ZXMAK2.MDX.DirectJoystick.GetHostJoysticks();
            cmbHostJoysticks.Items.Clear();
            cmbHostJoysticks.Items.Add(new HostJoystickInfo() { Id = Guid.Empty, Name = "NONE" });
            foreach (var item in list)
            {
                cmbHostJoysticks.Items.Add(item);
                
                if (item.Id == selectedJoystickId)
                    cmbHostJoysticks.SelectedItem = item;
            }

            if (cmbHostJoysticks.SelectedIndex < 0)
                cmbHostJoysticks.SelectedIndex = 0;
        }

        public void Init(BusManager bmgr, IJoystickDevice device)
        {
            m_bmgr = bmgr;
            m_device = device;

            BindJoysticks();
        }

        public override void Apply()
        {
            m_device.AssignedHostJoystick = (cmbHostJoysticks.SelectedItem as HostJoystickInfo).Id;
        }
    }
}
