﻿using System;
using ZXMAK2.Interfaces;
using ZXMAK2.Engine;
using ZXMAK2.Entities;

namespace ZXMAK2.Hardware.General
{
    public class KempstonJoystick : BusDeviceBase, IJoystickDevice
    {
        #region Fields

        private IMemoryDevice m_memory;
        private Guid m_assignedHostJoystick;

        #endregion Fields

        #region BusDeviceBase

        public override string Name { get { return "JOYSTICK KEMPSTON"; } }
        public override string Description { get { return "Kempston Joystick"; } }
        public override BusDeviceCategory Category { get { return BusDeviceCategory.Other; } }

        public override void BusInit(IBusManager bmgr)
        {
            m_memory = bmgr.FindDevice<IMemoryDevice>();
            bmgr.SubscribeRdIo(0x00e0, 0x0000, ReadPort1F);
        }

        public override void BusConnect()
        {
        }

        public override void BusDisconnect()
        {
        }

        protected override void OnConfigSave(System.Xml.XmlNode itemNode)
        {
            base.OnConfigSave(itemNode);
            Utils.SetXmlAttribute(itemNode, "UID", AssignedHostJoystick.ToString());
        }

        protected override void OnConfigLoad(System.Xml.XmlNode itemNode)
        {
            base.OnConfigLoad(itemNode);
            var joystickInstanceId = new Guid(Utils.GetXmlAttributeAsString(itemNode, "UID", Guid.Empty.ToString()));
            AssignedHostJoystick = joystickInstanceId;
        }

        #endregion BusDeviceBase

        #region IJoystickDevice

        public IJoystickState JoystickState { get; set; }

        public Guid AssignedHostJoystick
        {
            get
            {
                return m_assignedHostJoystick;
            }
            set
            {
                if (m_assignedHostJoystick != Guid.Empty)
                    ZXMAK2.MDX.DirectJoystick.DetachJoystick(m_assignedHostJoystick);
                if (value != Guid.Empty)
                    ZXMAK2.MDX.DirectJoystick.AttachJoystick(value);
                m_assignedHostJoystick = value;
            }
        }

        #endregion

        protected virtual void ReadPort1F(ushort addr, ref byte value, ref bool iorqge)
        {
            if (!iorqge || m_memory.DOSEN)
            {
                return;
            }
            iorqge = false;

            value = 0x00;

            if (JoystickState == null)
                return;

            if (JoystickState.IsLeft) value |= 0x01;
            if (JoystickState.IsRight) value |= 0x02;
            if (JoystickState.IsUp) value |= 0x04;
            if (JoystickState.IsDown) value |= 0x08;
            if (JoystickState.IsFire) value |= 0x10;
        }
    }
}
