
;.ORG	0X2000+0X00*32						; RLC B          [ CB00 ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB00:			BST		B,7					; ROM35/RAM36
				LSL		B					; ROM36/RAM37
				BLD		B,0					; ROM37/RAM38
				MOV		RES,B				; ROM38/RAM39
				RJMP	COMSHFT_CB			; ROM35/RAM36


;.ORG	0X2000+0X01*32						; RLC C          [ CB01 ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB01:			BST		C,7					; ROM35/RAM36
				LSL		C					; ROM36/RAM37
				BLD		C,0					; ROM37/RAM38
				MOV		RES,C				; ROM38/RAM39
				RJMP	COMSHFT_CB			; ROM35/RAM36


;.ORG	0X2000+0X02*32						; RLC D          [ CB02 ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB02:			BST		D,7					; ROM35/RAM36
				LSL		D					; ROM36/RAM37
				BLD		D,0					; ROM37/RAM38
				MOV		RES,D				; ROM38/RAM39
				RJMP	COMSHFT_CB			; ROM35/RAM36


;.ORG	0X2000+0X03*32						; RLC E          [ CB03 ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB03:			BST		E,7					; ROM35/RAM36
				LSL		E					; ROM36/RAM37
				BLD		E,0					; ROM37/RAM38
				MOV		RES,E				; ROM38/RAM39
				RJMP	COMSHFT_CB			; ROM35/RAM36


;.ORG	0X2000+0X04*32						; RLC H          [ CB04 ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB04:			BST		H,7					; ROM35/RAM36
				LSL		H					; ROM36/RAM37
				BLD		H,0					; ROM37/RAM38
				MOV		RES,H				; ROM38/RAM39
				RJMP	COMSHFT_CB			; ROM35/RAM36


;.ORG	0X2000+0X05*32						; RLC L          [ CB05 ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB05:			BST		L,7					; ROM35/RAM36
				LSL		L					; ROM36/RAM37
				BLD		L,0					; ROM37/RAM38
				MOV		RES,L				; ROM38/RAM39
				RJMP	COMSHFT_CB			; ROM35/RAM36


;.ORG	0X2000+0X06*32						; RLC (HL)       [ CB06 ] 15 (69-90) SZHVNC
											;                                      0P0  
EXCB06:			BRCS	TIMECORCB06			; 36
TIMECORCB06:	MOVW	ZL,L				; 37
				CPI		ZH,0X40				; 38
				BRCC	FROMRAMCB06			; 39 /> 40
				OR		ZH,ROMID			; 40
				ELPM	RES,Z				; 43
				DELAY2						; 45
				RJMP	COMCB06				; 47
FROMRAMCB06:	LOAD_RES_Z[7]				; 47
COMCB06:		BST		RES,7				; 48
				LSL		RES					; 49
				BLD		RES,0				; 50
				MOVW	ZL,RES				; 51
				LD		F,Z					; 52
				BLD		F,CC				; 53
				MOVW	ZL,L				; 54
				CPI		ZH,0X40				; 55
				BRCS	TOROMCB06			; 56 /> 57
				SAVE_RES_Z_[10]				; 66
				JMP		M1_-T15+68			; 69 ??? (+1)
TOROMCB06:		JMP		M1-T15+60			; 60


;.ORG	0X2000+0X07*32						; RLC A          [ CB07 ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB07:			BST		A,7					; ROM35/RAM36
				LSL		A					; ROM36/RAM0
				BLD		A,0					; ROM0/RAM1
				MOV		RES,A				; ROM1/RAM2
				RJMP	COMSHFT_CB			; ROM3/RAM4
COMSHFT_CB:		MOVW	ZL,RES				; ROM4/RAM5
				LD		F,Z					; ROM6/RAM7
				BLD		F,CC				; ROM7/RAM8
				STUFF37_3					; 
				M1H_INTEN[3]				; ROM10/RAM11
				BRCS	FROMROMCB07		; 12<>
				M1L_RAM[12]					; 24 ??? (+8)
FROMROMCB07:	M1L_ROM_SHORT[12]			; 24 ??? (+8)


;.ORG	0X2000+0X08*32						; RRC B          [ CB08 ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB08:			BST		B,0					; ROM35/RAM36
				LSR		B					; ROM36/RAM37
				BLD		B,7					; ROM37/RAM38
				MOV		RES,B				; ROM38/RAM39
				RJMP	COMSHFT_CB			; ROM35/RAM36


;.ORG	0X2000+0X09*32						; RRC C          [ CB09 ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB09:			BST		C,0					; ROM35/RAM36
				LSR		C					; ROM36/RAM37
				BLD		C,7					; ROM37/RAM38
				MOV		RES,C				; ROM38/RAM39
				RJMP	COMSHFT_CB			; ROM35/RAM36


;.ORG	0X2000+0X0A*32						; RRC D          [ CB0A ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB0A:			BST		D,0					; ROM35/RAM36
				LSR		D					; ROM36/RAM37
				BLD		D,7					; ROM37/RAM38
				MOV		RES,D				; ROM38/RAM39
				RJMP	COMSHFT_CB			; ROM35/RAM36


;.ORG	0X2000+0X0B*32						; RRC E          [ CB0B ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB0B:			BST		E,0					; ROM35/RAM36
				LSR		E					; ROM36/RAM37
				BLD		E,7					; ROM37/RAM38
				MOV		RES,E				; ROM38/RAM39
				RJMP	COMSHFT_CB			; ROM35/RAM36


;.ORG	0X2000+0X0C*32						; RRC H          [ CB0C ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB0C:			BST		H,0					; ROM35/RAM36
				LSR		H					; ROM36/RAM37
				BLD		H,7					; ROM37/RAM38
				MOV		RES,H				; ROM38/RAM39
				RJMP	COMSHFT_CB			; ROM35/RAM36


;.ORG	0X2000+0X0D*32						; RRC L          [ CB0D ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB0D:			BST		L,0					; ROM35/RAM36
				LSR		L					; ROM36/RAM37
				BLD		L,7					; ROM37/RAM38
				MOV		RES,L				; ROM38/RAM39
				RJMP	COMSHFT_CB			; ROM35/RAM36


;.ORG	0X2000+0X0E*32						; RRC (HL)       [ CB0E ] 15 (69-90) SZHVNC
											;                                      0P0  
EXCB0E:			MOVW	ZL,L				; ROM35/RAM36
				CPI		ZH,0X40				; ROM36/RAM37
				BRCC	FROMRAMCB0E			; ROM37/RAM38 /> ROM38/RAM39
				OR		ZH,ROMID			; ROM38/RAM39
				ELPM	RES,Z				; ROM41/RAM42
				DELAY2						; ROM43/RAM44
				RJMP	COMCB0E				; ROM45/RAM46
FROMRAMCB0E:	LOAD_RES_Z[7]				; ROM45/RAM46
COMCB0E:		BST		RES,0				; ROM46/RAM47
				LSR		RES					; ROM47/RAM48
				BLD		RES,7				; ROM48/RAM49
				MOVW	ZL,RES				; ROM49/RAM50
				LD		F,Z					; ROM51/RAM52
				BLD		F,CC				; ROM52/RAM53
				MOVW	ZL,L				; ROM53/RAM54
				CPI		ZH,0X40				; ROM54/RAM55
				BRCS	TOROMCB0E			; ROM55/RAM56 /> ROM56/RAM57
				SAVE_RES_Z_[10]				; ROM65/RAM66
				JMP		M1_-T15+68			; ROM68/RAM69
TOROMCB0E:		BRCS	TIMECORCB0E			; 58<>
TIMECORCB0E:	JMP		M1-T15+61			; 61


;.ORG	0X2000+0X0F*32						; RRC A          [ CB0F ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB0F:			BST		A,0					; ROM35/RAM36
				LSR		A					; ROM36/RAM37
				BLD		A,7					; ROM37/RAM38
				MOV		RES,A				; ROM38/RAM39
				RJMP	COMSHFT_CB			; ROM35/RAM36


;.ORG	0X2000+0X10*32						; RL B           [ CB10 ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB10:			OUT		SREG,F				; ROM35/RAM36
				ROL		B					; ROM36/RAM37
				MOV		RES,B				; ROM37/RAM38
				RJMP	COMRLRR_CB			; ROM39/RAM40


;.ORG	0X2000+0X11*32						; RL C           [ CB11 ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB11:			CBR		F,1<<II				; ROM35/RAM36
				OUT		SREG,F				; ROM36/RAM37
				ROL		C					; ROM37/RAM38
				MOV		RES,C				; ROM38/RAM39
				RJMP	COMRLRR_CB			; ROM35/RAM36


;.ORG	0X2000+0X12*32						; RL D           [ CB12 ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB12:			CBR		F,1<<II				; ROM35/RAM36
				OUT		SREG,F				; ROM36/RAM37
				ROL		D					; ROM37/RAM38
				MOV		RES,D				; ROM38/RAM39
				RJMP	COMRLRR_CB			; ROM35/RAM36


;.ORG	0X2000+0X13*32						; RL E           [ CB13 ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB13:			CBR		F,1<<II				; ROM35/RAM36
				OUT		SREG,F				; ROM36/RAM37
				ROL		E					; ROM37/RAM38
				MOV		RES,E				; ROM38/RAM39
				RJMP	COMRLRR_CB			; ROM35/RAM36


;.ORG	0X2000+0X14*32						; RL H           [ CB14 ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB14:			CBR		F,1<<II				; ROM35/RAM36
				OUT		SREG,F				; ROM36/RAM37
				ROL		H					; ROM37/RAM38
				MOV		RES,H				; ROM38/RAM39
				RJMP	COMRLRR_CB			; ROM35/RAM36


;.ORG	0X2000+0X15*32						; RL L           [ CB15 ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB15:			CBR		F,1<<II				; ROM35/RAM36
				OUT		SREG,F				; ROM36/RAM37
				ROL		L					; ROM37/RAM38
				MOV		RES,L				; ROM38/RAM39
				RJMP	COMRLRR_CB			; ROM35/RAM36


;.ORG	0X2000+0X16*32						; RL (HL)        [ CB16 ] 15 (69-90) SZHVNC
											;                                      0P0  
EXCB16:			MOVW	ZL,L				; ROM35/RAM36
				CPI		ZH,0X40				; ROM36/RAM37
				BRCC	FROMRAMCB16			; ROM37/RAM38 /> ROM38/RAM39
				OR		ZH,ROMID			; ROM38/RAM39
				ELPM	RES,Z				; ROM41/RAM42
				DELAY2						; ROM43/RAM44
				RJMP	COMCB16				; ROM45/RAM46
FROMRAMCB16:	LOAD_RES_Z[7]				; ROM45/RAM46
COMCB16:		CBR		F,1<<II				; ROM46/RAM47
				OUT		SREG,F				; ROM47/RAM48
				ROL		RES					; ROM48/RAM49
				MOVW	ZL,RES				; ROM49/RAM50
				LD		F,Z					; ROM51/RAM52
				BRCC	CCCB16				; ROM52/RAM53
				SBR		F,1<<CC				; ROM53/RAM54
CCCB16:			MOVW	ZL,L				; ROM54/RAM55
				CPI		ZH,0X40				; ROM55/RAM56
				BRCS	TOROMCB16			; ROM56/RAM57 /> ROM57/RAM58
				SAVE_RES_Z_[10]				; ROM66/RAM67
				JMP		M1_-T15+68			; ROM0/RAM1 ??? (+2)
TOROMCB16:		BRCS	TIMECORCB16			; 59<>
TIMECORCB16:	JMP		M1-T15+62			; 62


;.ORG	0X2000+0X17*32						; RL A           [ CB17 ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB17:			
				CBR		F,1<<II				; ROM35/RAM36
				OUT		SREG,F				; ROM36/RAM0
				ROL		A					; ROM0/RAM1
				MOV		RES,A				; ROM1/RAM2
				RJMP	COMRLRR_CB			; ROM3/RAM4
COMRLRR_CB:		MOVW	ZL,RES				; ROM4/RAM5 
				LD		F,Z					; ROM6/RAM7 
				BRCC	CCCB17				; ROM7/RAM8
				SBR		F,1<<CC				; ROM8/RAM9
CCCB17:			STUFF37_2					; 
				M1H_INTEN[3]				; ROM11/RAM12
				BRCS	FROMROMCB17			; 13<>
				M1L_RAM[12]					; 25 ??? (+9)
FROMROMCB17:	M1L_ROM_SHORT[12]			; 25 ??? (+9)


;.ORG	0X2000+0X18*32						; RR B           [ CB18 ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB18:			CBR		F,1<<II				; ROM35/RAM36
				OUT		SREG,F				; ROM36/RAM37
				ROR		B					; ROM37/RAM38
				MOV		RES,B				; ROM38/RAM39
				RJMP	COMRLRR_CB			; ROM35/RAM36


;.ORG	0X2000+0X19*32						; RR C           [ CB19 ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB19:			CBR		F,1<<II				; ROM35/RAM36
				OUT		SREG,F				; ROM36/RAM37
				ROR		C					; ROM37/RAM38
				MOV		RES,C				; ROM38/RAM39
				RJMP	COMRLRR_CB			; ROM35/RAM36


;.ORG	0X2000+0X1A*32						; RR D           [ CB1A ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB1A:			CBR		F,1<<II				; ROM35/RAM36
				OUT		SREG,F				; ROM36/RAM37
				ROR		D					; ROM37/RAM38
				MOV		RES,D				; ROM38/RAM39
				RJMP	COMRLRR_CB			; ROM35/RAM36


;.ORG	0X2000+0X1B*32						; RR E           [ CB1B ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB1B:			CBR		F,1<<II				; ROM35/RAM36
				OUT		SREG,F				; ROM36/RAM37
				ROR		E					; ROM37/RAM38
				MOV		RES,E				; ROM38/RAM39
				RJMP	COMRLRR_CB			; ROM35/RAM36


;.ORG	0X2000+0X1C*32						; RR H           [ CB1C ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB1C:			CBR		F,1<<II				; ROM35/RAM36
				OUT		SREG,F				; ROM36/RAM37
				ROR		H					; ROM37/RAM38
				MOV		RES,H				; ROM38/RAM39
				RJMP	COMRLRR_CB			; ROM35/RAM36


;.ORG	0X2000+0X1D*32						; RR L           [ CB1D ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB1D:			CBR		F,1<<II				; ROM35/RAM36
				OUT		SREG,F				; ROM36/RAM37
				ROR		L					; ROM37/RAM38
				MOV		RES,L				; ROM38/RAM39
				RJMP	COMRLRR_CB			; ROM35/RAM36


;.ORG	0X2000+0X1E*32						; RR (HL)        [ CB1E ] 15 (69-90) SZHVNC
											;                                      0P0  
EXCB1E:			MOVW	ZL,L				; ROM35/RAM36
				CPI		ZH,0X40				; ROM36/RAM37
				BRCC	FROMRAMCB1E			; ROM37/RAM38 /> ROM38/RAM39
				OR		ZH,ROMID			; ROM38/RAM39
				ELPM	RES,Z				; ROM41/RAM42
				DELAY2						; ROM43/RAM44
				RJMP	COMCB1E				; ROM45/RAM46
FROMRAMCB1E:	LOAD_RES_Z[7]				; ROM45/RAM46
COMCB1E:		CBR		F,1<<II				; ROM46/RAM47
				OUT		SREG,F				; ROM47/RAM48
				ROR		RES					; ROM48/RAM49
				MOVW	ZL,RES				; ROM49/RAM50
				LD		F,Z					; ROM51/RAM52
				BRCC	CCCB1E				; ROM52/RAM53
				SBR		F,1<<CC				; ROM53/RAM54
CCCB1E:			MOVW	ZL,L				; ROM54/RAM55
				CPI		ZH,0X40				; ROM55/RAM56
				BRCS	TOROMCB1E			; ROM56/RAM57 /> ROM57/RAM58
				SAVE_RES_Z_[10]				; ROM66/RAM67
				JMP		M1_-T15+68			; ROM0/RAM1 ??? (+2)
TOROMCB1E:		BRCS	TIMECORCB1E			; 59<>
TIMECORCB1E:	JMP		M1-T15+62			; 62


;.ORG	0X2000+0X1F*32						; RR A           [ CB1F ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB1F:			CBR		F,1<<II				; ROM35/RAM36
				OUT		SREG,F				; ROM36/RAM37
				ROR		A					; ROM37/RAM38
				MOV		RES,A				; ROM38/RAM39
				RJMP	COMRLRR_CB			; ROM35/RAM36


;.ORG	0X2000+0X20*32						; SLA B          [ CB20 ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB20:			CLC							; ROM35/RAM36
				ROL		B					; ROM36/RAM37
				MOV		RES,B				; ROM37/RAM38
				RJMP	COMRLRR_CB			; ROM39/RAM40



;.ORG	0X2000+0X21*32						; SLA C          [ CB21 ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB21:			CLC							; ROM35/RAM36
				ROL		C					; ROM36/RAM37
				MOV		RES,C				; ROM37/RAM38
				RJMP	COMRLRR_CB			; ROM39/RAM40


;.ORG	0X2000+0X22*32						; SLA D          [ CB22 ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB22:			CLC							; ROM35/RAM36
				ROL		D					; ROM36/RAM37
				MOV		RES,D				; ROM37/RAM38
				RJMP	COMRLRR_CB			; ROM39/RAM40


;.ORG	0X2000+0X23*32						; SLA E          [ CB23 ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB23:			CLC							; ROM35/RAM36
				ROL		E					; ROM36/RAM37
				MOV		RES,E				; ROM37/RAM38
				RJMP	COMRLRR_CB			; ROM39/RAM40


;.ORG	0X2000+0X24*32						; SLA H          [ CB24 ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB24:			CLC							; ROM35/RAM36
				ROL		H					; ROM36/RAM37
				MOV		RES,H				; ROM37/RAM38
				RJMP	COMRLRR_CB			; ROM39/RAM40


;.ORG	0X2000+0X25*32						; SLA L          [ CB25 ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB25:			CLC							; ROM35/RAM36
				ROL		L					; ROM36/RAM37
				MOV		RES,L				; ROM37/RAM38
				RJMP	COMRLRR_CB			; ROM39/RAM40


;.ORG	0X2000+0X26*32						; SLA (HL)       [ CB26 ] 15 (69-90) SZHVNC
											;                                      0P0  
EXCB26:			MOVW	ZL,L				; ROM35/RAM36
				CPI		ZH,0X40				; ROM36/RAM37
				BRCC	FROMRAMCB26			; ROM37/RAM38 /> ROM38/RAM39
				OR		ZH,ROMID			; ROM38/RAM39
				ELPM	RES,Z				; ROM41/RAM42
				DELAY2						; ROM43/RAM44
				RJMP	COMCB26				; ROM45/RAM46
FROMRAMCB26:	LOAD_RES_Z[7]				; ROM45/RAM46
COMCB26:		CLC							; ROM46/RAM47
				ROL		RES					; ROM47/RAM48
				MOVW	ZL,RES				; ROM48/RAM49
				LD		F,Z					; ROM50/RAM51
				BRCC	CCCB26				; ROM51/RAM52
				SBR		F,1<<CC				; ROM52/RAM53
CCCB26:			MOVW	ZL,L				; ROM53/RAM54
				CPI		ZH,0X40				; ROM54/RAM55
				BRCS	TOROMCB26			; ROM55/RAM56 /> ROM56/RAM57
				SAVE_RES_Z_[10]				; ROM65/RAM66
				JMP		M1_-T15+68			; ROM68/RAM0 ??? (+1)
TOROMCB26:		BRCS	TIMECORCB26			; 58<>
TIMECORCB26:	JMP		M1-T15+61			; 61


;.ORG	0X2000+0X27*32						; SLA A          [ CB27 ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB27:			CLC							; ROM35/RAM36
				ROL		A					; ROM36/RAM37
				MOV		RES,A				; ROM37/RAM38
				RJMP	COMRLRR_CB			; ROM39/RAM40


;.ORG	0X2000+0X28*32						; SRA B          [ CB28 ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB28:			ASR		B					; ROM35/RAM36
				MOV		RES,B				; SAVE BITS S, 5, 3                ROM41/RAM42
				RJMP	COMRLRR_CB			; ROM38/RAM39


;.ORG	0X2000+0X29*32						; SRA C          [ CB29 ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB29:			ASR		C					; ROM35/RAM36
				MOV		RES,C				; SAVE BITS S, 5, 3                ROM41/RAM42
				RJMP	COMRLRR_CB			; ROM38/RAM39


;.ORG	0X2000+0X2A*32						; SRA D          [ CB2A ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB2A:			ASR		D					; ROM35/RAM36
				MOV		RES,D				; SAVE BITS S, 5, 3                ROM41/RAM42
				RJMP	COMRLRR_CB			; ROM38/RAM39

;.ORG	0X2000+0X2B*32						; SRA E          [ CB2B ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB2B:			ASR		E					; ROM35/RAM36
				MOV		RES,E				; SAVE BITS S, 5, 3                ROM41/RAM42
				RJMP	COMRLRR_CB			; ROM38/RAM39


;.ORG	0X2000+0X2C*32						; SRA H          [ CB2C ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB2C:			ASR		H					; ROM35/RAM36
				MOV		RES,H				; SAVE BITS S, 5, 3                ROM41/RAM42
				RJMP	COMRLRR_CB			; ROM38/RAM39


;.ORG	0X2000+0X2D*32						; SRA L          [ CB2D ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB2D:			ASR		L					; ROM35/RAM36
				MOV		RES,L				; SAVE BITS S, 5, 3                ROM41/RAM42
				RJMP	COMRLRR_CB			; ROM38/RAM39


;.ORG	0X2000+0X2E*32						; SRA (HL)       [ CB2E ] 15 (69-90) SZHVNC
											;                                      0P0  
EXCB2E:			MOVW	ZL,L				; ROM35/RAM36
				CPI		ZH,0X40				; ROM36/RAM37
				BRCC	FROMRAMCB2E			; ROM37/RAM38 /> ROM38/RAM39
				OR		ZH,ROMID			; ROM38/RAM39
				ELPM	RES,Z				; ROM41/RAM42
				DELAY2						; ROM43/RAM44
				RJMP	COMCB2E				; ROM45/RAM46
FROMRAMCB2E:	LOAD_RES_Z[7]				; ROM45/RAM46
COMCB2E:		CLC							; ROM46/RAM47
				ASR		RES					; ROM47/RAM48
				MOVW	ZL,RES				; ROM48/RAM49
				LD		F,Z					; ROM50/RAM51
				BRCC	CCCB2E				; ROM51/RAM52
				SBR		F,1<<CC				; ROM52/RAM53
CCCB2E:			MOVW	ZL,L				; ROM53/RAM54
				CPI		ZH,0X40				; ROM54/RAM55
				BRCS	TOROMCB2E			; ROM55/RAM56 /> ROM56/RAM57
				SAVE_RES_Z_[10]				; ROM65/RAM66
				JMP		M1_-T15+68			; ROM68/RAM0 ??? (+1)
TOROMCB2E:		BRCS	TIMECORCB2E			; 58<>
TIMECORCB2E:	JMP		M1-T15+61			; 61


;.ORG	0X2000+0X2F*32						; SRA A          [ CB2F ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB2F:			ASR		A					; ROM35/RAM36
				MOV		RES,A				; SAVE BITS S, 5, 3                ROM41/RAM42
				RJMP	COMRLRR_CB			; ROM38/RAM39


;.ORG	0X2000+0X30*32						; SLL B*         [ CB30 ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB30:			ROL		B					; ROM35/RAM36
				SBR		B,0B00000001		; ROM36/RAM37
				MOV		RES,B				; ROM37/RAM38
				RJMP	COMRLRR_CB			; ROM39/RAM40


;.ORG	0X2000+0X31*32						; SLL C*         [ CB31 ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB31:			ROL		C					; ROM35/RAM36
				SBR		C,0B00000001		; ROM36/RAM37
				MOV		RES,C				; ROM37/RAM38
				RJMP	COMRLRR_CB			; ROM39/RAM40


;.ORG	0X2000+0X32*32						; SLL D*         [ CB32 ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB32:			ROL		D					; ROM35/RAM36
				SBR		D,0B00000001		; ROM36/RAM37
				MOV		RES,D				; ROM37/RAM38
				RJMP	COMRLRR_CB			; ROM39/RAM40


;.ORG	0X2000+0X33*32						; SLL E*         [ CB33 ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB33:			ROL		E					; ROM35/RAM36
				SBR		E,0B00000001		; ROM36/RAM37
				MOV		RES,E				; ROM37/RAM38
				RJMP	COMRLRR_CB			; ROM39/RAM40


;.ORG	0X2000+0X34*32						; SLL H*         [ CB34 ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB34:			ROL		H					; ROM35/RAM36
				OR		H,ONE				; ROM36/RAM37
				MOV		RES,H				; ROM37/RAM38
				RJMP	COMRLRR_CB			; ROM39/RAM40


;.ORG	0X2000+0X35*32						; SLL L*         [ CB35 ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB35:			ROL		L					; ROM35/RAM36
				OR		L,ONE				; ROM36/RAM37
				MOV		RES,L				; ROM37/RAM38
				RJMP	COMRLRR_CB			; ROM39/RAM40


;.ORG	0X2000+0X36*32						; SLL (HL)*      [ CB36 ] 15 (69-90) SZHVNC
											;                                      0P0  
EXCB36:			MOVW	ZL,L				; ROM35/RAM36
				CPI		ZH,0X40				; ROM36/RAM37
				BRCC	FROMRAMCB36			; ROM37/RAM38 /> ROM38/RAM39
				OR		ZH,ROMID			; ROM38/RAM39
				ELPM	RES,Z				; ROM41/RAM42
				DELAY2						; ROM43/RAM44
				RJMP	COMCB36				; ROM45/RAM46
FROMRAMCB36:	LOAD_RES_Z[7]				; ROM45/RAM46
COMCB36:		ROL		RES					; ROM46/RAM47
				OR		RES,ONE				; ROM47/RAM48
				MOVW	ZL,RES				; ROM48/RAM49
				LD		F,Z					; ROM50/RAM51
				BRCC	CCCB36				; ROM51/RAM52
				SBR		F,1<<CC				; ROM52/RAM53
CCCB36:			MOVW	ZL,L				; ROM53/RAM54
				CPI		ZH,0X40				; ROM54/RAM55
				BRCS	TOROMCB36			; ROM55/RAM56 /> ROM56/RAM57
				SAVE_RES_Z_[10]				; ROM65/RAM66
				JMP		M1_-T15+68			; ROM68/RAM0 ??? (+1)
TOROMCB36:		BRCS	TIMECORCB36			; 58<>
TIMECORCB36:	JMP		M1-T15+61			; 61


;.ORG	0X2000+0X37*32						; SLL A*         [ CB37 ] 8  (37-48) SZHVNC
											;                                      0P0
EXCB37:			ROL		A					; ROM35/RAM36
				SBR		A,0B00000001		; ROM36/RAM37
				MOV		RES,A				; ROM37/RAM38
				RJMP	COMRLRR_CB			; ROM39/RAM40


;.ORG	0X2000+0X38*32						; SRL B          [ CB38 ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB38:			LSR		B					; ROM35/RAM36
				MOV		RES,B				; ROM36/RAM37
				RJMP	COMRLRR_CB			; ROM38/RAM39


;.ORG	0X2000+0X39*32						; SRL C          [ CB39 ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB39:			LSR		C					; ROM35/RAM36
				MOV		RES,C				; ROM36/RAM37
				RJMP	COMRLRR_CB			; ROM38/RAM39


;.ORG	0X2000+0X3A*32						; SRL D          [ CB3A ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB3A:			LSR		D					; ROM35/RAM36
				MOV		RES,D				; ROM36/RAM37
				RJMP	COMRLRR_CB			; ROM38/RAM39


;.ORG	0X2000+0X3B*32						; SRL E          [ CB3B ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB3B:			LSR		E					; ROM35/RAM36
				MOV		RES,E				; ROM36/RAM37
				RJMP	COMRLRR_CB			; ROM38/RAM39


;.ORG	0X2000+0X3C*32						; SRL H          [ CB3C ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB3C:			LSR		H					; ROM35/RAM36
				MOV		RES,H				; ROM36/RAM37
				RJMP	COMRLRR_CB			; ROM38/RAM39

;.ORG	0X2000+0X3D*32						; SRL L          [ CB3D ] 8  (37-48) SZHVNC
											;                                      0P0  
EXCB3D:			LSR		L					; ROM35/RAM36
				MOV		RES,L				; ROM36/RAM37
				RJMP	COMRLRR_CB			; ROM38/RAM39

;.ORG	0X2000+0X3E*32						; SRL (HL)       [ CB3E ] 15 (69-90) SZHVNC
											;                                      0P0  
EXCB3E:			MOVW	ZL,L				; ROM35/RAM36
				CPI		ZH,0X40				; ROM36/RAM37
				BRCC	FROMRAMCB3E			; ROM37/RAM38 /> ROM38/RAM39
				OR		ZH,ROMID			; ROM38/RAM39
				ELPM	RES,Z				; ROM41/RAM42
				DELAY2						; ROM43/RAM44
				RJMP	COMCB3E				; ROM45/RAM46
FROMRAMCB3E:	LOAD_RES_Z[7]				; ROM45/RAM46
COMCB3E:		ASR		RES					; ROM46/RAM47
				CLT							; ROM47/RAM48
				BLD		RES,7				; ROM48/RAM49
				MOVW	ZL,RES				; ROM50/RAM51
				LD		F,Z					; ROM51/RAM52
				BRCC	CCCB3E				; ROM52/RAM53
				SBR		F,1<<CC				; ROM53/RAM54
CCCB3E:			MOVW	ZL,L				; ROM54/RAM55
				CPI		ZH,0X40				; ROM55/RAM56
				BRCS	TOROMCB3E			; ROM56/RAM57 /> ROM57/RAM58
				SAVE_RES_Z_[10]				; ROM66/RAM67
				JMP		M1_-T15+68			; ROM0/RAM1 ??? (+2)
TOROMCB3E:		BRCS	TIMECORCB3E			; 59<>
TIMECORCB3E:	JMP		M1-T15+62			; 62


;.ORG	0X2000+0X3F*32						; SRL A          [ CB3F ] 8  (37-48) SZHVNC
											;                                      0P0
EXCB3F:			LSR		A					; ROM35/RAM36
				MOV		RES,A				; ROM36/RAM37
				RJMP	COMRLRR_CB			; ROM38/RAM39


;.ORG	0X2000+0X40*32						; BIT 0,B        [ CB40 ] 8  (37-48) ZHVN
											;                                    B1B0 
EXCB40:			BST		RES,7				; ROM35/RAM36
				MOV		RES,B				; ROM36/RAM0
				RJMP	COMBIT0_CB			; ROM1/RAM2
EXCB41:			BST		RES,7				; ROM35/RAM36
				MOV		RES,C				; ROM36/RAM0
				RJMP	COMBIT0_CB			; ROM1/RAM2
EXCB42:			BST		RES,7				; ROM35/RAM36
				MOV		RES,D				; ROM36/RAM0
				RJMP	COMBIT0_CB			; ROM1/RAM2
EXCB43:			BST		RES,7				; ROM35/RAM36
				MOV		RES,E				; ROM36/RAM0
				RJMP	COMBIT0_CB			; ROM1/RAM2
EXCB44:			BST		RES,7				; ROM35/RAM36
				MOV		RES,H				; ROM36/RAM0
				RJMP	COMBIT0_CB			; ROM1/RAM2
EXCB45:			BST		RES,7				; ROM35/RAM36
				MOV		RES,L				; ROM36/RAM0
				RJMP	COMBIT0_CB			; ROM1/RAM2
EXCB47:			BST		RES,7				; ROM35/RAM36
				MOV		RES,A				; ROM36/RAM0
				RJMP	COMBIT0_CB			; ROM1/RAM2
COMBIT0_CB:		SBR		F,1<<HH				; ROM2/RAM3
				CBR		F,(1<<NN)|(1<<ZZ)|(1<<PP); ROM3/RAM4
				SBRS	RES,0				; ROM4/RAM5
				SBR		F,(1<<ZZ)|(1<<PP)	; ROM5/RAM6
				BLD		RES,7				; ROM6/RAM7
				STUFF37_4					; 
				M1H_INTEN[3]				; ROM9/RAM10
				BRCS	FROMROMBIT0_CB		; 11<>
				M1L_RAM[12]					; 23 ??? (+7)
FROMROMBIT0_CB:	M1L_ROM_SHORT[12]			; 23 ??? (+7)


;.ORG	0X2000+0X46*32						; BIT 0,(HL)     [ CB46 ] 12 (72) ZHVN
											;                                 B1B0 
EXCB46:			MOVW	ZL,L				; ROM35/RAM36
				CPI		ZH,0X40				; ROM36/RAM37
				BRCS	FROMROMCB46			;                                  ROM43/RAM43
				LOAD_BUF_Z[7]				;                                  50
COMCB46:		SBR		F,1<<HH				;                                  51
				CBR		F,(1<<NN)|(1<<ZZ)|(1<<PP);                             52
				SBRS	BUF,0				;                                  53
				SBR		F,(1<<ZZ)|(1<<PP)	;                                  54
				MOV		BUF,MEMPTRH			; SAVE BITS 13, 11 FROM MEMPTR     55
				CBR		BUF,1<<7			; CLEAR S FLAG                     56
				MOV		RES,BUF				;                                  57
				JMP		DONEM11				;                                  60
FROMROMCB46:	RLOAD_BUF_Z[4]				;                                  47
				NOP							; NOP                              48
				RJMP	COMCB46				;                                  50
											

;.ORG	0X2000+0X48*32						; BIT 1,B        [ CB48 ] 8  (37-48) ZHVN
											;                                 B1B0 
EXCB48:			BST		RES,7				; ROM35/RAM36
				MOV		RES,B				; ROM36/RAM0
				RJMP	COMBIT1_CB			; ROM1/RAM2
EXCB49:			BST		RES,7				; ROM35/RAM36
				MOV		RES,C				; ROM36/RAM0
				RJMP	COMBIT1_CB			; ROM1/RAM2
EXCB4A:			BST		RES,7				; ROM35/RAM36
				MOV		RES,D				; ROM36/RAM0
				RJMP	COMBIT1_CB			; ROM1/RAM2
EXCB4B:			BST		RES,7				; ROM35/RAM36
				MOV		RES,E				; ROM36/RAM0
				RJMP	COMBIT1_CB			; ROM1/RAM2
EXCB4C:			BST		RES,7				; ROM35/RAM36
				MOV		RES,H				; ROM36/RAM0
				RJMP	COMBIT1_CB			; ROM1/RAM2
EXCB4D:			BST		RES,7				; ROM35/RAM36
				MOV		RES,L				; ROM36/RAM0
				RJMP	COMBIT1_CB			; ROM1/RAM2
EXCB4F:			BST		RES,7				; ROM35/RAM36
				MOV		RES,A				; ROM36/RAM0
				RJMP	COMBIT1_CB			; ROM1/RAM2
COMBIT1_CB:		SBR		F,1<<HH				; ROM2/RAM3
				CBR		F,(1<<NN)|(1<<ZZ)|(1<<PP); ROM3/RAM4
				SBRS	RES,1				; ROM4/RAM5
				SBR		F,(1<<ZZ)|(1<<PP)	; ROM5/RAM6
				BLD		RES,7				; ROM6/RAM7
				STUFF37_4					; 
				M1H_INTEN[3]				; ROM9/RAM10
				BRCS	FROMROMBIT1_CB		; 11<>
				M1L_RAM[12]					; 23 ??? (+7)
FROMROMBIT1_CB:	M1L_ROM_SHORT[12]			; 23 ??? (+7)


;.ORG	0X2000+0X4E*32						; BIT 1,(HL)     [ CB4E ] 12 (72) ZHVN
											;                                 B1B0 
EXCB4E:			MOVW	ZL,L				; ROM35/RAM36
				CPI		ZH,0X40				; ROM36/RAM37
				BRCS	FROMROMCB4E			;                                  ROM43/RAM43
				LOAD_BUF_Z[7]				;                                  50
COMCB4E:		SBR		F,1<<HH				;                                  51
				CBR		F,(1<<NN)|(1<<ZZ)|(1<<PP);                             52
				SBRS	BUF,1				;                                  53
				SBR		F,(1<<ZZ)|(1<<PP)	;                                  54
				MOV		BUF,MEMPTRH			; SAVE BITS 13, 11 FROM MEMPTR     55
				CBR		BUF,1<<7			; CLEAR S FLAG                     56
				MOV		RES,BUF				;                                  57
				JMP		DONEM11				;                                  60
FROMROMCB4E:	RLOAD_BUF_Z[4]				;                                  47
				NOP							; NOP                              48
				RJMP	COMCB4E				;                                  50


;.ORG	0X2000+0X50*32						; BIT 2,B        [ CB50 ] 8  (37-48) ZHVN
											;                                 B1B0 
EXCB50:			BST		RES,7				; ROM35/RAM36
				MOV		RES,B				; ROM36/RAM0
				RJMP	COMBIT2_CB			; ROM1/RAM2
EXCB51:			BST		RES,7				; ROM35/RAM36
				MOV		RES,C				; ROM36/RAM0
				RJMP	COMBIT2_CB			; ROM1/RAM2
EXCB52:			BST		RES,7				; ROM35/RAM36
				MOV		RES,D				; ROM36/RAM0
				RJMP	COMBIT2_CB			; ROM1/RAM2
EXCB53:			BST		RES,7				; ROM35/RAM36
				MOV		RES,E				; ROM36/RAM0
				RJMP	COMBIT2_CB			; ROM1/RAM2
EXCB54:			BST		RES,7				; ROM35/RAM36
				MOV		RES,H				; ROM36/RAM0
				RJMP	COMBIT2_CB			; ROM1/RAM2
EXCB55:			BST		RES,7				; ROM35/RAM36
				MOV		RES,L				; ROM36/RAM0
				RJMP	COMBIT2_CB			; ROM1/RAM2
EXCB57:			BST		RES,7				; ROM35/RAM36
				MOV		RES,A				; ROM36/RAM0
				RJMP	COMBIT2_CB			; ROM1/RAM2
COMBIT2_CB:		SBR		F,1<<HH				; ROM2/RAM3
				CBR		F,(1<<NN)|(1<<ZZ)|(1<<PP); ROM3/RAM4
				SBRS	RES,2				; ROM4/RAM5
				SBR		F,(1<<ZZ)|(1<<PP)	; ROM5/RAM6
				BLD		RES,7				; ROM6/RAM7
				STUFF37_4					; 
				M1H_INTEN[3]				; ROM9/RAM10
				BRCS	FROMROMBIT2_CB		; 11<>
				M1L_RAM[12]					; 23 ??? (+7)
FROMROMBIT2_CB:	M1L_ROM_SHORT[12]			; 23 ??? (+7)


;.ORG	0X2000+0X56*32						; BIT 2,(HL)     [ CB56 ] 12 (72) ZHVN
											;                                 B1B0 
EXCB56:			MOVW	ZL,L				; ROM35/RAM36
				CPI		ZH,0X40				; ROM36/RAM37
				BRCS	FROMROMCB56			;                                  ROM43/RAM43
				LOAD_BUF_Z[7]				;                                  50
COMCB56:		SBR		F,1<<HH				;                                  51
				CBR		F,(1<<NN)|(1<<ZZ)|(1<<PP);                             52
				SBRS	BUF,2				;                                  53
				SBR		F,(1<<ZZ)|(1<<PP)	;                                  54
				MOV		BUF,MEMPTRH			; SAVE BITS 13, 11 FROM MEMPTR     55
				CBR		BUF,1<<7			; CLEAR S FLAG                     56
				MOV		RES,BUF				;                                  57
				JMP		DONEM11				;                                  60
FROMROMCB56:	RLOAD_BUF_Z[4]				;                                  47
				NOP							; NOP                              48
				RJMP	COMCB56				;                                  50
											

;.ORG	0X2000+0X58*32						; BIT 3,B        [ CB48 ] 8  (37-48) ZHVN
											;                                 B1B0 
EXCB58:			BST		RES,7				; ROM35/RAM36
				MOV		RES,B				; ROM36/RAM0
				RJMP	COMBIT3_CB			; ROM1/RAM2
EXCB59:			BST		RES,7				; ROM35/RAM36
				MOV		RES,C				; ROM36/RAM0
				RJMP	COMBIT3_CB			; ROM1/RAM2
EXCB5A:			BST		RES,7				; ROM35/RAM36
				MOV		RES,D				; ROM36/RAM0
				RJMP	COMBIT3_CB			; ROM1/RAM2
EXCB5B:			BST		RES,7				; ROM35/RAM36
				MOV		RES,E				; ROM36/RAM0
				RJMP	COMBIT3_CB			; ROM1/RAM2
EXCB5C:			BST		RES,7				; ROM35/RAM36
				MOV		RES,H				; ROM36/RAM0
				RJMP	COMBIT3_CB			; ROM1/RAM2
EXCB5D:			BST		RES,7				; ROM35/RAM36
				MOV		RES,L				; ROM36/RAM0
				RJMP	COMBIT3_CB			; ROM1/RAM2
EXCB5F:			BST		RES,7				; ROM35/RAM36
				MOV		RES,A				; ROM36/RAM0
				RJMP	COMBIT3_CB			; ROM1/RAM2
COMBIT3_CB:		SBR		F,1<<HH				; ROM2/RAM3
				CBR		F,(1<<NN)|(1<<ZZ)|(1<<PP); ROM3/RAM4
				SBRS	RES,3				; ROM4/RAM5
				SBR		F,(1<<ZZ)|(1<<PP)	; ROM5/RAM6
				BLD		RES,7				; ROM6/RAM7
				STUFF37_4					; 
				M1H_INTEN[3]				; ROM9/RAM10
				BRCS	FROMROMBIT3_CB		; 11<>
				M1L_RAM[12]					; 23 ??? (+7)
FROMROMBIT3_CB:	M1L_ROM_SHORT[12]			; 23 ??? (+7)


;.ORG	0X2000+0X5E*32						; BIT 3,(HL)     [ CB5E ] 12 (72) ZHVN
											;                                 B1B0 
EXCB5E:			MOVW	ZL,L				; ROM35/RAM36
				CPI		ZH,0X40				; ROM36/RAM37
				BRCS	FROMROMCB5E			;                                  ROM43/RAM43
				LOAD_BUF_Z[7]				;                                  50
COMCB5E:		SBR		F,1<<HH				;                                  51
				CBR		F,(1<<NN)|(1<<ZZ)|(1<<PP);                             52
				SBRS	BUF,3				;                                  53
				SBR		F,(1<<ZZ)|(1<<PP)	;                                  54
				MOV		BUF,MEMPTRH			; SAVE BITS 13, 11 FROM MEMPTR     55
				CBR		BUF,1<<7			; CLEAR S FLAG                     56
				MOV		RES,BUF				;                                  57
				JMP		DONEM11				;                                  60
FROMROMCB5E:	RLOAD_BUF_Z[4]				;                                  47
				NOP							; NOP                              48
				RJMP	COMCB5E				;                                  50


;.ORG	0X2000+0X60*32						; BIT 4,B        [ CB60 ] 8  (37-48) ZHVN
											;                                 B1B0 
EXCB60:			BST		RES,7				; ROM35/RAM36
				MOV		RES,B				; ROM36/RAM0
				RJMP	COMBIT4_CB			; ROM1/RAM2
EXCB61:			BST		RES,7				; ROM35/RAM36
				MOV		RES,C				; ROM36/RAM0
				RJMP	COMBIT4_CB			; ROM1/RAM2
EXCB62:			BST		RES,7				; ROM35/RAM36
				MOV		RES,D				; ROM36/RAM0
				RJMP	COMBIT4_CB			; ROM1/RAM2
EXCB63:			BST		RES,7				; ROM35/RAM36
				MOV		RES,E				; ROM36/RAM0
				RJMP	COMBIT4_CB			; ROM1/RAM2
EXCB64:			BST		RES,7				; ROM35/RAM36
				MOV		RES,H				; ROM36/RAM0
				RJMP	COMBIT4_CB			; ROM1/RAM2
EXCB65:			BST		RES,7				; ROM35/RAM36
				MOV		RES,L				; ROM36/RAM0
				RJMP	COMBIT4_CB			; ROM1/RAM2
EXCB67:			BST		RES,7				; ROM35/RAM36
				MOV		RES,A				; ROM36/RAM0
				RJMP	COMBIT4_CB			; ROM1/RAM2
COMBIT4_CB:		SBR		F,1<<HH				; ROM2/RAM3
				CBR		F,(1<<NN)|(1<<ZZ)|(1<<PP); ROM3/RAM4
				SBRS	RES,4				; ROM4/RAM5
				SBR		F,(1<<ZZ)|(1<<PP)	; ROM5/RAM6
				BLD		RES,7				; ROM6/RAM7
				STUFF37_4					; 
				M1H_INTEN[3]				; ROM9/RAM10
				BRCS	FROMROMBIT4_CB		; 11<>
				M1L_RAM[12]					; 23 ??? (+7)
FROMROMBIT4_CB:	M1L_ROM_SHORT[12]			; 23 ??? (+7)


;.ORG	0X2000+0X66*32						; BIT 4,(HL)     [ CB66 ] 12 (72) ZHVN
											;                                 B1B0 
EXCB66:			MOVW	ZL,L				; ROM35/RAM36
				CPI		ZH,0X40				; ROM36/RAM37
				BRCS	FROMROMCB66			;                                  ROM43/RAM43
				LOAD_BUF_Z[7]				;                                  50
COMCB66:		SBR		F,1<<HH				;                                  51
				CBR		F,(1<<NN)|(1<<ZZ)|(1<<PP);                             52
				SBRS	BUF,4				;                                  53
				SBR		F,(1<<ZZ)|(1<<PP)	;                                  54
				MOV		BUF,MEMPTRH			; SAVE BITS 13, 11 FROM MEMPTR     55
				CBR		BUF,1<<7			; CLEAR S FLAG                     56
				MOV		RES,BUF				;                                  57
				JMP		DONEM11				;                                  60
FROMROMCB66:	RLOAD_BUF_Z[4]				;                                  47
				NOP							; NOP                              48
				RJMP	COMCB66				;                                  50
											

;.ORG	0X2000+0X68*32						; BIT 5,B        [ CB68 ] 8  (37-48) ZHVN
											;                                 B1B0 
EXCB68:			BST		RES,7				; ROM35/RAM36
				MOV		RES,B				; ROM36/RAM0
				RJMP	COMBIT5_CB			; ROM1/RAM2
EXCB69:			BST		RES,7				; ROM35/RAM36
				MOV		RES,C				; ROM36/RAM0
				RJMP	COMBIT5_CB			; ROM1/RAM2
EXCB6A:			BST		RES,7				; ROM35/RAM36
				MOV		RES,D				; ROM36/RAM0
				RJMP	COMBIT5_CB			; ROM1/RAM2
EXCB6B:			BST		RES,7				; ROM35/RAM36
				MOV		RES,E				; ROM36/RAM0
				RJMP	COMBIT5_CB			; ROM1/RAM2
EXCB6C:			BST		RES,7				; ROM35/RAM36
				MOV		RES,H				; ROM36/RAM0
				RJMP	COMBIT5_CB			; ROM1/RAM2
EXCB6D:			BST		RES,7				; ROM35/RAM36
				MOV		RES,L				; ROM36/RAM0
				RJMP	COMBIT5_CB			; ROM1/RAM2
EXCB6F:			BST		RES,7				; ROM35/RAM36
				MOV		RES,A				; ROM36/RAM0
				RJMP	COMBIT5_CB			; ROM1/RAM2
COMBIT5_CB:		SBR		F,1<<HH				; ROM2/RAM3
				CBR		F,(1<<NN)|(1<<ZZ)|(1<<PP); ROM3/RAM4
				SBRS	RES,5				; ROM4/RAM5
				SBR		F,(1<<ZZ)|(1<<PP)	; ROM5/RAM6
				BLD		RES,7				; ROM6/RAM7
				STUFF37_4					; 
				M1H_INTEN[3]				; ROM9/RAM10
				BRCS	FROMROMBIT5_CB		; 11<>
				M1L_RAM[12]					; 23 ??? (+7)
FROMROMBIT5_CB:	M1L_ROM_SHORT[12]			; 23 ??? (+7)


;.ORG	0X2000+0X6E*32						; BIT 5,(HL)     [ CB6E ] 12 (72) ZHVN
											;                                 B1B0 
EXCB6E:			MOVW	ZL,L				; ROM35/RAM36
				CPI		ZH,0X40				; ROM36/RAM37
				BRCS	FROMROMCB6E			;                                  ROM43/RAM43
				LOAD_BUF_Z[7]				;                                  50
COMCB6E:		SBR		F,1<<HH				;                                  51
				CBR		F,(1<<NN)|(1<<ZZ)|(1<<PP);                             52
				SBRS	BUF,5				;                                  53
				SBR		F,(1<<ZZ)|(1<<PP)	;                                  54
				MOV		BUF,MEMPTRH			; SAVE BITS 13, 11 FROM MEMPTR     55
				CBR		BUF,1<<7			; CLEAR S FLAG                     56
				MOV		RES,BUF				;                                  57
				JMP		DONEM11				;                                  60
FROMROMCB6E:	RLOAD_BUF_Z[4]				;                                  47
				NOP							; NOP                              48
				RJMP	COMCB6E				;                                  50


;.ORG	0X2000+0X70*32						; BIT 6,B        [ CB70 ] 8  (37-48) ZHVN
											;                                 B1B0 
EXCB70:			BST		RES,7				; ROM35/RAM36
				MOV		RES,B				; ROM36/RAM0
				RJMP	COMBIT6_CB			; ROM1/RAM2
EXCB71:			BST		RES,7				; ROM35/RAM36
				MOV		RES,C				; ROM36/RAM0
				RJMP	COMBIT6_CB			; ROM1/RAM2
EXCB72:			BST		RES,7				; ROM35/RAM36
				MOV		RES,D				; ROM36/RAM0
				RJMP	COMBIT6_CB			; ROM1/RAM2
EXCB73:			BST		RES,7				; ROM35/RAM36
				MOV		RES,E				; ROM36/RAM0
				RJMP	COMBIT6_CB			; ROM1/RAM2
EXCB74:			BST		RES,7				; ROM35/RAM36
				MOV		RES,H				; ROM36/RAM0
				RJMP	COMBIT6_CB			; ROM1/RAM2
EXCB75:			BST		RES,7				; ROM35/RAM36
				MOV		RES,L				; ROM36/RAM0
				RJMP	COMBIT6_CB			; ROM1/RAM2
EXCB77:			BST		RES,7				; ROM35/RAM36
				MOV		RES,A				; ROM36/RAM0
				RJMP	COMBIT6_CB			; ROM1/RAM2
COMBIT6_CB:		SBR		F,1<<HH				; ROM2/RAM3
				CBR		F,(1<<NN)|(1<<ZZ)|(1<<PP); ROM3/RAM4
				SBRS	RES,6				; ROM4/RAM5
				SBR		F,(1<<ZZ)|(1<<PP)	; ROM5/RAM6
				BLD		RES,7				; ROM6/RAM7
				STUFF37_4					; 
				M1H_INTEN[3]				; ROM9/RAM10
				BRCS	FROMROMBIT6_CB		; 11<>
				M1L_RAM[12]					; 23 ??? (+7)
FROMROMBIT6_CB:	M1L_ROM_SHORT[12]			; 23 ??? (+7)


;.ORG	0X2000+0X76*32						; BIT 6,(HL)     [ CB76 ] 12 (72) ZHVN
											;                                 B1B0 
EXCB76:			MOVW	ZL,L				; ROM35/RAM36
				CPI		ZH,0X40				; ROM36/RAM37
				BRCS	FROMROMCB76			;                                  ROM43/RAM43
				LOAD_BUF_Z[7]				;                                  50
COMCB76:		SBR		F,1<<HH				;                                  51
				CBR		F,(1<<NN)|(1<<ZZ)|(1<<PP);                             52
				SBRS	BUF,6				;                                  53
				SBR		F,(1<<ZZ)|(1<<PP)	;                                  54
				MOV		BUF,MEMPTRH			; SAVE BITS 13, 11 FROM MEMPTR     55
				CBR		BUF,1<<7			; CLEAR S FLAG                     56
				MOV		RES,BUF				;                                  57
				JMP		DONEM11				;                                  60
FROMROMCB76:	RLOAD_BUF_Z[4]				;                                  47
				NOP							; NOP                              48
				RJMP	COMCB76				;                                  50
											

;.ORG	0X2000+0X78*32						; BIT 7,B        [ CB78 ] 8  (37-48) ZHVN
											;                                 B1B0 
EXCB78:			MOV		RES,B				; ROM35/RAM36
				RJMP	COMBIT7_CB			; ROM0/RAM1
EXCB79:			MOV		RES,C				; ROM35/RAM36
				RJMP	COMBIT7_CB			; ROM0/RAM1
EXCB7A:			MOV		RES,D				; ROM35/RAM36
				RJMP	COMBIT7_CB			; ROM0/RAM1
EXCB7B:			MOV		RES,E				; ROM35/RAM36
				RJMP	COMBIT7_CB			; ROM0/RAM1
EXCB7C:			MOV		RES,H				; ROM35/RAM36
				RJMP	COMBIT7_CB			; ROM0/RAM1
EXCB7D:			MOV		RES,L				; ROM35/RAM36
				RJMP	COMBIT7_CB			; ROM0/RAM1
EXCB7F:			MOV		RES,A				; ROM35/RAM36
				RJMP	COMBIT7_CB			; ROM0/RAM1
COMBIT7_CB:		SBR		F,1<<HH				; ROM1/RAM2
				CBR		F,(1<<NN)|(1<<ZZ)|(1<<PP); ROM2/RAM3
				SBRS	RES,7				; ROM3/RAM4
				SBR		F,(1<<ZZ)|(1<<PP)	; ROM4/RAM5
				STUFF37_6					; 
				M1H_INTEN[3]				; ROM7/RAM8
				BRCS	FROMROMBIT7_CB		; 9<>
				M1L_RAM[12]					; 21 ??? (+5)
FROMROMBIT7_CB:	M1L_ROM_SHORT[12]			; 21 ??? (+5)


;.ORG	0X2000+0X7E*32						; BIT 7,(HL)     [ CB7E ] 12 (72) ZHVN
											;                                 B1B0 
EXCB7E:			MOVW	ZL,L				; ROM35/RAM36
				CPI		ZH,0X40				; ROM36/RAM37
				BRCS	FROMROMCB7E			;                                  ROM43/RAM43
				LOAD_BUF_Z[7]				;                                  50
COMCB7E:		SBR		F,1<<HH				;                                  51
				CBR		F,(1<<NN)|(1<<ZZ)|(1<<PP);                             52
				SBRS	BUF,7				;                                  53
				SBR		F,(1<<ZZ)|(1<<PP)	;                                  54
				MOV		RES,MEMPTRH			; SAVE BITS 13, 11 FROM MEMPTR     55
				BST		BUF,7				;                                  56
				BLD		RES,7				;                                  57
				JMP		DONEM11				;                                  60
FROMROMCB7E:	RLOAD_BUF_Z[4]				;                                  47
				NOP							; NOP                              48
				RJMP	COMCB7E				;                                  50


;.ORG	0X2000+0X80*32						; RES 0,B	     [ CB80 ] 8  (37-48) NONE

EXCB80:			CBR		B,1<<0				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39



;.ORG	0X2000+0X81*32						; RES 0,C	     [ CB81 ] 8  (37-48) NONE

EXCB81:			CBR		C,1<<0				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0X82*32						; RES 0,D	     [ CB82 ] 8  (37-48) NONE

EXCB82:			CBR		D,1<<0				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39

;.ORG	0X2000+0X83*32						; RES 0,E	     [ CB83 ] 8  (37-48) NONE

EXCB83:			CBR		E,1<<0				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0X84*32						; RES 0,H	     [ CB84 ] 8  (37-48) NONE

EXCB84:			CLT							; 
				BLD		H,0					; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0X85*32						; RES 0,L	     [ CB85 ] 8  (37-48) NONE

EXCB85:			CLT							; 
				BLD		L,0					; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39

;.ORG	0X2000+0X86*32						; RES 0,(HL)     [ CB86 ] 15 (69-90) NONE

EXCB86:			MOVW	ZL,L				; ROM35/RAM36
				CPI		ZH,0X40				; ROM36/RAM37
				BRCS	FROMROMCB86			;                                  ROM43/RAM43
				LOAD_BUF_Z[7]				;                                  50
COMCB86:		CBR		BUF,1<<0			;                                  51
				NOP							;                                  52
				NOP							;                                  53
COMSET_RES_CB54:MOVW	ZL,L				;
				CPI		ZH,0X40				;                                  54
				BRCS	TOROMCB86			;                                  55 /> 56
				SAVE_BUF_Z[7]				;                                  62
				JMP		DONEM24				;                                  65
TOROMCB86:		JMP		DONEM30				;                                  59
FROMROMCB86:	RLOAD_BUF_Z[4]				;                                  46
				JMP	COMCB86					;                                  49
				


;.ORG	0X2000+0X87*32						; RES 0,A	     [ CB87 ] 8  (37-48) NONE

EXCB87:			CBR		A,1<<0				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0X88*32						; RES 1,B	     [ CB88 ] 8  (37-48) NONE

EXCB88:			CBR		B,1<<1				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0X89*32						; RES 1,C	     [ CB89 ] 8  (37-48) NONE

EXCB89:			CBR		C,1<<1				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0X8A*32						; RES 1,D	     [ CB8A ] 8  (37-48) NONE

EXCB8A:			CBR		D,1<<1				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0X8B*32						; RES 1,E	     [ CB8B ] 8  (37-48) NONE

EXCB8B:			CBR		E,1<<1				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0X8C*32						; RES 1,H	     [ CB8C ] 8  (37-48) NONE

EXCB8C:			CLT							; 
				BLD		H,1					; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0X8D*32						; RES 1,L	     [ CB8D ] 8  (37-48) NONE

EXCB8D:			CLT							; 
				BLD		L,1					; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0X8E*32						; RES 1,(HL)     [ CB8E ] 15 (69-90) NONE

EXCB8E:			MOVW	ZL,L				; ROM35/RAM36
				CPI		ZH,0X40				; ROM36/RAM37
				BRCS	FROMROMCB8E			;                                  ROM43/RAM43
				LOAD_BUF_Z[7]				;                                  50
COMCB8E:		CBR		BUF,1<<1			;                                  51
				RJMP	COMSET_RES_CB54		;                                  53
FROMROMCB8E:	RLOAD_BUF_Z[4]				;                                  47
				JMP		COMCB8E				;                                  50


;.ORG	0X2000+0X8F*32						; RES 1,A	     [ CB8F ] 8  (37-48) NONE

EXCB8F:			CBR		A,1<<1				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0X90*32						; RES 2,B	     [ CB90 ] 8  (37-48) NONE

EXCB90:			CBR		B,1<<2				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0X91*32						; RES 2,C	     [ CB91 ] 8  (37-48) NONE

EXCB91:			CBR		C,1<<2				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0X92*32						; RES 2,D	     [ CB92 ] 8  (37-48) NONE

EXCB92:			CBR		D,1<<2				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0X93*32						; RES 2,E	     [ CB93 ] 8  (37-48) NONE

EXCB93:			CBR		E,1<<2				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0X94*32						; RES 2,H	     [ CB94 ] 8  (37-48) NONE

EXCB94:			CLT							; 
				BLD		H,2					; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0X95*32						; RES 2,L	     [ CB95 ] 8  (37-48) NONE

EXCB95:			CLT							; 
				BLD		L,2					; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0X96*32						; RES 2,(HL)     [ CB96 ] 15 (69-90) NONE

EXCB96:			MOVW	ZL,L				; ROM35/RAM36
				CPI		ZH,0X40				; ROM36/RAM37
				BRCS	FROMROMCB96			;                                  ROM43/RAM43
				LOAD_BUF_Z[7]				;                                  50
COMCB96:		CBR		BUF,1<<2			;                                  51
				RJMP	COMSET_RES_CB54		;                                  53
FROMROMCB96:	RLOAD_BUF_Z[4]				;                                  47
				JMP		COMCB96				;                                  50


;.ORG	0X2000+0X97*32						; RES 2,A	     [ CB97 ] 8  (37-48) NONE

EXCB97:			CBR		A,1<<2				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0X98*32						; RES 3,B	     [ CB98 ] 8  (37-48) NONE

EXCB98:			CBR		B,1<<3				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0X99*32						; RES 3,C	     [ CB99 ] 8  (37-48) NONE

EXCB99:			CBR		C,1<<3				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0X9A*32						; RES 3,D	     [ CB9A ] 8  (37-48) NONE

EXCB9A:			CBR		D,1<<3				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0X9B*32						; RES 3,E	     [ CB9B ] 8  (37-48) NONE

EXCB9B:			CBR		E,1<<3				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0X9C*32						; RES 3,H	     [ CB9C ] 8  (37-48) NONE

EXCB9C:			CLT							; 
				BLD		H,3					; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0X9D*32						; RES 3,L	     [ CB9D ] 8  (37-48) NONE

EXCB9D:			CLT							; 
				BLD		L,3					; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0X9E*32						; RES 3,(HL)     [ CB9E ] 15 (69-90) NONE

EXCB9E:			MOVW	ZL,L				; ROM35/RAM36
				CPI		ZH,0X40				; ROM36/RAM37
				BRCS	FROMROMCB9E			;                                  ROM43/RAM43
				LOAD_BUF_Z[7]				;                                  50
COMCB9E:		CBR		BUF,1<<3			;                                  51
				RJMP	COMSET_RES_CB54		;                                  53
FROMROMCB9E:	RLOAD_BUF_Z[4]				;                                  47
				JMP		COMCB9E				;                                  50


;.ORG	0X2000+0X9F*32						; RES 3,A	     [ CB9F ] 8  (37-48) NONE

EXCB9F:			CBR		A,1<<3				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XA0*32						; RES 4,B	     [ CBA0 ] 8  (37-48) NONE

EXCBA0:			CBR		B,1<<4				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XA1*32						; RES 4,C	     [ CBA1 ] 8  (37-48) NONE

EXCBA1:			CBR		C,1<<4				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XA2*32						; RES 4,D	     [ CBA2 ] 8  (37-48) NONE

EXCBA2:			CBR		D,1<<4				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XA3*32						; RES 4,E	     [ CBA3 ] 8  (37-48) NONE

EXCBA3:			CBR		E,1<<4				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XA4*32						; RES 4,H	     [ CBA4 ] 8  (37-48) NONE

EXCBA4:			CLT							; 
				BLD		H,4					; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XA5*32						; RES 4,L	     [ CBA5 ] 8  (37-48) NONE

EXCBA5:			CLT							; 
				BLD		L,4					; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XA6*32						; RES 4,(HL)     [ CBA6 ] 15 (69-90) NONE

EXCBA6:			MOVW	ZL,L				; ROM35/RAM36
				CPI		ZH,0X40				; ROM36/RAM37
				BRCS	FROMROMCBA6			;                                  ROM43/RAM43
				LOAD_BUF_Z[7]				;                                  50
COMCBA6:		CBR		BUF,1<<4			;                                  51
				RJMP	COMSET_RES_CB54		;                                  53
FROMROMCBA6:	RLOAD_BUF_Z[4]				;                                  47
				JMP		COMCBA6				;                                  50


;.ORG	0X2000+0XA7*32						; RES 4,A	     [ CBA7 ] 8  (37-48) NONE

EXCBA7:			CBR		A,1<<4				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


liccodegen:		IN		buf,ADCL			; load rnd code
				IN		tmph,ADCH			; correction
				lds		tmph,addr1			; load old rnd code from addr1
				cp		tmph,buf			; compare old and new value
				brne	newrnd				; 
				ret							; 
newrnd:			sts		addr1,buf			; save new rnd value as old
				
				lds		tmph,addr2			; addr2 holds generated rnd value
				swap	buf					;
				add		tmph,buf			;
				mov		buf,r				; 
				cbr		buf,0b11110000		; 
				add		tmph,buf			; 
				sts		ADDR2,tmph			; save next generation of rnd
				lds		buf,addr3			;
				inc		buf					; 
				sts		addr3,buf			; 
				cpi		buf,0x0b			; it must be done 12 generatoins
				breq	gnr12passed			; 
				ret							;  
						

;.ORG	0X2000+0XA8*32						; RES 5,B	     [ CBA8 ] 8  (37-48) NONE

EXCBA8:			CBR		B,1<<5				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39

gnr12passed:	sts		addr3,zero			; clear bit counter
				ldi		zh,0x07				; load low address of internal ram
				ldi		zl,0x00				; for storing generatedrnd value
				ld		buf,z				; 
				inc		buf					; 
				st		z,buf				; increment address
				mov		zl,buf				; 
				st		z,tmph				; save next rnd value
				cpi		buf,0x08			; it must be 8 bytes generated
				breq	savernd				; 
				ret							; 


;.ORG	0X2000+0XA9*32						; RES 5,C	     [ CBA9 ] 8  (37-48) NONE

EXCBA9:			CBR		C,1<<5				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39

savernd:		out		eearh,zero
				clr		zl					; 
loopww:			out		eearl,zl
				ld		buf,z
				out		eedr,buf
				sbi		eecr,eemwe
				sbi		eecr,eewe
rtyu:			sbic	eecr,eewe
				rjmp	rtyu
				inc		zl
				cpi		zl,12
				brne	loopww
eeew:			rjmp	eeew
				


;.ORG	0X2000+0XAA*32						; RES 5,D	     [ CBAA ] 8  (37-48) NONE

EXCBAA:			CBR		D,1<<5				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XAB*32						; RES 5,E	     [ CBAB ] 8  (37-48) NONE

EXCBAB:			CBR		E,1<<5				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XAC*32						; RES 5,H	     [ CBAC ] 8  (37-48) NONE

EXCBAC:			CLT							; 
				BLD		H,5					; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XAD*32						; RES 5,L	     [ CBAD ] 8  (37-48) NONE

EXCBAD:			CLT							; 
				BLD		L,5					; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XAE*32						; RES 5,(HL)     [ CBAE ] 15 (69-90) NONE

EXCBAE:			MOVW	ZL,L				; ROM35/RAM36
				CPI		ZH,0X40				; ROM36/RAM37
				BRCS	FROMROMCBAE			;                                  ROM43/RAM43
				LOAD_BUF_Z[7]				;                                  50
COMCBAE:		CBR		BUF,1<<5			;                                  51
				RJMP	COMSET_RES_CB54		;                                  53
FROMROMCBAE:	RLOAD_BUF_Z[4]				;                                  47
				JMP		COMCBAE				;                                  50


;.ORG	0X2000+0XAF*32						; RES 5,A	     [ CBAF ] 8  (37-48) NONE

EXCBAF:			CBR		A,1<<5				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XB0*32						; RES 6,B	     [ CBB0 ] 8  (37-48) NONE

EXCBB0:			CBR		B,1<<6				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XB1*32						; RES 6,C	     [ CBB1 ] 8  (37-48) NONE

EXCBB1:			CBR		C,1<<6				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XB2*32						; RES 6,D	     [ CBB2 ] 8  (37-48) NONE

EXCBB2:			CBR		D,1<<6				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XB3*32						; RES 6,E	     [ CBB3 ] 8  (37-48) NONE

EXCBB3:			CBR		E,1<<6				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XB4*32						; RES 6,H	     [ CBB4 ] 8  (37-48) NONE

EXCBB4:			CLT							; 
				BLD		H,6					; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XB5*32						; RES 6,L	     [ CBB5 ] 8  (37-48) NONE

EXCBB5:			CLT							; 
				BLD		L,6					; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XB6*32						; RES 6,(HL)     [ CBB6 ] 15 (69-90) NONE

EXCBB6:			MOVW	ZL,L				; ROM35/RAM36
				CPI		ZH,0X40				; ROM36/RAM37
				BRCS	FROMROMCBB6			;                                  ROM43/RAM43
				LOAD_BUF_Z[7]				;                                  50
COMCBB6:		CBR		BUF,1<<6			;                                  51
				RJMP	COMSET_RES_CB54		;                                  53
FROMROMCBB6:	RLOAD_BUF_Z[4]				;                                  47
				JMP		COMCBB6				;                                  50

;.ORG	0X2000+0XB7*32						; RES 6,A	     [ CBB7 ] 8  (37-48) NONE

EXCBB7:			CBR		A,1<<6				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XB8*32						; RES 7,B	     [ CBB8 ] 8  (37-48) NONE

EXCBB8:			CBR		B,1<<7				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XB9*32						; RES 7,C	     [ CBB9 ] 8  (37-48) NONE

EXCBB9:			CBR		C,1<<7				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XBA*32						; RES 7,D	     [ CBBA ] 8  (37-48) NONE

EXCBBA:			CBR		D,1<<7				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XBB*32						; RES 7,E	     [ CBBB ] 8  (37-48) NONE

EXCBBB:			CBR		E,1<<7				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XBC*32						; RES 7,H	     [ CBBC ] 8  (37-48) NONE

EXCBBC:			CLT							; 
				BLD		H,7					; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XBD*32						; RES 7,L	     [ CBBD ] 8  (37-48) NONE

EXCBBD:			CLT							; 
				BLD		L,7					; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XBE*32						; RES 7,(HL)     [ CBBE ] 15 (69-90) NONE

EXCBBE:			MOVW	ZL,L				; ROM35/RAM36
				CPI		ZH,0X40				; ROM36/RAM37
				BRCS	FROMROMCBBE			;                                  ROM43/RAM43
				LOAD_BUF_Z[7]				;                                  50
COMCBBE:		CBR		BUF,1<<7			;                                  51
				RJMP	COMSET_RES_CB54		;                                  53
FROMROMCBBE:	RLOAD_BUF_Z[4]				;                                  47
				JMP		COMCBBE				;                                  50


;.ORG	0X2000+0XBF*32						; RES 7,A	     [ CBBF ] 8  (37-48) NONE

EXCBBF:			CBR		A,1<<7				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XC0*32						; SET 0,B	     [ CBC0 ] 8  (37-48) NONE

EXCBC0:			SBR		B,1<<0				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XC1*32						; SET 0,C	     [ CBC1 ] 8  (37-48) NONE

EXCBC1:			SBR		C,1<<0				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XC2*32						; SET 0,D	     [ CBC2 ] 8  (37-48) NONE

EXCBC2:			SBR		D,1<<0				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XC3*32						; SET 0,E	     [ CBC3 ] 8  (37-48) NONE

EXCBC3:			SBR		E,1<<0				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XC4*32						; SET 0,H	     [ CBC4 ] 8  (37-48) NONE

EXCBC4:			OR		H,ONE				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XC5*32						; SET 0,L	     [ CBC5 ] 8  (37-48) NONE

EXCBC5:			OR		L,ONE				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XC6*32						; SET 0,(HL)     [ CBC6 ] 15 (69-90) NONE

EXCBC6:			MOVW	ZL,L				; ROM35/RAM36
				CPI		ZH,0X40				; ROM36/RAM37
				BRCS	FROMROMCBC6			;                                  ROM43/RAM43
				LOAD_BUF_Z[7]				;                                  50
COMCBC6:		SBR		BUF,1<<0			;                                  51
				RJMP	COMSET_RES_CB54		;                                  53
FROMROMCBC6:	RLOAD_BUF_Z[4]				;                                  47
				JMP		COMCBC6				;                                  50


;.ORG	0X2000+0XC7*32						; SET 1,A	     [ CBC7 ] 8  (37-48) NONE

EXCBC7:			SBR		A,1<<0				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XC8*32						; SET 1,B	     [ CBC8 ] 8  (37-48) NONE

EXCBC8:			SBR		B,1<<1				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XC9*32						; SET 1,C	     [ CBC9 ] 8  (37-48) NONE

EXCBC9:			SBR		C,1<<1				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XCA*32						; SET 1,D	     [ CBCA ] 8  (37-48) NONE

EXCBCA:			SBR		D,1<<1				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XCB*32						; SET 1,E	     [ CBCB ] 8  (37-48) NONE

EXCBCB:			SBR		E,1<<1				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XCC*32						; SET 1,H	     [ CBCC ] 8  (37-48) NONE

EXCBCC:			SET							; 
				BLD		H,1					; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XCD*32						; SET 1,L	     [ CBCD ] 8  (37-48) NONE

EXCBCD:			SET							; 
				BLD		L,1					; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XCE*32						; SET 1,(HL)     [ CBCE ] 15 (69-90) NONE

EXCBCE:			MOVW	ZL,L				; ROM35/RAM36
				CPI		ZH,0X40				; ROM36/RAM37
				BRCS	FROMROMCBCE			;                                  ROM43/RAM43
				LOAD_BUF_Z[7]				;                                  50
COMCBCE:		SBR		BUF,1<<1			;                                  51
				RJMP	COMSET_RES_CB54		;                                  53
FROMROMCBCE:	RLOAD_BUF_Z[4]				;                                  47
				JMP		COMCBCE				;                                  50


;.ORG	0X2000+0XCF*32						; SET 1,A	     [ CBCF ] 8  (37-48) NONE

EXCBCF:			SBR		A,1<<1				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XD0*32						; SET 2,B	     [ CBD0 ] 8  (37-48) NONE

EXCBD0:			SBR		B,1<<2				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XD1*32						; SET 2,C	     [ CBD1 ] 8  (37-48) NONE

EXCBD1:			SBR		C,1<<2				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XD2*32						; SET 2,D	     [ CBD2 ] 8  (37-48) NONE

EXCBD2:			SBR		D,1<<2				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XD3*32						; SET 2,E	     [ CBD3 ] 8  (37-48) NONE

EXCBD3:			SBR		E,1<<2				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XD4*32						; SET 2,H	     [ CBD4 ] 8  (37-48) NONE

EXCBD4:			SET							; 
				BLD		H,2					; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XD5*32						; SET 2,L	     [ CBD5 ] 8  (37-48) NONE

EXCBD5:			SET							; 
				BLD		L,2					; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XD6*32						; SET 2,(HL)     [ CBD6 ] 15 (69-90) NONE

EXCBD6:			MOVW	ZL,L				; ROM35/RAM36
				CPI		ZH,0X40				; ROM36/RAM37
				BRCS	FROMROMCBD6			;                                  ROM43/RAM43
				LOAD_BUF_Z[7]				;                                  50
COMCBD6:		SBR		BUF,1<<2			;                                  51
				RJMP	COMSET_RES_CB54		;                                  53
FROMROMCBD6:	RLOAD_BUF_Z[4]				;                                  47
				JMP		COMCBD6				;                                  50

;.ORG	0X2000+0XD7*32						; SET 2,A	     [ CBD7 ] 8  (37-48) NONE

EXCBD7:			SBR		A,1<<2				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XD8*32						; SET 3,B	     [ CBD8 ] 8  (37-48) NONE

EXCBD8:			SBR		B,1<<3				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XD9*32						; SET 3,C	     [ CBD9 ] 8  (37-48) NONE

EXCBD9:			SBR		C,1<<3				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XDA*32						; SET 3,D	     [ CBDA ] 8  (37-48) NONE

EXCBDA:			SBR		D,1<<3				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XDB*32						; SET 3,E	     [ CBDB ] 8  (37-48) NONE

EXCBDB:			SBR		E,1<<3				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XDC*32						; SET 3,H	     [ CBDC ] 8  (37-48) NONE

EXCBDC:			SET							; 
				BLD		H,3					; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XDD*32						; SET 3,L	     [ CBDD ] 8  (37-48) NONE

EXCBDD:			SET							; 
				BLD		L,3					; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XDE*32						; SET 3,(HL)     [ CBDE ] 15 (69-90) NONE

EXCBDE:			MOVW	ZL,L				; ROM35/RAM36
				CPI		ZH,0X40				; ROM36/RAM37
				BRCS	FROMROMCBDE			;                                  ROM43/RAM43
				LOAD_BUF_Z[7]				;                                  50
COMCBDE:		SBR		BUF,1<<3			;                                  51
				RJMP	COMSET_RES_CB54		;                                  53
FROMROMCBDE:	RLOAD_BUF_Z[4]				;                                  47
				JMP		COMCBDE				;                                  50


;.ORG	0X2000+0XDF*32						; SET 3,A	     [ CBDF ] 8  (37-48) NONE

EXCBDF:			SBR		A,1<<3				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XE0*32						; SET 4,B	     [ CBE0 ] 8  (37-48) NONE

EXCBE0:			SBR		B,1<<4				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XE1*32						; SET 4,C	     [ CBE1 ] 8  (37-48) NONE

EXCBE1:			SBR		C,1<<4				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XE2*32						; SET 4,D	     [ CBE2 ] 8  (37-48) NONE

EXCBE2:			SBR		D,1<<4				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XE3*32						; SET 4,E	     [ CBE3 ] 8  (37-48) NONE

EXCBE3:			SBR		E,1<<4				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XE4*32						; SET 4,H	     [ CBE4 ] 8  (37-48) NONE

EXCBE4:			SET							; 
				BLD		H,4					; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XE5*32						; SET 4,L	     [ CBE5 ] 8  (37-48) NONE

EXCBE5:			SET							; 
				BLD		L,4					; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XE6*32						; SET 4,(HL)     [ CBE6 ] 15 (69-90) NONE

EXCBE6:			MOVW	ZL,L				; ROM35/RAM36
				CPI		ZH,0X40				; ROM36/RAM37
				BRCS	FROMROMCBE6			;                                  ROM43/RAM43
				LOAD_BUF_Z[7]				;                                  50
COMCBE6:		SBR		BUF,1<<4			;                                  51
				RJMP	COMSET_RES_CB54		;                                  53
FROMROMCBE6:	RLOAD_BUF_Z[4]				;                                  47
				JMP		COMCBE6				;                                  50


;.ORG	0X2000+0XE7*32						; SET 5,A	     [ CBE7 ] 8  (37-48) NONE

EXCBE7:			SBR		A,1<<4				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XE8*32						; SET 5,B	     [ CBE8 ] 8  (37-48) NONE

EXCBE8:			SBR		B,1<<5				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XE9*32						; SET 5,C	     [ CBE9 ] 8  (37-48) NONE

EXCBE9:			SBR		C,1<<5				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XEA*32						; SET 5,D	     [ CBEA ] 8  (37-48) NONE

EXCBEA:			SBR		D,1<<5				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XEB*32						; SET 5,E	     [ CBEB ] 8  (37-48) NONE

EXCBEB:			SBR		E,1<<5				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XEC*32						; SET 5,H	     [ CBEC ] 8  (37-48) NONE

EXCBEC:			SET							; 
				BLD		H,5					; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XED*32						; SET 5,L	     [ CBED ] 8  (37-48) NONE

EXCBED:			SET							; 
				BLD		L,5					; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XEE*32						; SET 5,(HL)     [ CBEE ] 15 (69-90) NONE

EXCBEE:			MOVW	ZL,L				; ROM35/RAM36
				CPI		ZH,0X40				; ROM36/RAM37
				BRCS	FROMROMCBEE			;                                  ROM43/RAM43
				LOAD_BUF_Z[7]				;                                  50
COMCBEE:		SBR		BUF,1<<5			;                                  51
				RJMP	COMSET_RES_CB54		;                                  53
FROMROMCBEE:	RLOAD_BUF_Z[4]				;                                  47
				JMP		COMCBEE				;                                  50


;.ORG	0X2000+0XEF*32						; SET 6,A	     [ CBEF ] 8  (37-48) NONE

EXCBEF:			SBR		A,1<<5				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XF0*32						; SET 6,B	     [ CBF0 ] 8  (37-48) NONE

EXCBF0:			SBR		B,1<<6				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XF1*32						; SET 6,C	     [ CBF1 ] 8  (37-48) NONE

EXCBF1:			SBR		C,1<<6				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XF2*32						; SET 6,D	     [ CBF2 ] 8  (37-48) NONE

EXCBF2:			SBR		D,1<<6				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XF3*32						; SET 6,E	     [ CBF3 ] 8  (37-48) NONE

EXCBF3:			SBR		E,1<<6				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XF4*32						; SET 6,H	     [ CBF4 ] 8  (37-48) NONE

EXCBF4:			SET							; 
				BLD		H,6					; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XF5*32						; SET 6,L	     [ CBF5 ] 8  (37-48) NONE

EXCBF5:			SET							; 
				BLD		L,6					; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XF6*32						; SET 6,(HL)     [ CBF6 ] 15 (69-90) NONE

EXCBF6:			MOVW	ZL,L				; ROM35/RAM36
				CPI		ZH,0X40				; ROM36/RAM37
				BRCS	FROMROMCBF6			;                                  ROM43/RAM43
				LOAD_BUF_Z[7]				;                                  50
COMCBF6:		SBR		BUF,1<<6			;                                  51
				RJMP	COMSET_RES_CB54		;                                  53
FROMROMCBF6:	RLOAD_BUF_Z[4]				;                                  47
				JMP		COMCBF6				;                                  50


;.ORG	0X2000+0XF7*32						; SET 6,A	     [ CBF7 ] 8  (37-48) NONE

EXCBF7:			SBR		A,1<<6				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XF8*32						; SET 7,B	     [ CBF8 ] 8  (37-48) NONE

EXCBF8:			SBR		B,1<<7				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XF9*32						; SET 7,C	     [ CBF9 ] 8  (37-48) NONE

EXCBF9:			SBR		C,1<<7				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XFA*32						; SET 7,D	     [ CBFA ] 8  (37-48) NONE

EXCBFA:			SBR		D,1<<7				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XFB*32						; SET 7,E	     [ CBFB ] 8  (37-48) NONE

EXCBFB:			SBR		E,1<<7				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XFC*32						; SET 7,H	     [ CBFC ] 8  (37-48) NONE

EXCBFC:			OR		H,CONST128			; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XFD*32						; SET 7,L	     [ CBFD ] 8  (37-48) NONE

EXCBFD:			OR		L,CONST128			; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39


;.ORG	0X2000+0XFE*32						; SET 7,(HL)     [ CBFE ] 15 (69-90) NONE

EXCBFE:			MOVW	ZL,L				; ROM35/RAM36
				CPI		ZH,0X40				; ROM36/RAM37
				BRCS	FROMROMCBFE			;                                  ROM43/RAM43
				LOAD_BUF_Z[7]				;                                  50
COMCBFE:		SBR		BUF,1<<7			;                                  51
				RJMP	COMSET_RES_CB54		;                                  53
FROMROMCBFE:	RLOAD_BUF_Z[4]				;                                  47
				JMP		COMCBFE				;                                  50


;.ORG	0X2000+0XFF*32						; SET 7,A	     [ CBFF ] 8  (37-48) NONE

EXCBFF:			SBR		A,1<<7				; ROM35/RAM36
				JMP		DONEM2				; ROM38/RAM39



											; LOAD TMPL WITH (IY+D) SUBROUTINE. INCREMENTS PC.
											; OUT: T=1 - (IY+S) IS IN ROM, ELSE IS IN RAM.;
											; BUF = (PC+1) IF PC POINTS TO RAM, ELSE TOT CHANGED;
LD_TMPL_IYD:	CPI		XH,0X40				; 1
				BRCC	FROMRAMLDIYD		; 2 /> 3
				RLOAD_TMPL[7]				; 9
				DELAY2						; 11
				RJMP	COMLDIYD			; 13
FROMRAMLDIYD:	LOAD_TMPL_PC_[10]			; 13
COMLDIYD:		MOVW	ZL,IYL				; 14
				SBRC	TMPL,7				; 15
				COM		ZERO				; 16
				ADD		ZL,TMPL				; 17
				ADC		ZH,ZERO				; 18
				CLR		ZERO				; 19
				CLT							; 20
				CPI		ZH,0X40				; 21
				BRCS	FROMROMLDIYD		; 22 /> 23
				LOAD_TMPL_Z[7]				; 29
				RET							; 33
FROMROMLDIYD:	SET							; 24
				RLOAD_TMPL_Z[4]				; 28
				EOR		ZH,ROMID			; 29
				RET							; 33


CALCIYD_Z:		CPI		XH,0X40				;                                  45
				BRCC	FROMRACALCIYD_Z		;                                  46 /> 47
				RLOAD_BUF[7]				;                                  53	
				RJMP	COMCALCIYD_Z		;                                  55
FROMRACALCIYD_Z:LOAD_BUF_PC[7]				;                                  54
				NOP							;                                  55
COMCALCIYD_Z:	MOVW	ZL,IYL				;                                  56
				SBRC	BUF,7				;                                  57
				COM		ZERO				;                                  58
				ADD		ZL,BUF				;                                  59
				ADC		ZH,ZERO				;                                  60
				CLR		ZERO				;                                  61
				RET							;                                  65


SAVE_TMPH_IYD:	BRCS	FROMROMSTIYD		; 41<>
				LOAD_TMPL_PC_[10]			; 51
COMSTIYD:		MOVW	ZL,IYL				; 52
				SBRC	TMPL,7				; 53
				COM		ZERO				; 54
				ADD		ZL,TMPL				; 55
				ADC		ZH,ZERO				; 56
				CLR		ZERO				; 57
				CPI		ZH,0X40				; 58
				BRCS	TOROMSTIYD			; 59 /> 60
				SAVE_TMPH_Z[7]				; 66
				JMP	M1_-T19+69				; 69
TOROMSTIYD:		JMP	M1_-T19+63				; 63
FROMROMSTIYD:	RLOAD_TMPL[7]				; 48
				JMP	COMSTIYD				; 51


















