

;.ORG	0X4000+0X09*32 						; ADD IX,BC      [ DD09 ] 15 (69-90) HNC
											;                                     0
EXDD09:			MOVW	ZL,C				; ROM35/RAM36
				RJMP	COMADDIXRP			; ROM37/RAM38
COMADDIXRP:		BRCS	TIMECORDD09			; 39<>
TIMECORDD09:	BST		RES,7				; 40
				MOVW	MEMPTRL,IXL			; 41
				ADD		MEMPTRL,ONE			; 42
				ADC		MEMPTRH,ZERO		; 43
				ADD		IXL,ZL				; 44
				ADC		IXH,ZH				; 45
				IN		BUF,SREG			; 46
				MOV		RES,IXH				; 47
				BLD		RES,7				; 48
				ANDI	BUF,(1<<HH)|(1<<CC)	; 49
				CBR		F,(1<<HH)|(1<<NN)|(1<<CC);50
				OR		F,BUF				; 51
				JMP		M1-T15+55			; 55


;.ORG	0X4000+0X19*32 						; ADD IX,DE      [ DD19 ] 15 (69-90) HNC
											;                                     0
EXDD19:			MOVW	ZL,E				; ROM35/RAM36
				RJMP	COMADDIXRP			; ROM37/RAM38


;.ORG	0X4000+0X21*32						; LD IX,NN  [ DD21 ] 14 (64-84) NONE

EXDD21:			BRCS	FROMROMDD21			; 36<>
				LOAD_IX_PC_[13]				; 49
				OUT		RAMPZ,ONE			; 50
				JMP		M1_-T10+53			; 53
FROMROMDD21:	RLOAD_IX[10]				; 46
				JMP		M1-T10+49			; 49


;.ORG	0X4000+0X22*32						; LD (NN),IX     [ DD22 ] 20 (120) NONE
EXDD22:			BRCS	FROMROMDD22			; 36<>
				XON_RBBCP					; 38
				LD		ZL,X+				; 41
				LD		ZH,X+				; 44
				LD		BUF,X				; 47
				CPI		ZH,0X40				; 48
				BRCS	TOROMDD22			; 49 /> 50
				ST		Z+,IXL				; 52
				ST		Z,IXH				; 55
				XOFF_RBBCP					; 57 
				OUT		RAMPZ,ONE			; 58
				MOVW	MEMPTRL,ZL			; 59
				JMP		M1_-T20+62			; 62
TOROMDD22:		XOFF_RBBCP					; 52
				OUT		RAMPZ,ONE			; 53
				ADIW	ZL,0X01				; 55
				MOVW	MEMPTRL,ZL			; 56
				JMP		M1_-T20+59			; 59
FROMROMDD22:	RLOAD_Z_PC[11]				; 47
				CPI		ZH,0X40				; 48
				BRCS	TOROMDD22_			; 49 /> 50
				SAVE_IX_Z[10]				; 59
				OUT		RAMPZ,ONE			; 60
				MOVW	MEMPTRL,ZL			; 61
				JMP		M1-T16+64			; 64
TOROMDD22_:		ADIW	ZL,0X01				; 52
				MOVW	MEMPTRL,ZL			; 53
				JMP		M1-T16+56			; 56


;.ORG	0X4000+0X23*32						; INC IX         [ DD23 ] 10 (46-60) NONE
				
EXDD23:			BRCS	TIMECORDD23			; 36<>
TIMECORDD23:	ADD		IXL,ONE				; 37
				ADC		IXH,ZERO			; 38
				JMP		M1-T10+41			; 41


;.ORG	0X4000+0X24*32						; INC IXH*       [ DD24 ]  8 (37-48) SZHVN
				                            ;                                        0
EXDD24:			BST		F,CC				; ROM35/RAM36
				ADD		IXH,ONE				; ROM36/RAM0
				IN		F,SREG				; ROM0/RAM1
				BLD		F,CC				; ROM1/RAM2
				CBR		F,1<<NN				; ROM2/RAM3
				MOV		RES,IXH				; ROM3/RAM4
				STUFF37_7					; 
				M1H_INTEN[3]				; ROM6/RAM7
				BRCS	FROMROMDD24			; 8<>
				M1L_RAM[12]					; 20 ??? (+4)
FROMROMDD24:	M1L_ROM_SHORT[12]			; 20 ??? (+4)


;.ORG	0X4000+0X25*32						; DEC IXH*       [ DD25 ]  8 (37-48) SZHVN
				                            ;                                        1
EXDD25:			BST		F,CC				; ROM35/RAM36
				SUB		IXH,ONE				; ROM36/RAM0
				IN		F,SREG				; ROM0/RAM1
				BLD		F,CC				; ROM1/RAM2
				SBR		F,1<<NN				; ROM2/RAM3
				MOV		RES,IXH				; ROM3/RAM4
				STUFF37_7					; 
				M1H_INTEN[3]				; ROM6/RAM7
				BRCS	FROMROMDD25			; 8<>
				M1L_RAM[12]					; 20 ??? (+4)
FROMROMDD25:	M1L_ROM_SHORT[12]			; 20 ??? (+4)


;.ORG	0X4000+0X26*32						; LD IXH,N*      [ DD26 ] 11  (50-66) NONE
											; CRITICAL TO TIMINGS FOR END OF VIBRATIONS DEMO
EXDD26:			CPI		PCH,0X40			;                                  40
				BRCS	FROMROMDD26			;                                  41 /> 42
				LOAD_BUF_PC[7]				;                                  48
				MOV		IXH,BUF				;                                  49
				JMP		DONEM13				;                                  52
FROMROMDD26:	RLOAD_BUF[7]				;                                  47
				MOV		IXH,BUF				;                                  48
				JMP		DONEM14				;                                  51	


;EXDD26:		BRCS	FROMROMDD26			; 36<>
;				LOAD_IXH_PC_[10]			; 46
;				JMP		M1_-T11+49			; 49
;FROMROMDD26:	RLOAD_IXH[7]				; 43
;				JMP		M1-T11+46			; 46	


;.ORG	0X4000+0X29*32						; ADD IX,IX      [ DD29 ] 15 (69-90) HNC
                                            ;                                  0
EXDD29:			BRCS	TIMECORDD29			; 36<>
TIMECORDD29:	MOVW	MEMPTRL,IXL			; 37
				ADD		MEMPTRL,ONE			; 38
				ADC		MEMPTRH,ZERO		; 39
				ADD		IXL,IXL				; 40
				ADC		IXH,IXH				; 41
				IN		BUF,SREG			; 42
				BST		RES,7				; 43
				MOV		RES,IXH				; 44
				BLD		RES,7				; 45
				ANDI	BUF,(1<<HH)|(1<<CC)	; 46
				CBR		F,(1<<HH)|(1<<NN)|(1<<CC);47
				OR		F,BUF				; 48
				JMP		M1-T15+51			; 51


;.ORG	0X4000+0X2A*32						; LD IX,(NN)     [ DD2A ] 20 (120) NONE
				
EXDD2A:			BRCS	FROMROMDD2A			; 18 /> 19
				XON_RBBCP					; 20
				LD		ZL,X+				; 23
				LD		ZH,X+				; 26
				LD		BUF,X				; 29
				CPI		ZH,0X40				; 30
				BRCS	FROMROMDD2A_		; 31 /> 32
				LD		IXL,Z+				; 34
				LD		IXH,Z				; 37
				XOFF_RBBCP					; 39
				OUT		RAMPZ,ONE			; 40
				MOVW	MEMPTRL,ZL			; 41
				JMP		M1_-T16+44			; 44
FROMROMDD2A_:	XOFF_RBBCP					; 34
				OUT		RAMPZ,ONE			; 35
				OR		ZH,ROMID			; 36
				ELPM	IXL,Z+				; 39
				ELPM	IXH,Z				; 42
				EOR		ZH,ROMID			; 43
				MOVW	MEMPTRL,ZL			; 44
				JMP		M1_-T16+47			; 47
FROMROMDD2A:	RLOAD_Z_PC[11]				; 30
				CPI		ZH,0X40				; 31
				BRCS	FROMROMDD2A_+1		; 32 /> 33
				LOAD_IX_Z[10]				; 42
				OUT		RAMPZ,ONE			; 43
				MOVW	MEMPTRL,ZL			; 44
				JMP		M1-T16+47			; 47


;.ORG	0X4000+0X2B*32						; DEC IX         [ DD2B ] 10 (46-60) NONE

EXDD2B:			BRCS	TIMECORDD2B			; 36<>
TIMECORDD2B:	SUB		IXL,ONE				; 37
				SBC		IXH,ZERO			; 38
				JMP		M1-T10+41			; 41


;.ORG	0X4000+0X2C*32						; INC IXL*       [ DD2C ] 8 (37-48) SZHVN
				                            ;                                    0
EXDD2C:			BST		F,CC				; ROM35/RAM36
				ADD		IXL,ONE				; ROM36/RAM0
				IN		F,SREG				; ROM0/RAM1
				BLD		F,CC				; ROM1/RAM2
				CBR		F,1<<NN				; ROM2/RAM3
				MOV		RES,IXL				; ROM3/RAM4
				STUFF37_7					; 
				M1H_INTEN[3]				; ROM6/RAM7
				BRCS	FROMROMDD2C			; 8<>
				M1L_RAM[12]					; 20 ??? (+4)
FROMROMDD2C:	M1L_ROM_SHORT[12]			; 20 ??? (+4)


;.ORG	0X4000+0X2D*32						; DEC IXL*       [ DD2D ] 8 (37-48) SZHVN	
											;                                    1
EXDD2D:			BST		F,CC				; ROM35/RAM36
				SUB		IXL,ONE				; ROM36/RAM0
				IN		F,SREG				; ROM0/RAM1
				BLD		F,CC				; ROM1/RAM2
				SBR		F,1<<NN				; ROM2/RAM3
				MOV		RES,IXL				; ROM3/RAM4
				STUFF37_7					; 
				M1H_INTEN[3]				; ROM6/RAM7
				BRCS	FROMROMDD2D			; 8<>
				M1L_RAM[12]					; 20 ??? (+4)
FROMROMDD2D:	M1L_ROM_SHORT[12]			; 20 ??? (+4)


;.ORG	0X4000+0X2E*32						; LD IXL,N*      [ DD2E ] 11 (50-66) NONE

EXDD2E:			BRCS	FROMROMDD2E			; 36<>
				LOAD_IXL_PC_[10]			; 46
				JMP		M1_-T11+49			; 49
FROMROMDD2E:	RLOAD_IXL[7]				; 43
				JMP		M1-T11+46			; 46



;.ORG	0X4000+0X34*32						; INC (IX+D)    [ DD34 ] 23 (138) SZHVN
				                            ;                                     0
EXDD34:			BRCS	TIMECORDD34			; 36<>
TIMECORDD34:	CALL	LD_TMPL_IXD			; 40 + 33 => 73
				CBR		F,(1<<SS)|(1<<ZZ)|(1<<HH)|(1<<VV)|(1<<NN); 73
				ADD		TMPL,ONE			; 74
				MOV		RES,TMPL			; 75
				IN		TMPH,SREG			; 76
				ANDI	TMPH,(1<<SS)|(1<<ZZ)|(1<<HH)|(1<<VV); 77
				OR		F,TMPH				; 78
				CPI		ZH,0X40				; 79
				BRCS	TOROMDD34			; 80 /> 81
				SAVE_RES_Z[7]				; 87
				JMP		M1_-T23+90			; 90
TOROMDD34:		JMP		M1_-T23+84			; 84


;.ORG	0X4000+0X35*32						; DEC (IX+D)    [ DD35 ] 23 (138) SZHVN
				                            ;                                     1
EXDD35:			BRCS	TIMECORDD35			; 36<>
TIMECORDD35:	CALL	LD_TMPL_IXD			; 40 + 33 => 73
				CBR		F,(1<<SS)|(1<<ZZ)|(1<<HH)|(1<<VV); 73
				SUB		TMPL,ONE			; 74
				MOV		RES,TMPL			; 75
				IN		TMPH,SREG			; 76
				ANDI	TMPH,(1<<SS)|(1<<ZZ)|(1<<HH)|(1<<VV); 77
				OR		F,TMPH				; 78
				SBR		F,1<<NN				; 79
				CPI		ZH,0X40				; 80
				BRCS	TOROMDD35			; 81 /> 82
				SAVE_RES_Z[7]				; 88
				JMP		M1_-T23+91			; 91
TOROMDD35:		JMP		M1_-T23+85			; 85


;.ORG	0X4000+0X36*32						; LD (IX+D),N   [ DD36 ] 19 (87-114) NONE

EXDD36:			BRCS	FROMROMDD36			; 36<>
				XON_RBBCP					; 38
				LD		TMPL,X+				; 41
				LD		TMPH,X+				; 44
				LD		BUF,X				; 47
				XOFF_RBBCP					; 49
COMDD36:		MOVW	ZL,IXL				; 50
				SBRC	TMPL,7				; 51
				COM		ZERO				; 52
				ADD		ZL,TMPL				; 53
				ADC		ZH,ZERO				; 54
				CLR		ZERO				; 55
				CPI		ZH,0X40				; 56
				BRCS	TOROMDD36			; 57 /> 58
				SAVE_TMPH_Z[7]				; 64
				JMP		M1_-T19+67			; 67
TOROMDD36:		JMP		M1_-T19+61			; 61
FROMROMDD36:	MOVW	ZL,PCL				; 37
				OR		ZH,ROMID			; 38
				ELPM	TMPL,Z+				; 41
				ELPM	TMPH,Z				; 44
				ADIW	PCL,0X02			; 46
				DELAY1						; 47
				RJMP	COMDD36				; 49


;.ORG	0X4000+0X39*32						; ADD IX,SP      [ DD39 ] 15 (69-90) HNC
                                            ;                                     0
EXDD39:			MOVW	ZL,STPL				; ROM35/RAM36
				RJMP	COMADDIXRP			; ROM36/RAM0
				

;.ORG	0X4000+0X44*32						; LD B,IXH* [ DD44 ]    8  (37-48) NONE

EXDD44:			MOV		B,IXH				; ROM35/RAM36
				RJMP	COMM1HDD			; ROM0/RAM1
COMM1HDD:		STUFF37_11					; 
				M1H_INTEN_SHORT[2]			; ROM2/RAM3
				BRCS	FROMROMDD44			; 4<>
				M1L_RAM[12]					; 16
FROMROMDD44:	M1L_ROM_SHORT[12]			; 16


;.ORG	0X4000+0X45*32						; LD B,IXL* [ DD45 ]    8  (37-48) NONE

EXDD45:			MOV		B,IXL				; ROM35/RAM36
				RJMP	COMM1HDD			; ROM0/RAM1


;.ORG	0X4000+0X46*32						; LD B,(IX+D) [ DD46 ]   19  (87-114) NONE

EXDD46:			BRCS	TIMECORDD46			; 36<>
TIMECORDD46:	CALL	LD_TMPL_IXD			; 40 + 33 => 73
				MOV		B,TMPL				; 74
				JMP		M1_-T19+77			; 77


;.ORG	0X4000+0X4C*32						; LD C,IXH* [ DD4C ]    8  (37-48) NONE

EXDD4C:			MOV		C,IXH				; ROM35/RAM36
				RJMP	COMM1HDD			; ROM0/RAM1


;.ORG	0X4000+0X4D*32						; LD C,IXL* [ DD4D ]    8  (37-48) NONE

EXDD4D:			MOV		C,IXL				; ROM35/RAM36
				RJMP	COMM1HDD			; ROM0/RAM1


;.ORG	0X4000+0X4E*32						; LD C,(IX+D) [ DD4E ]   19  (87-114) NONE

EXDD4E:			BRCS	TIMECORDD4E			; 36<>
TIMECORDD4E:	CALL	LD_TMPL_IXD			; 40 + 33 => 73
				MOV		C,TMPL				; 74
				JMP		M1_-T19+77			; 77


;.ORG	0X4000+0X54*32						; LD D,IXH* [ DD54 ]    8  (37-48) NONE

EXDD54:			MOV		D,IXH				; ROM35/RAM36
				RJMP	COMM1HDD			; ROM0/RAM1


;.ORG	0X4000+0X55*32						; LD D,IXL* [ DD55 ]    8  (37-48) NONE

EXDD55:			MOV		D,IXL				; ROM35/RAM36
				RJMP	COMM1HDD			; ROM0/RAM1


;.ORG	0X4000+0X56*32						; LD D,(IX+D) [ DD56 ]   19  (87-114) NONE

EXDD56:			BRCS	TIMECORDD56			; 36<>
TIMECORDD56:	CALL	LD_TMPL_IXD			; 40 + 33 => 73
				MOV		D,TMPL				; 74
				JMP		M1_-T19+77			; 77


;.ORG	0X4000+0X5C*32						; LD E,IXH* [ DD5C ]    8  (37-48) NONE

EXDD5C:			MOV		E,IXH				; ROM35/RAM36
				RJMP	COMM1HDD			; ROM0/RAM1


;.ORG	0X4000+0X5D*32						; LD E,IXL* [ DD5D ]    8  (37-48) NONE

EXDD5D:			MOV		E,IXL				; ROM35/RAM36
				RJMP	COMM1HDD			; ROM0/RAM1


;.ORG	0X4000+0X5E*32						; LD E,(IX+D) [ DD5E ]   19  (87-114) NONE

EXDD5E:			BRCS	TIMECORDD5E			; 36<>
TIMECORDD5E:	CALL	LD_TMPL_IXD			; 40 + 33 => 73
				MOV		E,TMPL				; 74
				JMP		M1_-T19+77			; 77


;.ORG	0X4000+0X60*32						; LD IXH,B*    [ DD60 ]    8  (37-48) NONE

EXDD60:			MOV		IXH,B				; ROM35/RAM36
				RJMP	COMM1HDD			; ROM0/RAM1


;.ORG	0X4000+0X61*32						; LD IXH,C*    [ DD61 ]    8  (37-48) NONE

EXDD61:			MOV		IXH,C				; ROM35/RAM36
				RJMP	COMM1HDD			; ROM0/RAM1


;.ORG	0X4000+0X62*32						; LD IXH,D*    [ DD62 ]    8  (37-48) NONE

EXDD62:			MOV		IXH,D				; ROM35/RAM36
				RJMP	COMM1HDD			; ROM0/RAM1


;.ORG	0X4000+0X63*32						; LD IXH,E*    [ DD63 ]    8  (37-48) NONE

EXDD63:			MOV		IXH,E				; ROM35/RAM36
				RJMP	COMM1HDD			; ROM0/RAM1


;.ORG	0X4000+0X64*32						; LD IXH,IXH*    [ DD64 ]    8  (37-48) NONE

EXDD64:			MOV		IXH,IXH				; ROM35/RAM36
				RJMP	COMM1HDD			; ROM0/RAM1


;.ORG	0X4000+0X65*32						; LD IXH,IXL*    [ DD65 ]    8  (37-48) NONE

EXDD65:			MOV		IXH,IXL				; ROM35/RAM36
				RJMP	COMM1HDD			; ROM0/RAM1


;.ORG	0X4000+0X66*32						; LD H,(IX+D) [ DD66 ]   19  (87-114) NONE

EXDD66:			BRCS	TIMECORDD66			; 36<>
TIMECORDD66:	CALL	LD_TMPL_IXD			; 40 + 33 => 73
				MOV		H,TMPL				; 74
				JMP		M1_-T19+77			; 77


;.ORG	0X4000+0X67*32						; LD IXH,A*    [ DD67 ]    8  (37-48) NONE

EXDD67:			MOV		IXH,A				; ROM35/RAM36
				RJMP	COMM1HDD			; ROM0/RAM1


;.ORG	0X4000+0X68*32						; LD IXL,B*    [ DD68 ]    8  (37-48) NONE

EXDD68:			MOV		IXL,B				; ROM35/RAM36
				RJMP	COMM1HDD			; ROM0/RAM1


;.ORG	0X4000+0X69*32						; LD IXL,C*    [ DD69 ]    8  (37-48) NONE

EXDD69:			MOV		IXL,C				; ROM35/RAM36
				RJMP	COMM1HDD			; ROM0/RAM1


;.ORG	0X4000+0X6A*32						; LD IXL,D*    [ DD6A ]    8  (37-48) NONE

EXDD6A:			MOV		IXL,D				; ROM35/RAM36
				RJMP	COMM1HDD			; ROM0/RAM1


;.ORG	0X4000+0X6B*32						; LD IXL,E*    [ DD6B ]    8  (37-48) NONE

EXDD6B:			MOV		IXL,E				; ROM35/RAM36
				RJMP	COMM1HDD			; ROM0/RAM1


;.ORG	0X4000+0X6C*32						; LD IXL,IXH*    [ DD6C ]    8  (37-48) NONE

EXDD6C:			MOV		IXL,IXH				; ROM35/RAM36
				RJMP	COMM1HDD			; ROM0/RAM1


;.ORG	0X4000+0X6D*32						; LD IXL,IXL*    [ DD6D ]    8  (37-48) NONE

EXDD6D:			MOV		IXL,IXL				; ROM35/RAM36
				RJMP	COMM1HDD			; ROM0/RAM1


;.ORG	0X4000+0X6E*32						; LD L,(IX+D) [ DD6E ]   19  (87-114) NONE

EXDD6E:			BRCS	TIMECORDD6E			; 36<>
TIMECORDD6E:	CALL	LD_TMPL_IXD			; 40 + 33 => 73
				MOV		L,TMPL				; 74
				JMP		M1_-T19+77			; 77


;.ORG	0X4000+0X6F*32						; LD IXL,A*    [ DD6F ]    8  (37-48) NONE

EXDD6F:			MOV		IXL,A				; ROM35/RAM36
				RJMP	COMM1HDD			; ROM0/RAM1


;.ORG	0X4000+0X70*32						; LD (IX+D),B  [ DD70 ]  19 (87-114) NONE

EXDD70:			MOV		TMPH,B				; ROM35/RAM36
				JMP		SAVE_TMPH_IXD		; ROM38/RAM39
				


;.ORG	0X4000+0X71*32						; LD (IX+D),C  [ DD71 ]  19 (87-114) NONE

EXDD71:			MOV		TMPH,C				; ROM35/RAM36
				JMP		SAVE_TMPH_IXD		; ROM38/RAM39


;.ORG	0X4000+0X72*32						; LD (IX+D),D  [ DD72 ]  19 (87-114) NONE

EXDD72:			MOV		TMPH,D				; ROM35/RAM36
				JMP		SAVE_TMPH_IXD		; ROM38/RAM39


;.ORG	0X4000+0X73*32						; LD (IX+D),E  [ DD73 ]  19 (87-114) NONE

EXDD73:			MOV		TMPH,E				; ROM35/RAM36
				JMP		SAVE_TMPH_IXD		; ROM38/RAM39


;.ORG	0X4000+0X74*32						; LD (IX+D),H  [ DD74 ]  19 (87-114) NONE

EXDD74:			MOV		TMPH,H				; ROM35/RAM36
				JMP		SAVE_TMPH_IXD		; ROM38/RAM39


;.ORG	0X4000+0X75*32						; LD (IX+D),L  [ DD75 ]  19 (87-114) NONE

EXDD75:			MOV		TMPH,L				; ROM35/RAM36
				JMP		SAVE_TMPH_IXD		; ROM38/RAM39


;.ORG	0X4000+0X77*32						; LD (IX+D),A  [ DD77 ]  19 (87-114) NONE

EXDD77:			MOV		TMPH,A				; ROM35/RAM36
				JMP		SAVE_TMPH_IXD		; ROM38/RAM39


;.ORG	0X4000+0X7C*32						; LD A,IXH*    [ DD7C ]    8  (37-48) NONE

EXDD7C:			MOV		A,IXH				; ROM35/RAM36
				RJMP	COMM1HDD			; ROM0/RAM1


;.ORG	0X4000+0X7D*32						; LD A,IXL*    [ DD7D ]    8  (37-48) NONE

EXDD7D:			MOV		A,IXL				; ROM35/RAM36
				RJMP	COMM1HDD			; ROM0/RAM1


;.ORG	0X4000+0X7E*32						; LD A,(IX+D) [ DD7E ]   19  (87-114) NONE

EXDD7E:			BRCS	TIMECORDD7E			; 36<>
TIMECORDD7E:	CALL	LD_TMPL_IXD			; 40 + 33 => 73
				MOV		A,TMPL				; 74
				JMP		M1_-T19+77			; 77


;.ORG	0X4000+0X84*32						; ADD A,IXH*  [ DD84 ]  8 (37-48) SZHVNC
				                            ;                                     0
EXDD84:			ADD		A,IXH				; ROM35/RAM36
				IN		F,SREG				; ROM36/RAM0
				CBR		F,1<<NN				; ROM0/RAM1
				MOV		RES,A				; ROM1/RAM2
				STUFF37_9					;
				M1H_INTEN[3]				; ROM4/RAM5
				BRCS	FROMROMDD84			; 6<>
				M1L_RAM[12]					; 18 ??? (+2)
FROMROMDD84:	M1L_ROM_SHORT[12]			; 18 ??? (+2)

;.ORG	0X4000+0X85*32						; ADD A,IXL*  [ DD85 ]  8 (37-48) SZHVNC
				                            ;                                     0
EXDD85:			ADD		A,IXL				; ROM35/RAM36
				IN		F,SREG				; ROM36/RAM0
				CBR		F,1<<NN				; ROM0/RAM1
				MOV		RES,A				; ROM1/RAM2
				STUFF37_9					;
				M1H_INTEN[3]				; ROM4/RAM5
				BRCS	FROMROMDD85			; 6<>
				M1L_RAM[12]					; 18 ??? (+2)
FROMROMDD85:	M1L_ROM_SHORT[12]			; 18 ??? (+2)


;.ORG	0X4000+0X86*32						; ADD A,(IX+D) [ DD86 ]   19  (87-114) SZHVNC
											;                                          0
EXDD86:			BRCS	TIMECORDD86			; 36<>
TIMECORDD86:	CALL	LD_TMPL_IXD			; 40 + 33 => 73
				ADD		A,TMPL				; 74
				IN		F,SREG				; 75
				CBR		F,1<<NN				; 76
				MOV		RES,A				; 77
				JMP		M1_-T19+80			; 80


;.ORG	0X4000+0X8C*32						; ADC A,IXH*  [ DD8C ]  8 (37-48) SZHVNC
				                            ;                                     0
EXDD8C:			CBR		F,1<<II				; ROM35/RAM36
				OUT		SREG,F				; ROM36/RAM0
				ADC		A,IXH				; ROM0/RAM1
				CLN							; ROM1/RAM2
				IN		F,SREG				; ROM2/RAM3
				MOV		RES,A				; ROM3/RAM4
				STUFF37_7					;
				M1H_INTEN[3]				; ROM6/RAM7
				BRCS	FROMROMDD8C			; 8<>
				M1L_RAM[12]					; 20 ??? (+4)
FROMROMDD8C:	M1L_ROM_SHORT[12]			; 20 ??? (+4)


;.ORG	0X4000+0X8D*32						; ADC A,IXL*  [ DD8D ]  8 (37-48) SZHVNC
				                            ;                                     0
EXDD8D:			CBR		F,1<<II				; ROM35/RAM36
				OUT		SREG,F				; ROM36/RAM0
				ADC		A,IXL				; ROM0/RAM1
				CLN							; ROM1/RAM2
				IN		F,SREG				; ROM2/RAM3
				MOV		RES,A				; ROM3/RAM4
				STUFF37_7					;
				M1H_INTEN[3]				; ROM6/RAM7
				BRCS	FROMROMDD8D			; 8<>
				M1L_RAM[12]					; 20 ??? (+4)
FROMROMDD8D:	M1L_ROM_SHORT[12]			; 20 ??? (+4)


;.ORG	0X4000+0X8E*32						; ADC A,(IX+D) [ DD8E ]   19  (87-114) SZHVNC
											;                                          0
EXDD8E:			BRCS	TIMECORDD8E			; 36<>
TIMECORDD8E:	CALL	LD_TMPL_IXD			; 40 + 33 => 73
				CBR		F,1<<II				; 74
				OUT		SREG,F				; 75
				ADC		A,TMPL				; 76
				CLN							; 77
				IN		F,SREG				; 78
				MOV		RES,A				; 79
				JMP		M1_-T19+82			; 82


;.ORG	0X4000+0X94*32						; SUB IXH*    [ DD94 ]  8 (37-48) SZHVNC
				                            ;                                     1
EXDD94:			CBR		F,1<<II				; ROM35/RAM36
				OUT		SREG,F				; ROM36/RAM0
				SUB		A,IXH				; ROM0/RAM1
				SEN							; ROM1/RAM2
				IN		F,SREG				; ROM2/RAM3
				MOV		RES,A				; ROM3/RAM4
				STUFF37_7					;
				M1H_INTEN[3]				; ROM6/RAM7
				BRCS	FROMROMDD94			; 8<>
				M1L_RAM[12]					; 20 ??? (+4)
FROMROMDD94:	M1L_ROM_SHORT[12]			; 20 ??? (+4)


;.ORG	0X4000+0X95*32						; SUB IXL*    [ DD95 ]  8 (37-48) SZHVNC
				                            ;                                     1
EXDD95:			CBR		F,1<<II				; ROM35/RAM36
				OUT		SREG,F				; ROM36/RAM0
				SUB		A,IXL				; ROM0/RAM1
				SEN							; ROM1/RAM2
				IN		F,SREG				; ROM2/RAM3
				MOV		RES,A				; ROM3/RAM4
				STUFF37_7					;
				M1H_INTEN[3]				; ROM6/RAM7
				BRCS	FROMROMDD95			; 8<>
				M1L_RAM[12]					; 20 ??? (+4)
FROMROMDD95:	M1L_ROM_SHORT[12]			; 20 ??? (+4)


;.ORG	0X4000+0X96*32						; SUB (IX+D) [ DD96 ]   19  (87-114) SZHVNC
											;                                        1
EXDD96:			BRCS	TIMECORDD96			; 36<>
TIMECORDD96:	CALL	LD_TMPL_IXD			; 40 + 33 => 73
				CBR		F,1<<II				; 74
				OUT		SREG,F				; 75
				SUB		A,TMPL				; 76
				SEN							; 77
				IN		F,SREG				; 78
				MOV		RES,A				; 79
				JMP		M1_-T19+82			; 82


;.ORG	0X4000+0X9C*32						; SBC A,IXH*  [ DD9C ]  8 (37-48) SZHVNC
				                            ;                                     1
EXDD9C:			CBR		F,1<<II				; ROM35/RAM36
				OUT		SREG,F				; ROM36/RAM0
				SEZ							; ROM0/RAM1
				SBC		A,IXH				; ROM1/RAM2
				SEN							; ROM2/RAM3
				IN		F,SREG				; ROM3/RAM4
				MOV		RES,A				; ROM4/RAM5
				STUFF37_6					;
				M1H_INTEN[3]				; ROM7/RAM8
				BRCS	FROMROMDD9C			; 9<>
				M1L_RAM[12]					; 21 ??? (+5)
FROMROMDD9C:	M1L_ROM_SHORT[12]			; 21 ??? (+5)


;.ORG	0X4000+0X9D*32						; SBC A,IXL*  [ DD9D ]  8 (37-48) SZHVNC
				                            ;                                     1
EXDD9D:			CBR		F,1<<II				; ROM35/RAM36
				OUT		SREG,F				; ROM36/RAM0
				SEZ							; ROM0/RAM1
				SBC		A,IXL				; ROM1/RAM2
				SEN							; ROM2/RAM3
				IN		F,SREG				; ROM3/RAM4
				MOV		RES,A				; ROM4/RAM5
				STUFF37_6					;
				M1H_INTEN[3]				; ROM7/RAM8
				BRCS	FROMROMDD9D			; 9<>
				M1L_RAM[12]					; 21 ??? (+5)
FROMROMDD9D:	M1L_ROM_SHORT[12]			; 21 ??? (+5)


;.ORG	0X4000+0X9E*32						; SBC A,(IX+D) [ DD9E ]   19  (87-114) SZHVNC
											;                                          1
EXDD9E:			BRCS	TIMECORDD9E			; 36<>
TIMECORDD9E:	CALL	LD_TMPL_IXD			; 40 + 33 => 73
				CBR		F,1<<II				; 74
				OUT		SREG,F				; 75
				SEZ							; 76
				SBC		A,TMPL				; 77
				SEN							; 78
				IN		F,SREG				; 79
				MOV		RES,A				; 80
				JMP		M1_-T19+83			; 83


;.ORG	0X4000+0XA4*32						; AND IXH*    [ DDA4 ]  8 (37-48) SZHVNC
				                            ;                                   1P00
EXDDA4:			AND		A,IXH				; ROM35/RAM36
				MOV		RES,A				; ROM36/RAM0
				MOV		ZL,RES				; ROM0/RAM1
				LDI		ZH,0X03				; ROM1/RAM2 SECOND PTABLE(WITH Z-F AND H SET)
				LD		F,Z					; ROM3/RAM4
				STUFF37_8					;
				M1H_INTEN_SHORT[2]			; ROM5/RAM6
				BRCS	FROMROMDDA4			; 7<>
				M1L_RAM[12]					; 19 ??? (+3)
FROMROMDDA4:	M1L_ROM_SHORT[12]			; 19 ??? (+3)


;.ORG	0X4000+0XA5*32						; AND IXL*    [ DDA4 ]  8 (37-48) SZHVNC
				                            ;                                   1P00
EXDDA5:			AND		A,IXL				; ROM35/RAM36
				MOV		RES,A				; ROM36/RAM0
				MOV		ZL,RES				; ROM0/RAM1
				LDI		ZH,0X03				; ROM1/RAM2 SECOND PTABLE(WITH Z-F AND H SET)
				LD		F,Z					; ROM3/RAM4
				STUFF37_8					;
				M1H_INTEN_SHORT[2]			; ROM5/RAM6
				BRCS	FROMROMDDA5			; 7<>
				M1L_RAM[12]					; 19 ??? (+3)
FROMROMDDA5:	M1L_ROM_SHORT[12]			; 19 ??? (+3)


;.ORG	0X4000+0XA6*32						; AND (IX+D)   [ DDA6 ]   19  (87-114) SZHVNC
											;                                        1P00
EXDDA6:			BRCS	TIMECORDDA6			; 36<>
TIMECORDDA6:	CALL	LD_TMPL_IXD			; 40 + 33 => 73
				AND		A,TMPL				; 74
				MOV		RES,A				; 75
				MOV		ZL,RES				; 76
				LDI		ZH,0X03				; 77 SECOND PTABLE(WITH Z-F AND H SET)
				LD		F,Z					; 79
				JMP		M1_-T19+82			; 82


;.ORG	0X4000+0XAC*32						; XOR IXH*    [ DDAC ]  8 (37-48) SZHVNC
				                            ;                                   0P00
EXDDAC:			EOR		A,IXH				; ROM35/RAM36
				MOV		RES,A				; ROM36/RAM0
				MOVW	ZL,RES				; ROM0/RAM1 FIRST  PARITY TABLE (WITH Z FLAG)
				LD		F,Z					; ROM2/RAM3
				STUFF37_9					;
				M1H_INTEN_SHORT[2]			; ROM4/RAM5
				BRCS	FROMROMDDAC			; 6<>
				M1L_RAM[12]					; 18 ??? (+2)
FROMROMDDAC:	M1L_ROM_SHORT[12]			; 18 ??? (+2)


;.ORG	0X4000+0XAD*32						; XOR IXL*    [ DDAD ]  8 (37-48) SZHVNC
				                            ;                                     1
EXDDAD:			EOR		A,IXL				; ROM35/RAM36
				MOV		RES,A				; ROM36/RAM0
				MOVW	ZL,RES				; ROM0/RAM1 FIRST  PARITY TABLE (WITH Z FLAG)
				LD		F,Z					; ROM2/RAM3
				STUFF37_9					;
				M1H_INTEN_SHORT[2]			; ROM4/RAM5
				BRCS	FROMROMDDAD			; 6<>
				M1L_RAM[12]					; 18 ??? (+2)
FROMROMDDAD:	M1L_ROM_SHORT[12]			; 18 ??? (+2)


;.ORG	0X4000+0XAE*32						; XOR (IX+D)   [ DDAE ]   19  (87-114) SZHVNC
											;                                        0P00
EXDDAE:			BRCS	TIMECORDDAE			; 36<>
TIMECORDDAE:	CALL	LD_TMPL_IXD			; 40 + 33 => 73
				EOR		A,TMPL				; 74
				MOV		RES,A				; 75
				MOVW	ZL,RES				; 76 FIRST  PARITY TABLE (WITH Z FLAG)
				LD		F,Z					; 77
				JMP		M1_-T19+80			; 80


;.ORG	0X4000+0XB4*32						; OR IXH*    [ DDB4 ]  8 (37-48) SZHVNC
				                            ;                                  0P00
EXDDB4:			OR		A,IXH				; ROM35/RAM36
				MOV		RES,A				; ROM36/RAM0
				MOVW	ZL,RES				; ROM0/RAM1 FIRST  PARITY TABLE (WITH Z FLAG)
				LD		F,Z					; ROM2/RAM3
				STUFF37_9					;
				M1H_INTEN_SHORT[2]			; ROM4/RAM5
				BRCS	FROMROMDDB4			; 6<>
				M1L_RAM[12]					; 18 ??? (+2)
FROMROMDDB4:	M1L_ROM_SHORT[12]			; 18 ??? (+2)


;.ORG	0X4000+0XB5*32						; OR IXL*    [ DDB4 ]  4 (24) SZHVNC
				                            ;                               0P00
EXDDB5:			OR		A,IXL				; ROM35/RAM36
				MOV		RES,A				; ROM36/RAM0
				MOVW	ZL,RES				; ROM0/RAM1 FIRST  PARITY TABLE (WITH Z FLAG)
				LD		F,Z					; ROM2/RAM3
				STUFF37_9					;
				M1H_INTEN_SHORT[2]			; ROM4/RAM5
				BRCS	FROMROMDDB5			; 6<>
				M1L_RAM[12]					; 18 ??? (+2)
FROMROMDDB5:	M1L_ROM_SHORT[12]			; 18 ??? (+2)


;.ORG	0X4000+0XB6*32						; OR (IX+D)    [ DDB6 ]   19  (87-114) SZHVNC
				                            ;                                        0P00
EXDDB6:			BRCS	TIMECORDDB6			; 36<>
TIMECORDDB6:	CALL	LD_TMPL_IXD			; 40 + 33 => 73
				OR		A,TMPL				; 74
				MOV		RES,A				; 75
				MOVW	ZL,RES				; 76 FIRST  PARITY TABLE (WITH Z FLAG)
				LD		F,Z					; 78
				JMP		M1_-T19+81			; 81


;.ORG	0X4000+0XBC*32						; CP IXH*    [ DDBC ]  4 (24) SZHVNC 3,4 FROM OPERAND
				                            ;                                 1
EXDDBC:			MOV		RES,IXH				; ROM35/RAM36
				MOV		TMPH,A				; ROM36/RAM0
				SUB		TMPH,RES			; ROM0/RAM1
				IN		F,SREG				; ROM1/RAM2
				SBR		F,(1<<NN)			; ROM2/RAM3
				BST		TMPH,7				; ROM3/RAM4
				BLD		RES,7				; ROM4/RAM5
				STUFF37_7					;
				M1H_INTEN_SHORT[2]			; ROM6/RAM7
				BRCS	FROMROMDDBC			; 8<>
				M1L_RAM[12]					; 20 ??? (+4)
FROMROMDDBC:	M1L_ROM_SHORT[12]			; 20 ??? (+4)


;.ORG	0X4000+0XBD*32						; CP IXL*    [ DDBD ]  4 (24) SZHVNC
				                            ;                                 1
EXDDBD:			MOV		RES,IXL				; ROM35/RAM36
				MOV		TMPH,A				; ROM36/RAM0
				SUB		TMPH,RES			; ROM0/RAM1
				IN		F,SREG				; ROM1/RAM2
				SBR		F,(1<<NN)			; ROM2/RAM3
				BST		TMPH,7				; ROM3/RAM4
				BLD		RES,7				; ROM4/RAM5
				STUFF37_7					;
COMM1DD:		M1H_INTEN_SHORT[2]			; ROM6/RAM7
				BRCS	FROMROMDDBD			; 8<>
				M1L_RAM[12]					; 20 ??? (+4)
FROMROMDDBD:	M1L_ROM_SHORT[12]			; 20 ??? (+4)


;.ORG	0X4000+0XBE*32						; CP (IX+D)    [ DDBE ]   19  (87-114) SZHVNC 3,4 FROM OPERAND
				                            ;                                          1
EXDDBE:			BRCS	TIMECORDDBE			; 36<>
TIMECORDDBE:	CALL	LD_TMPL_IXD			; 40 + 33 => 73
				MOV		RES,TMPL			; 74
				MOV		TMPH,A				; 75
				SUB		TMPH,RES			; 76
				IN		F,SREG				; 77
				SBR		F,(1<<NN)			; 78
				BST		TMPH,7				; 79
				BLD		RES,7				; 80
				JMP		M1_-T19+80			; 80


;.ORG	0X4000+0XCB*32						; PREFIX DDCB      [ DDCB ] NONE

EXDDCB:			MOVW	TMPL,IXL			; ROM35/RAM36
				BRCS	FROMROMDDCB			; 37<>
				XON_RBBCP					; 39
				LD		ZL,X+				; 42
				LD		BUFH,X+				; 45
				LD		BUF,X				; 48
				XOFF_RBBCP					; 50
				SBRC	ZL,7				; 51
				COM		ZERO				; 52
				ADD		TMPL,ZL				; 53
				ADC		TMPH,ZERO			; 54
				CLR		ZERO				; 55
				MOVW	MEMPTRL,TMPL		; 56
				MOVW	ZL,TMPL				; 57
				CPI		ZH,0X40				; 58
				BRCS	FROMROMDDCB_		; 59 /> 60
				XON_RBBCP					; 61
				LD		ONE,Z				; 64
				XOFF_RBBCP					; 66
COMDDCB:		MOV		ZH,BUFH				; 67
				LDI		ZL,60*2				; 68
				LSR		ZH					; 69
				ROR		ZL					; 70
				IJMP						; 72 !!! +3 CROSSER. C IS RESET HEARE
FROMROMDDCB_:	OR		ZH,ROMID			; 61
				ELPM	ONE,Z				; 64
				RJMP	COMDDCB				; 66
FROMROMDDCB:	MOVW	ZL,PCL				; 38
				OR		ZH,ROMID			; 39
				ELPM	BUF,Z+				; 42
				ELPM	BUFH,Z				; 45
				ADIW	PCL,0X02			; 47
				SBRC	BUF,7				; 48
				COM		ZERO				; 49
				ADD		TMPL,BUF			; 50
				ADC		TMPH,ZERO			; 51
				CLR		ZERO				; 52
				MOVW	MEMPTRL,TMPL		; 53
				MOVW	ZL,TMPL				; 54
				CPI		ZH,0X40				; 55
				BRCS	FROMROMDDCB__		; 56 /> 57
				XON_RBBCP					; 58
				LD		ONE,Z				; 61
				XOFF_RBBCP					; 63
COMDDCB_:		MOV		ZH,BUFH				; 64
				LDI		ZL,60*2+1			; 65
				LSR		ZH					; 66
				ROR		ZL					; 67
				IJMP						; 69 !!! +3 CROSSER. C IIS SET HEARE
FROMROMDDCB__:	OR		ZH,ROMID			; 58
				ELPM	ONE,Z				; 61
				RJMP	COMDDCB_			; 63 


;.ORG	0X4000+0XE1*32						; POP IX         [ DDE1 ]  14   (64-84) NONE

EXDDE1:			BRCS	WRKROMDDE1			; 36<>
				LOAD_IX_STP_[13]			; 49
				JMP		M1_-T14+52			; 52
WRKROMDDE1:		LOAD_IX_STP[10]				; 46
				JMP		M1-T14+49			; 49


;.ORG	0X4000+0XE3*32						; EX (SP),IX      [ DDE3 ]  23   (138) NONE

EXDDE3:			MOVW	TMPL,IXL			; ROM35/RAM36
				BRCS	WRKROMDDE3			; 37<>
				XON_RBBCP					; 39
				LD		ZL,Y+				; 42
				LD		ZH,Y+				; 45
				ST		-Y,TMPH				; 48
				ST		-Y,TMPL				; 51
				LD		BUF,X				; 54
				XOFF_RBBCP					; 56
COMDDE3:		MOVW	IXL,ZL				; 57
				MOVW	MEMPTRL,ZL			; 58
				JMP		M1_-T23+61			; 61
WRKROMDDE3:		XON_RBBCP					; 39
				LD		ZL,Y+				; 42
				LD		ZH,Y+				; 45
				ST		-Y,TMPH				; 48
				ST		-Y,TMPL				; 51
				XOFF_RBBCP					; 53
				JMP		COMDDE3				; 56


;.ORG	0X4000+0XE5*32						; PUSH IX        [ DDE5 ]  15   (69-90) NONE

EXDDE5:			BRCS	WRKROMDDE5			; 36<>
				SAVE_IX_STP_[13]			; 49
				JMP		M1_-T14+52			; 52
WRKROMDDE5:		SAVE_IX_STP[10]				; 46
				JMP		M1-T14+49			; 49



;.ORG	0X4000+0XE9*32						; JP (IX)        [ DDE9 ]  8 (37-48)      NONE

EXDDE9:			MOVW	PCL,IXL				; ROM35/RAM36
				RJMP	COMM1DD				; ROM0/RAM1
				

;.ORG	0X4000+0XF9*32						; LD SP,IX       [ F9 ] 10 (46-60)      NONE

EXDDF9:			MOVW	STPL,IXL			; ROM35/RAM36
				RJMP	COMM1DD				; ROM0/RAM1
				

											; LOAD TMPL WITH (IX+D) SUBROUTINE. INCREMENTS PC.
											; OUT: T=1 - (IY+S) IS IN ROM, ELSE IS IN RAM.;
											; BUF = (PC+1) IF PC POINTS TO RAM, ELSE TOT CHANGED;
LD_TMPL_IXD:	CPI		XH,0X40				; 1
				BRCC	FROMRAMLDIXD		; 2 /> 3
				RLOAD_TMPL[7]				; 9
				DELAY2						; 11
				RJMP	COMLDIXD			; 13
FROMRAMLDIXD:	LOAD_TMPL_PC_[10]			; 13
COMLDIXD:		MOVW	ZL,IXL				; 14
				SBRC	TMPL,7				; 15
				COM		ZERO				; 16
				ADD		ZL,TMPL				; 17
				ADC		ZH,ZERO				; 18
				CLR		ZERO				; 19
				CLT							; 20
				CPI		ZH,0X40				; 21
				BRCS	FROMROMLDIXD		; 22 /> 23
				LOAD_TMPL_Z[7]				; 29
				RET							; 33
FROMROMLDIXD:	SET							; 24
				RLOAD_TMPL_Z[4]				; 28
				EOR		ZH,ROMID			; 29
				RET							; 33


SAVE_TMPH_IXD:	BRCS	FROMROMSTIXD		; 40<>
				LOAD_TMPL_PC_[10]			; 50
COMSTIXD:		MOVW	ZL,IXL				; 51
				SBRC	TMPL,7				; 52
				COM		ZERO				; 53
				ADD		ZL,TMPL				; 54
				ADC		ZH,ZERO				; 55
				CLR		ZERO				; 56
				CPI		ZH,0X40				; 57
				BRCS	TOROMSTIXD			; 58 /> 59
				SAVE_TMPH_Z[7]				; 65
				JMP	M1_-T19+68				; 68
TOROMSTIXD:		JMP	M1_-T19+62				; 62
FROMROMSTIXD:	RLOAD_TMPL[7]				; 47
				JMP		COMSTIXD			; 50




























