
;********************************************************************************************************************************************
;****************************************************** OPCPDE 0x ***************************************************************************
;********************************************************************************************************************************************


.ORG	0X0000+0X00*128						; NOP            [ 00 ] 4  (18-24) NONE //

EX00:			STUFF18_CLI					; 
				STUFF18_5					; 
				NOP							; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM00			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM00:		M1L_RAM[12]					; 16


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0X01*128						; LD BC,NN       [ 01 ] 10 (46-60) NONE //
				
EX01:			CLI							; 17
				BRCS	FROMROM01			; 18 /> 19
				LOAD_BC_PC_[13]				; 31
				OUT		RAMPZ,ONE			; 32
				JMP		M1_-T10+35			; 35
FROMROM01:		RLOAD_BC[10]				; 29
				JMP		M1-T10+32			; 32


.ORG	0X0000+0X11*128						; LD DE,NN       [ 11 ] 10 (46-60) NONE //
				
EX11:			CLI							; 17
				BRCS	FROMROM11			; 18 /> 19
				LOAD_DE_PC_[13]				; 31
				OUT		RAMPZ,ONE			; 32
				JMP		M1_-T10+35			; 35
FROMROM11:		RLOAD_DE[10]				; 29
				JMP		M1-T10+32			; 32

.ORG	0X0000+0X21*128						; LD HL,NN       [ 21 ] 10 (46-60) NONE // 
				
EX21:			CLI							; 17
				BRCS	FROMROM21			; 18 /> 19
				LOAD_HL_PC_[13]				; 31
				OUT		RAMPZ,ONE			; 32
				JMP		M1_-T10+35			; 35
FROMROM21:		RLOAD_HL[10]				; 29
				JMP		M1-T10+32			; 32

.ORG	0X0000+0X31*128						; LD SP,NN       [ 31 ] 10 (46-60) NONE //
				
EX31:			CLI							; 17
				BRCS	FROMROM31			; 18 /> 19
				LOAD_STP_PC_[13]			; 31
				OUT		RAMPZ,ONE			; 32
				JMP		M1_-T10+35			; 35
FROMROM31:		RLOAD_STP[10]				; 29
				JMP		M1-T10+32			; 32


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0X02*128						; LD (BC),A      [ 02 ]  7 (32-42) NONE \\
				
EX02:			CLI							; 17
				MOVW	ZL,C				; 18
				CPI		ZH,0X40				; 19
				BRCS	TOROM02				; 20 / 21
				SAVE_A_ZI_[10]				; 30
				OUT		RAMPZ,ONE			; 31
				MOV		MEMPTRH,A			; 0
				MOV		MEMPTRL,ZL			; 1
				STUFF32_8					; 
				M1H_INTEN[3]				; 4
				BRCC	FROMRAM02			; 5 /> 6
				M1L_ROM[13]					; 18 ??? (+2)
FROMRAM02:		M1L_RAM_[12]				; 18 ??? (+2)
TOROM02:		ADIW	ZL,0X01				; 22
				MOV		MEMPTRH,A			; 23
				MOV		MEMPTRL,ZL			; 24
				JMP		M1-T7+27			; 27


.ORG	0X0000+0X12*128						; LD (DE),A      [ 12 ]  7 (32-42) NONE \\
				
EX12:			CLI							; 17
				MOVW	ZL,E				; 18
				MOV		MEMPTRH,A			; 19
				MOV		MEMPTRL,ZL			; 20
				INC		MEMPTRL				; 21
				CPI		ZH,0X40				; 22
				BRCS	TOROM12				; 23 /> 24
				SAVE_A_Z_[10]				; 1
				STUFF32_8					; 
				M1H_INTEN[3]				; 4
				BRCC	FROMRAM_12			; 5 /> 6
				M1L_ROM[13]					; 18 ??? (+2)
FROMRAM_12:		M1L_RAM_[12]				; 18 ??? (+2)
TOROM12:		JMP		M1-T7+27			; 27




;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0X03*128						; INC BC         [ 03 ] 6 (27-36) NONE //
				
EX03:			ADD		C,ONE				; 17
				ADC		B,ZERO				; 18
				JMP		M1-T6+21			; 21


.ORG	0X0000+0X13*128						; INC DE         [ 13 ] 6 (27-36) NONE //

EX13:			ADD		E,ONE				; 17
				ADC		D,ZERO				; 18
				JMP		M1-T6+21			; 21

.ORG	0X0000+0X23*128						; INC HL         [ 23 ] 6 (27-36) NONE //

EX23:			ADD		L,ONE				; 17
				ADC		H,ZERO				; 18
				JMP		M1-T6+21			; 21


.ORG	0X0000+0X33*128						; INC SP         [ 33 ] 6 (27-36) NONE //

EX33:			ADD		STPL,ONE			; 17
				ADC		STPH,ZERO			; 18
				JMP		M1-T6+21			; 21


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0X04*128						; INC B          [ 04 ] 4 (18-24) SZHVN \\
				                            ;                                  0

EX04:			STUFF18_CLI					; +1
				ANDI	F,(1<<II)|(1<<CC)	; 17
				ADD		B,ONE				; 0
				IN		BUF,SREG			; 1
				ANDI	BUF,(1<<SS)|(1<<ZZ)|(1<<HH)|(1<<VV); 2
				OR		F,BUF				; 3
				MOV		RES,B				; 4
				STUFF18_SEI					; +1
				M1H[2]						; 6
				BRCC	FROMRAM04			; 7 /> 8
				M1L_ROM[13]					; 20 ??? (+4)
FROMRAM04:		M1L_RAM[12]					; 20 ??? (+4)


.ORG	0X0000+0X0C*128						; INC C          [ 0C ] 4 (18-24) SZHVN \\
				                            ;                                     0
EX0C:			STUFF18_CLI					; +1
				ANDI	F,(1<<II)|(1<<CC)	; 17
				ADD		C,ONE				; 0
				IN		BUF,SREG			; 1
				ANDI	BUF,(1<<SS)|(1<<ZZ)|(1<<HH)|(1<<VV); 2
				OR		F,BUF				; 3
				MOV		RES,C				; 4
				STUFF18_SEI					; +1
				M1H[2]						; 6
				BRCC	FROMRAM0C			; 7 /> 8
				M1L_ROM[13]					; 20 ??? (+4)
FROMRAM0C:		M1L_RAM[12]					; 20 ??? (+4)


.ORG	0X0000+0X14*128						; INC D          [ 14 ] 4 (18-24) SZHVN \\
				                            ;                                     0
EX14:			STUFF18_CLI					; +1
				ANDI	F,(1<<II)|(1<<CC)	; 17
				ADD		D,ONE				; 0
				IN		BUF,SREG			; 1
				ANDI	BUF,(1<<SS)|(1<<ZZ)|(1<<HH)|(1<<VV); 2
				OR		F,BUF				; 3
				MOV		RES,D				; 4
				STUFF18_SEI					; +1
				M1H[2]						; 6
				BRCC	FROMRAM14			; 7 /> 8
				M1L_ROM[13]					; 20 ??? (+4)
FROMRAM14:		M1L_RAM[12]					; 20 ??? (+4)


.ORG	0X0000+0X1C*128						; INC E          [ 1C ] 4 (18-24) SZHVN \\
				                            ;                                     0
EX1C:			STUFF18_CLI					; +1
				ANDI	F,(1<<II)|(1<<CC)	; 17
				ADD		E,ONE				; 0
				IN		BUF,SREG			; 1
				ANDI	BUF,(1<<SS)|(1<<ZZ)|(1<<HH)|(1<<VV); 2
				OR		F,BUF				; 3
				MOV		RES,E				; 4
				STUFF18_SEI					; +1
				M1H[2]						; 6
				BRCC	FROMRAM1C			; 7 /> 8
				M1L_ROM[13]					; 20 ??? (+4)
FROMRAM1C:		M1L_RAM[12]					; 20 ??? (+4)


.ORG	0X0000+0X24*128						; INC H          [ 24 ] 4 (18-24) SZHVN \\
				                            ;                                     0
EX24:			STUFF18_CLI					; +1
				ANDI	F,(1<<II)|(1<<CC)	; 17
				ADD		H,ONE				; 0
				IN		BUF,SREG			; 1
				ANDI	BUF,(1<<SS)|(1<<ZZ)|(1<<HH)|(1<<VV); 2
				OR		F,BUF				; 3
				MOV		RES,H				; 4
				STUFF18_SEI					; +1
				M1H[2]						; 6
				BRCC	FROMRAM24			; 7 /> 8
				M1L_ROM[13]					; 20 ??? (+4)
FROMRAM24:		M1L_RAM[12]					; 20 ??? (+4)


.ORG	0X0000+0X2C*128						; INC L          [ 2C ] 4 (18-24) SZHVN \\
				                            ;                                     0
EX2C:			STUFF18_CLI					; +1
				ANDI	F,(1<<II)|(1<<CC)	; 17
				ADD		L,ONE				; 0
				IN		BUF,SREG			; 1
				ANDI	BUF,(1<<SS)|(1<<ZZ)|(1<<HH)|(1<<VV); 2
				OR		F,BUF				; 3
				MOV		RES,L				; 4
				STUFF18_SEI					; +1
				M1H[2]						; 6
				BRCC	FROMRAM2C			; 7 /> 8
				M1L_ROM[13]					; 20 ??? (+4)
FROMRAM2C:		M1L_RAM[12]					; 20 ??? (+4)


.ORG	0X0000+0X3C*128						; INC A          [ 3C ] 4 (18-24) SZHVN \\
				                            ;                                     0
EX3C:			STUFF18_CLI					; +1
				ANDI	F,(1<<II)|(1<<CC)	; 17
				ADD		A,ONE				; 0
				IN		BUF,SREG			; 1
				ANDI	BUF,(1<<SS)|(1<<ZZ)|(1<<HH)|(1<<VV); 2
				OR		F,BUF				; 3
				MOV		RES,A				; 4
				STUFF18_SEI					; +1
				M1H[2]						; 6
				BRCC	FROMRAM3C			; 7 /> 8
				M1L_ROM[13]					; 20 ??? (+4)
FROMRAM3C:		M1L_RAM[12]					; 20 ??? (+4)


.ORG	0X0000+0X34*128						; INC (HL)       [ 34 ] 11 (50-66) SZHVN //
				                            ;                                      0
EX34:			CLI							; 17
				MOVW	ZL,L				; 18
				CPI		ZH,0X40				; 19
				BRCS	FROMROM34			; 20 /> 21
				LOAD_RES_Z[7]				; 27
				CBR		F,(1<<SS)|(1<<ZZ)|(1<<HH)|(1<<VV)|(1<<NN);28
				ADD		RES,ONE				; 29
				IN		BUF,SREG			; 30
				ANDI	BUF,(1<<SS)|(1<<ZZ)|(1<<HH)|(1<<VV); 31
				OR		F,BUF				; 32
				MOVW	ZL,L				; 33
				SAVE_RES_Z_[10]				; 43
				JMP		M1_-T11+46			; 46
FROMROM34:		RLOAD_RES_Z[4]				; 25
				CBR		F,(1<<SS)|(1<<ZZ)|(1<<HH)|(1<<VV)|(1<<NN);26
				ADD		RES,ONE				; 27
				IN		BUF,SREG			; 28
				ANDI	BUF,(1<<SS)|(1<<ZZ)|(1<<HH)|(1<<VV); 29
				OR		F,BUF				; 30
				JMP		M1-T11+33			; 33


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0X05*128						; DEC B          [ 05 ] 4 (18-24) SZHVN \\	
											;                                  1
EX05:			STUFF18_CLI					; +1
				BST		F,CC				; 17
				SUB		B,ONE				; 0
				IN		F,SREG				; 1
				SBR 	F,1<<NN				; 2
				BLD		F,CC				; 3
				MOV		RES,B				; 4
				STUFF18_SEI					; +1
				M1H[2]						; 6
				BRCC	FROMRAM05			; 7 /> 8
				M1L_ROM[13]					; 20 ??? (+4)
FROMRAM05:		M1L_RAM[12]					; 20 ??? (+4)
	
											; 
.ORG	0X0000+0X0D*128						; DEC C          [ 0D ] 4 (18-24) SZHVN \\	
											;                                     1
EX0D:			STUFF18_CLI					; +1
				BST		F,CC				; 17
				SUB		C,ONE				; 0
				IN		F,SREG				; 1
				SBR 	F,1<<NN				; 2
				BLD		F,CC				; 3
				MOV		RES,C				; 4
				STUFF18_SEI					; +1
				M1H[2]						; 6
				BRCC	FROMRAM0D			; 7 /> 8
				M1L_ROM[13]					; 20 ??? (+4)
FROMRAM0D:		M1L_RAM[12]					; 20 ??? (+4)


.ORG	0X0000+0X15*128						; DEC D          [ 15 ] 4 (18-24) SZHVN \\	
											;                                     1
EX15:			STUFF18_CLI					; +1
				BST		F,CC				; 17
				SUB		D,ONE				; 0
				IN		F,SREG				; 1
				SBR 	F,1<<NN				; 2
				BLD		F,CC				; 3
				MOV		RES,D				; 4
				STUFF18_SEI					; +1
				M1H[2]						; 6
				BRCC	FROMRAM15			; 7 /> 8
				M1L_ROM[13]					; 20 ??? (+4)
FROMRAM15:		M1L_RAM[12]					; 20 ??? (+4)


.ORG	0X0000+0X1D*128						; DEC E          [ 1D ] 4 (18-24) SZHVN \\	
											;                                     1
EX1D:			STUFF18_CLI					; +1
				BST		F,CC				; 17
				SUB		E,ONE				; 0
				IN		F,SREG				; 1
				SBR 	F,1<<NN				; 2
				BLD		F,CC				; 3
				MOV		RES,E				; 4
				STUFF18_SEI					; +1
				M1H[2]						; 6
				BRCC	FROMRAM1D			; 7 /> 8
				M1L_ROM[13]					; 20 ??? (+4)
FROMRAM1D:		M1L_RAM[12]					; 20 ??? (+4)


.ORG	0X0000+0X25*128						; DEC H          [ 25 ] 4 (18-24) SZHVN \\	
											;                                     1
EX25:			STUFF18_CLI					; +1
				BST		F,CC				; 17
				SUB		H,ONE				; 0
				IN		F,SREG				; 1
				SBR 	F,1<<NN				; 2
				BLD		F,CC				; 3
				MOV		RES,H				; 4
				STUFF18_SEI					; +1
				M1H[2]						; 6
				BRCC	FROMRAM25			; 7 /> 8
				M1L_ROM[13]					; 20 ??? (+4)
FROMRAM25:		M1L_RAM[12]					; 20 ??? (+4)


.ORG	0X0000+0X2D*128						; DEC L          [ 2D ] 4 (18-24) SZHVN \\	
											;                                     1
EX2D:			STUFF18_CLI					; +1
				BST		F,CC				; 17
				SUB		L,ONE				; 0
				IN		F,SREG				; 1
				SBR 	F,1<<NN				; 2
				BLD		F,CC				; 3
				MOV		RES,L				; 4
				STUFF18_SEI					; +1
				M1H[2]						; 6
				BRCC	FROMRAM2D			; 7 /> 8
				M1L_ROM[13]					; 20 ??? (+4)
FROMRAM2D:		M1L_RAM[12]					; 20 ??? (+4)


.ORG	0X0000+0X3D*128						; DEC A          [ 3D ] 4 (18-24) SZHVN \\
											;                                     1
EX3D:			STUFF18_CLI					; +1
				BST		F,CC				; 17
				SUB		A,ONE				; 0
				IN		F,SREG				; 1
				SBR 	F,1<<NN				; 2
				BLD		F,CC				; 3
				MOV		RES,A				; 4
				STUFF18_SEI					; +1
				M1H[2]						; 6
				BRCC	FROMRAM3D			; 7 /> 8
				M1L_ROM[13]					; 20 ??? (+4)
FROMRAM3D:		M1L_RAM[12]					; 20 ??? (+4)


.ORG	0X0000+0X35*128						; DEC (HL)       [ 35 ] 11 (50-66) SZHVN //
				                            ;                                      1
EX35:			CLI							; 17
				MOVW	ZL,L				; 18
				CPI		ZH,0X40				; 19
				BRCS	FROMROM35			; 20 /> 21
				LOAD_RES_Z[7]				; 27
				CBR		F,(1<<SS)|(1<<ZZ)|(1<<HH)|(1<<VV)|(1<<NN);28
				SUB		RES,ONE				; 29
				IN		BUF,SREG			; 30
				ANDI	BUF,(1<<SS)|(1<<ZZ)|(1<<HH)|(1<<VV); 31
				OR		F,BUF				; 32
				SBR		F,1<<NN				; 33
				MOVW	ZL,L				; 34
				SAVE_RES_Z_[10]				; 44
				JMP		M1_-T11+47			; 47
FROMROM35:		RLOAD_RES_Z[4]				; 25
				CBR		F,(1<<SS)|(1<<ZZ)|(1<<HH)|(1<<VV)|(1<<NN);26
				SUB		RES,ONE				; 27
				IN		BUF,SREG			; 28
				ANDI	BUF,(1<<SS)|(1<<ZZ)|(1<<HH)|(1<<VV); 29
				OR		F,BUF				; 30
				SBR		F,1<<NN				; 31
				JMP		M1-T11+34			; 34


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0X06*128						; LD B,N         [ 06 ]  7 (32-42) NONE //

EX06:			CLI							; ROM16
				BRCS	FROMROM06			; 17 /> 18
				LOAD_B_PC_[10]				; 27
				JMP		M1_-T7+30			; 30
FROMROM06:		RLOAD_B[7]					; 25
				JMP		M1-T7+28			; 28


.ORG	0X0000+0X0E*128						; LD C,N         [ 0E ]  7 (32-42) NONE //

EX0E:			CLI							; ROM16
				BRCS	FROMROM0E			; 17 /> 18
				LOAD_C_PC_[10]				; 27
				JMP		M1_-T7+30			; 30
FROMROM0E:		RLOAD_C[7]					; 25
				JMP		M1-T7+28			; 28
		
.ORG	0X0000+0X16*128						; LD D,N         [ 16 ]  7 (32-42) NONE //

EX16:			CLI							; ROM16
				BRCS	FROMROM16			; 17 /> 18
				LOAD_D_PC_[10]				; 27
				JMP		M1_-T7+30			; 30
FROMROM16:		RLOAD_D[7]					; 25
				JMP		M1-T7+28			; 28


.ORG	0X0000+0X1E*128						; LD E,N         [ 1E ]  7 (32-42) NONE //

EX1E:			CLI							; ROM16
				BRCS	FROMROM1E			; 17 /> 18
				LOAD_E_PC_[10]				; 27
				JMP		M1_-T7+30			; 30
FROMROM1E:		RLOAD_E[7]					; 25
				JMP		M1-T7+28			; 28


.ORG	0X0000+0X26*128						; LD H,N         [ 26 ]  7 (32-42) NONE //

EX26:			CLI							; ROM16
				BRCS	FROMROM26			; 17 /> 18
				LOAD_H_PC_[10]				; 27
				JMP		M1_-T7+30			; 30
FROMROM26:		RLOAD_H[7]					; 25
				JMP		M1-T7+28			; 28


.ORG	0X0000+0X2E*128						; LD L,N         [ 2E ]  7 (32-42) NONE //

EX2E:			CLI							; ROM16
				BRCS	FROMROM2E			; 17 /> 18
				LOAD_L_PC_[10]				; 27
				JMP		M1_-T7+30			; 30
FROMROM2E:		RLOAD_L[7]					; 25
				JMP		M1-T7+28			; 28


.ORG	0X0000+0X3E*128						; LD A,N         [ 3E ]  7 (32-42) NONE //

EX3E:			CLI							; ROM16
				BRCS	FROMROM3E			; 17 /> 18
				LOAD_A_PC_[10]				; 27
				JMP		M1_-T7+30			; 30
FROMROM3E:		RLOAD_A[7]					; 25
				JMP		M1-T7+28			; 28


.ORG	0X0000+0X36*128						; LD (HL),N      [ 36 ] 10 (46-60) NONE //

EX36:			CLI							; 17
				MOVW	ZL,L				; 18
				CPI		ZH,0X40				; 19
				BRCS	TOROM36				; 20 /> 21
				CPI		XH,0X40				; 21
				BRCS	FROMROM36			; 23 /> 24
				XON_RBBCP					; 25
				LD		BUF,X+				; 28
				ST		Z,BUF				; 31
				LD		BUF,X				; 34
				XOFF_RBBCP					; 36
				OUT		RAMPZ,ONE			; 37
				JMP		M1_-T10+40			; 40
FROMROM36:		RLOAD_BUF[7]				; 31
				MOVW	ZL,L				; 32
				SAVE_BUF_Z[7]				; 39
				JMP		M1-T10+42			; 42
TOROM36:		JMP		M1-T10+24			; 24


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0X07*128						; RLC A          [ 07 ]  4 (18-24) HNC \\
											;                                  00
EX07:			BST		A,7					; 17
				BLD		F,CC				; 0
				LSL		A					; 1
				BLD		A,0					; 2
				CBR		F,(1<<HH)|(1<<NN)	; 3
				BST		RES,7				; 4
				MOV		RES,A				; 5
				BLD		RES,7				; 6
				M1H[2]						; 8
				BRCC	FROMRAM07			; 9 /> 10
				M1L_ROM[13]					; 22 ??? (+6)
FROMRAM07:		M1L_RAM[12]					; 22 ??? (+6)


.ORG	0X0000+0X0F*128						; RRC A          [ 0F ]  4 (18-24) HNC \\
											;                                  00
EX0F:			BST		A,0					; 17
				BLD		F,CC				; 0
				LSR		A					; 1
				BLD		A,7					; 2
				CBR		F,(1<<HH)|(1<<NN)|(1<<II); 3
				BST		RES,7				; 4
				MOV		RES,A				; 5
				BLD		RES,7				; 6
				M1H[2]						; 8
				BRCC	FROMRAM0F			; 9 /> 10
				M1L_ROM[13]					; 22 ??? (+6)
FROMRAM0F:		M1L_RAM[12]					; 22 ??? (+6)


.ORG	0X0000+0X08*128						; EX AF,AF'      [ 08 ]  4 (18-24) NONE \\

EX08:			IN	ZL,_A					; 17
				IN	ZH,_F					; 0
				OUT	_A,A					; 1
				OUT	_F,F					; 2
				MOVW	A,ZL				; 3
				IN		ZL,_RES				; 4
				OUT		_RES,RES			; 5
				MOV		RES,ZL				; 6
				M1H[2]						; 8
				BRCC	FROMRAM08			; 9 /> 10
				M1L_ROM[13]					; 22 ??? (+6)
FROMRAM08:		M1L_RAM[12]					; 22 ??? (+6)


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0X09*128						; ADD HL,BC      [ 09 ] 11 (50-66) HNC //
                                            ;                                   0
EX09:			CLI							; 17
				MOVW	TMPL,C				; 18
				JMP		COMADDHL_PR			; 21
COMADDHL_PR:	BST		RES,7				; 22
				MOVW	MEMPTRL,L			; 23
				ADD		MEMPTRL,ONE			; 24
				ADC		MEMPTRH,ZERO		; 25
				ADD		L,TMPL				; 26
				ADC		H,TMPH				; 27
				MOV		RES,H				; 28
				BLD		RES,7				; 29
				IN		BUF,SREG			; 30
				ANDI	BUF,(1<<HH)|(1<<CC)	; 31
				CBR		F,(1<<HH)|(1<<NN)|(1<<CC);32
				OR		F,BUF				; 33
				JMP		M1-T11+36			; 36


.ORG	0X0000+0X19*128						; ADD HL,DE      [ 09 ] 11 (50-66) HNC //
                                            ;                                   0
EX19:			CLI							; 17
				MOVW	TMPL,E				; 18
				JMP		COMADDHL_PR			; 21


.ORG	0X0000+0X29*128						; ADD HL,HL      [ 29 ] 11 (50-66) HNC //
                                            ;                                   0
EX29:			CLI							; 17
				MOVW	TMPL,L				; 18
				JMP		COMADDHL_PR			; 1


.ORG	0X0000+0X39*128						; ADD HL,SP      [ 39 ] 11 (50-66) HNC //
                                            ;                                   0
EX39:			CLI							; 7
				MOVW	TMPL,STPL			; 18
				JMP		COMADDHL_PR			; 21


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0X0A*128						; LD A,(BC)      [ 0A ]  7 (32-42) NONE \\

EX0A:			CLI							; 17
				MOVW	ZL,C				; 18
				CPI		ZH,0X40				; 19
				BRCS	FROMROM0A			; 20 /> 21
				LOAD_A_Z_[10]				; 30
				ADIW	ZL,0X01				; 0
				MOVW	MEMPTRL,ZL			; 1
				M1H_INTEN[3]				; 4 
				BRCC	FROMRAM0A			; 5 /> 6
				M1L_ROM[13]					; 18 ??? (+2)
FROMRAM0A:		M1L_RAM_[12]				; 18 ??? (+2)
FROMROM0A:		OR		ZH,ROMID			; 22
				ELPM	A,Z+				; 25
				CBR		ZH,0B11000000		; 26
				MOVW	MEMPTRL,ZL			; 27
				JMP		M1-T7+30			; 30


.ORG	0X0000+0X1A*128						; LD A,(DE)      [ 1A ]  7 (32-42) NONE \\

EX1A:			CLI							; 17
				MOVW	ZL,E				; 18
				CPI		ZH,0X40				; 19
				BRCS	FROMROM1A			; 20 /> 21
				LOAD_A_Z_[10]				; 30
				ADIW	ZL,0X01				; 0
				MOVW	MEMPTRL,ZL			; 1
				M1H_INTEN[3]				; 4 
				BRCC	FROMRAM1A			; 5 /> 6
				M1L_ROM[13]					; 18 ??? (+2)
FROMRAM1A:		M1L_RAM_[12]				; 18 ??? (+2)
FROMROM1A:		OR		ZH,ROMID			; 22
				ELPM	A,Z+				; 25
				CBR		ZH,0B11000000		; 26
				MOVW	MEMPTRL,ZL			; 27
				JMP		M1-T7+30			; 30


.ORG	0X0000+0X46*128						; LD B,(HL) [ 46 ]    7  (32-42) NONE //

EX46:			CLI							; 17
				MOVW	ZL,L				; 18
				CPI		ZH,0X40				; 19
				BRCS	FROMROM46			; 20 /> 21
				LOAD_B_Z_[10]				; 30
				NOP							; 31
				M1H_INTEN[3]				; 2 
				BRCC	FROMRAM46			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM46:		M1L_RAM_[12]				; 16	
FROMROM46:		OR		ZH,ROMID			; 22
				ELPM	B,Z					; 25
				JMP		M1-T7+28			; 28


.ORG	0X0000+0X4E*128						; LD C,(HL) [ 4E ]    7  (32-42) NONE //

EX4E:			CLI							; 17
				MOVW	ZL,L				; 18
				CPI		ZH,0X40				; 19
				BRCS	FROMROM4E			; 20 /> 21
				LOAD_C_Z_[10]				; 30
				NOP							; 31
				M1H_INTEN[3]				; 2 
				BRCC	FROMRAM4E			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM4E:		M1L_RAM_[12]				; 16	
FROMROM4E:		OR		ZH,ROMID			; 22
				ELPM	C,Z					; 25
				JMP		M1-T7+28			; 28


.ORG	0X0000+0X56*128						; LD D,(HL) [ 56 ]    7  (32-42) NONE //

EX56:			CLI							; 17
				MOVW	ZL,L				; 18
				CPI		ZH,0X40				; 19
				BRCS	FROMROM56			; 20 /> 21
				LOAD_D_Z_[10]				; 30
				NOP							; 31
				M1H_INTEN[3]				; 2 
				BRCC	FROMRAM56			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM56:		M1L_RAM_[12]				; 16	
FROMROM56:		OR		ZH,ROMID			; 22
				ELPM	D,Z					; 25
				JMP		M1-T7+28			; 28


.ORG	0X0000+0X5E*128						; LD E,(HL) [ 5E ]    7  (32-42) NONE //

EX5E:			CLI							; 17
				MOVW	ZL,L				; 18
				CPI		ZH,0X40				; 19
				BRCS	FROMROM5E			; 20 /> 21
				LOAD_E_Z_[10]				; 30
				NOP							; 31
				M1H_INTEN[3]				; 2 
				BRCC	FROMRAM5E			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM5E:		M1L_RAM_[12]				; 16	
FROMROM5E:		OR		ZH,ROMID			; 22
				ELPM	E,Z					; 25
				JMP		M1-T7+28			; 28


.ORG	0X0000+0X66*128						; LD H,(HL) [ 66 ]    7  (32-42) NONE //

EX66:			CLI							; 17
				MOVW	ZL,L				; 18
				CPI		ZH,0X40				; 19
				BRCS	FROMROM66			; 20 /> 21
				LOAD_H_Z_[10]				; 30
				NOP							; 31
				M1H_INTEN[3]				; 2 
				BRCC	FROMRAM66			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM66:		M1L_RAM_[12]				; 16	
FROMROM66:		OR		ZH,ROMID			; 22
				ELPM	H,Z					; 25
				JMP		M1-T7+28			; 28


.ORG	0X0000+0X6E*128						; LD L,(HL)      [ 6E ]  7  (32-42) NONE //

EX6E:			CLI							; 17
				MOVW	ZL,L				; 18
				CPI		ZH,0X40				; 19
				BRCS	FROMROM6E			; 20 /> 21
				LOAD_L_Z_[10]				; 30
				NOP							; 31
				M1H_INTEN[3]				; 2 
				BRCC	FROMRAM6E			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM6E:		M1L_RAM_[12]				; 16	
FROMROM6E:		OR		ZH,ROMID			; 22
				ELPM	L,Z					; 25
				JMP		M1-T7+28			; 28


.ORG	0X0000+0X7E*128						; LD A,(HL)  [ 7E ]    7  (32-42) NONE //

EX7E:			CLI							; 17
				MOVW	ZL,L				; 18
				CPI		ZH,0X40				; 19
				BRCS	FROMROM7E			; 20 /> 21
				LOAD_A_Z_[10]				; 30
				NOP							; 31
				M1H_INTEN[3]				; 2 
				BRCC	FROMRAM7E			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM7E:		M1L_RAM_[12]				; 16	
FROMROM7E:		OR		ZH,ROMID			; 22
				ELPM	A,Z					; 25
				JMP		M1-T7+28			; 28


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0X0B*128						; DEC BC         [ 0B ]  6 (27-36) NONE //

EX0B:			CLI							; 17
				CPI		PCH,0X40			; 18
				SUB		C,ONE				; 19
				SBC		B,ZERO				; 20
				JMP		M1-T6+23			; 23


.ORG	0X0000+0X1B*128						; DEC DE         [ 1B ]  6 (27-36) NONE //

EX1B:			CLI							; 17
				CPI		PCH,0X40			; 18
				SUB		E,ONE				; 19
				SBC		D,ZERO				; 20
				JMP		M1-T6+23			; 23


.ORG	0X0000+0X2B*128						; DEC HL         [ 2B ]  6 (27-36) NONE //

EX2B:			CLI							; 17
				CPI		PCH,0X40			; 18
				SUB		L,ONE				; 19
				SBC		H,ZERO				; 20
				JMP		M1-T6+23			; 23


.ORG	0X0000+0X3B*128						; DEC SP         [ 3B ]  6 (27-36) NONE //

EX3B:			CLI							; 17
				CPI		PCH,0X40			; 18
				SUB		STPL,ONE			; 19
				SBC		STPH,ZERO			; 20
				JMP		M1-T6+23			; 23


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0X10*128						; DJNZ (PC+N)    [ 10 ] 8/13  (37/78 - 48/59) NONE //

EX10:			CLI							; 17
				SUB		B,ONE				; 18
				BRNE	J10					; 19 /> 20
				ADIW	PCL,0X01			; 21
				JMP		M1-T8+24			; 24
J10:			NOP							; 21
J10_:			CPI		PCH,0X40			; 22
				BRCC	FROMRAM10			; 23 /> 24
				RLOAD_BUF[7]				; 30
				RJMP	COM10				; 32
FROMRAM10:		LOAD_BUF_PC[7]				; 31
				NOP							; 32
COM10:			SBRC	BUF,7				; 33
				COM		ZERO				; 34
				ADD		PCL,BUF				; 35
				ADC		PCH,ZERO			; 36
				CLR		ZERO				; 37
				MOVW	MEMPTRL,PCL			; 38
				JMP		M1-T13+41			; 41


.ORG	0X0000+0X18*128						; JR (PC+N)      [ 18 ]  12 (55-72) NONE \\

EX18:			CLI							; 17
				CPI		PCH,0X40			; 18
				BRCS	FROMROM18			; 19 /> 20
				LOAD_TMPL_PC_[7]			; 26
				RJMP	COM18				; 28
FROMROM18:		RLOAD_TMPL[7]				; 27
				NOP							; 28
COM18:			SBRC	TMPL,7				; 29
				COM		ZERO				; 30
				ADD		PCL,TMPL			; 31
				ADC		PCH,ZERO			; 32
				CLR		ZERO				; 33
				MOVW	MEMPTRL,PCL			; 34
				JMP		M1-T12+37			; 37


.ORG	0X0000+0X20*128						; JR NZ,(PC+N)  [ 20 ] 12/7  (72/42 - 55/32) NONE //

EX20:			CLI							; 17
				SBRS	F,ZZ 				; 18 /> 20
				JMP		J20					; 21
				ADIW	PCL,0X01			; 22
				JMP		M1-T7+25			; 25
J20:			CPI		PCH,0X40			; 22
				BRCC	FROMRAM20			; 23 /> 24
				RLOAD_BUF[7]				; 30
				RJMP	COM20_				; 32
FROMRAM20:		LOAD_BUF_PC[7]				; 31
				NOP							; 32
COM20_:			SBRC	BUF,7				; 33
				COM		ZERO				; 34
				ADD		PCL,BUF				; 35
				ADC		PCH,ZERO			; 36
				CLR		ZERO				; 37
				MOVW	MEMPTRL,PCL			; 38
				JMP		M1-T12+41			; 41

.ORG	0X0000+0X28*128						; JR Z,(PC+e)    [ 28 ]  12/7 (72/42 - 55/32) NONE //

EX28:			CLI							; 17
				SBRC	F,ZZ 				; 18 /> 20
				JMP		J20					; 21
				ADIW	PCL,0X01			; 22
				JMP		M1-T7+25			; 25


.ORG	0X0000+0X30*128						; JR NC,(PC+N)  [ 30 ] 12/7  (72/42 - 55/32) NONE //

EX30:			CLI							; 17
				SBRS	F,CC 				; 18 /> 20
				JMP		J20					; 21
				ADIW	PCL,0X01			; 22
				JMP		M1-T7+25			; 25


.ORG	0X0000+0X38*128						; JR C,(PC+N)    [ 38 ]  12/7  (72/42 - 55/32) NONE //

EX38:			CLI							; 17
				SBRC	F,CC 				; 18 /> 20
				JMP		J20					; 21
				ADIW	PCL,0X01			; 22
				JMP		M1-T7+25			; 25


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0X17*128						; RLA            [ 17 ] 4 (18-24) HNC \\
											;                                 00
EX17:			CBR		F,(1<<HH)|(1<<NN)|(1<<II); 17
				OUT		SREG,F				; 0
				ROL		A					; 1
				IN		BUF,SREG			; 
				BST		BUF,CC				; 3
				BLD		F,CC				; 4
				BST		RES,7				; 5
				MOV		RES,A				; 6
				BLD		RES,7				; 7
				M1H[2]						; 9
				BRCC	FROMRAM17			; 10 /> 11
				M1L_ROM[13]					; 23 ??? (+7)
FROMRAM17:		M1L_RAM[12]					; 23 ??? (+7)


.ORG	0X0000+0X1F*128						; RRA            [ 1F ] 4 (18-24) HNC \\
											;                                 00
EX1F:			CBR		F,(1<<HH)|(1<<NN)|(1<<II); 17
				OUT		SREG,F				; 0
				ROR		A					; 1
				IN		BUF,SREG			; 2
				BST		BUF,CC				; 3
				BLD		F,CC				; 4
				BST		RES,7				; 5
				MOV		RES,A				; 6
				BLD		RES,7				; 7
				M1H[2]						; 9
				BRCC	FROMRAM1F			; 10 /> 11
				M1L_ROM[13]					; 23 ??? (+7)
FROMRAM1F:		M1L_RAM[12]					; 23 ??? (+7)


.ORG	0X0000+0X22*128						; LD (NN),HL     [ 22 ] 16 (73-96) NONE //

EX22:			CLI							; 17
				BRCS	FROMROM22			; 18 /> 19
				XON_RBBCP					; 20
				LD		ZL,X+				; 23
				LD		ZH,X+				; 26
				LD		BUF,X				; 29
				CPI		ZH,0X40				; 30
				BRCS	TOROM22				; 31 /> 32
				ST		Z+,L				; 34
				ST		Z,H					; 37
				XOFF_RBBCP					; 39 
				OUT		RAMPZ,ONE			; 40
				MOVW	MEMPTRL,ZL			; 41
				JMP		M1_-T16+44			; 44
TOROM22:		XOFF_RBBCP					; 34
				OUT		RAMPZ,ONE			; 35
				ADIW	ZL,0X01				; 37
				MOVW	MEMPTRL,ZL			; 38
				JMP		M1_-T16+41			; 41
FROMROM22:		RLOAD_Z_PC[11]				; 30
				CPI		ZH,0X40				; 31
				BRCS	TOROM22_			; 32 /> 33
				SAVE_HL_Z[10]				; 42
				OUT		RAMPZ,ONE			; 43
				MOVW	MEMPTRL,ZL			; 44
				JMP		M1-T16+47			; 47
TOROM22_:		ADIW	ZL,0X01				; 34
				MOVW	MEMPTRL,ZL			; 35
				JMP		M1-T16+38			; 38


.ORG	0X0000+0X27*128						; DAA           [ 27 ] 4  (18-24) SZHPC \\

EX27:			OUT		EEARL,A 			; 17
				BST		F,HH	 			; 0
				BLD		F,ZZ	 			; 1
				CBR		F,0B11111000		; 2
				OUT		EEARH,F				; 3
				OUT		EECR,ONE			; 4
				IN		A,EEDR				; 5
				SBI		EEARH,3				; 7
				OUT		EECR,ONE			; 8
				IN		F,EEDR				; 9
				MOV		RES,A				; 10
				M1H[2]						; 12
				BRCC	FROMRAM27			; 13 /> 14
				M1L_ROM_SHORT[12]			; 25 ??? (+9)
FROMRAM27:		M1L_RAM[12]					; 26 ??? (+10)


.ORG	0X0000+0X2A*128						; LD HL,(NN)     [ 2A ] 16 (73-96) NONE

EX2A:			CLI							; 17
				BRCS	FROMROM2A			; 18 /> 19
				XON_RBBCP					; 20
				LD		ZL,X+				; 23
				LD		ZH,X+				; 26
				LD		BUF,X				; 29
				CPI		ZH,0X40				; 30
				BRCS	FROMROM2A_			; 31 /> 32
				LD		L,Z+				; 34
				LD		H,Z					; 37
				XOFF_RBBCP					; 39 
				OUT		RAMPZ,ONE			; 40
				MOVW	MEMPTRL,ZL			; 41
				JMP		M1_-T16+44			; 44
FROMROM2A_:		XOFF_RBBCP					; 34
				OUT		RAMPZ,ONE			; 35
				OR		ZH,ROMID			; 36
				ELPM	L,Z+				; 39
				ELPM	H,Z					; 42
				EOR		ZH,ROMID			; 43
				MOVW	MEMPTRL,ZL			; 44
				JMP		M1_-T16+47			; 47
FROMROM2A:		RLOAD_Z_PC[11]				; 30
				CPI		ZH,0X40				; 31
				BRCS	FROMROM2A_+1		; 32 /> 33
				LOAD_HL_Z[10]				; 42
				OUT		RAMPZ,ONE			; 43
				MOVW	MEMPTRL,ZL			; 44
				JMP		M1-T16+47			; 47


.ORG	0X0000+0X2F*128						; CPL            [ 2F ]  4 (18-24) HN \\
											;                                  11
EX2F:			STUFF18_CLI					; 
				COM		A					; 17
				SBR		F,(1<<HH)|(1<<NN)	; 0
				BST		RES,7				; 1
				MOV		RES,A				; 2
				BLD		RES,7				; 3
				STUFF18_1					; 
				STUFF18_SEI					; 
				M1H[2]						; 5
				BRCC	FROMRAM2F			; 6 /> 7
				M1L_ROM[13]					; 19 ??? (+3)
FROMRAM2F:		M1L_RAM[12]					; 19 ??? (+3)


.ORG	0X0000+0X32*128						; LD (NN),A      [ 32 ] 13 (59-78)  NONE
				
EX32:			CLI							; 17
				BRCS	FROMROM32			; 18 /> 19
				XON_RBBCP					; 20
				LD		ZL,X+				; 23
				LD		ZH,X+				; 26
				LD		BUF,X				; 29
				CPI		ZH,0X40				; 30
				BRCS	TOROM32				; 31 /> 32
				ST		Z,A					; 34
				XOFF_RBBCP					; 36 
COM32_RAM:		OUT		RAMPZ,ONE			; 37
				MOV		MEMPTRH,A			; 38
				MOV		MEMPTRL,ZL			; 39
				INC		MEMPTRL				; 40
				JMP		M1_-T13+43			; 43
TOROM32:		XOFF_RBBCP					; 34
				RJMP	COM32_RAM			; 36
FROMROM32:		RLOAD_Z_PC[11]				; 30
				CPI		ZH,0X40				; 31
				BRCS	TOROM32_			; 32 /> 33
				SAVE_A_ZI[7]				; 39
				OUT		RAMPZ,ONE			; 40
				JMP		M1-T13+43			; 43
TOROM32_:		INC		ZL					; 34
				JMP		M1-T13+37			; 37


.ORG	0X0000+0X37*128						; SCF            [ 37 ] 4 (18-24) NCH
											;                                 010
EX37:			STUFF18_CLI					; 
				STUFF18_1					; 
				CBR		F,(1<<NN)|(1<<HH)	; 17
				SBR		F,1<<CC				; 0
				BST		RES,7				; 1
				MOV		RES,A				; 2
				BLD		RES,7				; 3
				STUFF18_SEI					; 
				M1H[2]						; 5
				BRCC	FROMRAM37			; 6 /> 7
				M1L_ROM[13]					; 19 ??? (+3)
FROMRAM37:		M1L_RAM[12]					; 19 ??? (+3)


.ORG	0X0000+0X3F*128						; CCF            [ 3F ] 4 (18-24) HNC
											;                              C0
EX3F:			BST		F,CC				; 17
				BLD		F,HH				; 0
				CBR		F,(1<<NN)			; 1
				EOR		F,ONE				; 2
				BST		RES,7				; 3
				MOV		RES,A				; 4
				BLD		RES,7				; 5
				STUFF18_1					; 
				M1H[2]						; 7
				BRCC	FROMRAM3F			; 8 /> 9
				M1L_ROM[13]					; 21 ??? (+5)
FROMRAM3F:		M1L_RAM[12]					; 21 ??? (+5)


.ORG	0X0000+0X3A*128						; LD A,(NN)      [ 3A ] 13 (59) NONE

EX3A:			CLI							; 17
				CPI		PCH,0X40			; 18
				BRCS	FROMROM3A			; 19 /> 20
				LOAD_Z_PC_[13]				; 32
				RJMP	COM3A				; 34
FROMROM3A:		RLOAD_Z_PC[11]				; 31
				ELPM	BUFH,Z				; 34
COM3A:			CPI		ZH,0X40				; 35
				BRCS	FROMROM3A_			; 36 /> 37
				LOAD_A_Z[7]					; 43
				ADIW	ZL,0X01				; 45
				MOVW	MEMPTRL,ZL			; 46
				JMP	M1_-T13+49				; 49
FROMROM3A_:		RLOAD_A_ZI[5]				; 42
				MOVW	MEMPTRL,ZL			; 43
				JMP		M1_-T13+46			; 46


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0X40*128						; LD B,B    [ 40 ]      4   (18-24)    NONE //

EX40:			CLI							; 17
				STUFF18_6					; CLI AT THE TOP !!! 
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM40			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM40:		M1L_RAM[12]					; 16


.ORG	0X0000+0X41*128						; LD B,C    [ 41 ]      4   (18-24)    NONE \\

EX41:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		B,C					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM41			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM41:		M1L_RAM[12]					; 16



.ORG	0X0000+0X42*128						; LD B,D    [ 42 ]      4   (18-24)    NONE \\

EX42:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		B,D					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM42			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM42:		M1L_RAM[12]					; 16


.ORG	0X0000+0X43*128						; LD B,E    [ 43 ]      4   (18-24)    NONE \\

EX43:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		B,E					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM43			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM43:		M1L_RAM[12]					; 16


.ORG	0X0000+0X44*128						; LD B,H    [ 44 ]      4   (18-24)    NONE \\

EX44:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		B,H					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM44			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM44:		M1L_RAM[12]					; 16


.ORG	0X0000+0X45*128						; LD B,L    [ 45 ]      4   (18-24)    NONE \\

EX45:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		B,L					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM45			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM45:		M1L_RAM[12]					; 16


.ORG	0X0000+0X47*128						; LD B,A    [ 47 ]      4   (18-24)    NONE \\

EX47:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		B,A					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM47			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM47:		M1L_RAM[12]					; 16


.ORG	0X0000+0X48*128						; LD C,B    [ 48 ]      4   (18-24)    NONE \\

EX48:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		C,B					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM48			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM48:		M1L_RAM[12]					; 16


.ORG	0X0000+0X49*128						; LD C,C    [ 49 ]      4   (18-24)    NONE //

EX49:			CLI							; 17
				STUFF18_6					; CLI AT THE TOP !!! 
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM49			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM49:		M1L_RAM[12]					; 16


.ORG	0X0000+0X4A*128						; LD C,D    [ 4A ]      4   (18-24)    NONE //

EX4A:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		C,D					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM4A			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM4A:		M1L_RAM[12]					; 16


.ORG	0X0000+0X4B*128						; LD C,E    [ 4B ]      4   (18-24)    NONE //

EX4B:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		C,E					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM4B			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM4B:		M1L_RAM[12]					; 16


.ORG	0X0000+0X4C*128						; LD C,H    [ 4C ]      4   (18-24)    NONE //

EX4C:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		C,H					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM4C			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM4C:		M1L_RAM[12]					; 16


.ORG	0X0000+0X4D*128						; LD C,L    [ 4D ]      4   (18-24)    NONE //

EX4D:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		C,L					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM4D			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM4D:		M1L_RAM[12]					; 16


.ORG	0X0000+0X4F*128						; LD C,A    [ 4F ]      4   (18-24)    NONE //

EX4F:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		C,A					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM4F			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM4F:		M1L_RAM[12]					; 16


.ORG	0X0000+0X50*128						; LD D,B    [ 50 ]      4   (18-24)    NONE //

EX50:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		D,B					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM50			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM50:		M1L_RAM[12]					; 16


.ORG	0X0000+0X51*128						; LD D,C    [ 51 ]      4   (18-24)    NONE //

EX51:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		D,C					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM51			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM51:		M1L_RAM[12]					; 16


.ORG	0X0000+0X52*128						; LD D,D    [ 52 ]      4   (18-24)    NONE //

EX52:			CLI							; 17
				STUFF18_6					; CLI AT THE TOP !!! 
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM52			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM52:		M1L_RAM[12]					; 16



.ORG	0X0000+0X53*128						; LD D,E    [ 53 ]      4   (18-24)    NONE //

EX53:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		D,E					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM53			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM53:		M1L_RAM[12]					; 16


.ORG	0X0000+0X54*128						; LD D,H    [ 54 ]      4   (18-24)    NONE //

EX54:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		D,H					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM54			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM54:		M1L_RAM[12]					; 16


.ORG	0X0000+0X55*128						; LD D,L    [ 55 ]    4     (18-24) NONE //

EX55:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		D,L					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM55			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM55:		M1L_RAM[12]					; 16


.ORG	0X0000+0X57*128						; LD D,A    [ 57 ]    4     (18-24) NONE //

EX57:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		D,A					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM57			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM57:		M1L_RAM[12]					; 16


.ORG	0X0000+0X58*128						; LD E,B    [ 58 ]    4     (18-24) NONE //

EX58:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		E,B					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM58			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM58:		M1L_RAM[12]					; 16


.ORG	0X0000+0X59*128						; LD E,C    [ 59 ]    4     (18-24) NONE //

EX59:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		E,C					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM59			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM59:		M1L_RAM[12]					; 16


.ORG	0X0000+0X5A*128						; LD E,D    [ 5A ]    4     (18-24) NONE //

EX5A:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		E,D					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM5A			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM5A:		M1L_RAM[12]					; 16

.ORG	0X0000+0X5B*128						; LD E,E    [ 5B ]    4     (18-24)  NONE //

EX5B:			CLI							; 17
				STUFF18_6					; CLI AT THE TOP !!! 
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM5B			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM5B:		M1L_RAM[12]					; 16


.ORG	0X0000+0X5C*128						; LD E,H    [ 5C ]    4     (18-24) NONE //

EX5C:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		E,H					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM5C			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM5C:		M1L_RAM[12]					; 16


.ORG	0X0000+0X5D*128						; LD E,L    [ 5D ]    4     (18-24) NONE //

EX5D:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		E,L					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM5D			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM5D:		M1L_RAM[12]					; 16


.ORG	0X0000+0X5F*128						; LD E,A    [ 5F ]    4     (18-24) NONE //

EX5F:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		E,A					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM5F			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM5F:		M1L_RAM[12]					; 16


.ORG	0X0000+0X60*128						; LD H,B    [ 60 ]    4     (18-24) NONE //

EX60:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		H,B					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM60			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM60:		M1L_RAM[12]					; 16


.ORG	0X0000+0X61*128						; LD H,C    [ 61 ]    4     (18-24) NONE // 

EX61:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		H,C					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM61			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM61:		M1L_RAM[12]					; 16


.ORG	0X0000+0X62*128						; LD H,D    [ 62 ]    4     (18-24) NONE //

EX62:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		H,D					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM62			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM62:		M1L_RAM[12]					; 16


.ORG	0X0000+0X63*128						; LD H,E    [ 63 ]    4     (18-24) NONE //

EX63:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		H,E					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM63			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM63:		M1L_RAM[12]					; 16


.ORG	0X0000+0X64*128						; LD H,H     [ 64 ]   4     (18-24) NONE //

EX64:			CLI							; 17
				STUFF18_6					; CLI AT THE TOP !!! 
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM64			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM64:		M1L_RAM[12]					; 16


.ORG	0X0000+0X65*128						; LD H,L     [ 65 ]   4     (18-24) NONE //

EX65:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		H,L					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM65			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM65:		M1L_RAM[12]					; 16


.ORG	0X0000+0X67*128						; LD H,A     [ 67 ]   4     (18-24) NONE //

EX67:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		H,A					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM67			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM67:		M1L_RAM[12]					; 16


.ORG	0X0000+0X68*128						; LD L,B     [ 68 ]   4     (18-24) NONE //

EX68:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		L,B					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM68			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM68:		M1L_RAM[12]					; 16


.ORG	0X0000+0X69*128						; LD L,C     [ 69 ]   4     (18-24) NONE //

EX69:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		L,C					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM69			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM69:		M1L_RAM[12]					; 16


.ORG	0X0000+0X6A*128						; LD L,D     [ 6A ]   4     (18-24) NONE //

EX6A:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		L,D					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM6A			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM6A:		M1L_RAM[12]					; 16


.ORG	0X0000+0X6B*128						; LD L,E     [ 6B ]   4     (18-24) NONE //

EX6B:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		L,E					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM6B			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM6B:		M1L_RAM[12]					; 16


.ORG	0X0000+0X6C*128						; LD L,H     [ 6C ]   4     (18-24) NONE //

EX6C:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		L,H					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM6C			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM6C:		M1L_RAM[12]					; 16


.ORG	0X0000+0X6D*128						; LD L,L    [ 6D ]    4     (18-24) NONE //

EX6D:			CLI							; 17
				STUFF18_6					; CLI AT THE TOP !!! 
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM6D			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM6D:		M1L_RAM[12]					; 16


.ORG	0X0000+0X6F*128						; LD L,A    [ 6F ]    4     (18-24) NONE //

EX6F:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		L,A					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM6F			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM6F:		M1L_RAM[12]					; 16


.ORG	0X0000+0X78*128						; LD A,B     [ 78 ]    4  (18-24) NONE //

EX78:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		A,B					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM78			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM78:		M1L_RAM[12]					; 16


.ORG	0X0000+0X79*128						; LD A,C     [ 79 ]    4  (18-24) NONE //

EX79:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		A,C					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM79			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM79:		M1L_RAM[12]					; 16


.ORG	0X0000+0X7A*128						; LD A,D     [ 7A ]    4  (18-24) NONE //

EX7A:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		A,D					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM7A			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM7A:		M1L_RAM[12]					; 16


.ORG	0X0000+0X7B*128						; LD A,E     [ 7B ]    4  (18-24) NONE //

EX7B:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		A,E					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM7B			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM7B:		M1L_RAM[12]					; 16


.ORG	0X0000+0X7C*128						; LD A,H     [ 7C ]    4  (18-24) NONE //

EX7C:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		A,H					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM7C			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM7C:		M1L_RAM[12]					; 16


.ORG	0X0000+0X7D*128						; LD A,L     [ 7D ]    4  (18-24) NONE //

EX7D:			STUFF18_6					; CLI AT THE TOP !!! 
				MOV		A,L					; 17
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM7D			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM7D:		M1L_RAM[12]					; 16


.ORG	0X0000+0X7F*128						; LD A,A     [ 7F ]    4  (18-24) NONE

EX7F:			CLI							; 17
				STUFF18_6					; CLI AT THE TOP !!! 
				M1H_INTEN[3]				; 2
				BRCC	FROMRAM7F			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM7F:		M1L_RAM[12]					; 16


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0X70*128						; LD (HL),B  [ 70 ]    7  (32-42) NONE \\

EX70:			CLI							; 17
				MOVW	ZL,L				; 18
				BRCS	WRKROM70			; 19/> 20
				CPI		ZH,0X40				; 20
				BRCS	TOROM70				; 21 /> 22
				SAVE_B_Z_[10]				; 31
COM70:			STUFF32_10					; 
				M1H_INTEN[3]				; 2 
				BRCC	FROMRAM70			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM70:		M1L_RAM_[12]				; 16
TOROM70:		JMP		M1-T7+25			; 25
WRKROM70:		CPI		ZH,0X40				; 21
				BRCS	TOROM70_			; 22 /> 23
				SAVE_B_Z[7]					; 29
				RJMP	COM70				; 31
TOROM70_:		JMP		M1-T7+26			; 26


.ORG	0X0000+0X71*128						; LD (HL),C  [ 71 ]    7   (32-42)  NONE \\

EX71:			CLI							; 17
				MOVW	ZL,L				; 18
				BRCS	WRKROM71			; 19/> 20
				CPI		ZH,0X40				; 20
				BRCS	TOROM71				; 21 /> 22
				SAVE_C_Z_[10]				; 31
COM71:			STUFF32_10					; 
				M1H_INTEN[3]				; 2 
				BRCC	FROMRAM71			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM71:		M1L_RAM_[12]				; 16
TOROM71:		JMP		M1-T7+25			; 25
WRKROM71:		CPI		ZH,0X40				; 21
				BRCS	TOROM71_			; 22 /> 23
				SAVE_C_Z[7]					; 29
				RJMP	COM71				; 31
TOROM71_:		JMP		M1-T7+26			; 26


.ORG	0X0000+0X72*128						; LD (HL),D  [ 72 ]    7  (32-42) NONE

EX72:			CLI							; 17
				MOVW	ZL,L				; 18
				BRCS	WRKROM72			; 19/> 20
				CPI		ZH,0X40				; 20
				BRCS	TOROM72				; 21 /> 22
				SAVE_D_Z_[10]				; 31
COM72:			STUFF32_10					; 
				M1H_INTEN[3]				; 2 
				BRCC	FROMRAM72			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM72:		M1L_RAM_[12]				; 16
TOROM72:		JMP		M1-T7+25			; 25
WRKROM72:		CPI		ZH,0X40				; 21
				BRCS	TOROM72_			; 22 /> 23
				SAVE_D_Z[7]					; 29
				RJMP	COM72				; 31
TOROM72_:		JMP		M1-T7+26			; 26


.ORG	0X0000+0X73*128						; LD (HL),E  [ 73 ]    7    (32-42) NONE

EX73:			CLI							; 17
				MOVW	ZL,L				; 18
				BRCS	WRKROM73			; 19/> 20
				CPI		ZH,0X40				; 20
				BRCS	TOROM73				; 21 /> 22
				SAVE_E_Z_[10]				; 31
COM73:			STUFF32_10					; 
				M1H_INTEN[3]				; 2 
				BRCC	FROMRAM73			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM73:		M1L_RAM_[12]				; 16
TOROM73:		JMP		M1-T7+25			; 25
WRKROM73:		CPI		ZH,0X40				; 21
				BRCS	TOROM73_			; 22 /> 23
				SAVE_E_Z[7]					; 29
				RJMP	COM73				; 31
TOROM73_:		JMP		M1-T7+26			; 26


.ORG	0X0000+0X74*128						; LD (HL),H  [ 74 ]    7  (32-42) NONE

EX74:			CLI							; 17
				MOVW	ZL,L				; 18
				BRCS	WRKROM74			; 19/> 20
				CPI		ZH,0X40				; 20
				BRCS	TOROM74				; 21 /> 22
				SAVE_H_Z_[10]				; 31
COM74:			STUFF32_10					; 
				M1H_INTEN[3]				; 2 
				BRCC	FROMRAM74			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM74:		M1L_RAM_[12]				; 16
TOROM74:		JMP		M1-T7+25			; 25
WRKROM74:		CPI		ZH,0X40				; 21
				BRCS	TOROM74_			; 22 /> 23
				SAVE_H_Z[7]					; 29
				RJMP	COM74				; 31
TOROM74_:		JMP		M1-T7+26			; 26


.ORG	0X0000+0X75*128						; LD (HL),L  [ 75 ]    7  (32-42) NONE

EX75:			CLI							; 17
				MOVW	ZL,L				; 18
				BRCS	WRKROM75			; 19/> 20
				CPI		ZH,0X40				; 20
				BRCS	TOROM75				; 21 /> 22
				SAVE_L_Z_[10]				; 31
COM75:			STUFF32_10					; 
				M1H_INTEN[3]				; 2 
				BRCC	FROMRAM75			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM75:		M1L_RAM_[12]				; 16
TOROM75:		JMP		M1-T7+25			; 25
WRKROM75:		CPI		ZH,0X40				; 21
				BRCS	TOROM75_			; 22 /> 23
				SAVE_L_Z[7]					; 29
				RJMP	COM75				; 31
TOROM75_:		JMP		M1-T7+26			; 26


.ORG	0X0000+0X77*128						; LD (HL),A  [ 77 ]    7  (32-42) NONE

EX77:			CLI							; 17
				MOVW	ZL,L				; 18
				BRCS	WRKROM77			; 19/> 20
				CPI		ZH,0X40				; 20
				BRCS	TOROM77				; 21 /> 22
				SAVE_A_Z_[10]				; 31
COM77:			STUFF32_10					; 
				M1H_INTEN[3]				; 2 
				BRCC	FROMRAM77			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM77:		M1L_RAM_[12]				; 16
TOROM77:		JMP		M1-T7+25			; 25
WRKROM77:		CPI		ZH,0X40				; 21
				BRCS	TOROM77_			; 22 /> 23
				SAVE_A_Z[7]					; 29
				RJMP	COM77				; 31
TOROM77_:		JMP		M1-T7+26			; 26


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0X76*128						; HALT       [ 76 ]    4  (18-24) NONE

EX76:			CLI							; NOT CARE
				SBIC	ACSR,ACI			; NOT CARE
				JMP		DONEM2    			; 
LOOPHALT:		ADD		R,ONE				; 1
				LDI		TMPH,4				; * N=4
DECHALT:		DEC		TMPH				; * 
				BRNE	DECHALT				; * T=3*N=12 >> 13
				DELAY2						; 15
				STUFF18_6					; 
				SBIC	PINE,MINT;SBIS	ACSR,ACI			; 16
				RJMP	LOOPHALT			; 18
WAIT76:			SBIS	PINE,MINT;SBIS	ACSR,ACI			; 16
				RJMP	WAIT76				; 18
				;SBI		ACSR,ACI			; 19 ??? - FOR BATMAN (THE MOVIE)
				JMP		M1-2				; 


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0X80*128						; ADD A,B     [ 80 ]  4 (18-24) SZHVNC \\
				                            ;                                   0
EX80:			STUFF18_CLI					; 
				ADD		A,B					; ROM16/RAM17
				IN		F,SREG				; ROM17/RAM0
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<HH)|(1<<VV)|(1<<CC)|(1<<II); ROM0/RAM1
				MOV		RES,A				; ROM1/RAM2
				STUFF18_3					; 
				STUFF18_SEI					; 
M1H80:			M1H[2]						; ROM3/RAM4
				BRCS	FROMROM80			; 5<>
				M1L_RAM[12]					; 17 ??? (+1)
FROMROM80:		M1L_ROM[12]					; 17 ??? (+1)


.ORG	0X0000+0X81*128						; ADD A,C     [ 81 ]  4 (18-24) SZHVNC \\
				                            ;                                   0
EX81:			STUFF18_CLI					; 
				ADD		A,C					; ROM16/RAM17
				IN		F,SREG				; ROM17/RAM0
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<HH)|(1<<VV)|(1<<CC)|(1<<II); ROM0/RAM1
				MOV		RES,A				; ROM1/RAM2
				STUFF18_3					; 
				STUFF18_SEI					; 
M1H81:			M1H[2]						; ROM3/RAM4
				BRCS	FROMROM81			; 5<>
				M1L_RAM[12]					; 17 ??? (+1)
FROMROM81:		M1L_ROM[12]					; 17 ??? (+1)


.ORG	0X0000+0X82*128						; ADD A,D     [ 82 ]  4 (18-24) SZHVNC \\
				                            ;                                   0
EX82:			STUFF18_CLI					; 
				ADD		A,D					; ROM16/RAM17
				IN		F,SREG				; ROM17/RAM0
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<HH)|(1<<VV)|(1<<CC)|(1<<II); ROM0/RAM1
				MOV		RES,A				; ROM1/RAM2
				STUFF18_3					; 
				STUFF18_SEI					; 
M1H82:			M1H[2]						; ROM3/RAM4
				BRCS	FROMROM82			; 5<>
				M1L_RAM[12]					; 17 ??? (+1)
FROMROM82:		M1L_ROM[12]					; 17 ??? (+1)


.ORG	0X0000+0X83*128						; ADD A,E     [ 83 ]  4 (18-24) SZHVNC \\
				                            ;                                   0
EX83:			STUFF18_CLI					; 
				ADD		A,E					; ROM16/RAM17
				IN		F,SREG				; ROM17/RAM0
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<HH)|(1<<VV)|(1<<CC)|(1<<II); ROM0/RAM1
				MOV		RES,A				; ROM1/RAM2
				STUFF18_3					; 
				STUFF18_SEI					; 
M1H83:			M1H[2]						; ROM3/RAM4
				BRCS	FROMROM83			; 5<>
				M1L_RAM[12]					; 17 ??? (+1)
FROMROM83:		M1L_ROM[12]					; 17 ??? (+1)


.ORG	0X0000+0X84*128						; ADD A,H     [ 84 ]  4 (18-24) SZHVNC \\
				                            ;                                   0
EX84:			STUFF18_CLI					; 
				ADD		A,H					; ROM16/RAM17
				IN		F,SREG				; ROM17/RAM0
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<HH)|(1<<VV)|(1<<CC)|(1<<II); ROM0/RAM1
				MOV		RES,A				; ROM1/RAM2
				STUFF18_3					; 
				STUFF18_SEI					; 
M1H84:			M1H[2]						; ROM3/RAM4
				BRCS	FROMROM84			; 5<>
				M1L_RAM[12]					; 17 ??? (+1)
FROMROM84:		M1L_ROM[12]					; 17 ??? (+1)


.ORG	0X0000+0X85*128						; ADD A,L     [ 85 ]  4 (18-24) SZHVNC \\
				                            ;                                   0
EX85:			STUFF18_CLI					; 
				ADD		A,L					; ROM16/RAM17
				IN		F,SREG				; ROM17/RAM0
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<HH)|(1<<VV)|(1<<CC)|(1<<II); ROM0/RAM1
				MOV		RES,A				; ROM1/RAM2
				STUFF18_3					; 
				STUFF18_SEI					; 
M1H85:			M1H[2]						; ROM3/RAM4
				BRCS	FROMROM85			; 5<>
				M1L_RAM[12]					; 17 ??? (+1)
FROMROM85:		M1L_ROM[12]					; 17 ??? (+1)


.ORG	0X0000+0X87*128						; ADD A,A     [ 87 ]  4 (18-24) SZHVNC \\
				                            ;                                   0
EX87:			STUFF18_CLI					; 
				ADD		A,A					; ROM16/RAM17
				IN		F,SREG				; ROM17/RAM0
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<HH)|(1<<VV)|(1<<CC)|(1<<II); ROM0/RAM1
				MOV		RES,A				; ROM1/RAM2
				STUFF18_3					; 
				STUFF18_SEI					; 
M1H87:			M1H[2]						; ROM3/RAM4
				BRCS	FROMROM87			; 5<>
				M1L_RAM[12]					; 17 ??? (+1)
FROMROM87:		M1L_ROM[12]					; 17 ??? (+1)


.ORG	0X0000+0X86*128						; ADD A,(HL)  [ 86 ]  7 (32-42) SZHVNC //
				                            ;                                   0
EX86:			CLI							; 17
				MOVW	ZL,L				; 18
				CPI		ZH,0X40				; 19
				BRCS	FROMROM86			; 20 /> 21
				LOAD_TMPL_Z[7]				; 27
				ADD		A,TMPL				; 28
				IN		F,SREG				; 29
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<HH)|(1<<VV)|(1<<CC); 30
				MOV		RES,A				; 31
COM86:			STUFF32_10					; 
				M1H_INTEN[3]				; 2 
				BRCC	FROMRAM86			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAM86:		M1L_RAM[12]					; 16
FROMROM86:		RLOAD_TMPL_Z[4]				; 25
				ADD		A,TMPL				; 26
				IN		F,SREG				; 27
				ANDI	F,(1<<SS)|(1<<ZZ)|(1<<HH)|(1<<VV)|(1<<CC); 28
				MOV		RES,A				; 29
				RJMP	COM86				; 31


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0X88*128						; ADC A,B     [ 88 ]  4 (18-24) SZHVNC \\
				                            ;                                   0
EX88:			STUFF18_CLI					; 
				OUT		SREG,F				; 17
				ADC		A,B					; 0
				CLN							; 1
				IN		F,SREG				; 2
				MOV		RES,A				; 3
				STUFF18_1					; 
				STUFF18_SEI					; 
				M1H[2]						; 5
				BRCC	FROMRAM88			; 6 /> 7
				M1L_ROM[13]					; 19 ??? (+3)
FROMRAM88:		M1L_RAM[12]					; 19 ??? (+3)


.ORG	0X0000+0X89*128						; ADC A,C     [ 89 ]  4 (18-24) SZHVNC \\
				                            ;                                   0
EX89:			STUFF18_CLI					; 
				OUT		SREG,F				; 17
				ADC		A,C					; 0
				CLN							; 1
				IN		F,SREG				; 2
				MOV		RES,A				; 3
				STUFF18_1					; 
				STUFF18_SEI					; 
				M1H[2]						; 5
				BRCC	FROMRAM89			; 6 /> 7
				M1L_ROM[13]					; 19 ??? (+3)
FROMRAM89:		M1L_RAM[12]					; 19 ??? (+3)


.ORG	0X0000+0X8A*128						; ADC A,D     [ 8A ]  4 (18-24) SZHVNC \\
				                            ;                                   0
EX8A:			STUFF18_CLI					; 
				OUT		SREG,F				; 17
				ADC		A,D					; 0
				CLN							; 1
				IN		F,SREG				; 2
				MOV		RES,A				; 3
				STUFF18_1					; 
				STUFF18_SEI					; 
				M1H[2]						; 5
				BRCC	FROMRAM8A			; 6 /> 7
				M1L_ROM[13]					; 19 ??? (+3)
FROMRAM8A:		M1L_RAM[12]					; 19 ??? (+3)


.ORG	0X0000+0X8B*128						; ADC A,E     [ 8B ]  4 (18-24) SZHVNC \\
				                            ;                                   0
EX8B:			STUFF18_CLI					; 
				OUT		SREG,F				; 17
				ADC		A,E					; 0
				CLN							; 1
				IN		F,SREG				; 2
				MOV		RES,A				; 3
				STUFF18_1					; 
				STUFF18_SEI					; 
				M1H[2]						; 5
				BRCC	FROMRAM8B			; 6 /> 7
				M1L_ROM[13]					; 19 ??? (+3)
FROMRAM8B:		M1L_RAM[12]					; 19 ??? (+3)


.ORG	0X0000+0X8C*128						; ADC A,H     [ 8C ]  4 (18-24) SZHVNC \\
				                            ;                                   0
EX8C:			STUFF18_CLI					; 
				OUT		SREG,F				; 17
				ADC		A,H					; 0
				CLN							; 1
				IN		F,SREG				; 2
				MOV		RES,A				; 3
				STUFF18_1					; 
				STUFF18_SEI					; 
				M1H[2]						; 5
				BRCC	FROMRAM8C			; 6 /> 7
				M1L_ROM[13]					; 19 ??? (+3)
FROMRAM8C:		M1L_RAM[12]					; 19 ??? (+3)


.ORG	0X0000+0X8D*128						; ADC A,L     [ 8D ]  4 (18-24) SZHVNC \\
				                            ;                                   0
EX8D:			STUFF18_CLI					; 
				OUT		SREG,F				; 17
				ADC		A,L					; 0
				CLN							; 1
				IN		F,SREG				; 2
				MOV		RES,A				; 3
				STUFF18_1					; 
				STUFF18_SEI					; 
				M1H[2]						; 5
				BRCC	FROMRAM8D			; 6 /> 7
				M1L_ROM[13]					; 19 ??? (+3)
FROMRAM8D:		M1L_RAM[12]					; 19 ??? (+3)


.ORG	0X0000+0X8F*128						; ADC A,A     [ 8F ]  4 (18-24) SZHVNC \\
				                            ;                                   0
EX8F:			STUFF18_CLI					; 
				OUT		SREG,F				; 17
				ADC		A,A					; 0
				CLN							; 1
				IN		F,SREG				; 2
				MOV		RES,A				; 3
				STUFF18_1					; 
				STUFF18_SEI					; 
				M1H[2]						; 5
				BRCC	FROMRAM8F			; 6 /> 7
				M1L_ROM[13]					; 19 ??? (+3)
FROMRAM8F:		M1L_RAM[12]					; 19 ??? (+3)


.ORG	0X0000+0X8E*128						; ADC A,(HL)  [ 8E ]  7 (32-42) SZHVNC \\
				                            ;                                   0
EX8E:			CLI							; 17
				MOVW	ZL,L				; 18
				CPI		ZH,0X40				; 19
				BRCS	FROMROM8E			; 20 /> 21
				LOAD_TMPL_Z[7]				; 27
				OUT		SREG,F				; 28
				ADC		A,TMPL				; 29
				CLN							; 30
				IN		F,SREG				; 31
				MOV		RES,A				; 0
COM8E:			STUFF32_9					; 
				M1H_INTEN[3]				; 3 
				BRCC	FROMRAM8E			; 4 /> 5
				M1L_ROM[13]					; 17 ??? (+1)
FROMRAM8E:		M1L_RAM[12]					; 17 ??? (+1)
FROMROM8E:		RLOAD_TMPL_Z[4]				; 25
				OUT		SREG,F				; 26
				ADC		A,TMPL				; 27
				CLN							; 28
				IN		F,SREG				; 29
				MOV		RES,A				; 30
				RJMP	COM8E				; 32


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0X90*128						; SUB B       [ 90 ]  4 (18-24) SZHVNC \\
				                            ;                                   1
EX90:			STUFF18_CLI					; 
				OUT		SREG,F				; 17
				SUB		A,B					; 0
				SEN							; 1
				IN		F,SREG				; 2
				MOV		RES,A				; 3
				STUFF18_2					; 
				STUFF18_SEI					; 
				M1H[2]						; 4
				BRCC	FROMRAM90			; 5 /> 6
				M1L_ROM[13]					; 18 ??? (+2)
FROMRAM90:		M1L_RAM[12]					; 18 ??? (+2)


.ORG	0X0000+0X91*128						; SUB C       [ 91 ]  4 (18-24) SZHVNC \\
				                            ;                                   1
EX91:			STUFF18_CLI					; 
				OUT		SREG,F				; 17
				SUB		A,C					; 0
				SEN							; 1
				IN		F,SREG				; 2
				MOV		RES,A				; 3
				STUFF18_2					; 
				STUFF18_SEI					; 
				M1H[2]						; 4
				BRCC	FROMRAM91			; 5 /> 6
				M1L_ROM[13]					; 18 ??? (+2)
FROMRAM91:		M1L_RAM[12]					; 18 ??? (+2)


.ORG	0X0000+0X92*128						; SUB D       [ 92 ]  4 (18-24) SZHVNC \\
				                            ;                                   1
EX92:			STUFF18_CLI					; 
				OUT		SREG,F				; 17
				SUB		A,D					; 0
				SEN							; 1
				IN		F,SREG				; 2
				MOV		RES,A				; 3
				STUFF18_2					; 
				STUFF18_SEI					; 
				M1H[2]						; 4
				BRCC	FROMRAM92			; 5 /> 6
				M1L_ROM[13]					; 18 ??? (+2)
FROMRAM92:		M1L_RAM[12]					; 18 ??? (+2)


.ORG	0X0000+0X93*128						; SUB E       [ 93 ]  4 (18-24) SZHVNC \\
				                            ;                                   1
EX93:			STUFF18_CLI					; 
				OUT		SREG,F				; 17
				SUB		A,E					; 0
				SEN							; 1
				IN		F,SREG				; 2
				MOV		RES,A				; 3
				STUFF18_2					; 
				STUFF18_SEI					; 
				M1H[2]						; 4
				BRCC	FROMRAM93			; 5 /> 6
				M1L_ROM[13]					; 18 ??? (+2)
FROMRAM93:		M1L_RAM[12]					; 18 ??? (+2)


.ORG	0X0000+0X94*128						; SUB H       [ 94 ]  4 (18-24) SZHVNC \\
				                            ;                                   1
EX94:			STUFF18_CLI					; 
				OUT		SREG,F				; 17
				SUB		A,H					; 0
				SEN							; 1
				IN		F,SREG				; 2
				MOV		RES,A				; 3
				STUFF18_2					; 
				STUFF18_SEI					; 
				M1H[2]						; 4
				BRCC	FROMRAM94			; 5 /> 6
				M1L_ROM[13]					; 18 ??? (+2)
FROMRAM94:		M1L_RAM[12]					; 18 ??? (+2)


.ORG	0X0000+0X95*128						; SUB L       [ 95 ]  4 (18-24) SZHVNC \\
				                            ;                                   1
EX95:			STUFF18_CLI					; 
				OUT		SREG,F				; 17
				SUB		A,L					; 0
				SEN							; 1
				IN		F,SREG				; 2
				MOV		RES,A				; 3
				STUFF18_2					; 
				STUFF18_SEI					; 
				M1H[2]						; 4
				BRCC	FROMRAM95			; 5 /> 6
				M1L_ROM[13]					; 18 ??? (+2)
FROMRAM95:		M1L_RAM[12]					; 18 ??? (+2)


.ORG	0X0000+0X97*128						; SUB A       [ 97 ]  4 (18-24) SZHVNC \\
				                            ;                                   1
EX97:			STUFF18_CLI					; 
				OUT		SREG,F				; 17
				SUB		A,A					; 0
				SEN							; 1
				IN		F,SREG				; 2
				MOV		RES,A				; 3
				STUFF18_2					; 
				STUFF18_SEI					; 
				M1H[2]						; 4
				BRCC	FROMRAM97			; 5 /> 6
				M1L_ROM[13]					; 18 ??? (+2)
FROMRAM97:		M1L_RAM[12]					; 18 ??? (+2)


.ORG	0X0000+0X96*128						; SUB (HL)    [ 96 ]  7 (32-42) SZHVNC //
				                            ;                                   1
EX96:			CLI							; 17
				MOVW	ZL,L				; 18
				CPI		ZH,0X40				; 19
				BRCS	FROMROM96			; 20 /> 21
				LOAD_TMPL_Z[7]				; 27
				OUT		SREG,F				; 28
				SUB		A,TMPL				; 29
				SEN							; 30
				IN		F,SREG				; 31
				MOV		RES,A				; 0
COM96:			STUFF32_9					; 
				M1H_INTEN[3]				; 3 
				BRCC	FROMRAM96			; 4 /> 5
				M1L_ROM[13]					; 17 ??? (+1)
FROMRAM96:		M1L_RAM[12]					; 17 ??? (+1)
FROMROM96:		RLOAD_TMPL_Z[4]				; 25
				OUT		SREG,F				; 26
				SUB		A,TMPL				; 27
				SEN							; 28
				IN		F,SREG				; 29
				MOV		RES,A				; 30
				RJMP	COM96				; 0


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0X98*128						; SBC A,B       [ 98 ]  4 (18-24) SZHVNC \\
				                            ;                                     1
EX98:			STUFF18_CLI
				OUT		SREG,F				; 17
				SEZ							; 0
				SBC		A,B					; 1
				SEN							; 2
				IN		F,SREG				; 3
				MOV		RES,A				; 4
				STUFF18_1					; 
				STUFF18_SEI					; 
				M1H[2]						; 5
				BRCC	FROMRAM98			; 6 /> 7
				M1L_ROM[13]					; 19 ??? (+3)
FROMRAM98:		M1L_RAM[12]					; 19 ??? (+3)


.ORG	0X0000+0X99*128						; SBC A,C       [ 99 ]  4 (18-24) SZHVNC \\
				                            ;                                     1
EX99:			STUFF18_CLI
				OUT		SREG,F				; 17
				SEZ							; 0
				SBC		A,C					; 1
				SEN							; 2
				IN		F,SREG				; 3
				MOV		RES,A				; 4
				STUFF18_1					; 
				STUFF18_SEI					; 
				M1H[2]						; 5
				BRCC	FROMRAM99			; 6 /> 7
				M1L_ROM[13]					; 19 ??? (+3)
FROMRAM99:		M1L_RAM[12]					; 19 ??? (+3)


.ORG	0X0000+0X9A*128						; SBC A,D       [ 9A ]  4 (18-24) SZHVNC \\
				                            ;                                     1
EX9A:			STUFF18_CLI
				OUT		SREG,F				; 17
				SEZ							; 0
				SBC		A,D					; 1
				SEN							; 2
				IN		F,SREG				; 3
				MOV		RES,A				; 4
				STUFF18_1					; 
				STUFF18_SEI					; 
				M1H[2]						; 5
				BRCC	FROMRAM9A			; 6 /> 7
				M1L_ROM[13]					; 19 ??? (+3)
FROMRAM9A:		M1L_RAM[12]					; 19 ??? (+3)


.ORG	0X0000+0X9B*128						; SBC A,E       [ 9B ]  4 (18-24) SZHVNC \\
				                            ;                                     1
EX9B:			STUFF18_CLI
				OUT		SREG,F				; 17
				SEZ							; 0
				SBC		A,E					; 1
				SEN							; 2
				IN		F,SREG				; 3
				MOV		RES,A				; 4
				STUFF18_1					; 
				STUFF18_SEI					; 
				M1H[2]						; 5
				BRCC	FROMRAM9B			; 6 /> 7
				M1L_ROM[13]					; 19 ??? (+3)
FROMRAM9B:		M1L_RAM[12]					; 19 ??? (+3)


.ORG	0X0000+0X9C*128						; SBC A,H       [ 9C ]  4 (18-24) SZHVNC \\
				                            ;                                     1
EX9C:			STUFF18_CLI
				OUT		SREG,F				; 17
				SEZ							; 0
				SBC		A,H					; 1
				SEN							; 2
				IN		F,SREG				; 3
				MOV		RES,A				; 4
				STUFF18_1					; 
				STUFF18_SEI					; 
				M1H[2]						; 5
				BRCC	FROMRAM9C			; 6 /> 7
				M1L_ROM[13]					; 19 ??? (+3)
FROMRAM9C:		M1L_RAM[12]					; 19 ??? (+3)


.ORG	0X0000+0X9D*128						; SBC A,L       [ 9D ]  4 (18-24) SZHVNC \\
				                            ;                                     1
EX9D:			STUFF18_CLI
				OUT		SREG,F				; 17
				SEZ							; 0
				SBC		A,L					; 1
				SEN							; 2
				IN		F,SREG				; 3
				MOV		RES,A				; 4
				STUFF18_1					; 
				STUFF18_SEI					; 
				M1H[2]						; 5
				BRCC	FROMRAM9D			; 6 /> 7
				M1L_ROM[13]					; 19 ??? (+3)
FROMRAM9D:		M1L_RAM[12]					; 19 ??? (+3)


.ORG	0X0000+0X9F*128						; SBC A,A       [ 9F ]  4 (18-24) SZHVNC \\
				                            ;                                     1
EX9F:			STUFF18_CLI
				OUT		SREG,F				; 17
				SEZ							; 0
				SBC		A,A					; 1
				SEN							; 2
				IN		F,SREG				; 3
				MOV		RES,A				; 4
				STUFF18_1					; 
				STUFF18_SEI					; 
				M1H[2]						; 5
				BRCC	FROMRAM9F			; 6 /> 7
				M1L_ROM[13]					; 19 ??? (+3)
FROMRAM9F:		M1L_RAM[12]					; 19 ??? (+3)


.ORG	0X0000+0X9E*128						; SBC A,(HL)  [ 9E ]  7 (32-42) SZHVNC \\
				                            ;                                   1
EX9E:			CLI							; 17
				MOVW	ZL,L				; 18
				CPI		ZH,0X40				; 19
				BRCS	FROMROM9E			; 20 /> 21
				LOAD_TMPL_Z[7]				; 27
				OUT		SREG,F				; 28
				SEZ							; 29
				SBC		A,TMPL				; 30
				SEN							; 31
				IN		F,SREG				; 0
				MOV		RES,A				; 1
COM9E:			STUFF32_8
				M1H_INTEN[3]				; 4 
				BRCC	FROMRAM9E			; 5 /> 6
				M1L_ROM[13]					; 18 ??? (+2)
FROMRAM9E:		M1L_RAM[12]					; 18 ??? (+2)
FROMROM9E:		RLOAD_TMPL_Z[4]				; 25
				OUT		SREG,F				; 26
				SEZ							; 27
				SBC		A,TMPL				; 28
				SEN							; 29
				IN		F,SREG				; 30
				MOV		RES,A				; 31
				RJMP	COM9E				; 1


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0XA0*128						; AND B         [ A0 ]  4 (18-24) SZHVNC
				                            ;                                   1P00
EXA0:			AND		A,B					; 17
				MOV		RES,A				; 0
				MOV		ZL,RES				; 1
				LDI		ZH,0X03				; 2
				LD		F,Z					; 4
				STUFF18_SEI					; 
				M1H[2]						; 6
				BRCC	FROMRAMA0			; 7 /> 8
				M1L_ROM[13]					; 20 ??? (+4)
FROMRAMA0:		M1L_RAM[12]					; 20 ??? (+4)


.ORG	0X0000+0XA1*128						; AND C         [ A1 ]  4 (18-24) SZHVNC
				                            ;                                   1P00
EXA1:			AND		A,C					; 17
				MOV		RES,A				; 0
				MOV		ZL,RES				; 1
				LDI		ZH,0X03				; 2
				LD		F,Z					; 4
				STUFF18_SEI					; 
				M1H[2]						; 6
				BRCC	FROMRAMA1			; 7 /> 8
				M1L_ROM[13]					; 20 ??? (+4)
FROMRAMA1:		M1L_RAM[12]					; 20 ??? (+4)


.ORG	0X0000+0XA2*128						; AND D         [ A2 ]  4 (18-24) SZHVNC
				                            ;                                   1P00
EXA2:			AND		A,D					; 17
				MOV		RES,A				; 0
				MOV		ZL,RES				; 1
				LDI		ZH,0X03				; 2
				LD		F,Z					; 4
				STUFF18_SEI					; 
				M1H[2]						; 6
				BRCC	FROMRAMA2			; 7 /> 8
				M1L_ROM[13]					; 20 ??? (+4)
FROMRAMA2:		M1L_RAM[12]					; 20 ??? (+4)


.ORG	0X0000+0XA3*128						; AND E         [ A3 ]  4 (18-24) SZHVNC
				                            ;                                   1P00
EXA3:			AND		A,E					; 17
				MOV		RES,A				; 0
				MOV		ZL,RES				; 1
				LDI		ZH,0X03				; 2
				LD		F,Z					; 4
				STUFF18_SEI					; 
				M1H[2]						; 6
				BRCC	FROMRAMA3			; 7 /> 8
				M1L_ROM[13]					; 20 ??? (+4)
FROMRAMA3:		M1L_RAM[12]					; 20 ??? (+4)


.ORG	0X0000+0XA4*128						; AND H         [ A4 ]  4 (18-24) SZHVNC
				                            ;                                   1P00
EXA4:			AND		A,H					; 17
				MOV		RES,A				; 0
				MOV		ZL,RES				; 1
				LDI		ZH,0X03				; 2
				LD		F,Z					; 4
				STUFF18_SEI					; 
				M1H[2]						; 6
				BRCC	FROMRAMA4			; 7 /> 8
				M1L_ROM[13]					; 20 ??? (+4)
FROMRAMA4:		M1L_RAM[12]					; 20 ??? (+4)


.ORG	0X0000+0XA5*128						; AND L         [ A5 ]  4 (18-24) SZHVNC
				                            ;                                   1P00
EXA5:			AND		A,L					; 17
				MOV		RES,A				; 0
				MOV		ZL,RES				; 1
				LDI		ZH,0X03				; 2
				LD		F,Z					; 4
				STUFF18_SEI					; 
				M1H[2]						; 6
				BRCC	FROMRAMA5			; 7 /> 8
				M1L_ROM[13]					; 20 ??? (+4)
FROMRAMA5:		M1L_RAM[12]					; 20 ??? (+4)


.ORG	0X0000+0XA7*128						; AND A         [ A7 ]  4 (18-24) SZHVNC
				                            ;                                   1P00
EXA7:			AND		A,A					; 17
				MOV		RES,A				; 0
				MOV		ZL,RES				; 1
				LDI		ZH,0X03				; 2
				LD		F,Z					; 4
				STUFF18_SEI					; 
				M1H[2]						; 6
				BRCC	FROMRAMA7			; 7 /> 8
				M1L_ROM[13]					; 20 ??? (+4)
FROMRAMA7:		M1L_RAM[12]					; 20 ??? (+4)


.ORG	0X0000+0XA6*128						; AND (HL)      [ A6 ]  7 (32-42) SZHVNC
				                            ;                                   1 00
EXA6:			CLI							; 17
				MOVW	ZL,L				; 18
				CPI		ZH,0X40				; 19
				BRCS	FROMROMA6			; 20 /> 21
				LOAD_TMPL_Z[7]				; 27
				AND		A,TMPL				; 28
				MOV		RES,A				; 29
				MOV		ZL,RES				; 30
				LDI		ZH,0X03				; 31
				LD		F,Z					; 1
COMA6:			STUFF32_8					; 
				M1H_INTEN[3]				; 4 
				BRCC	FROMRAMA6			; 5 /> 6
				M1L_ROM[13]					; 18 ??? (+2)
FROMRAMA6:		M1L_RAM[12]					; 18 ??? (+2)
FROMROMA6:		RLOAD_TMPL_Z[4]				; 25
				AND		A,TMPL				; 26
				MOV		RES,A				; 27
				MOV		ZL,RES				; 28
				LDI		ZH,0X03				; 29
				LD		F,Z					; 31
				RJMP	COMA6				; 1


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0XA8*128						; XOR B         [ A8 ]  4 (18-24) SZHVNC
				                            ;                                   0P00
EXA8:			STUFF18_CLI					; 
				EOR		A,B					; 17
				MOV		RES,A				; 0
				MOVW	ZL,RES				; 1
				LD		F,Z					; 3
				STUFF18_1					; 
				STUFF18_SEI					; 
				M1H[2]						; 5
				BRCC	FROMRAMA8			; 6 /> 7
				M1L_ROM[13]					; 19 ??? (+3)
FROMRAMA8:		M1L_RAM[12]					; 19 ??? (+3)


.ORG	0X0000+0XA9*128						; XOR C         [ A9 ]  4 (18-24) SZHVNC
				                            ;                                   0P00
EXA9:			STUFF18_CLI					; 
				EOR		A,C					; 17
				MOV		RES,A				; 0
				MOVW	ZL,RES				; 1
				LD		F,Z					; 3
				STUFF18_1					; 
				STUFF18_SEI					; 
				M1H[2]						; 5
				BRCC	FROMRAMA9			; 6 /> 7
				M1L_ROM[13]					; 19 ??? (+3)
FROMRAMA9:		M1L_RAM[12]					; 19 ??? (+3)


.ORG	0X0000+0XAA*128						; XOR D         [ AA ]  4 (18-24) SZHVNC
				                            ;                                   0P00
EXAA:			STUFF18_CLI					; 
				EOR		A,D					; 17
				MOV		RES,A				; 0
				MOVW	ZL,RES				; 1
				LD		F,Z					; 3
				STUFF18_1					; 
				STUFF18_SEI					; 
				M1H[2]						; 5
				BRCC	FROMRAMAA			; 6 /> 7
				M1L_ROM[13]					; 19 ??? (+3)
FROMRAMAA:		M1L_RAM[12]					; 19 ??? (+3)


.ORG	0X0000+0XAB*128						; XOR E         [ AB ]  4 (18-24) SZHVNC
				                            ;                                   0P00
EXAB:			STUFF18_CLI					; 
				EOR		A,E					; 17
				MOV		RES,A				; 0
				MOVW	ZL,RES				; 1
				LD		F,Z					; 3
				STUFF18_1					; 
				STUFF18_SEI					; 
				M1H[2]						; 5
				BRCC	FROMRAMAB			; 6 /> 7
				M1L_ROM[13]					; 19 ??? (+3)
FROMRAMAB:		M1L_RAM[12]					; 19 ??? (+3)


.ORG	0X0000+0XAC*128						; XOR H         [ AC ]  4 (18-24) SZHVNC
				                            ;                                   0P00
EXAC:			STUFF18_CLI					; 
				EOR		A,H					; 17
				MOV		RES,A				; 0
				MOVW	ZL,RES				; 1
				LD		F,Z					; 3
				STUFF18_1					; 
				STUFF18_SEI					; 
				M1H[2]						; 5
				BRCC	FROMRAMAC			; 6 /> 7
				M1L_ROM[13]					; 19 ??? (+3)
FROMRAMAC:		M1L_RAM[12]					; 19 ??? (+3)


.ORG	0X0000+0XAD*128						; XOR L         [ AD ]  4 (18-24) SZHVNC
				                            ;                                   0P00
EXAD:			STUFF18_CLI					; 
				EOR		A,L					; 17
				MOV		RES,A				; 0
				MOVW	ZL,RES				; 1
				LD		F,Z					; 3
				STUFF18_1					; 
				STUFF18_SEI					; 
				M1H[2]						; 5
				BRCC	FROMRAMAD			; 6 /> 7
				M1L_ROM[13]					; 19 ??? (+3)
FROMRAMAD:		M1L_RAM[12]					; 19 ??? (+3)


.ORG	0X0000+0XAF*128						; XOR A         [ AF ]  4 (18-24) SZHVNC
				                            ;                                   0P00
EXAF:			STUFF18_CLI					; 
				EOR		A,A					; 17
				MOV		RES,A				; 0
				MOVW	ZL,RES				; 1
				LD		F,Z					; 3
				STUFF18_1					; 
				STUFF18_SEI					; 
				M1H[2]						; 5
				BRCC	FROMRAMAF			; 6 /> 7
				M1L_ROM[13]					; 19 ??? (+3)
FROMRAMAF:		M1L_RAM[12]					; 19 ??? (+3)


.ORG	0X0000+0XAE*128						; XOR (HL)    [ AE ]  7 (32-42) SZHVNC
				                            ;                                 0P00
EXAE:			CLI							; 17
				MOVW	ZL,L				; 18
				CPI		ZH,0X40				; 19
				BRCS	FROMROMAE			; 20 /> 21
				LOAD_BUF_Z[7]				; 27
COMAE:			STUFF32_9
				EOR		A,BUF				; 28
				MOV		RES,A				; 29
				MOVW	ZL,RES				; 30
				LD		F,Z					; 0
				M1H_INTEN[3]				; 3
				BRCC	FROMRAMAE			; 4 /> 5
				M1L_ROM[13]					; 17 ??? (+1)
FROMRAMAE:		M1L_RAM[12]					; 17 ??? (+1)
FROMROMAE:		RLOAD_BUF_Z[4]				; 25
				RJMP	COMAE				; 27


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0XB0*128						; OR B       [ B0 ]  4 (18-24) SZHVNC
				                            ;                                0P00
EXB0:			STUFF18_CLI					; 
				OR		A,B					; 17
				MOV		RES,A				; 0
				MOVW	ZL,RES				; 1
				LD		F,Z					; 3
				STUFF18_1					; 
				STUFF18_SEI					; 
				M1H[2]						; 5
				BRCC	FROMRAMB0			; 6 /> 7
				M1L_ROM[13]					; 19 ??? (+3)
FROMRAMB0:		M1L_RAM[12]					; 19 ??? (+3)


.ORG	0X0000+0XB1*128						; OR C       [ B1 ]  4 (18-24) SZHVNC
				                            ;                                0P00
EXB1:			STUFF18_CLI					; 
				OR		A,C					; 17
				MOV		RES,A				; 0
				MOVW	ZL,RES				; 1
				LD		F,Z					; 3
				STUFF18_1					; 
				STUFF18_SEI					; 
				M1H[2]						; 5
				BRCC	FROMRAMB1			; 6 /> 7
				M1L_ROM[13]					; 19 ??? (+3)
FROMRAMB1:		M1L_RAM[12]					; 19 ??? (+3)


.ORG	0X0000+0XB2*128						; OR D       [ B2 ]  4 (18-24) SZHVNC
				                            ;                                0P00
EXB2:			STUFF18_CLI					; 
				OR		A,D					; 17
				MOV		RES,A				; 0
				MOVW	ZL,RES				; 1
				LD		F,Z					; 3
				STUFF18_1					; 
				STUFF18_SEI					; 
				M1H[2]						; 5
				BRCC	FROMRAMB2			; 6 /> 7
				M1L_ROM[13]					; 19 ??? (+3)
FROMRAMB2:		M1L_RAM[12]					; 19 ??? (+3)


.ORG	0X0000+0XB3*128						; OR E       [ B3 ]  4 (18-24) SZHVNC
				                            ;                                0P00
EXB3:			STUFF18_CLI					; 
				OR		A,E					; 17
				MOV		RES,A				; 0
				MOVW	ZL,RES				; 1
				LD		F,Z					; 3
				STUFF18_1					; 
				STUFF18_SEI					; 
				M1H[2]						; 5
				BRCC	FROMRAMB3			; 6 /> 7
				M1L_ROM[13]					; 19 ??? (+3)
FROMRAMB3:		M1L_RAM[12]					; 19 ??? (+3)


.ORG	0X0000+0XB4*128						; OR H       [ B4 ]  4 (18-24) SZHVNC
				                            ;                                0P00
EXB4:			STUFF18_CLI					; 
				OR		A,H					; 17
				MOV		RES,A				; 0
				MOVW	ZL,RES				; 1
				LD		F,Z					; 3
				STUFF18_1					; 
				STUFF18_SEI					; 
				M1H[2]						; 5
				BRCC	FROMRAMB4			; 6 /> 7
				M1L_ROM[13]					; 19 ??? (+3)
FROMRAMB4:		M1L_RAM[12]					; 19 ??? (+3)


.ORG	0X0000+0XB5*128						; OR L       [ B5 ]  4 (18-24) SZHVNC
				                            ;                                0P00
EXB5:			STUFF18_CLI					; 
				OR		A,L					; 17
				MOV		RES,A				; 0
				MOVW	ZL,RES				; 1
				LD		F,Z					; 3
				STUFF18_1					; 
				STUFF18_SEI					; 
				M1H[2]						; 5
				BRCC	FROMRAMB5			; 6 /> 7
				M1L_ROM[13]					; 19 ??? (+3)
FROMRAMB5:		M1L_RAM[12]					; 19 ??? (+3)


.ORG	0X0000+0XB7*128						; OR A       [ B7 ]  4 (18-24) SZHVNC
				                            ;                                0P00
EXB7:			STUFF18_CLI					; 
				OR		A,A					; 17
				MOV		RES,A				; 0
				MOVW	ZL,RES				; 1
				LD		F,Z					; 3
				STUFF18_1					; 
				STUFF18_SEI					; 
				M1H[2]						; 5
				BRCC	FROMRAMB7			; 6 /> 7
				M1L_ROM[13]					; 19 ??? (+3)
FROMRAMB7:		M1L_RAM[12]					; 19 ??? (+3)


.ORG	0X0000+0XB6*128						; OR (HL)    [ B6 ]  7 (32-42) SZHVNC
				                            ;                                0P00
EXB6:			CLI							; 17
				MOVW	ZL,L				; 18
				CPI		ZH,0X40				; 19
				BRCS	FROMROMB6			; 20 /> 21
				LOAD_BUF_Z[7]				; 27
COMB6:			OR		A,BUF				; 28
				MOV		RES,A				; 29
				MOVW	ZL,RES				; 30
				LD		F,Z					; 0
				STUFF32_9					; 
				M1H_INTEN[3]				; 3
				BRCC	FROMRAMB6			; 4 /> 5
				M1L_ROM[13]					; 17 ??? (+1)
FROMRAMB6:		M1L_RAM[12]					; 17 ??? (+1)
FROMROMB6:		RLOAD_BUF_Z[4]				; 25
				RJMP	COMB6				; 27


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0XB8*128						; CP B       [ B8 ]  4 (18-24) SZHVNC 3,4 FROM OPERAND
				                            ;                                  1
EXB8:			STUFF18_CLI					; 
				MOV		TMPH,A				; 17
				SUB		TMPH,B				; 0
				IN		F,SREG				; 1
				MOV		RES,B				; 2
				SBR		F,(1<<NN)			; 3
				BST		TMPH,7				; 4
				BLD		RES,7				; 5
				STUFF18_SEI					; 
				M1H[2]						; 7
				BRCC	FROMRAMB8			; 8 /> 9
				M1L_ROM_SHORT[12]			; 20 ??? (+4)
FROMRAMB8:		M1L_RAM[12]					; 21 ??? (+5)


.ORG	0X0000+0XB9*128						; CP C       [ B9 ]  4 (18-24) SZHVNC 3,4 FROM OPERAND
				                            ;                                  1
EXB9:			STUFF18_CLI					; 
				MOV		TMPH,A				; 17
				SUB		TMPH,C				; 0
				IN		F,SREG				; 1
				MOV		RES,C				; 2
				SBR		F,(1<<NN)			; 3
				BST		TMPH,7				; 4
				BLD		RES,7				; 5
				STUFF18_SEI					; 
				M1H[2]						; 7
				BRCC	FROMRAMB9			; 8 /> 9
				M1L_ROM_SHORT[12]			; 20 ??? (+4)
FROMRAMB9:		M1L_RAM[12]					; 21 ??? (+5)


.ORG	0X0000+0XBA*128						; CP D       [ BA ]  4 (18-24) SZHVNC 3,4 FROM OPERAND
				                            ;                                  1
EXBA:			STUFF18_CLI					; 
				MOV		TMPH,A				; 17
				SUB		TMPH,D				; 0
				IN		F,SREG				; 1
				MOV		RES,D				; 2
				SBR		F,(1<<NN)			; 3
				BST		TMPH,7				; 4
				BLD		RES,7				; 5
				STUFF18_SEI					; 
				M1H[2]						; 7
				BRCC	FROMRAMBA			; 8 /> 9
				M1L_ROM_SHORT[12]			; 20 ??? (+4)
FROMRAMBA:		M1L_RAM[12]					; 21 ??? (+5)


.ORG	0X0000+0XBB*128						; CP E       [ BB ]  4 (18-24) SZHVNC 3,4 FROM OPERAND
				                            ;                                  1
EXBB:			STUFF18_CLI					; 
				MOV		TMPH,A				; 17
				SUB		TMPH,E				; 0
				IN		F,SREG				; 1
				MOV		RES,E				; 2
				SBR		F,(1<<NN)			; 3
				BST		TMPH,7				; 4
				BLD		RES,7				; 5
				STUFF18_SEI					; 
				M1H[2]						; 7
				BRCC	FROMRAMBB			; 8 /> 9
				M1L_ROM_SHORT[12]			; 20 ??? (+4)
FROMRAMBB:		M1L_RAM[12]					; 21 ??? (+5)


.ORG	0X0000+0XBC*128						; CP H       [ BC ]  4 (18-24) SZHVNC 3,4 FROM OPERAND
				                            ;                                  1
EXBC:			STUFF18_CLI					; 
				MOV		TMPH,A				; 17
				SUB		TMPH,H				; 0
				IN		F,SREG				; 1
				MOV		RES,H				; 2
				SBR		F,(1<<NN)			; 3
				BST		TMPH,7				; 4
				BLD		RES,7				; 5
				STUFF18_SEI					; 
				M1H[2]						; 7
				BRCC	FROMRAMBC			; 8 /> 9
				M1L_ROM_SHORT[12]			; 20 ??? (+4)
FROMRAMBC:		M1L_RAM[12]					; 21 ??? (+5)


.ORG	0X0000+0XBD*128						; CP L       [ BD ]  4 (18-24) SZHVNC 3,4 FROM OPERAND
				                            ;                                  1
EXBD:			STUFF18_CLI					; 
				MOV		TMPH,A				; 17
				SUB		TMPH,L				; 0
				IN		F,SREG				; 1
				MOV		RES,L				; 2
				SBR		F,(1<<NN)			; 3
				BST		TMPH,7				; 4
				BLD		RES,7				; 5
				STUFF18_SEI					; 
				M1H[2]						; 7
				BRCC	FROMRAMBD			; 8 /> 9
				M1L_ROM_SHORT[12]			; 20 ??? (+4)
FROMRAMBD:		M1L_RAM[12]					; 21 ??? (+5)


.ORG	0X0000+0XBF*128						; CP A       [ BF ]  4 (18-24) SZHVNC 3,4 FROM OPERAND
				                            ;                                  1
EXBF:			STUFF18_CLI					; 
				MOV		TMPH,A				; 17
				SUB		TMPH,A				; 0
				IN		F,SREG				; 1
				MOV		RES,A				; 2
				SBR		F,(1<<NN)			; 3
				BST		TMPH,7				; 4
				BLD		RES,7				; 5
				STUFF18_SEI					; 
				M1H[2]						; 7
				BRCC	FROMRAMBF			; 8 /> 9
				M1L_ROM_SHORT[12]			; 20 ??? (+4)
FROMRAMBF:		M1L_RAM[12]					; 21 ??? (+5)


.ORG	0X0000+0XBE*128						; CP (HL)    [ BE ]  7 (32-42) SZHVNC 3,4 FROM OPERAND
				                            ;                                  1
EXBE:			CLI							; 17
				MOVW	ZL,L				; 18
				CPI		ZH,0X40				; 19
				BRCS	FROMROMBE			; 20 /> 21
				LOAD_BUF_Z[7]				; 27
COMBE:			MOV		TMPH,A				; 28
				SUB		TMPH,BUF			; 29
				IN		F,SREG				; 30
				MOV		RES,BUF				; 31
				SBR		F,(1<<NN)			; 0
				BST		TMPH,7				; 1
				BLD		RES,7				; 2
				STUFF32_7					; 
				M1H_INTEN[3]				; 5
				BRCC	FROMRAMBE			; 6 /> 7
				M1L_ROM[13]					; 19 ??? (+3)
FROMRAMBE:		M1L_RAM[12]					; 19 ??? (+3)
FROMROMBE:		RLOAD_BUF_Z[4]				; 25
				RJMP	COMBE				; 27


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0XC0*128						; RET NZ         [ C0 ] 11/5 (50/23 - 66/30) NONE

EXC0:			CLI							; 17
				SBRC	F,ZZ				; 18 /> 20
				JMP		M1-T5+21			; 21
				LOAD_PC_STP_[13]			; 33
				MOVW	MEMPTRL,PCL			; 34
				JMP		M1_-T11+37			; 37


.ORG	0X0000+0XC8*128						; RET Z         [ C8 ] 11/5 (50/23) NONE

EXC8:			CLI							; 17
				SBRS	F,ZZ				; 18 /> 20
				JMP		M1-T5+21			; 21
				LOAD_PC_STP_[13]			; 33
				MOVW	MEMPTRL,PCL			; 34
				JMP		M1_-T11+37			; 37


.ORG	0X0000+0XD0*128						; RET NC         [ D0 ] 11/5 (66/30) NONE

EXD0:			CLI							; 17
				SBRC	F,CC				; 18 /> 20
				JMP		M1-T5+21			; 21
				LOAD_PC_STP_[13]			; 33
				MOVW	MEMPTRL,PCL			; 34
				JMP		M1_-T11+37			; 37


.ORG	0X0000+0XD8*128						; RET C          [ D8 ] 11/5 (66/30) NONE

EXD8:			CLI							; 17
				SBRS	F,CC				; 18 /> 20
				JMP		M1-T5+21			; 21
				LOAD_PC_STP_[13]			; 33
				MOVW	MEMPTRL,PCL			; 34
				JMP		M1_-T11+37			; 37

.ORG	0X0000+0XE0*128						; RET PO         [ E0 ] 11/5 (66/30) NONE

EXE0:			CLI							; 17
				SBRC	F,PP				; 18 /> 20
				JMP		M1-T5+21			; 21
				LOAD_PC_STP_[13]			; 33
				MOVW	MEMPTRL,PCL			; 34
				JMP		M1_-T11+37			; 37


.ORG	0X0000+0XE8*128						; RET PE         [ E8 ] 11/5 (66/30) NONE

EXE8:			CLI							; 17
				SBRS	F,PP				; 18 /> 20
				JMP		M1-T5+21			; 21
				LOAD_PC_STP_[13]			; 33
				MOVW	MEMPTRL,PCL			; 34
				JMP		M1_-T11+37			; 37


.ORG	0X0000+0XF0*128						; RET P          [ F0 ] 11/5 (66/30) NONE

EXF0:			CLI							; 17
				SBRC	RES,7				; 18 /> 20
				JMP		M1-T5+21			; 21
				LOAD_PC_STP_[13]			; 33
				MOVW	MEMPTRL,PCL			; 34
				JMP		M1_-T11+37			; 37


.ORG	0X0000+0XF8*128						; RET M          [ F8 ] 11/5 (66/30) NONE
				
EXF8:			CLI							; 17
				SBRS	RES,7				; 18 /> 20
				JMP		M1-T5+21			; 21
				LOAD_PC_STP_[13]			; 33
				MOVW	MEMPTRL,PCL			; 34
				JMP		M1_-T11+37			; 37


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0XC9*128						; RET            [ C9 ] 10 (46-60)      NONE

EXC9:			CLI							; 17
				LOAD_PC_STP[10]				; 27
				MOVW	MEMPTRL,PCL			; 28
				JMP		M1-T10+31			; 31


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0XC1*128						; POP BC         [ C1 ]  10 (46-60) NONE

EXC1:			CLI							; 17
				BRCS	WRKROMC1			; 18 /> 19
				LOAD_BC_STP_[13]			; 31
				JMP		M1_-T10+34			; 34
WRKROMC1:		LOAD_BC_STP[10]				; 29
				JMP		M1-T10+32			; 32


.ORG	0X0000+0XD1*128						; POP DE         [ D1 ] 10 (46-60) NONE

EXD1:			CLI							; 17
				BRCS	WRKROMD1			; 18 /> 19
				LOAD_DE_STP_[13]			; 31
				JMP		M1_-T10+34			; 34
WRKROMD1:		LOAD_DE_STP[10]				; 29
				JMP		M1-T10+32			; 32


.ORG	0X0000+0XE1*128						; POP HL         [ E1 ]  10   (46-60) NONE

EXE1:			CLI							; 17
				BRCS	WRKROME1			; 18 /> 19
				LOAD_HL_STP_[13]			; 31
				JMP		M1_-T10+34			; 34
WRKROME1:		LOAD_HL_STP[10]				; 29
				JMP		M1-T10+32			; 32


.ORG	0X0000+0XF1*128						; POP AF         [ F1 ]  10   (46-60) NONE

EXF1:			CLI							; 17
				BRCS	WRKROMF1			; 18 /> 19
				LOAD_AF_STP_[13]			; 31
				MOV		RES,F				; 32
				LSL		F					; 33
				BST		F,1					; 34
				BLD		F,0					; 35
				BST		F,7					; 36
				BLD		F,1					; 37
				CBR		F,1<<II				; 38
				JMP		M1_-T10+41			; 41
WRKROMF1:		LOAD_AF_STP[10]				; 29
				MOV		RES,F				; 30
				LSL		F					; 31
				BST		F,1					; 32
				BLD		F,0					; 33
				BST		F,7					; 34
				BLD		F,1					; 35
				CBR		F,1<<II				; 36
				JMP		M1-T10+39			; 39


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0XC2*128						; JP NZ,(NN)     [ C2 ]  10   (46-60) NONE

EXC2:			CLI							; 17
				SBRC	F,ZZ				; 18 / 19
				RJMP	NJPC2				; 20
				BRCS	FROMROMC2			; 20 /> 21
				LOAD_PC_Z[11]				; 31
				JMP		M1-T10+34			; 34
FROMROMC2:		RLOAD_PC[8]					; 29
				JMP		M1-T10+32			; 32
NJPC2:			ADIW	PCL,0X02			; 22
				JMP		M1-T10+25 			; 25


.ORG	0X0000+0XCA*128						; JP Z,(NN)     [ CA ]  10   (46-60) NONE

EXCA:			CLI							; 17
				SBRS	F,ZZ				; 18 / 19
				RJMP	NJPCA				; 20
				BRCS	FROMROMCA			; 20 /> 21
				LOAD_PC_Z[11]				; 31
				JMP		M1-T10+34			; 34
FROMROMCA:		RLOAD_PC[8]					; 29
				JMP		M1-T10+32			; 32
NJPCA:			ADIW	PCL,0X02			; 22
				JMP		M1-T10+25 			; 25


.ORG	0X0000+0XD2*128						; JP NC,(NN)     [ D2 ] 10 (46-60) NONE

EXD2:			CLI							; 17
				SBRC	F,CC				; 18 / 19
				RJMP	NJPD2				; 20
				BRCS	FROMROMD2			; 20 /> 21
				LOAD_PC_Z[11]				; 31
				JMP		M1-T10+34			; 34
FROMROMD2:		RLOAD_PC[8]					; 29
				JMP		M1-T10+32			; 32
NJPD2:			ADIW	PCL,0X02			; 22
				JMP		M1-T10+25 			; 25


.ORG	0X0000+0XDA*128						; JP C,(NN)      [ DA ] 10 (46-60)      NONE

EXDA:			CLI							; 17
				SBRS	F,CC				; 18 / 19
				RJMP	NJPDA				; 20
				BRCS	FROMROMDA			; 20 /> 21
				LOAD_PC_Z[11]				; 31
				JMP		M1-T10+34			; 34
FROMROMDA:		RLOAD_PC[8]					; 29
				JMP		M1-T10+32			; 32
NJPDA:			ADIW	PCL,0X02			; 22
				JMP		M1-T10+25 			; 25


.ORG	0X0000+0XE2*128						; JP PO,(NN)     [ E2 ]  10   (46-60) NONE
		
EXE2:			CLI							; 17
				SBRC	F,PP				; 18 / 19
				RJMP	NJPE2				; 20
				BRCS	FROMROME2			; 20 /> 21
				LOAD_PC_Z[11]				; 31
				JMP		M1-T10+34			; 34
FROMROME2:		RLOAD_PC[8]					; 29
				JMP		M1-T10+32			; 32
NJPE2:			ADIW	PCL,0X02			; 22
				JMP		M1-T10+25 			; 25
				
								
.ORG	0X0000+0XEA*128						; JP PE,(NN)     [ EA ] 10 (46-60)      NONE

EXEA:			CLI							; 17
				SBRS	F,PP				; 18 / 19
				RJMP	NJPEA				; 20
				BRCS	FROMROMEA			; 20 /> 21
				LOAD_PC_Z[11]				; 31
				JMP		M1-T10+34			; 34
FROMROMEA:		RLOAD_PC[8]					; 29
				JMP		M1-T10+32			; 32
NJPEA:			ADIW	PCL,0X02			; 22
				JMP		M1-T10+25 			; 25


.ORG	0X0000+0XF2*128						; JP P,(NN)      [ F2 ]  10   (46-60) NONE			
				
EXF2:			CLI							; 17
				SBRC	RES,7				; 18 / 19
				RJMP	NJPF2				; 20
				BRCS	FROMROMF2			; 20 /> 21
				LOAD_PC_Z[11]				; 31
				JMP		M1-T10+34			; 34
FROMROMF2:		RLOAD_PC[8]					; 29
				JMP		M1-T10+32			; 32
NJPF2:			ADIW	PCL,0X02			; 22
				JMP		M1-T10+25 			; 25


.ORG	0X0000+0XFA*128						; JP M,(NN)      [ FA ] 10 (46-60)      NONE

EXFA:			CLI							; 17
				SBRS	RES,7				; 18 / 19
				RJMP	NJPFA				; 20
				BRCS	FROMROMFA			; 20 /> 21
				LOAD_PC_Z[11]				; 31
				JMP		M1-T10+34			; 34
FROMROMFA:		RLOAD_PC[8]					; 29
				JMP		M1-T10+32			; 32
NJPFA:			ADIW	PCL,0X02			; 22
				JMP		M1-T10+25 			; 25


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0XC3*128						; JP (NN)        [ C3 ]  10   (46-60) NONE

EXC3:			CLI							; 17
				BRCS	FROMROMC3			; 18 /> 19
				LOAD_PC_Z[11]				; 29
				JMP		M1-T10+32			; 32
FROMROMC3:		RLOAD_PC[8]					; 27
				JMP		M1-T10+30			; 30


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0XC4*128						; CALL NZ,(NN)   [ C4 ]  17/10 (78/46 - 102/60) NONE

EXC4:			CLI							; 17
				SBRC	F,ZZ				; 18 /> 19
				RJMP	NCALLC4				; 20
				BRCS	FROMROMC4			; 20 /> 21
				MOVW	ZL,PCL				; 21
				ADIW	PCL,0X02			; 23
				XON_RBBCP					; 25
				ST		-Y,PCH				; 28
				ST		-Y,PCL				; 31
				LD		XL,Z+				; 34
				LD		XH,Z				; 37
				XOFF_RBBCP					; 39
				MOVW	MEMPTRL,PCL			; 40
				JMP		M1-T17+43			; 43
FROMROMC4:		MOVW	ZL,PCL				; 22
				ADIW	PCL,0X02			; 24
				SAVE_PC_SP[10]				; 34
				OR		ZH,ROMID			; 35
				ELPM		PCL,Z+			; 38
				ELPM		PCH,Z			; 41
				MOVW	MEMPTRL,PCL			; 42
				JMP		M1-T17+45			; 45
NCALLC4:		ADIW	PCL,0X02			; 22
				JMP		M1-T10+25			; 25


.ORG	0X0000+0XCC*128						; CALL Z,(NN)   [ CC ]  17/10 (78/46 - 102/60) NONE

EXCC:			CLI							; 17
				SBRS	F,ZZ				; 18 /> 19
				RJMP	NCALLCC				; 20
				BRCS	FROMROMCC			; 20 /> 21
				MOVW	ZL,PCL				; 21
				ADIW	PCL,0X02			; 23
				XON_RBBCP					; 25
				ST		-Y,PCH				; 28
				ST		-Y,PCL				; 31
				LD		XL,Z+				; 34
				LD		XH,Z				; 37
				XOFF_RBBCP					; 39
				MOVW	MEMPTRL,PCL			; 40
				JMP		M1-T17+43			; 43
FROMROMCC:		MOVW	ZL,PCL				; 22
				ADIW	PCL,0X02			; 24
				SAVE_PC_SP[10]				; 34
				OR		ZH,ROMID			; 35
				ELPM		PCL,Z+			; 38
				ELPM		PCH,Z			; 41
				MOVW	MEMPTRL,PCL			; 42
				JMP		M1-T17+45			; 45
NCALLCC:		ADIW	PCL,0X02			; 22
				JMP		M1-T10+25			; 25


.ORG	0X0000+0XD4*128						; CALL NC,(NN)   [ D4 ]  17/10 (78/46 - 102/60) NONE

EXD4:			CLI							; 17
				SBRC	F,CC				; 18 /> 19
				RJMP	NCALLD4				; 20
				BRCS	FROMROMD4			; 20 /> 21
				MOVW	ZL,PCL				; 21
				ADIW	PCL,0X02			; 23
				XON_RBBCP					; 25
				ST		-Y,PCH				; 28
				ST		-Y,PCL				; 31
				LD		XL,Z+				; 34
				LD		XH,Z				; 37
				XOFF_RBBCP					; 39
				MOVW	MEMPTRL,PCL			; 40
				JMP		M1-T17+43			; 43
FROMROMD4:		MOVW	ZL,PCL				; 22
				ADIW	PCL,0X02			; 24
				SAVE_PC_SP[10]				; 34
				OR		ZH,ROMID			; 35
				ELPM		PCL,Z+			; 38
				ELPM		PCH,Z			; 41
				MOVW	MEMPTRL,PCL			; 42
				JMP		M1-T17+45			; 45
NCALLD4:		ADIW	PCL,0X02			; 22
				JMP		M1-T10+25			; 25


.ORG	0X0000+0XDC*128						; CALL C,(NN)    [ DC ]  17/10 (78/46 - 102/60) NONE

EXDC:			CLI							; 17
				SBRS	F,CC				; 18 /> 19
				RJMP	NCALLDC				; 20
				BRCS	FROMROMDC			; 20 /> 21
				MOVW	ZL,PCL				; 21
				ADIW	PCL,0X02			; 23
				XON_RBBCP					; 25
				ST		-Y,PCH				; 28
				ST		-Y,PCL				; 31
				LD		XL,Z+				; 34
				LD		XH,Z				; 37
				XOFF_RBBCP					; 39
				MOVW	MEMPTRL,PCL			; 40
				JMP		M1-T17+43			; 43
FROMROMDC:		MOVW	ZL,PCL				; 22
				ADIW	PCL,0X02			; 24
				SAVE_PC_SP[10]				; 34
				OR		ZH,ROMID			; 35
				ELPM		PCL,Z+			; 38
				ELPM		PCH,Z			; 41
				MOVW	MEMPTRL,PCL			; 42
				JMP		M1-T17+45			; 45
NCALLDC:		ADIW	PCL,0X02			; 22
				JMP		M1-T10+25			; 25


.ORG	0X0000+0XE4*128						; CALL PO,(NN)   [ E4 ]  17/10 (78/46 - 102/60) NONE

EXE4:			CLI							; 17
				SBRC	F,PP				; 18 /> 19
				RJMP	NCALLE4				; 20
				BRCS	FROMROME4			; 20 /> 21
				MOVW	ZL,PCL				; 21
				ADIW	PCL,0X02			; 23
				XON_RBBCP					; 25
				ST		-Y,PCH				; 28
				ST		-Y,PCL				; 31
				LD		XL,Z+				; 34
				LD		XH,Z				; 37
				XOFF_RBBCP					; 39
				MOVW	MEMPTRL,PCL			; 40
				JMP		M1-T17+43			; 43
FROMROME4:		MOVW	ZL,PCL				; 22
				ADIW	PCL,0X02			; 24
				SAVE_PC_SP[10]				; 34
				OR		ZH,ROMID			; 35
				ELPM		PCL,Z+			; 38
				ELPM		PCH,Z			; 41
				MOVW	MEMPTRL,PCL			; 42
				JMP		M1-T17+45			; 45
NCALLE4:		ADIW	PCL,0X02			; 22
				JMP		M1-T10+25			; 25
				
						
.ORG	0X0000+0XEC*128						; CALL PE,(NN)   [ EC ]  17/10 (78/46 - 102/60) NONE

EXEC:			CLI							; 17
				SBRS	F,PP				; 18 /> 19
				RJMP	NCALLEC				; 20
				BRCS	FROMROMEC			; 20 /> 21
				MOVW	ZL,PCL				; 21
				ADIW	PCL,0X02			; 23
				XON_RBBCP					; 25
				ST		-Y,PCH				; 28
				ST		-Y,PCL				; 31
				LD		XL,Z+				; 34
				LD		XH,Z				; 37
				XOFF_RBBCP					; 39
				MOVW	MEMPTRL,PCL			; 40
				JMP		M1-T17+43			; 43
FROMROMEC:		MOVW	ZL,PCL				; 22
				ADIW	PCL,0X02			; 24
				SAVE_PC_SP[10]				; 34
				OR		ZH,ROMID			; 35
				ELPM		PCL,Z+			; 38
				ELPM		PCH,Z			; 41
				MOVW	MEMPTRL,PCL			; 42
				JMP		M1-T17+45			; 45
NCALLEC:		ADIW	PCL,0X02			; 22
				JMP		M1-T10+25			; 25


.ORG	0X0000+0XF4*128						; CALL P,(NN)    [ F4 ]  17/10 (78/46 - 102/60) NONE

EXF4:			CLI							; 17
				SBRC	RES,7				; 18 /> 19
				RJMP	NCALLF4				; 20
				BRCS	FROMROMF4			; 20 /> 21
				MOVW	ZL,PCL				; 21
				ADIW	PCL,0X02			; 23
				XON_RBBCP					; 25
				ST		-Y,PCH				; 28
				ST		-Y,PCL				; 31
				LD		XL,Z+				; 34
				LD		XH,Z				; 37
				XOFF_RBBCP					; 39
				MOVW	MEMPTRL,PCL			; 40
				JMP		M1-T17+43			; 43
FROMROMF4:		MOVW	ZL,PCL				; 22
				ADIW	PCL,0X02			; 24
				SAVE_PC_SP[10]				; 34
				OR		ZH,ROMID			; 35
				ELPM		PCL,Z+			; 38
				ELPM		PCH,Z			; 41
				MOVW	MEMPTRL,PCL			; 42
				JMP		M1-T17+45			; 45
NCALLF4:		ADIW	PCL,0X02			; 22
				JMP		M1-T10+25			; 25


.ORG	0X0000+0XFC*128						; CALL M,(NN)    [ FC ]  17/10 (78/46 - 102/60) NONE				
				
								
EXFC:			CLI							; 17
				SBRS	RES,7				; 18 /> 19
				RJMP	NCALLFC				; 20
				BRCS	FROMROMFC			; 20 /> 21
				MOVW	ZL,PCL				; 21
				ADIW	PCL,0X02			; 23
				XON_RBBCP					; 25
				ST		-Y,PCH				; 28
				ST		-Y,PCL				; 31
				LD		XL,Z+				; 34
				LD		XH,Z				; 37
				XOFF_RBBCP					; 39
				MOVW	MEMPTRL,PCL			; 40
				JMP		M1-T17+43			; 43
FROMROMFC:		MOVW	ZL,PCL				; 22
				ADIW	PCL,0X02			; 24
				SAVE_PC_SP[10]				; 34
				OR		ZH,ROMID			; 35
				ELPM		PCL,Z+			; 38
				ELPM		PCH,Z			; 41
				MOVW	MEMPTRL,PCL			; 42
				JMP		M1-T17+45			; 45
NCALLFC:		ADIW	PCL,0X02			; 22
				JMP		M1-T10+25			; 25


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0XCD*128						; CALL (NN)      [ CD ]  17 (78) NONE
		
EXCD:			CLI							; 17
				BRCS	FROMROMCD			; 18 /> 19
				MOVW	ZL,PCL				; 19
				ADIW	PCL,0X02			; 21
				XON_RBBCP					; 23
				ST		-Y,PCH				; 26
				ST		-Y,PCL				; 29
				LD		XL,Z+				; 32
				LD		XH,Z				; 35
				XOFF_RBBCP					; 37
				MOVW	MEMPTRL,PCL			; 39
				JMP		M1-T17+41			; 41
FROMROMCD:		MOVW	ZL,PCL				; 20
				ADIW	PCL,0X02			; 22
				SAVE_PC_SP[10]				; 32
				OR		ZH,ROMID			; 33
				ELPM		PCL,Z+			; 36
				ELPM		PCH,Z			; 39
				MOVW	MEMPTRL,PCL			; 40
				JMP		M1-T17+43			; 43


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0XC5*128						; PUSH BC        [ C5 ]  11   (50-66) NONE

EXC5:			CLI							; 17
				BRCS	WRKROMC5			; 18 /> 19
				SAVE_BC_SP_[13]				; 31
				JMP		M1_-T11+34			; 34
WRKROMC5:		SAVE_BC_SP[10]				; 29
				JMP		M1-T11+32			; 32


.ORG	0X0000+0XD5*128						; PUSH DE        [ D5 ]  11   (50-66) NONE

EXD5:			CLI							; 17
				BRCS	WRKROMD5			; 18 /> 19
				SAVE_DE_SP_[13]				; 31
				JMP		M1_-T11+34			; 34
WRKROMD5:		SAVE_DE_SP[10]				; 29
				JMP		M1-T11+32			; 32


.ORG	0X0000+0XE5*128						; PUSH HL        [ E5 ]  11   (50-66) NONE

EXE5:			CLI							; 17
				BRCS	WRKROME5			; 18 /> 19
				SAVE_HL_SP_[13]				; 31
				JMP		M1_-T11+34			; 34
WRKROME5:		SAVE_HL_SP[10]				; 29
				JMP		M1-T11+32			; 32


.ORG	0X0000+0XF5*128						; PUSH AF        [ F5 ]  11   (50-66) NONE

EXF5:			CLI							; 17	
				MOVW	ZL,A				; 18
				BST		ZH,1				; 19
				BLD		ZH,7				; 20
				BST		ZH,0				; 21
				BLD		ZH,1				; 22
				LSR		ZH					; 23
				CBR		ZH,(1<<7)|(1<<5)|(1<<3); 24
				MOV		BUF,RES				; 25
				ANDI	BUF,(1<<7)|(1<<5)|(1<<3); 26
				OR		ZH,BUF				; 27
				MOV		BUF,ZH				; 28
				MOV		ZH,ZL				; 29
				MOV		ZL,BUF				; 30
				CPI		PCH,0X40			; 31
				BRCS	WRKROMF5			; 32 /> 33
				SAVE_Z_SP_[13]				; 45
				JMP		M1_-T11+48			; 48
WRKROMF5:		SAVE_Z_SP[10]				; 43
				JMP		M1-T11+46			; 46


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0XC6*128						; ADD A,N        [ C6 ]   7   (32-42) SZHVNC
											;                                         0
EXC6:			CLI							; 17
				BRCS	FROMROMC6			; 18 /> 19
				LOAD_TMPL_PC_[10]			; 28
				OUT		SREG,F				; 29
				ADD		A,TMPL				; 30
				CLN							; 31
				IN		F,SREG				; 0
				MOV		RES,A				; 1
				STUFF32_10					; 
				M1H_INTEN[3]				; 4
				M1L_RAM_[12]				; 16
FROMROMC6:		RLOAD_TMPL[7]				; 26
				OUT		SREG,F				; 27
				ADD		A,TMPL				; 28
				CLN							; 29
				IN		F,SREG				; 30
				MOV		RES,A				; 31
				DELAY2						; 1
				M1H_INTEN[3]				; 4
				M1L_ROM[12]					; 16



.ORG	0X0000+0XCE*128						; ADC A,N        [ CE ] 7 (32-42) SZHVNC
				                            ;                                      
EXCE:			CLI							; 17
				BRCS	FROMROMCE			; 18 /> 19
				LOAD_TMPL_PC_[10]			; 28
				OUT		SREG,F				; 29
				ADC		A,TMPL				; 30
				CLN							; 31
				IN		F,SREG				; 0
				MOV		RES,A				; 1
				STUFF32_10					; 
				M1H_INTEN[3]				; 4
				M1L_RAM_[12]				; 16
FROMROMCE:		RLOAD_TMPL[7]				; 26
				OUT		SREG,F				; 27
				ADC		A,TMPL				; 28
				CLN							; 29
				IN		F,SREG				; 30
				MOV		RES,A				; 31
				DELAY2						; 1
				M1H_INTEN[3]				; 4
				M1L_ROM[12]					; 16


.ORG	0X0000+0XD6*128						; SUB N          [ D6 ]   7   (32-42) SZHVNC
											;                                         1
EXD6:			CLI							; 17
				BRCS	FROMROMD6			; 18 /> 19
				LOAD_TMPL_PC_[10]			; 28
				OUT		SREG,F				; 29
				SUB		A,TMPL				; 30
				SEN							; 31
				IN		F,SREG				; 0
				MOV		RES,A				; 1
				STUFF32_10					; 
				M1H_INTEN[3]				; 4
				M1L_RAM_[12]				; 16
FROMROMD6:		RLOAD_TMPL[7]				; 26
				OUT		SREG,F				; 27
				SUB		A,TMPL				; 28
				SEN							; 29
				IN		F,SREG				; 30
				MOV		RES,A				; 31
				DELAY2						; 1
				M1H_INTEN[3]				; 4
				M1L_ROM[12]					; 16


.ORG	0X0000+0XDE*128						; SBC A,N       [ DE ]  7 (32-42) SZHVNC
											;                                     1
EXDE:			CLI							; 17
				BRCS	FROMROMDE			; 18 /> 19
				LOAD_TMPL_PC_[10]			; 28
				OUT		SREG,F				; 29
				SEZ							; 30
				SBC		A,TMPL				; 31
				SEN							; 0
				IN		F,SREG				; 1
				MOV		RES,A				; 2
				STUFF32_9					; 
				M1H_INTEN[3]				; 5
				M1L_RAM_[12]				; 17 ??? (+1)
FROMROMDE:		RLOAD_TMPL[7]				; 26
				OUT		SREG,F				; 27
				SEZ							; 28
				SBC		A,TMPL				; 29
				SEN							; 30
				IN		F,SREG				; 31
				MOV		RES,A				; 0
				DELAY1						; 1
				M1H_INTEN[3]				; 4
				M1L_ROM[12]					; 16


.ORG	0X0000+0XE6*128						; AND N          [ E6 ]   7   (32-42) SZHVNC
											;                                       1P00
EXE6:			CLI							; 17
				BRCS	FROMROME6			; 18 /> 19
				LOAD_TMPL_PC_[10]			; 28
				OUT		SREG,F				; 29
				AND		A,TMPL				; 30
				MOV		RES,A				; 31
				MOV		ZL,RES				; 0
				LDI		ZH,0X03				; 1
				LD		F,Z					; 3
				STUFF32_8					; 
				M1H_INTEN[3]				; 6
				M1L_RAM_[12]				; 18 ??? (+2)
FROMROME6:		RLOAD_TMPL[7]				; 26
				OUT		SREG,F				; 27
				AND		A,TMPL				; 28
				MOV		RES,A				; 29
				MOV		ZL,RES				; 30
				LDI		ZH,0X03				; 31
				LD		F,Z					; 1
				M1H_INTEN[3]				; 5
				M1L_ROM[12]					; 16


.ORG	0X0000+0XEE*128						; XOR N          [ EE ] 7 (32-42) SZHVNC
				                            ;                                   0P00
EXEE:			CLI							; 17
				BRCS	FROMROMEE			; 18 /> 19
				LOAD_TMPL_PC_[10]			; 28
				EOR		A,TMPL				; 29
				MOV		RES,A				; 30
				MOVW	ZL,RES				; 31
				LD		F,Z					; 1
				STUFF32_10					; 
				M1H_INTEN[3]				; 4
				M1L_RAM_[12]				; 16
FROMROMEE:		RLOAD_TMPL[7]				; 26
				EOR		A,TMPL				; 27
				MOV		RES,A				; 28
				MOVW	ZL,RES				; 29
				LD		F,Z					; 31
				DELAY2						; 1
				M1H_INTEN[3]				; 4
				M1L_ROM[12]					; 16


.ORG	0X0000+0XF6*128						; OR N           [ F6 ]   7   (32-42) SZHVNC
											;                                       0P00
EXF6:			CLI							; 17
				BRCS	FROMROMF6			; 18 /> 19
				LOAD_TMPL_PC_[10]			; 28
				OR		A,TMPL				; 29
				MOV		RES,A				; 30
				MOVW	ZL,RES				; 31
				LD		F,Z					; 1
				STUFF32_10					; 
				M1H_INTEN[3]				; 4
				M1L_RAM_[12]				; 16
FROMROMF6:		RLOAD_TMPL[7]				; 26
				OR		A,TMPL				; 27
				MOV		RES,A				; 28
				MOVW	ZL,RES				; 29
				LD		F,Z					; 31
				DELAY2						; 1
				M1H_INTEN[3]				; 4
				M1L_ROM[12]					; 16


.ORG	0X0000+0XFE*128						; CP N           [ FE ] 7 (32-42) SZHVNC 3,4 FROM OPERAND
				                            ;                                     1
EXFE:			CLI							; 17
				BRCS	FROMROMFE			; 18 /> 19
				LOAD_RES_PC_[10]			; 28
				MOV		TMPH,A				; 29
				SUB		TMPH,RES			; 30
				IN		F,SREG				; 31
				SBR		F,(1<<NN)			; 0
				BST		TMPH,7				; 1
				BLD		RES,7				; 2
				STUFF32_9					; 
				M1H_INTEN[3]				; 5
				M1L_RAM_[12]				; 17 ??? (+1)
FROMROMFE:		RLOAD_RES[7]				; 26
				MOV		TMPH,A				; 27
				SUB		TMPH,RES			; 28
				IN		F,SREG				; 29
				SBR		F,(1<<NN)			; 30
				BST		TMPH,7				; 31
				BLD		RES,7				; 0
				DELAY1						; 1
				M1H_INTEN[3]				; 4
				M1L_ROM[12]					; 16


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0XC7*128						; RST 0H         [ C7 ] 11   (50-66)    NONE
			
EXC7:			CLI							; 17
				SAVE_PC_SP[10]				; 27
				LDI		PCH,0X00			; 28
				LDI		PCL,0X00			; 29
				MOVW	MEMPTRL,PCL			; 30
				JMP		M1-T11+33			; 33


.ORG	0X0000+0XCF*128						; RST 8H         [ CF ] 11   (50-66)    NONE

EXCF:			CLI							; 17
				SAVE_PC_SP[10]				; 27
				LDI		PCH,0X00			; 28
				LDI		PCL,0X08			; 29
				MOVW	MEMPTRL,PCL			; 30
				JMP		M1-T11+33			; 33


.ORG	0X0000+0XD7*128						; RST 10H        [ D7 ] 11   (50-66)    NONE

EXD7:			CLI							; 17
				SAVE_PC_SP[10]				; 27
				LDI		PCH,0X00			; 28
				LDI		PCL,0X10			; 29
				MOVW	MEMPTRL,PCL			; 30
				JMP		M1-T11+33			; 33


.ORG	0X0000+0XDF*128						; RST 18H        [ DF ] 11   (50-66)    NONE

EXDF:			CLI							; 17
				SAVE_PC_SP[10]				; 27
				LDI		PCH,0X00			; 28
				LDI		PCL,0X18			; 29
				MOVW	MEMPTRL,PCL			; 30
				JMP		M1-T11+33			; 33


.ORG	0X0000+0XE7*128						; RST 20H        [ E7 ]  11   (50-66)   NONE

EXE7:			CLI							; 17
				SAVE_PC_SP[10]				; 27
				LDI		PCH,0X00			; 28
				LDI		PCL,0X20			; 29
				MOVW	MEMPTRL,PCL			; 30
				JMP		M1-T11+33			; 33


.ORG	0X0000+0XEF*128						; RST 28H        [ EF ] 11   (50-66)    NONE

EXEF:			CLI							; 17
				SAVE_PC_SP[10]				; 27
				LDI		PCH,0X00			; 28
				LDI		PCL,0X28			; 29
				MOVW	MEMPTRL,PCL			; 30
				JMP		M1-T11+33			; 33


.ORG	0X0000+0XF7*128						; RST 30H        [ F7 ] 11   (50-66)    NONE

EXF7:			CLI							; 17
				SAVE_PC_SP[10]				; 27
				LDI		PCH,0X00			; 28
				LDI		PCL,0X30			; 29
				MOVW	MEMPTRL,PCL			; 30
				JMP		M1-T11+33			; 33


.ORG	0X0000+0XFF*128						; RST 38H        [ FF ] 11   (50-66)    NONE

EXFF:			CLI							; 17
				SAVE_PC_SP[10]				; 27
				LDI		PCH,0X00			; 28
				LDI		PCL,0X38			; 29
				MOVW	MEMPTRL,PCL			; 30
				JMP		M1-T11+33			; 33


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0XD3*128						; OUT (N),A      [ D3 ] 11 (50-66) NONE
EXD3:			CLI							; 17
				BRCS	FROMROMD3			; 18 /> 19
				LOAD_MEMPTRL_PC[7]			; 25
				LDI		ZH,0XFF				; 26
				MOV		ZL,MEMPTRL			; 27
				MOV		MEMPTRH,A			; 28
				ADD		MEMPTRL,ONE			; 29
				CBR		ZL,0XF0				; 30
				MOV		BUF,A				; 31
				CBR		BUF,0X0F			; 32
				OR		ZL,BUF				; 33
				MOV		TMPH,A				; 34
				IJMP						; 36

FROMROMD3:		RLOAD_MEMPTRL[7]			; 26
COMD3:			LDI		ZH,0XFF				; 27
				MOV		ZL,MEMPTRL			; 28
				MOV		MEMPTRH,A			; 29
				ADD		MEMPTRL,ONE			; 30
				CBR		ZL,0XF0				; 31
				MOV		BUF,A				; 32
				CBR		BUF,0X0F			; 33
				OR		ZL,BUF				; 34
				MOV		TMPH,A				; 35
				IJMP						; 37


.ORG	0X0000+0XD9*128						; EXX            [ D9 ]  4 (18-24)      NONE

EXD9:			MOVW	ZL,_C				; 17
				MOVW	_C,C				; 0
				MOVW	C,ZL				; 1
				IN		ZL,_E				; 2
				IN		ZH,_D				; 3
				OUT		_E,E				; 4
				OUT		_D,D				; 5
				MOVW	E,ZL				; 6
				IN		ZL,_L				; 7
				IN		ZH,_H				; 8
				OUT		_L,L				; 9
				OUT		_H,H				; 10
				MOVW	L,ZL				; 11
				M1H[2]						; 13
				BRCC	FROMRAMD9			; 14 /> 15
				M1L_ROM_SHORT[12]			; 26 ??? (+10)
FROMRAMD9:		M1L_RAM[12]					; 27 ??? (+11)


.ORG	0X0000+0XDB*128						; IN A,(N)       [ DB ] 11 (50-66) NONE
EXDB:			CLI							; 17
				BRCS	FROMROMDB_			; 18 /> 19
				XON_RBBCP					; 20
				LD		BUF,X+				; 23
				XOFF						; 25
				RJMP	COMDB				; 27
FROMROMDB_:		RLOAD_BUF[7]				; 26
				NOP							; 27
COMDB:			IN		BUFH,PORTC			; 28
				OUT		PORTE,ZERO			; 29
				STS		PORTF,ZERO			; 31				2
				LDI		TMPH,0XFF			; 32				3
				OUT		PORTC,A				; 33				4
				OUT		DDRC,TMPH			; 34				5
				STS		DDRF,ZERO			; 36				7
				LDI		TMPH,(1<<A15_CPU)|(1<<A14_CPU); 		37		8
				OUT		PORTC,BUFH			; 38				9
				OUT		DDRC,TMPH			; 39				10
				OUT		PORTE,CONST128		; 40				11
				NOP							; 41				12				
				MOV		ZH,A				; 42				13
				MOV		ZL,BUF				; 43				14
				ADIW	ZL,0X01				; 45				16
				MOV		MEMPTRH,ZH			; 46				17
				IN		TMPL,ADCH			; 47				18
				BST		TMPL,7				; 48				19
				MOV		TMPL,F				; 49				20
				AND		TMPL,ONE			; 50				21
				LDI		A,0XFF				; 51				22
				SBRS	BUF,0				; 52				23
				IN		A,PINF				; 53				24
				SBR		A,(1<<7)|(1<<FROMTAPE)|(1<<5); 54
				BLD		A,FROMTAPE			; 55
				SBIC	PINB,BEEP			; 56
				SBR		A,1<<FROMTAPE		; 57
				LDI		TMPH,(1<<7)|(1<<5)|(1<<KEYMH); 58
				STS		PORTF,TMPH			; 60
				STS		DDRF,TMPH			; 62
				MOV		MEMPTRL,ZL			; 63
				JMP		DONEM1				; 66


.ORG	0X0000+0XE0*128+0X2D
				JMP		_INT				; JUMP TO INTERRUPT ROUTINE        10


.ORG	0X0000+0XE3*128						; EX (SP),HL      [ E3 ]  19   (87-114) NONE

EXE3:			CLI							; 17
				MOVW	ZL,L				; 18
				CPI		XH,0X40
				BRCS	WRKROME3			; 19 /> 20
				XON_RBBCP					; 21
				LD		L,Y+				; 24
				LD		H,Y+				; 27
				ST		-Y,ZH				; 30
				ST		-Y,ZL				; 33
				LD		BUF,X				; 36
				XOFF_RBBCP					; 38
				MOVW	MEMPTRL,L			; 39
				OUT		RAMPZ,ONE			; 40
				JMP		M1_-T19+43			; 43	
WRKROME3:		XON_RBBCP					; 22
				LD		L,Y+				; 25
				LD		H,Y+				; 28
				ST		-Y,ZH				; 31
				ST		-Y,ZL				; 34
				XOFF_RBBCP					; 36
				MOVW	MEMPTRL,L			; 37
				OUT		RAMPZ,ONE			; 48
				JMP		M1-T19+41			; 41


.ORG	0X0000+0XE9*128						; JP (HL)        [ E9 ]  4 (18-24)      NONE //

EXE9:			STUFF18_CLI					;
				MOVW	PCL,L				; 17
				DELAY1						; 0
				STUFF18_4					; 
				STUFF18_SEI					; 
				M1H[2]						; 2
				BRCC	FROMRAME9			; 3 /> 4
				M1L_ROM[13]					; 16
FROMRAME9:		M1L_RAM[12]					; 16


.ORG	0X0000+0XEB*128						; EX DE,HL       [ EB ]  4 (18-24)  NONE

EXEB:			STUFF18_CLI					;
				MOVW	ZL,L				; 17
				MOVW	L,E					; 0
				MOVW	E,ZL				; 1
				STUFF18_3					; 
				STUFF18_SEI					; 
				M1H[2]						; 3
				BRCC	FROMRAMEB			; 4 /> 5
				M1L_ROM[13]					; 17 ??? (+1)
FROMRAMEB:		M1L_RAM[12]					; 17 ??? (+1)


.ORG	0X0000+0XF3*128						; DI             [ F3 ]    4   (18-24) NONE

				
EXF3:			STUFF18_CLI					;
				OUT		ACSR,ZERO			; 17
				SBI		ACSR,ACI			; 0
				IN		BUF,CONTROL			; 1
				CBR		BUF,(1<<IFF2)|(1<<IFF1); 2
				OUT		CONTROL,BUF			; 3
				STUFF18_1					; 
				STUFF18_SEI					; 
				M1H[2]						; 5
				BRCC	FROMRAMF3			; 6 /> 7
				M1L_ROM[13]					; 19 ??? (+3)
FROMRAMF3:		M1L_RAM[12]					; 19 ??? (+3)


.ORG	0X0000+0XF9*128						; LD SP,HL       [ F9 ]  6 (27-36)      NONE

EXF9:			CLI							; 17
				MOVW	STPL,L				; 18
				JMP		M1-T6+21			; 21


.ORG	0X0000+0XFB*128						; EI             [ FB ]   4   (18-24) NONE
			
EXFB:			STUFF18_CLI					;
				LDI		BUF,(1<<ACBG)|(1<<ACIS0)|(1<<ACIE)|(1<<ACIS1)|(1<<ACI);17
				OUT		ACSR,BUF			; 0
				IN		BUF,CONTROL			; 1
				SBR		BUF,(1<<IFF2)|(1<<IFF1); 2
				OUT		CONTROL,BUF			; 3
				STUFF18_1					; 
				STUFF18_SEI					; 
				M1H_INTFREE[2]				; 5
				BRCC	FROMRAMFB			; 6 /> 7
				M1L_ROM[13]					; 19 ??? (+3)
FROMRAMFB:		M1L_RAM[12]					; 19 ??? (+3)


;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&  P R E F I X E S ! ! !  &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
;&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


.ORG	0X0000+0XCB*128						; PREFIX CB      [ CB ] NONE

EXCB:			CLI							; 17
				INC		R					; 18
				BRCC	FROMRAMCB			; 19 /> 20
				MOVW	ZL,PCL				; 20 
				OR		ZH,ROMID			; 21 
				ELPM	ZH,Z				; 24 
				ADIW	PCL,0X01			; 26
				LDI		ZL,58*2+1			; 27
				LSR		ZH					; 28
				ROR		ZL					; 29 
				IJMP						; 31 !!! +3 CROSSER
FROMRAMCB:		LOAD_ZH_PC[7]				; 27
				LDI		ZL,58*2				; 28
				LSR		ZH					; 29
				ROR		ZL					; 30
				IJMP						; 32 !!! +3 CROSSER      ROM34/RAM35


.ORG	0X0000+0XDD*128						; PREFIX DD      [ DD ] NONE

EXDD:			BRCC	FROMRAMDD			; 17 /> 18
				OUT		SREG,ZERO			; 18
				INC		R					; 19
				MOVW	ZL,PCL				; 20 
				OR		ZH,ROMID			; 21 
				ELPM	ZH,Z				; 24 
				ADIW	PCL,0X01			; 26
				LDI		ZL,55*2+1			; 27
				LSR		ZH					; 28
				ROR		ZL					; 29 
				IJMP						; 31 !!! +3 CROSSER
FROMRAMDD:		OUT		SREG,ZERO			; 19
				INC		R					; 20
				LOAD_ZH_PC[7]				; 27
				LDI		ZL,55*2				; 28
				LSR		ZH					; 29
				ROR		ZL					; 30
				IJMP						; 32 !!! +3 CROSSER      ROM34/RAM35


.ORG	0X0000+0XED*128						; PREFIX ED      [ ED ] NONE		/// ROM30/RAM31 \\\

EXED:			CLI							; 17
				INC		R					; 18
				BRCC	FROMRAMED			; 19 /> 20
				MOVW	ZL,PCL				; 20 
				OR		ZH,ROMID			; 21 
				ELPM	ZH,Z				; 24 
				ADIW	PCL,0X01			; 26
				LDI		ZL,63*2+1			; 27
				LSR		ZH					; 28
				ROR		ZL					; 29 
				IJMP						; 31 
FROMRAMED:		LOAD_ZH_PC[7]				; 27
				LDI		ZL,63*2				; 28
				LSR		ZH					; 29
				ROR		ZL					; 30
				IJMP						; 32


.ORG	0X0000+0XFD*128						; PREFIX FD      [ FD ] NONE	/// ROM30/RAM31 \\\

EXFD:			BRCC	FROMRAMFD			; 17 /> 18
				OUT		SREG,ZERO			; 18
				INC		R					; 19
				MOVW	ZL,PCL				; 20 
				OR		ZH,ROMID			; 21 
				ELPM	ZH,Z				; 24 
				ADIW	PCL,0X01			; 26
				LDI		ZL,126*2+1			; 27
				LSR		ZH					; 28
				ROR		ZL					; 29 
				IJMP						; 31
FROMRAMFD:		OUT		SREG,ZERO			; 19
				INC		R					; 20
				LOAD_ZH_PC[7]				; 27
				LDI		ZL,126*2			; 28
				LSR		ZH					; 29
				ROR		ZL					; 30
				IJMP						; 32



								





