
;********************** DESCRIPTION ********************************
; CONTROL:
; 7 IFF2
; 6 IFF1
; 5 
; 4 IOM: IN/OUT MODE: 0 -NORMAL, 1 - INTERNAL AVR ADDRESS SPACE
; 3 R:7
; 2 IMH INTERRUPT MODE LOW BIT
; 1 IML INTERRUPT MODE HIGH BIT
; 0 
; 
; X-PAIR = PROGRAM COUNTER
; Y-PAIR = STACK POINTER (STPH:STPL)
; Z-PAIR = TEMPORARY POINTER
; 
;********************************************************************
.INCLUDE "m128def.inc"
.INCLUDE "REGDEF.inc"
.INCLUDE "MACROSES.inc"
.INCLUDE "TIMINGS.inc"

.ORG 0X0000
.INCLUDE "CROSSER.inc"
.INCLUDE "OPCODE_ED.inc"
.INCLUDE "OPCODE_MAIN.inc"
.INCLUDE "OPCODE_FD.inc"

.ORG 0X8000

;.INCLUDE "ZX_SPECTRUM_48.inc"				;   ZX SPECTRUM 48 
;.INCLUDE "ZX_SPECTRUM_48_2006.inc"			;   ZX SPECTRUM 48 ,   2006 .
;.INCLUDE "ZX_SPECTRUM_128.inc"				;  ZX SPECTRUM 128 
.INCLUDE "PENTAGON_128.inc"				;  PENTAGON 128 
;.INCLUDE "ROM_TEST.inc"				;
;.INCLUDE "ZX_SPECTRUM_PLUS2.inc"			;  ZX SPECTRUM +3 (128 )
;.INCLUDE "ZX_SPECTRUM_PLUS3_HIGH.inc"		;  ZX SPECTRUM +3 (128 )

.INCLUDE "OPCODE_CB.inc"
.INCLUDE "OPCODE_DD.inc"
.INCLUDE "OPCODE_DDCB.inc"



RESET:			CLI

				LDI		BUF,(1<<MUXA15)|(1<<MUXA14)			; 1 
				OUT		PORTB,BUF							; 1 PORTB 
				LDI		BUF,(1<<TOTAPE)|(1<<BEEP)|(1<<NBEEP)|(1<<MUXA17)|(1<<MUXA16)|(1<<MUXA15)|(1<<MUXA14); 1 CONFIGURATION
				OUT		DDRB,BUF							; 1 

				LDI		BUF,(1<<A14_CPU)					; 1 
				OUT		PORTC,BUF							; 1 PORTC 
				LDI		BUF,(1<<A15_CPU)|(1<<A14_CPU)		; 1 CONFIGURATION
				OUT		DDRC,BUF							; 1 

				LDI		BUF,(1<<TOVCPU)						; 2 
				OUT		PORTD,BUF							; 2 PORTD CONFIGURATION
				LDI		BUF,(1<<BORDERL)|(1<<BORDERM)|(1<<BORDERH)|(1<<BORDERY)|(1<<A16)|(1<<TOVCPU); 2 
				OUT		DDRD,BUF

				LDI		BUF,(1<<RBBCP)						; 2 
				OUT		PORTE,BUF							; 2 PORTE CONFIGURATION
				LDI		BUF,(1<<RBBCP)|(1<<SCRA16)|(1<<BC1)|(1<<BDIR);2
				OUT		DDRE,BUF							; 2 

				LDI		BUF,(1<<KEYMH)|(1<<7);|(1<<5)		; 3 
				STS		PORTF,BUF							; 3 PORTF CONFIGURATION
				LDI		BUF,(1<<KEYMH)|(1<<7)|(1<<5)		; 3 
				STS		DDRF,BUF							; 3 

				LDI		BUF,0XFF							; 0 STEK POINTER
				OUT		SPL,BUF								; 0 INITIALISING
				LDI		BUF,0X10							; 0 STEK POINTER
				OUT		SPH,BUF								; 0 INITIALISING
				LDI		BUF,(1<<IVCE)						; 1 
				OUT		MCUCR,BUF							; 1 REMOVE VECTOR TABLE 
				LDI		BUF,(1<<IVSEL)						; 1 TO 0XFE00
				OUT		MCUCR,BUF							; 1 				

				LDI		BUF,1<<RAMPZ0						; 2 SET 
				OUT		RAMPZ,BUF							; 2 ROM PAGE 1	

				CLR		ZERO								; CLEAR ZERO REGISTER
				LDI		BUF,128								; 1 LOAD 
				MOV		CONST128,BUF						; 1 CONST128 REGISTER
				LDI		BUF,0X01							; 2 LOAD
				MOV		ONE,BUF								; 2 ONE REGISTER
				LDI		BUF,0X00;01<<ROMIDBIT				; 2 LOAD
				MOV		ROMID,BUF							; 2 ROMID REGISTER

				LDI		B,0XFF					;
				LDI		C,0XFF					;
				MOVW	E,C						;
				MOVW	L,C						;
				MOVW	A,C						;
				MOVW	_C,C					;
				MOVW	IXL,C					;
				MOVW	IYL,C					;
				OUT		_D,C					;
				OUT		_E,C					;
				OUT		_H,C					;
				OUT		_L,C					;
				OUT		_A,C					;
				OUT		_F,C					;

				MOV		MEMPTRL,ZERO			; 
				MOV		MEMPTRH,ZERO			; 
				STS		ADDR3,ZERO				; 
				STS		ADDR2,ZERO				; 
				STS		ADDR1,ZERO				; 
				LDI		ZH,0X07					;
				LDI		ZL,0X00					; 
				ST		Z,ZERO					; CLEAR BYTE-COUNTER OF LICENSE CODE GENERATOR (ADDRESS 0X0700)

				LDI		BUF,(1<<ADLAR)|(1<<MUX2)|(1<<MUX1)|(1<<REFS0)	; % SET EXTERNAL REF, LEFT ADJUSTMENT, 
				OUT		ADMUX,BUF										; % ADC6 CHANNEL
				LDI		BUF,(1<<ADEN)|(1<<ADFR)|(1<<ADSC)|(1<<ADPS1)	; % ON AD CONVERTER IN FREE-RUNNING MODE
				OUT		ADCSRA,BUF										; % WITH PRESCALING FACTOR 2

				LDI		BUF,(1<<SYS)			; 
				OUT		CONTROL,BUF				; INTERUPT DISABLED, INTERUPT MODE 0, SYSTEM HAS STARTED
				MOV		R,ZERO					; CLEAR REGENERATION REGISTER
				OUT		I,ZERO					; CLEAR INDEX REGISTER
				LDI		PCH,0X00				; RESET
				LDI		PCL,0X00                ; PROGRAM COUNTER

TAB16:			LDI		ZH,0X08
				LDI		ZL,0X00
				LDI		BUF,0X45					; 0
				ST		Z+,BUF
				LDI		BUF,0X16					; 1
				ST		Z+,BUF
				LDI		BUF,0X1E					; 2
				ST		Z+,BUF
				LDI		BUF,0X26					; 3
				ST		Z+,BUF
				LDI		BUF,0X25					; 4
				ST		Z+,BUF
				LDI		BUF,0X2E					; 5
				ST		Z+,BUF
				LDI		BUF,0X36					; 6
				ST		Z+,BUF
				LDI		BUF,0X3D					; 7
				ST		Z+,BUF
				LDI		BUF,0X3E					; 8
				ST		Z+,BUF
				LDI		BUF,0X46					; 9
				ST		Z+,BUF
				LDI		BUF,0X1C					; A
				ST		Z+,BUF
				LDI		BUF,0X32					; B
				ST		Z+,BUF
				LDI		BUF,0X21					; C
				ST		Z+,BUF
				LDI		BUF,0X23					; D
				ST		Z+,BUF
				LDI		BUF,0X24					; E
				ST		Z+,BUF
				LDI		BUF,0X2B					; F
				ST		Z+,BUF

				LDI		ZL,0X00								; **
				LDI		ZH,0X01								; ** FIRST PARITY TABLE (WITH Z FLAG)
				LDI		TMPH,1<<PP							; **
PM1:			LDI		BUF,0X08							; **
				MOV		ZERO,BUF							; **
				LDI		BUF,1<<PP							; **
				MOV		TMPL,ZL								; **	
BITLPTP:		SBRC	TMPL,7								; **
				EOR		BUF,TMPH							; **
				LSL		TMPL								; **
				DEC		ZERO								; **
				BRNE	BITLPTP								; **
				ST		Z,BUF								; **
				LDI		ZH,0X05								; ** THURD PARITY TABLE (WITHOUT Z FLAG AND H FLAGS)
				ST		Z,BUF								; **
				LDI		ZH,0X03								; ** SECOND PARITY TABLE (WITH Z FLAG AND H SET)
				SBR		BUF,1<<HH							; **
				ST		Z+,BUF								; **
				LDI		ZH,0X01								; ** FIRST PARITY TABLE (WITH Z FLAG)
				CP		ZL,ZERO								; **
				BRNE	PM1    								; ** 
				LDI		BUF,(1<<ZZ)|(1<<PP)					; ** 
				ST		Z,BUF								; ** 
				LDI		ZH,0X03								; ** SECOND PARITY TABLE (WITH Z FLAG AND H SET)
				LDI		BUF,(1<<ZZ)|(1<<PP)|(1<<HH)			; **
				ST		Z,BUF								; ** 
				LDI		ZH,0X05								; ** THURD PARITY TABLE (WITHOUT Z FLAG AND H FLAGS)
				LDI		BUF,(1<<PP)							; **
				ST		Z,BUF								; ** 

				LDI		ZH,HIGH(PAGETBL)					; # 
				LDI		ZL,0X00								; # 
PGTBLFILLLOOP:	MOV		BUF,ZL								; # 
				CBR		BUF,0B11111000						; # 
				CPI		BUF,0X00							; # 
				BRNE	PAGENOT0							; # 
				LDI		BUF,(1<<MUXA15)|(1<<MUXA14)			; # 
				ST		Z+,BUF								; # 
				RJMP	COMPGTBLFILL						; # 
PAGENOT0:		CPI		BUF,0X01							; # 
				BRNE	PAGENOT1							; # 
				LDI		BUF,(1<<MUXA16)|(1<<MUXA14)			; # 
				ST		Z+,BUF								; # 
				RJMP	COMPGTBLFILL						; # 
PAGENOT1:		CPI		BUF,0X02							; # 
				BRNE	PAGENOT2							; # 
				LDI		BUF,(1<<MUXA15)						; # 
				ST		Z+,BUF								; # 
				RJMP	COMPGTBLFILL						; # 
PAGENOT2:		CPI		BUF,0X03							; # 
				BRNE	PAGENOT3							; # 
				LDI		BUF,(1<<MUXA16)						; # 				
				ST		Z+,BUF								; # 
				RJMP	COMPGTBLFILL						; # 
PAGENOT3:		CPI		BUF,0X04							; # 
				BRNE	PAGENOT4							; # 
				LDI		BUF,(1<<MUXA16)|(1<<MUXA15)			; # 
				ST		Z+,BUF								; # 
				RJMP	COMPGTBLFILL						; # 
PAGENOT4:		CPI		BUF,0X05							; # 
				BRNE	PAGENOT5							; # 
				LDI		BUF,(1<<MUXA14)						; # 
				ST		Z+,BUF								; # 
				RJMP	COMPGTBLFILL						; # 
PAGENOT5:		CPI		BUF,0X06							; # 
				BRNE	PAGENOT6							; # 
				LDI		BUF,(1<<MUXA16)|(1<<MUXA15)|(1<<MUXA14); # 
				ST		Z+,BUF								; # 
				RJMP	COMPGTBLFILL						; # 
PAGENOT6:		LDI		BUF,0X00							; # 
				ST		Z+,BUF								; # 
COMPGTBLFILL:	CPI		ZL,0X00								; # 
				BRNE	PGTBLFILLLOOP						; # 


DONEM80:		NOP											; -80
DONEM79:		NOP											; -79
DONEM78:		NOP											; -78
DONEM77:		NOP											; -77
DONEM76:		NOP											; -76
DONEM75:		NOP											; -75
DONEM74:		NOP											; -74
DONEM73:		NOP											; -73
DONEM72:		NOP											; -72
DONEM71:		NOP											; -71
DONEM70:		NOP											; -70
DONEM69:		NOP											; -69
DONEM68:		NOP											; -68
DONEM67:		NOP											; -67
DONEM66:		NOP											; -66
DONEM65:		NOP											; -65
DONEM64:		NOP											; -64
DONEM63:		NOP											; -63
DONEM62:		NOP											; -62
DONEM61:		NOP											; -61
DONEM60:		NOP											; -60
DONEM59:		NOP											; -59
DONEM58:		NOP											; -58
DONEM57:		NOP											; -57
DONEM56:		NOP											; -56
DONEM55:		NOP											; -55
DONEM54:		NOP											; -54
DONEM53:		NOP											; -53
DONEM52:		NOP											; -52
DONEM51:		NOP											; -51
DONEM50:		NOP											; -50
DONEM49:		NOP											; -49
DONEM48:		NOP											; -48
DONEM47:		NOP											; -47
DONEM46:		NOP											; -46
DONEM45:		NOP											; -45
DONEM44:		NOP											; -44
DONEM43:		NOP											; -43
DONEM42:		NOP											; -42
DONEM41:		NOP											; -41
DONEM40:		NOP											; -40
DONEM39:		NOP											; -39
DONEM38:		NOP											; -38
DONEM37:		NOP											; -37
DONEM36:		NOP											; -36
DONEM35:		NOP											; -35
DONEM34:		NOP											; -34
DONEM33:		NOP											; -33
DONEM32:		NOP											; -32
DONEM31:		NOP											; -31
DONEM30:		NOP											; -30
DONEM29:		NOP											; -29
DONEM28:		NOP											; -28
DONEM27:		NOP											; -27
DONEM26:		NOP											; -26
DONEM25:		NOP											; -25
DONEM24:		NOP											; -24
DONEM23:		NOP											; -23
DONEM22:		NOP											; -22
DONEM21:		NOP											; -21
DONEM20:		NOP											; -20
DONEM19:		NOP											; -19
DONEM18:		NOP											; -18
DONEM17:		NOP											; -17
DONEM16:		NOP											; -16
DONEM15:		NOP											; -15
DONEM14:		NOP											; -14
DONEM13:		NOP											; -13
DONEM12:		NOP											; -12
DONEM11:		NOP											; -11
DONEM10:		NOP											; -10
DONEM9:			NOP											; -9
DONEM8:			NOP											; -8
DONEM7:			NOP											; -7
DONEM6:			NOP											; -6
DONEM5:			NOP											; -5
DONEM4:			NOP;SBIC	PINF,INTFLG				;                                 -4, -3
				NOP;sbi		control,snde;NOP;RCALL	KEYINT					; 
DONEM2:			NOP;SBIC	ACSR,ACI				;                                 -2
DONEM1:			NOP;SEI								;                                 -1
M1:				M1H[2]							; 2 
				BRCC	FROMRAM					; 3 /> 4
				M1L_ROM[13]						; 16
FROMRAM:		M1L_RAM[12]						; 16




DONEM80_:		NOP											; -80
DONEM79_:		NOP											; -79
DONEM78_:		NOP											; -78
DONEM77_:		NOP											; -77
DONEM76_:		NOP											; -76
DONEM75_:		NOP											; -75
DONEM74_:		NOP											; -74
DONEM73_:		NOP											; -73
DONEM72_:		NOP											; -72
DONEM71_:		NOP											; -71
DONEM70_:		NOP											; -70
DONEM69_:		NOP											; -69
DONEM68_:		NOP											; -68
DONEM67_:		NOP											; -67
DONEM66_:		NOP											; -66
DONEM65_:		NOP											; -65
DONEM64_:		NOP											; -64
DONEM63_:		NOP											; -63
DONEM62_:		NOP											; -62
DONEM61_:		NOP											; -61
DONEM60_:		NOP											; -60
DONEM59_:		NOP											; -59
DONEM58_:		NOP											; -58
DONEM57_:		NOP											; -57
DONEM56_:		NOP											; -56
DONEM55_:		NOP											; -55
DONEM54_:		NOP											; -54
DONEM53_:		NOP											; -53
DONEM52_:		NOP											; -52
DONEM51_:		NOP											; -51
DONEM50_:		NOP											; -50
DONEM49_:		NOP											; -49
DONEM48_:		NOP											; -48
DONEM47_:		NOP											; -47
DONEM46_:		NOP											; -46
DONEM45_:		NOP											; -45
DONEM44_:		NOP											; -44
DONEM43_:		NOP											; -43
DONEM42_:		NOP											; -42
DONEM41_:		NOP											; -41
DONEM40_:		NOP											; -40
DONEM39_:		NOP											; -39
DONEM38_:		NOP											; -38
DONEM37_:		NOP											; -37
DONEM36_:		NOP											; -36
DONEM35_:		NOP											; -35
DONEM34_:		NOP											; -34
DONEM33_:		NOP											; -33
DONEM32_:		NOP											; -32
DONEM31_:		NOP											; -31
DONEM30_:		NOP											; -30
DONEM29_:		NOP											; -29
DONEM28_:		NOP											; -28
DONEM27_:		NOP											; -27
DONEM26_:		NOP											; -26
DONEM25_:		NOP											; -25
DONEM24_:		NOP											; -24
DONEM23_:		NOP											; -23
DONEM22_:		NOP											; -22
DONEM21_:		NOP											; -21
DONEM20_:		NOP											; -20
DONEM19_:		NOP											; -19
DONEM18_:		NOP											; -18
DONEM17_:		NOP											; -17
DONEM16_:		NOP											; -16
DONEM15_:		NOP											; -15
DONEM14_:		NOP											; -14
DONEM13_:		NOP											; -13
DONEM12_:		NOP											; -12
DONEM11_:		NOP											; -11
DONEM10_:		NOP											; -10
DONEM9_:		NOP											; -9
DONEM8_:	 	NOP											; -8
DONEM7_:		NOP											; -7
DONEM6_:		NOP											; -6
DONEM5_:		NOP											; -5
DONEM4_:		NOP;SBIC	PINF,INTFLG				;                                 -4, -3
				NOP;sbi		control,snde;NOP;RCALL	KEYINT					; 
DONEM2_:		NOP;SBIC	ACSR,ACI				;                                 -2
DONEM1_:		NOP;SEI								;                                 -1
M1_:			M1H[2]							; 2 
				BRCC	FROMRAM_				; 3 /> 4
				M1L_ROM[13]						; 16
FROMRAM_:		M1L_RAM_[12]					; 16


_INT:			RJMP	INT_SERV			;
				SBIS	PINE,RBBCP			; 2
				RETI						; 
				MOV		CONST128,ZH			; 5
				MOV		ZERO,ZL				; 6
				POP		ZH					; 8
				POP		ZL					; 10
				PUSH	ZL					; 12
				PUSH	ZH					; 14
				SBIW	ZL,0X01				; 16
				PUSH	BUF					; 18
				IN		BUF,SREG			; 19
				PUSH	BUF					; 21
				BST		ZH,7				; 22
				BLD		BUF,0				; 23
				OUT		RAMPZ,BUF			; 24
				;CLC							; 25
				LSL		ZL					; 26
				ROL		ZH					; 27
				ELPM	BUF,Z+				; 30
				CPI		BUF,0XC3			; 31
				BRNE	OUTINT				; 32
				ELPM	BUF,Z				; 35
				CPI		BUF,0X94			; 36
				BREQ	INT_USTED			; 48
OUTINT:			MOV		ZL,ZERO				; 
				MOV		ZH,CONST128			; 
				LDI		CONST128,128		; 
				OUT		RAMPZ,ONE			; 
				CLR		ZERO				; 
				POP		BUF					; 
				OUT		SREG,BUF			; 
				POP		BUF					; 
				STS		TCNT3H,ZERO			; 
				STS		TCNT3L,ZERO			; 
				STS		TCCR3B,ONE			;
				RETI						; 

INT_USTED:		CLR		ZERO				; 48
				LDI		TMPH,128			; 50
				MOV		CONST128,TMPH		; 51
				LDI		BUF,0X01			; 52
				OUT		RAMPZ,BUF			; 53
INT_SERV:		nop							; 
				;call	liccodegen			; 56
				nop							; 
				LDI		TMPH,0XFF			; 57
				OUT		SPL,TMPH			; 58
				LDI		TMPH,0X10			; 59
				OUT		SPH,TMPH			; 60
				OUT		ACSR,ZERO			; 61
				SBI		ACSR,ACI			; 62
				IN		TMPH,CONTROL		; 63
				CBR		TMPH,(1<<IFF1)|(1<<IFF2);64
				OUT		CONTROL,TMPH		; 65
				SAVE_PC_SP[11]				; 76
				CBR		TMPH,0B11111100		; 77
				CPI		TMPH,0X02			; 78
				BRNE	IM0_1				; 79 /> 80
				RJMP	IM_2				; 81
IM0_1:			LDI		XH,0X00				; 82
				LDI		XL,0X38				; 83
				MOV		MEMPTRH,PCH			; 84
				MOV		MEMPTRL,PCL			; 85
				DEC		R					; 86
				LDI		TMPH,8				; N=8
IM0_1DELLOOP:	DEC		TMPH				; T=3*N=24
				BRNE	IM0_1DELLOOP		; 110
				RJMP	M1					; 112
IM_2:			LDI		ZL,0XFF				; 82
				IN		ZH,I				; 83
				CPI		ZH,0X40				; 84
				BRCC	FROMRAMIM_2_L		; 85 /> 86
				OR		ZH,ROMID			; 86
				ELPM	PCL,Z				; 89
				NOP							; 90
				NOP							; 91
				RJMP	COMIM_2_1			; 93
FROMRAMIM_2_L:	XON_RBBCP					; 88
				LD		PCL,Z				; 91
				XOFF_RBBCP					; 93
				OUT		RAMPZ,ONE			; ??
COMIM_2_1:		LDI		ZL,0XFF				; 82
				IN		ZH,I				; 83
				ADIW	ZL,0X01				; ???
				CPI		ZH,0X40				; 94
				BRCC	FROMRAMIM_2_H		; 95 /> 96
				OR		ZH,ROMID			; 96
				ELPM	PCH,Z				; 99
				NOP							; 100
				NOP							; 101
				RJMP	COMIM_2_2			; 103
FROMRAMIM_2_H:	XON_RBBCP					; 98
				LD		PCH,Z				; 101
				XOFF_RBBCP					; 103
COMIM_2_2:		OUT		RAMPZ,ONE			; ??
				MOV		MEMPTRH,PCH			; 104
				MOV		MEMPTRL,PCL			; 105
				DEC		R					; 106
				NOP							; 107
				NOP							; 108
				NOP							; 109				
				NOP							; 110 
				RJMP	M1					; 112




.ORG	0XFA00								; OUT (BFFD),TMPH     [ ED51 ] 12 (55-72) NONE \\ (DATA AY)

OUTBFFD:		IN		TMPL,PORTC			; 
				LDI		BUF,0XFF			; 
				OUT		PORTE,ZERO			; HOLD ON BUS
				OUT		PORTC,TMPH			; 
				OUT		DDRC,BUF			; OUT DATA
				SBI		PORTE,BDIR			; 
				NOP
				NOP
				NOP
				NOP
				NOP
				NOP
				NOP
				NOP	
				NOP
				NOP
				LDI		BUF,(1<<A15_CPU)|(1<<A14_CPU)
				OUT		PORTE,ZERO			;
				OUT		PORTC,TMPL			; 
				OUT		DDRC,BUF			; 
				OUT		PORTE,CONST128		;  HOLD OFF BUS

				STUFF55_11
				M1H_INTEN[3]				; ROM63/RAM64
				BRCC	FROMRAMOUTBFFD		; 65<>
				M1L_ROM_SHORT[12]			; 77 ??? (+6)
FROMRAMOUTBFFD:	M1L_RAM[12]					; 77 ??? (+6)




.ORG	0XFB00								; OUT (FFFD),TMPH     [ ED51 ] 12 (55-72) NONE \\ (ADDRESS AY)

OUTFFFD:		IN		TMPL,PORTC			; 
				LDI		BUF,0XFF			; 
				OUT		PORTE,ZERO			; HOLD ON BUS
				OUT		PORTC,TMPH			; 
				OUT		DDRC,BUF			; OUT DATA
				LDI		BUF,(1<<BC1)|(1<<BDIR);
				OUT		PORTE,BUF			; 
				NOP
				NOP
				NOP	
				NOP
				NOP
				NOP
				NOP
				NOP	
				NOP
				NOP
				LDI		BUF,(1<<A15_CPU)|(1<<A14_CPU)
				OUT		PORTE,ZERO			; 
				OUT		PORTC,TMPL			; 
				OUT		DDRC,BUF			; 
				OUT		PORTE,CONST128		;  HOLD OFF BUS


				STUFF55_11
				M1H_INTEN[3]				; ROM63/RAM64
				BRCC	FROMRAMOUTFFFD		; 65<>
				M1L_ROM_SHORT[12]			; 77 ??? (+6)
FROMRAMOUTFFFD:	M1L_RAM[12]					; 77 ??? (+6)

.ORG	0XFC00								; OUT (7FFD),TMPH     [ ED51 ] 12 (55-72) NONE \\

OUT7FFD:		SBIC	CONTROL,WD7FFD		; ROM42/RAM43 /> ROM43/RAM44
				RJMP	WR7FFDDISABLED		; ROM44/RAM45
				SBRC	TMPH,5				; ROM44/RAM45 /> ROM45/RAM46
				SBI		CONTROL,WD7FFD		; ROM46/RAM47  -  -  -  ROM45/RAM46 
				LDI		BUF,1<<A14_CPU		; ROM47/RAM48
				SBRC	TMPH,3				; ROM48/RAM49
				LDI		BUF,0X00			; ROM49/RAM50
				OUT		PORTC,BUF			; ROM50/RAM51
				BST		TMPH,4				; ROM51/RAM52
				BLD		ROMID,ROMIDBIT		; ROM52/RAM53
				LDI		ZH,HIGH(PAGETBL)	; ROM53/RAM54
				MOV		ZL,TMPH				; ROM54/RAM55
				LD		TMPH,Z				; ROM56/RAM57
				IN		BUF,PORTB			; ROM57/RAM58
				CBR		BUF,(1<<MUXA17)|(1<<MUXA16)|(1<<MUXA15)|(1<<MUXA14); ROM58/RAM59
				OR		BUF,TMPH			; ROM59/RAM60
				OUT		PORTB,BUF			; ROM60/RAM61
				STUFF55_11
				M1H_INTEN[3]				; ROM63/RAM64
				BRCC	FROMRAMOUT7FFD		; 65<>
				M1L_ROM_SHORT[12]			; 77 ??? (+6)
FROMRAMOUT7FFD:	M1L_RAM[12]					; 77 ??? (+6)
WR7FFDDISABLED:	JMP		M1-T12+48			; ROM47/RAM48


.ORG	0XFD00								; OUT (254),TMPH     [ ED51 ] 12 (55-72) NONE \\

OUT254:			IN		TMPL,PORTD			; ROM42/RAM43
				BST		TMPH,2				; ROM43/RAM44
				BLD		TMPL,BORDERH		; ROM44/RAM45
				BST		TMPH,1				; ROM45/RAM46
				BLD		TMPL,BORDERM		; ROM46/RAM47
				BST		TMPH,0				; ROM47/RAM48
				BLD		TMPL,BORDERL		; ROM48/RAM49
				OUT		PORTD,TMPL			; ROM49/RAM50
				IN		TMPL,PORTB			; ROM50/RAM51
				BST		TMPH,4				; ROM51/RAM52
				BLD		TMPL,BEEP			; ROM52/RAM53
				BST		TMPH,3				; ROM53/RAM54
				BLD		TMPL,TOTAPE			; ROM54/RAM55
				OUT		PORTB,TMPL			; ROM55/RAM56
				STUFF55_16
				M1H_INTEN[3]				; ROM58/RAM59
				BRCC	FROMRAMOUT254		; 60<>
				M1L_ROM_SHORT[12]			; 72 ??? (+1)
FROMRAMOUT254:	M1L_RAM[12]					; 72 ??? (+1)





.ORG	0XFE00
				JMP		RESET				; JUMP RESET 

.ORG	0XFE2E
				JMP		_INT				; JUMP TO INTERRUPT ROUTINE         6

JOUTPORTM1:		JMP		M1-T15+55			; 55
.ORG	0XFF00

				RJMP	OUT254				; 00	PORT 254
				RJMP	JOUTPORTM1			; 01
				RJMP	OUT254				; 02	PORT 254
				RJMP	JOUTPORTM1			; 03
				RJMP	OUT254				; 04	PORT 254
				RJMP	JOUTPORTM1			; 05
				RJMP	OUT254				; 06	PORT 254
				RJMP	JOUTPORTM1			; 07
				RJMP	OUT254				; 08	PORT 254
				RJMP	JOUTPORTM1			; 09
				RJMP	OUT254				; 0A	PORT 254
				RJMP	JOUTPORTM1			; 0B
				RJMP	OUT254				; 0C	PORT 254
				RJMP	JOUTPORTM1			; 0D
				RJMP	OUT254				; 0E	PORT 254
				RJMP	JOUTPORTM1			; 0F

				RJMP	OUT254				; 10	PORT 254
				RJMP	JOUTPORTM1			; 11
				RJMP	OUT254				; 12	PORT 254
				RJMP	JOUTPORTM1			; 13
				RJMP	OUT254				; 14	PORT 254
				RJMP	JOUTPORTM1			; 15
				RJMP	OUT254				; 16	PORT 254
				RJMP	JOUTPORTM1			; 17
				RJMP	OUT254				; 18	PORT 254
				RJMP	JOUTPORTM1			; 19
				RJMP	OUT254				; 1A	PORT 254
				RJMP	JOUTPORTM1			; 1B
				RJMP	OUT254				; 1C	PORT 254
				RJMP	JOUTPORTM1			; 1D
				RJMP	OUT254				; 1E	PORT 254
				RJMP	JOUTPORTM1			; 1F

				RJMP	OUT254				; 20	PORT 254
				RJMP	JOUTPORTM1			; 21
				RJMP	OUT254				; 22	PORT 254
				RJMP	JOUTPORTM1			; 23
				RJMP	OUT254				; 24	PORT 254
				RJMP	JOUTPORTM1			; 25
				RJMP	OUT254				; 26	PORT 254
				RJMP	JOUTPORTM1			; 27
				RJMP	OUT254				; 28	PORT 254
				RJMP	JOUTPORTM1			; 29
				RJMP	OUT254				; 2A	PORT 254
				RJMP	JOUTPORTM1			; 2B
				RJMP	OUT254				; 2C	PORT 254
				RJMP	JOUTPORTM1			; 2D
				RJMP	OUT254				; 2E	PORT 254
				RJMP	JOUTPORTM1			; 2F

				RJMP	OUT254				; 30	PORT 254
				RJMP	JOUTPORTM1			; 31
				RJMP	OUT254				; 32	PORT 254
				RJMP	JOUTPORTM1			; 33
				RJMP	OUT254				; 34	PORT 254
				RJMP	JOUTPORTM1			; 35
				RJMP	OUT254				; 36	PORT 254
				RJMP	JOUTPORTM1			; 37
				RJMP	OUT254				; 38	PORT 254
				RJMP	JOUTPORTM1			; 39
				RJMP	OUT254				; 3A	PORT 254
				RJMP	JOUTPORTM1			; 3B
				RJMP	OUT254				; 3C	PORT 254
				RJMP	JOUTPORTM1			; 3D
				RJMP	OUT254				; 3E	PORT 254
				RJMP	JOUTPORTM1			; 3F

				RJMP	OUT254				; 40	PORT 254
				RJMP	JOUTPORTM1			; 41
				RJMP	OUT254				; 42	PORT 254
				RJMP	JOUTPORTM1			; 43
				RJMP	OUT254				; 44	PORT 254
				RJMP	JOUTPORTM1			; 45
				RJMP	OUT254				; 46	PORT 254
				RJMP	JOUTPORTM1			; 47
				RJMP	OUT254				; 48	PORT 254
				RJMP	JOUTPORTM1			; 49
				RJMP	OUT254				; 4A	PORT 254
				RJMP	JOUTPORTM1			; 4B
				RJMP	OUT254				; 4C	PORT 254
				RJMP	JOUTPORTM1			; 4D
				RJMP	OUT254				; 4E	PORT 254
				RJMP	JOUTPORTM1			; 4F

				RJMP	OUT254				; 50	PORT 254
				RJMP	JOUTPORTM1			; 51
				RJMP	OUT254				; 52	PORT 254
				RJMP	JOUTPORTM1			; 53
				RJMP	OUT254				; 54	PORT 254
				RJMP	JOUTPORTM1			; 55
				RJMP	OUT254				; 56	PORT 254
				RJMP	JOUTPORTM1			; 57
				RJMP	OUT254				; 58	PORT 254
				RJMP	JOUTPORTM1			; 59
				RJMP	OUT254				; 5A	PORT 254
				RJMP	JOUTPORTM1			; 5B
				RJMP	OUT254				; 5C	PORT 254
				RJMP	JOUTPORTM1			; 5D
				RJMP	OUT254				; 5E	PORT 254
				RJMP	JOUTPORTM1			; 5F

				RJMP	OUT254				; 60	PORT 254
				RJMP	JOUTPORTM1			; 61
				RJMP	OUT254				; 62	PORT 254
				RJMP	JOUTPORTM1			; 63
				RJMP	OUT254				; 64	PORT 254
				RJMP	JOUTPORTM1			; 65
				RJMP	OUT254				; 66	PORT 254
				RJMP	JOUTPORTM1			; 67
				RJMP	OUT254				; 68	PORT 254
				RJMP	JOUTPORTM1			; 69
				RJMP	OUT254				; 6A	PORT 254
				RJMP	JOUTPORTM1			; 6B
				RJMP	OUT254				; 6C	PORT 254
				RJMP	JOUTPORTM1			; 6D
				RJMP	OUT254				; 6E	PORT 254
				RJMP	JOUTPORTM1			; 6F

				RJMP	OUT254				; 70	PORT 254
				RJMP	JOUTPORTM1			; 71
				RJMP	OUT254				; 72	PORT 254
				RJMP	JOUTPORTM1			; 73
				RJMP	OUT254				; 74	PORT 254
				RJMP	JOUTPORTM1			; 75
				RJMP	OUT254				; 76	PORT 254
				RJMP	JOUTPORTM1			; 77
				RJMP	OUT254				; 78	PORT 254
				RJMP	JOUTPORTM1			; 79
				RJMP	OUT254				; 7A	PORT 254
				RJMP	JOUTPORTM1			; 7B
				RJMP	OUT254				; 7C	PORT 254
				RJMP	OUT7FFD				; 7D	PORT 7FFD
				RJMP	OUT254				; 7E	PORT 254
				RJMP	JOUTPORTM1			; 7F

				RJMP	OUT254				; 80	PORT 254
				RJMP	JOUTPORTM1			; 81
				RJMP	OUT254				; 82	PORT 254
				RJMP	JOUTPORTM1			; 83
				RJMP	OUT254				; 84	PORT 254
				RJMP	JOUTPORTM1			; 85
				RJMP	OUT254				; 86	PORT 254
				RJMP	JOUTPORTM1			; 87
				RJMP	OUT254				; 88	PORT 254
				RJMP	JOUTPORTM1			; 89
				RJMP	OUT254				; 8A	PORT 254
				RJMP	JOUTPORTM1			; 8B
				RJMP	OUT254				; 8C	PORT 254
				RJMP	JOUTPORTM1			; 8D
				RJMP	OUT254				; 8E	PORT 254
				RJMP	JOUTPORTM1			; 8F

				RJMP	OUT254				; 90	PORT 254
				RJMP	JOUTPORTM1			; 91
				RJMP	OUT254				; 92	PORT 254
				RJMP	JOUTPORTM1			; 93
				RJMP	OUT254				; 94	PORT 254
				RJMP	JOUTPORTM1			; 95
				RJMP	OUT254				; 96	PORT 254
				RJMP	JOUTPORTM1			; 97
				RJMP	OUT254				; 98	PORT 254
				RJMP	JOUTPORTM1			; 99
				RJMP	OUT254				; 9A	PORT 254
				RJMP	JOUTPORTM1			; 9B
				RJMP	OUT254				; 9C	PORT 254
				RJMP	JOUTPORTM1			; 9D
				RJMP	OUT254				; 9E	PORT 254
				RJMP	JOUTPORTM1			; 9F

				RJMP	OUT254				; A0	PORT 254
				RJMP	JOUTPORTM1			; A1
				RJMP	OUT254				; A2	PORT 254
				RJMP	JOUTPORTM1			; A3
				RJMP	OUT254				; A4	PORT 254
				RJMP	JOUTPORTM1			; A5
				RJMP	OUT254				; A6	PORT 254
				RJMP	JOUTPORTM1			; A7
				RJMP	OUT254				; A8	PORT 254
				RJMP	JOUTPORTM1			; A9
				RJMP	OUT254				; AA	PORT 254
				RJMP	JOUTPORTM1			; AB
				RJMP	OUT254				; AC	PORT 254
				RJMP	JOUTPORTM1			; AD
				RJMP	OUT254				; AE	PORT 254
				RJMP	JOUTPORTM1			; AF

				RJMP	OUT254				; B0	PORT 254
				RJMP	JOUTPORTM1			; B1
				RJMP	OUT254				; B2	PORT 254
				RJMP	JOUTPORTM1			; B3
				RJMP	OUT254				; B4	PORT 254
				RJMP	JOUTPORTM1			; B5
				RJMP	OUT254				; B6	PORT 254
				RJMP	JOUTPORTM1			; B7
				RJMP	OUT254				; B8	PORT 254
				RJMP	JOUTPORTM1			; B9
				RJMP	OUT254				; BA	PORT 254
				RJMP	JOUTPORTM1			; BB
				RJMP	OUT254				; BC	PORT 254
				RJMP	OUTBFFD				; BD	PORT BFFD
				RJMP	OUT254				; BE	PORT 254
				RJMP	JOUTPORTM1			; BF

				RJMP	OUT254				; C0	PORT 254
				RJMP	JOUTPORTM1			; C1
				RJMP	OUT254				; C2	PORT 254
				RJMP	JOUTPORTM1			; C3
				RJMP	OUT254				; C4	PORT 254
				RJMP	JOUTPORTM1			; C5
				RJMP	OUT254				; C6	PORT 254
				RJMP	JOUTPORTM1			; C7
				RJMP	OUT254				; C8	PORT 254
				RJMP	JOUTPORTM1			; C9
				RJMP	OUT254				; CA	PORT 254
				RJMP	JOUTPORTM1			; CB
				RJMP	OUT254				; CC	PORT 254
				RJMP	JOUTPORTM1			; CD
				RJMP	OUT254				; CE	PORT 254
				RJMP	JOUTPORTM1			; CF

				RJMP	OUT254				; D0	PORT 254
				RJMP	JOUTPORTM1			; D1
				RJMP	OUT254				; D2	PORT 254
				RJMP	JOUTPORTM1			; D3
				RJMP	OUT254				; D4	PORT 254
				RJMP	JOUTPORTM1			; D5
				RJMP	OUT254				; D6	PORT 254
				RJMP	JOUTPORTM1			; D7
				RJMP	OUT254				; D8	PORT 254
				RJMP	JOUTPORTM1			; D9
				RJMP	OUT254				; DA	PORT 254
				RJMP	JOUTPORTM1			; DB
				RJMP	OUT254				; DC	PORT 254
				RJMP	JOUTPORTM1			; DD
				RJMP	OUT254				; DE	PORT 254
				RJMP	JOUTPORTM1			; DF

				RJMP	OUT254				; E0	PORT 254
				RJMP	JOUTPORTM1			; E1
				RJMP	OUT254				; E2	PORT 254
				RJMP	JOUTPORTM1			; E3
				RJMP	OUT254				; E4	PORT 254
				RJMP	JOUTPORTM1			; E5
				RJMP	OUT254				; E6	PORT 254
				RJMP	JOUTPORTM1			; E7
				RJMP	OUT254				; E8	PORT 254
				RJMP	JOUTPORTM1			; E9
				RJMP	OUT254				; EA	PORT 254
				RJMP	JOUTPORTM1			; EB
				RJMP	OUT254				; EC	PORT 254
				RJMP	JOUTPORTM1			; ED
				RJMP	OUT254				; EE	PORT 254
				RJMP	JOUTPORTM1			; EF

				RJMP	OUT254				; F0	PORT 254
				RJMP	JOUTPORTM1			; F1
				RJMP	OUT254				; F2	PORT 254
				RJMP	JOUTPORTM1			; F3
				RJMP	OUT254				; F4	PORT 254
				RJMP	JOUTPORTM1			; F5
				RJMP	OUT254				; F6	PORT 254
				RJMP	JOUTPORTM1			; F7
				RJMP	OUT254				; F8	PORT 254
				RJMP	JOUTPORTM1			; F9
				RJMP	OUT254				; FA	PORT 254
				RJMP	JOUTPORTM1			; FB
				RJMP	OUT254				; FC	PORT 254
				RJMP	OUTFFFD				; FD	PORT FFFD
				RJMP	OUT254				; FE	PORT 254
				RJMP	JOUTPORTM1			; FF
















