	device pentagon1024 ; but code is for ATM Turbo 2+ ;)

	org #8000

begin
        jp START

; SHADOW : enable shadow ports and set Turbo2+ mode
; A - value to write into port FD77

SHADOW  LD BC,#FD77 ; enable shadow ports
        LD IX,10835
        PUSH IX
        JP #3D2F

; A - memory page number (0..63) for window #0000..#3FFF

;MEM0	XOR %01111111
;	LD BC,#3FF7
;	OUT (C),A
;       RET

; A - memory page number (0..63) for window #4000..#7FFF

MEM1	XOR %01111111
	LD BC,#7FF7
	OUT (C),A
	RET

; A - memory page number (0..63) for window #8000..#BFFF

;MEM2	XOR %01111111
;	LD BC,#BFF7
;	OUT (C),A
;       RET

; A - memory page number (0..63) for window #C000..#FFFF

MEM3	XOR %01111111
	LD BC,#FFF7
	OUT (C),A
        RET

RND
	push bc
	push hl
seed=$+1
	ld hl,0
	ld b,h,c,l
	add hl,hl
	add hl,hl
	add hl,hl
	add hl,hl
	add hl,bc
	ld bc,12423
	add hl,bc
	ld (seed),hl
	ld a,h
	pop hl
	pop bc
	ret

START
	xor a
	out (#fe),a
	ld sp,#C000

        ld A,%10101000 ; turbo and 320x200
        call SHADOW

;	ld a,1
;	out (#fe),a

	ld a,1
	call MEM1
	ld a,5
	call MEM3

;	ld ix,#4000
;	ld iy,#C000
;	ld c,16
;	ld a,0
;loop	ld (ix),a
;	ld (iy),#FF
;	inc ix
;	inc iy
;	inc a
;	dec c
;	jr nz,loop

	ld de,#C001
	ld hl,#C000
	ld (hl),#00
	ld bc,#4000
	ldir

	ld de,#4001
	ld hl,#4000
	ld (hl),#00
	ld bc,#4000
	ldir

	ld a,(image)
	srl a
	ld (maxbyte),a

	ld hl,image+2
loop1	ld ix,#4014
	ld iy,#E013
	ld a,(curline)
	push hl
	ld l,a
	ld h,0
	add hl,hl
	add hl,hl
	add hl,hl
	add hl,hl
	ld d,h
	ld e,l
	add hl,hl
	add hl,hl
	add hl,de
	ex de,hl
	add ix,de
	add iy,de
	pop hl	
loop2	ld a,(hl)
	and #C0
	cp #00
	jr z,lpix0
	cp #40
	jr z,lpix1
	cp #80
	jr z,lpix2
	; black on white (for eyes)
	ld a,#38
	ld (attr),a
	ld a,#07
	ld (attri),a
	ld a,#3F
	ld (attr2),a
	ld a,#00
	ld (attr2i),a
	jr lpixset
lpix2   ; white on yellow
        ld a,#37
	ld (attr),a
	ld a,#3E
	ld (attri),a
	ld a,#36
	ld (attr2),a
	ld a,#3F
	ld (attr2i),a
	jr lpixset
lpix1   ; yellow on red
	ld a,#16
	ld (attr),a
	ld a,#32
	ld (attri),a
	ld a,#12
	ld (attr2),a
	ld a,#36
	ld (attr2i),a
	jr lpixset
lpix0   ; red on black
        ld a,#02
	ld (attr),a
	ld a,#10
	ld (attri),a
	ld a,#00
	ld (attr2),a
	ld a,#12
	ld (attr2i),a
lpixset	ld a,(hl)
	and #30
	cp #30
	jp z,lpix13
	cp #20
	jp z,lpix12
	cp #10
	jp z,lpix11
	ld a,(attr2)
	ld (ix),a
	ld (iy),a
	ld de,#0028
	add ix,de
	add iy,de
	ld (ix),a
	ld (iy),a
	ld de,#FFD8
	add ix,de
	add iy,de
	jp lpixset2
lpix11  ld a,(attr2)
	ld (ix),a
	ld (iy),a
	ld de,#0028
	add ix,de
	add iy,de
	ld a,(attr)
	ld (ix),a
	ld (iy),a
	ld de,#FFD8
	add ix,de
	add iy,de
	jp lpixset2
lpix12  ld a,(attri)
	ld (ix),a
	ld (iy),a
	ld de,#0028
	add ix,de
	add iy,de
	ld a,(attr)
	ld (ix),a
	ld (iy),a
	ld de,#FFD8
	add ix,de
	add iy,de
	jp lpixset2
lpix13  ld a,(attri)
	ld (ix),a
	ld (iy),a
	ld de,#0028
	add ix,de
	add iy,de
	ld a,(attr2i)
	ld (ix),a
	ld (iy),a
	ld de,#FFD8
	add ix,de
	add iy,de
lpixset2
	ld de,#8000
	add ix,de
	add iy,de
	ld a,(hl)
	and #0C
	cp #00
	jr z,lpix0a
	cp #04
	jr z,lpix1a
	cp #08
	jr z,lpix2a
	; black on white (for eyes)
	ld a,#38
	ld (attr),a
	ld a,#07
	ld (attri),a
	ld a,#3F
	ld (attr2),a
	ld a,#00
	ld (attr2i),a
	jr lpixset2a
lpix2a  ; white on yellow
        ld a,#37
	ld (attr),a
	ld a,#3E
	ld (attri),a
	ld a,#36
	ld (attr2),a
	ld a,#3F
	ld (attr2i),a
	jr lpixset2a
lpix1a  ; yellow on red
	ld a,#16
	ld (attr),a
	ld a,#32
	ld (attri),a
	ld a,#12
	ld (attr2),a
	ld a,#36
	ld (attr2i),a
	jr lpixset2a
lpix0a  ; red on black
        ld a,#02
	ld (attr),a
	ld a,#10
	ld (attri),a
	ld a,#00
	ld (attr2),a
	ld a,#12
	ld (attr2i),a
lpixset2a
	ld a,(hl)
	and #03
	cp #03
	jp z,lpix23
	cp #02
	jp z,lpix22
	cp #01
	jp z,lpix21
	ld a,(attr2)
	ld (ix),a
	ld (iy),a
	ld de,#0028
	add ix,de
	add iy,de
	ld (ix),a
	ld (iy),a
	ld de,#FFD8
	add ix,de
	add iy,de
	jp lpixset0
lpix21  ld a,(attr2)
	ld (ix),a
	ld (iy),a
	ld de,#0028
	add ix,de
	add iy,de
	ld a,(attr)
	ld (ix),a
	ld (iy),a
	ld de,#FFD8
	add ix,de
	add iy,de
	jp lpixset0
lpix22  ld a,(attri)
	ld (ix),a
	ld (iy),a
	ld de,#0028
	add ix,de
	add iy,de
	ld a,(attr)
	ld (ix),a
	ld (iy),a
	ld de,#FFD8
	add ix,de
	add iy,de
	jp lpixset0
lpix23  ld a,(attri)
	ld (ix),a
	ld (iy),a
	ld de,#0028
	add ix,de
	add iy,de
	ld a,(attr2i)
	ld (ix),a
	ld (iy),a
	ld de,#FFD8
	add ix,de
	add iy,de
lpixset0
        inc hl
        ld a,(curbyte)
	inc a
	ld (curbyte),a
	ld d,a
	ld a,(maxbyte)
	cp d
	jp z,lendline

	bit 0,d
	jp z,lsec
	ld de,#A000
	add ix,de
	ld de,#6000
	add iy,de
	jp loop2

lsec	ld de,#6001
	add ix,de
	ld de,#9FFF
	add iy,de
	jp loop2

lendline
	xor a
	ld (curbyte),a
	ld a,(curline)
	inc a
	ld (curline),a
	ld a,(hl)
	cp #FF
	jp nz,loop1
loope
	ld hl,eye_0
	call eyeright
	ld hl,eye_0
	call eyeleft
	call RND
loope1
	halt
	dec a
	jr nz,loope1

	ld hl,eye_1
	call eyeright
	ld hl,eye_1
	call eyeleft
	call RND
loope2
	halt
	dec a
	jr nz,loope2

	ld hl,eye_0
	call eyeright
	ld hl,eye_0
	call eyeleft
	call RND
loope3
	halt
	dec a
	jr nz,loope3

	ld hl,eye_00
	call eyeright
	ld hl,eye_00
	call eyeleft
	call RND
loope4
	halt
	dec a
	jr nz,loope4

	jp loope

	jr $-1

;  |oo|oo|
; o| o|o |o
;oo|oo|oo|oo
;o |oo|oo| o
;oo|oo|oo|oo
; o| o|o |o
;  |oo|oo|

eye_00 db #3F,#3F,#3F,#3F,#3F,#3F,#3F
eye_0  db #3F,#3F,#3F,#3F,#3F,#3F,#3F
eye_1  db #3F,#07,#00,#38,#00,#07,#3F
eye_2  db #00,#07,#00,#00,#00,#07,#00
eye_3  db #00,#38,#00,#00,#00,#38,#00
eye_4  db #3F,#38,#00,#07,#00,#38,#3F
eye_e  db #3F,#3F,#3F,#3F,#3F,#3F,#3F
eye_ee db #3F,#3F,#3F,#3F,#3F,#3F,#3F

; eyeal dw #EDD6,#4DD7,#CDD7,#6DD7,#EDD7,#4DD8
; eyear dw #EDCF,#4DD0,#CDD0,#6DD0,#EDD0,#4DD1

eyecol
	ld c,7
eyecol1
	ld a,(hl)
	inc hl
	ld (ix),a
	add ix,de	
	dec c
	jp nz,eyecol1
	ret

eyeright
	ld de,#0028
	ld ix,#EDD6
	call eyecol
	ld ix,#4DD7
	call eyecol
	ld ix,#CDD7
	call eyecol
	ld ix,#6DD7
	call eyecol
	ld ix,#EDD7
	call eyecol
	ld ix,#4DD8
	call eyecol
	ret

eyeleft
	ld de,#0028
	ld ix,#EDCF
	call eyecol
	ld ix,#4DD0
	call eyecol
	ld ix,#CDD0
	call eyecol
	ld ix,#6DD0
	call eyecol
	ld ix,#EDD0
	call eyecol
	ld ix,#4DD1
	call eyecol
	ret


curline db 0
curbyte db 0
maxbyte db 35
attr    db 0
attri	db 0
attr2	db 0
attr2i	db 0

image
        ; 1st byte is width
        ; 2nd byte is height

        incbin "KrazyShaos1l.bin"

	db #FF

end

	display "Size ",/d,end-begin," bytes"
	
	savebin "code.c",begin,end-begin
	
	LABELSLIST "user.l"
