/*---------------------------------------------------------------*/
/* OS-depended file systems module. Block operations. (c) Serge  */
/*---------------------------------------------------------------*/

#include <hitech.h>
#include <ctype.h>
#include <stringz.h>

static uchar toAlt[]={
  0xC4, 0xB3, 0xDA, 0xBF, 0xC0, 0xD9, 0xC3, 0xB4, 0xC2, 0xC1, 0xC5, 0xDF, 0xDC, 0xDB, 0xDD, 0xDE,
  0xB0, 0xB1, 0xB2, 0xF4, 0xFE, 0xF9, 0xFB, 0xF7, 0xF3, 0xF2, 0xFF, 0xF5, 0xF8, 0xFD, 0xFA, 0xF6,
  0xCD, 0xBA, 0xD5, 0xF1, 0xD6, 0xC9, 0xB8, 0xB7, 0xBB, 0xD4, 0xD3, 0xC8, 0xBE, 0xBD, 0xBC, 0xC6,
  0xC7, 0xCC, 0xB5, 0xF0, 0xB6, 0xB9, 0xD1, 0xD2, 0xCB, 0xCF, 0xD0, 0xCA, 0xD8, 0xD7, 0xCE, 0xFC,
  0xEE, 0xA0, 0xA1, 0xE6, 0xA4, 0xA5, 0xE4, 0xA3, 0xE5, 0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE,
  0xAF, 0xEF, 0xE0, 0xE1, 0xE2, 0xE3, 0xA6, 0xA2, 0xEC, 0xEB, 0xA7, 0xE8, 0xED, 0xE9, 0xE7, 0xEA,
  0x9E, 0x80, 0x81, 0x96, 0x84, 0x85, 0x94, 0x83, 0x95, 0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E,
  0x8F, 0x9F, 0x90, 0x91, 0x92, 0x93, 0x86, 0x82, 0x9C, 0x9B, 0x87, 0x98, 0x9D, 0x99, 0x97, 0x9A};

static uchar toKoi[]={
  0xE1, 0xE2, 0xF7, 0xE7, 0xE4, 0xE5, 0xF6, 0xFA, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF, 0xF0, 
  0xF2, 0xF3, 0xF4, 0xF5, 0xE6, 0xE8, 0xE3, 0xFE, 0xFB, 0xFD, 0xFF, 0xF9, 0xF8, 0xFC, 0xE0, 0xF1, 
  0xC1, 0xC2, 0xD7, 0xC7, 0xC4, 0xC5, 0xD6, 0xDA, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF, 0xD0, 
  0x90, 0x91, 0x92, 0x81, 0x87, 0xB2, 0xB4, 0xA7, 0xA6, 0xB5, 0xA1, 0xA8, 0xAE, 0xAD, 0xAC, 0x83, 
  0x84, 0x89, 0x88, 0x86, 0x80, 0x8A, 0xAF, 0xB0, 0xAB, 0xA5, 0xBB, 0xB8, 0xB1, 0xA0, 0xBE, 0xB9, 
  0xBA, 0xB6, 0xB7, 0xAA, 0xA9, 0xA2, 0xA4, 0xBD, 0xBC, 0x85, 0x82, 0x8D, 0x8C, 0x8E, 0x8F, 0x8B, 
  0xD2, 0xD3, 0xD4, 0xD5, 0xC6, 0xC8, 0xC3, 0xDE, 0xDB, 0xDD, 0xDF, 0xD9, 0xD8, 0xDC, 0xC0, 0xD1, 
  0xB3, 0xA3, 0x99, 0x98, 0x93, 0x9B, 0x9F, 0x97, 0x9C, 0x95, 0x9E, 0x96, 0xBF, 0x9D, 0x94, 0x9A};


char* alt_koi(char* strn, uchar* codetable)
{
  register BYTE* st;
  for (st=(BYTE*)strn; *st; st++)
    if (*st>127) *st=codetable[*st - 128];
  return strn;
}

char* alt2koi(char* strn)
{
  return alt_koi(strn, toKoi);
}

char* koi2alt(char* strn)
{
  return alt_koi(strn, toAlt);
}

int __atoi(char *st)
{
  register int ii=0;
  while (isdigit(*st))
    ii=ii*10+(*st++ - '0');
  return ii;
}

char* UpperCase(char* ss)
{
  register char* st=ss;
  while (*st) {
    if ( (*st>='a') && (*st<='z') ) *st-=32;
    st++;
  }
  return ss;
}

BOOL FileFilter(name, filter)
  register char* name;
  char* filter;
{
    char  c;
    while ((*name) || (*filter))
    {
        switch ((c = *filter++))
        {
            case '?':
                name++;
                break;
            case '*':
                while ( (*name!=*filter) && (*name) )  name++;
                if (! (*name)) break;
                if (FileFilter(name, filter)) return(TRUE);
                filter--;
                name++;
                break;
            default: if(*name++ != c) return(FALSE);
        }
    }
    return(*name==*filter);
}

static ushort level;
static ushort sublevel;

ushort OsLevel(ushort *SubLevel)
{
#asm
  push	de
  push	bc
  ld	C,12
  call	5
  ld	(_level),hl
  exx
  ld	(_sublevel),hl
  pop	bc
  pop	de
#endasm
  *SubLevel=sublevel;
  return level;
}

/* read Orion ROMDISK (page=0, offset 800h) or RAMDISK (page=3..15) */

/*                       ix+6       ix+8+9      ix+10+11     ix+12+13 */
ushort MemBlockGet(uchar page, ushort addr, ushort count, char* block)
{
#asm
  push	BC
  push	DE
  ld	A,(62457)
  ld	L,(ix+12)
  ld	H,(ix+13)
  exx
  ex	AF,AF'
  ld	A,(ix+6)
  ld	L,(ix+8)
  ld	H,(ix+9)
  ld	C,(ix+10)
  ld	B,(ix+11)
  or	A
  jr	nz,endget
  ld	DE,2048
  defb	25		/* add hl,de */ 
eget:dec BC
  ld	(62721),HL
  ld	A,(62720)
  inc	HL
  exx
  ld	(HL),A
  inc	HL
  exx
  ld	A,B
  or	C
  jr	nz,eget
endget:
  call	nz,61953
  ld	(ix+8),L
  ld	(ix+9),H
  pop	DE
  pop	BC
#endasm
  return addr;
}

/*                       ix+6       ix+8+9      ix+10+11     ix+12+13 */
ushort MemBlockPut(uchar page, ushort addr, ushort count, char* block)
{
#asm
  push	BC
  push	DE
  ld	A,(ix+6)
  or	A
  jr	z,endput 
  ld	L,(ix+8)
  ld	H,(ix+9)
  exx
  ex	AF,AF'    
  ld	C,(ix+10)
  ld	B,(ix+11)
  ld	L,(ix+12)
  ld	H,(ix+13)
  ld	A,(62457)
  call	61953
  exx
  ld	(ix+8), L
  ld	(ix+9), H
endput:pop DE 
  pop	BC
#endasm
  return addr;
}

