	device	zxspectrum48
	org	#8500

start:
	ld	ix,8700h
	ld	de,6912
	ld	a,255
	call	sa_bytes
	ret


sa_bytes:
	ld	hl,053fh	;the sa/ld-ret ROM subroutine to restore border and handle break key
	push	hl
	exx
	ld	de,0101h	;initial value for the Fletcher's checksum
	exx
	ld	hl,2710H	;5s leader for header
	bit	7,a		;check if saving header or data
	jr	z,sa_flag
	ld	hl,0fa0h	;2s leader for data block
sa_flag:
	ex	af,af'		;save header/data type byte in af'
	inc	de
	dec	ix
	di
	ld	a,2		;red border
	ld	b,a
; Saving the leader
; Timing: for each signal excursion, 60+(tc-1)*13 t-states (target: 2 bits = 1750)
sa_leader:
	djnz	sa_leader	;8/13
	out	(0feh),a	;11
	xor	0fh		;7 xor the tape bit and border colors
	ld	b,131		;7 leader timing constant
	or	0		;7 delay
	nop			;4 delay
	dec	l		;4
	jr	nz,sa_leader	;7/12
	dec	b		;4 compensate for longer loop path
	dec	h		;4
	jp	p,sa_leader	;10
; Saving one '1' bit: 875 t-states from last out, 58 above and 817 below
	ld	b,61		;7 delay 806 t-states
sa_sync1:
	djnz	sa_sync1	;8/13
	or	0		;7 delay
	nop			;4 delay
	out	(0feh),a	;11
; Saving one '0' bit: need to have 875 t-states between outs.
	ld	b,6		;7	;delay 80 t-states
sa_sync2:
	djnz	sa_sync2	;8/13
; Entering the main saving loop
; t-states:
; between successive bytes - 99+t(sa_byte)
	ex	af,af'		;4 restore the header/data type byte
	ld	c,0		;7 running disparity and P7/A7 coding flag
sa_loop:
	call	sa_byte		;17+t(sa_byte)
	ld	a,7fh		;7
	in	a,(0xfe)	;11 check break key
	rra			;4
	ret	nc		;5/11
	inc	ix		;10
	dec	de		;6
	ld	a,d		;4
	or	e		;4
	ld	a,(ix)		;19
	jr	nz,sa_loop	;7/12
; Save the Fletcher's checksum
	exx			;4
	ld	a,e		;4
	ld	b,d		;4
	exx			;4
	ld	b,a		;4
	exx			;4 sa_byte_nc entry point must have exx-register set activated
	call	sa_byte_nc	;17
	exx			;4
	ld	a,b		;4
	exx			;4
	ld	b,5		;7
sacs0:	djnz	sacs0		;8/13
	nop			;4
	call	sa_byte		;17
; Exit delay
	ld	b,0FFh
sa_delay:
	djnz	sa_delay
	ret



;--------- Encode and save a data byte
;in A - byte to save
;in/out C - current running disparity (bit 0), bit 1 must be 0
;t-states:
; from entry to branch sa_pn_check - 128
; from branch sa_pn_check to call sa_bits (including call) - 70/69/72
; from last out till exit (including ret) - 38
; from lat out of prev byte to entry - 137
; from entry to first out - 124+70/69/72+42+8+(tc-1)*13
sa_byte:
	jp	sa_byte1	;10 delay
sa_byte1:
; Update the Fletcher's checksum
	ld	b,a		;4
	exx			;4
	add	a,e		;4
	adc	a,0		;7 modulo 255 addition
	ld	e,a		;4
; Entry point for saving the checksum: minus 23 t-states
sa_byte_nc:
	add	a,d		;4
	adc	a,0		;7
	ld	d,a		;4 modulo 255 addition
	exx			;4
	ld	a,b		;4
	and	0F8H		;7 do the 5b/6b conversion
	rrca			;4
	rrca			;4
	rrca			;4
	add	a,low coding_tbl_5b	;7
	ld	l,a		;4
	ld	h,high coding_tables	;7
	ld	l,(hl)		;7
	ld	h,b		;4 save the original data byte for later
	ld	a,c		;4
	rra			;4
	sbc	a,a		;4 current disparity (A=00 when -1, A=FF when +1)
	xor	l		;4 perform optional inversion and flipping of RD
	bit	1,l		;8 check if the codeword affects RD or requires optional inversion
	jr	nz,sa_pn_check	;7/12 parity-neutral codeword - check for P7/A7 codes
	and	0FDH		;7 reset bit 1 - (P7/A7 flag)
	ld	c,a		;4 bit 0 becomes new running disparity (inversion of old)
	and	0FCH		;7 extract data bits only
	or	2		;7 set stop bit
	ld	l,a             ;4
	jp	sa_byte0        ;10
sa_pn_check:
	cpl			;4
	and	0CH		;7 extract last two bits of the codeword (xored with RD and inv)
; now Z flag is set if A7 code must be used
	jr	nz,sa_byte01	;7/12
	set	1,c		;8 set flag to use A7 code
sa_byte01:
	jp	sa_byte0	;10 delay
sa_byte0:
	ld	b,027h		;7 timing constant
	call	sa_bits		;17+t(sa_bits) save the group of 6 bits
	ld	a,h		;4 previously saved original data byte
	and	7		;7 do the 3b/4b conversion
	add	a,low coding_tbl_3b_p	;7
	bit	1,c		;8
	jr	z,sa_prim	;7/12
	add	a,low (coding_tbl_3b_a - coding_tbl_3b_p)	;7
sa_prim:
	ld	l,a		;4
	ld	h,high coding_tables	;7
	ld	l,(hl)		;7
	bit	1,l		;8 check if the codeword affects RD and requires optional inversion
	ld	b,037h		;7 38+84+42+8+(tc-1)*13 t-states between outs
	jr	z,sa_bits	;7/12 parity-neutral codeword - do nothing
	rr	c		;8
	sbc	a,a		;4 00 if bit 0(c)=0, otherwise FF
	xor	l		;4 perform optional inversion
	and	0F1H		;7 reset P7/A7 flag
	ld	c,a		;4 bit 0 becomes new running disparity (inversion of old)
	and	0F0H		;7 extract data bits only
	or	8		;7 set stop bit
	ld	l,a		;4
	ret	c		;5 ret will be never executed, just delay 5 t-states
	ld	b,037h-4	;7 there are 52 extra t-states for this branch, compensate 4*13
;--------- Save a group of bits (6 or 4)
;in L - bits to save, with a stop bit=1 and post-stop bits all 0s
;in B - initial timing constant
;T-states:
; from entry to first out - 50+(tc-1)*13
; between successive outs - 69+(tc-1)*13
; from last out to exit (including ret) - 38
sa_bits:
	rl	l		;8 extract the first data bit
	ret	z		;5/11 return if no more bits
sa_bits0:
	djnz	sa_bits0	;8/13
	sbc	a,a		;4 extend data bit to the whole A
	and	0fh		;7 restrict it to MIC bit and border colors
	xor	1		;7 adjust border colors
	out	(0feh),a        ;11
	ld	b,03fh		;7 timing constant for successive outs - target is 0.25ms
	jr	sa_bits		;12 loop


	org	#8600

coding_tables:



coding_tbl_5b:
	db	10011101b	;0
	db	01110101b	;1
	db	10110101b	;2
	db	11000110b	;3
	db	11010101b	;4
	db	10100110b	;5
	db	01100110b	;6
	db	11100000b	;7
	db	11100101b	;8
	db	10010110b	;9
	db	01010110b	;10
	db	11010010b	;11
	db	00110110b	;12
	db	10110010b	;13
	db	01110010b	;14
	db	01011101b	;15
	db	01101101b	;16
	db	10001110b	;17
	db	01001110b	;18
	db	11001010b	;19
	db	00101110b	;20
	db	10101010b	;21
	db	01101010b	;22
	db	11101001b	;23
	db	11001101b	;24
	db	10011010b	;25
	db	01011010b	;26
	db	11011001b	;27
	db	00111010b	;28
	db	10111001b	;29
	db	01111001b	;30
	db	10101101b	;31

coding_tbl_3b_p:
	db	10110011b	;0
	db	10011000b	;1
	db	01011000b	;2
	db	11000010b	;3
	db	11010011b	;4
	db	10101000b	;5
	db	01101000b	;6
	db	11100011b	;7
coding_tbl_3b_a:
	db	10110011b	;0
	db	10011000b	;1
	db	01011000b	;2
	db	11000010b	;3
	db	11010011b	;4
	db	10101000b	;5
	db	01101000b	;6
	db	01110011b	;7


	savebin "tape.bin",start,0x130
