	device	zxspectrum48
	org	#8500

start:
	ld	ix,8700h
	ld	de,6912
	ld	a,255
	call	sa_bytes
	ret


sa_bytes:
	ld	hl,053fh	;the sa/ld-ret ROM subroutine to restore border and handle break key
	push	hl
	exx
	ld	de,0101h	;initial value for the Fletcher's checksum
	exx
	ld	hl,2710H	;5s leader for header
	bit	7,a		;check if saving header or data
	jr	z,sa_flag
	ld	hl,0fa0h	;2s leader for data block
sa_flag:
	ex	af,af'		;save header/data type byte in af'
	inc	de
	dec	ix
	di
	ld	a,2		;red border
	ld	b,a
; Saving the leader
; Timing: for each signal excursion, 60+(tc-1)*13 t-states (target: 2 bits = 1750)
sa_leader:
	djnz	sa_leader	;8/13
	out	(0feh),a	;11
	xor	0fh		;7 xor the tape bit and border colors
	ld	b,131		;7 leader timing constant
	or	0		;7 delay
	nop			;4 delay
	dec	l		;4
	jr	nz,sa_leader	;7/12
	dec	b		;4 compensate for longer loop path
	dec	h		;4
	jp	p,sa_leader	;10
; Saving one '1' bit: 875 t-states from last out, 58 above and 817 below
	ld	b,61		;7 delay 806 t-states
sa_sync1:
	djnz	sa_sync1	;8/13
	or	0		;7 delay
	nop			;4 delay
	out	(0feh),a	;11
; Saving one '0' bit: need to have 875 t-states between outs.
; from here to call to sa_byte (incl call) - 73+8 (delay)
; from entry to sa_byte to first out - 40+(tc-1)*13, tc=59
	nop			;4 delay
	nop			;4 delay
; Entering the main saving loop
; t-states:
; between successive bytes - 148+11(delay), tc=49, must be 783-(tc-1)*13
; from last call to sa_byte to next call to sa_byte - 132+14, tc=50, must be 783-(tc-1)*13
	ex	af,af'		;4 restore the header/data type byte
	ld	bc,3b0eh	;10 initial tc=59, RD and MIC/border status
sa_loop:
	ld	l,a		;4 argument location for sa_byte
	; Update the Fletcher's checksum
	exx			;4
	add	a,e		;4
	adc	a,0		;7 modulo 255 addition
	ld	e,a		;4
	add	a,d		;4
	adc	a,0		;7
	ld	d,a		;4 modulo 255 addition
	exx			;4
	call	sa_byte		;17+t(sa_byte)
	ld	a,7fh		;7
	in	a,(0xfe)	;11 check break key
	rra			;4
	ret	nc		;5/11
	inc	ix		;10
	dec	de		;6
	or	0		;7 delay
	nop			;4 delay
	ld	a,d		;4
	or	e		;4
	ld	a,(ix)		;19
	ld	b,49		;7 set time constant for the next call of sa_byte
	jr	nz,sa_loop	;7/12
; Save the Fletcher's checksum
; timing: 
; between calls to sa_byte - 40+15 (delay), tc=57, must be 783-(tc-1)*13
	exx			;4
	ld	a,e		;4
	exx			;4
	ld	l,a		;4
	inc	b		;4 adjust the delay constant
	jp	$+3		;10 delay
	nop			;4 delay
	call	sa_byte		;17
	exx			;4
	ld	a,d		;4
	exx			;4
	ld	l,a		;4
	ld	b,57		;7
	or	0		;7
	nop			;4
	nop			;4
	call	sa_byte		;17
; Exit delay
	ld	b,0FFh
sa_delay:
	djnz	sa_delay
	ret



;--------- Encode and save a data byte
;in L - byte to save
;in B - delay constant
;in/out C - current running disparity and MIC/border bit status (bits 0-3, of them bit 0 inverted)
;t-states:
; from entry first out - 40+(B-1)*13
; from last out to exit (including ret) - 52
; between successive outs - 875/1750
; from last out to sa_bits - 33
; from sa_bits to out - 36+(B-1)*13
; between first and mid out for data "0" - 875
; from last out of prev byte to entry - must be 783-(B-1)*13
sa_byte:
	scf			;4 set carry flag to shift in the stop-bit first
sa_bits:
	rl	l		;8 shift out the next data bit and move in the stop-bit
	ret	z		;5/11 return if no more bits
sa_bitsd:
	djnz	sa_bitsd	;8/13 delay
	ld	a,c		;4 current state of out FE and RD
	out	(0feh),a	;11 first out, always flips the MIC bit
	jr	nc,sa_bits0	;7/12 branch on "0" data bit
	xor	0fh		;7 Flip RD and reset the C flag (past-stop bits)
	ld	c,a		;4
	ld	b,66		;7
sa_bits1:
	djnz	sa_bits1	;8/13
	or	0		;7 delay
	nop			;4 delay
	ld	b,63		;7
	jr	sa_bits		;12 
sa_bits0:
	ld	b,64		;7 delay constant for 
sa_bits01:
	djnz	sa_bits01	;8/13 delay
	xor	0fh		;7 Flip MIC/border bits, reset C flag (past-stop bits)
	or	0		;7 delay
	nop			;4 delay
	out	(0feh),a	;11
	ld	b,63		;7
	jp	$+3		;10 delay
	nop			;4 delay
	jr	sa_bits		;12






	savebin "saver.bin",start,0xC0
