/*
PROGRAM DESCRIPTION:

    dec soft chars
Downline loadable character set utility

Menu driver and font description file translator

AUTHORS:

    ya

CREATION DATE:


            C H A N G E   L O G

     Date     |   Name  | Description
--------------+---------+-------------------------------------------------------
20-JAN-1993 13:54:18.92        Implicit destination code in fnt file
 2-MAR-1993 12:00:02.66        Programm ident
15-MAR-1993    ya       Errors handler established during files opening
2-nov-1993  ya     rewriten to C
*/

#include <stdio.h>
#include <string.h>
#ifdef __BORLANDC__
#include <alloc.h>
#endif
#include <stdlib.h>
#include "decfnt.h"

#define EOS '\0'
#define EscStr "\033"
#define DcsStr "\033P"
#define StStr  "\033\\"
#define CsiStr "\033["
#define    DecFntId  "DEC font utility  V1.3 2-NOV-1993 "
typedef enum {ErrorLex,StopLex,
			  DcsLex,StLex,ImageIndexLex,EscLex,
			  ImageHdrLex,
			  PfnLex,PcnLex,PeLex,PcmwLex,PssLex,PtLex,PcmhLex,PcssLex,DscsLex,
              CmhLex,CmwLex,
			  CsiLex,CommentLex,ImageLex,DataLex } Lex_;

typedef struct
	{
    Lex_ lex;
    char *text;
    }_LexTab;
static _LexTab lex_tab[]=
{
 ImageHdrLex,TrImage,
 DcsLex,TrDcs,
 StLex,TrSt,
 EscLex,TrEsc,
 PfnLex,TrPfn,
 PcnLex,TrPcn,
 PeLex,TrPe,
 PcmwLex,TrPcmw,
 PssLex,TrPss,
 PtLex,TrPt,
 PcmhLex,TrPcmh,
 PcssLex,TrPcss,
 DscsLex,TrDscs,
 CmhLex,TrCmh,
 CmwLex,TrCmw,
 CsiLex,TrCsi,
 ErrorLex,NULL
};

/* globals  */
FILE    *in, *out;
int ipcn,
	isxbpn,
	sxOffSet,
	ipcss,
	icmh,
	icmw;
wordString_    Pfn,
    Pcn,
    Pe,
    Pcmw,
    Pss,
    Pt,
    Pcmh,
    Pcss,
    Dscs;
int     CellHeight,CellWidth;
StringList_    IntroSeq,FinalSeq;
int     ErrCount;

Cell_   Cell;
Cell_   *ChSet,*NewSet;
static int AcceptLex;
static Lex_ Lex;
static u_char OutLine[512],
              line[512],
              ch;
static int LineCount;
static int InFileEof;
static int CurrPos;
static int CreOutput=0;
static int max_x,max_y;

static void LexError()
{
   Lex=ErrorLex;
   fprintf(stderr,"\n  Undefined line control symbol at line:%d,line followed below.\n%s\n",
     LineCount,line);
}


static int LineRead()
{
    CurrPos=1;
    if (fgets(line,sizeof line-2,in))
        {
        int l = strlen(line)-1;
        if (line[l]=='\n')
            {
            line[l]=0;
            }
        LineCount++;
        return true;
        }
    InFileEof = TRUE;
    return false;
}

static Lex_ get_lex()
{
	_LexTab *p=lex_tab;
#define MATCH(src,pat) (memcmp(src,pat,sizeof pat -1)==0)
    for(;p->text!=NULL;p++)
    	{
		if (memcmp(line,p->text,strlen(p->text))==0)
        	return p->lex;
        }
    return ErrorLex;
}

static int ReadLex()
{
int l;
do
    {
    if (LineRead())
        {
        if ((l=strlen(line))<=0 || line[0]==' ')
            Lex=CommentLex;
        else
            {
            switch(line[0])
                {
                case '!':
                	Lex = get_lex();
                    break;
                case '|':
                    if (l<4)
                        Lex=DataLex;
                    else
                        {
                        if (line[3]!='|')
                            Lex=DataLex;
                        else
                            Lex=ImageLex;
                        }
                    break;
                case 'I':/* Image for "any_char" line */
                    Lex=ImageIndexLex;
                    break;
                default:
                    LexError();
                }/* end switch(line[0]) */
            }/* end if (l=strlen(line))<=0 || line[0]==' ' */
        }
    else
       {
       Lex=StopLex;
       return true;
       }
    }
while(Lex==ErrorLex);
return TRUE;
}


static void ReadImageLine()
{
	int y=-1,x,n;
    sscanf(line+1,"%d", &y);
    if ( y>=0)
    	{
        char *cp = line+4;
        for (x=0;*cp>=' ' && x<MaxCellWidth;cp++,x++)
            {
            if (*cp!=' ')
                Cell.c[x][y]=true;
            else
                Cell.c[x][y]=false;
            }
        }
    else
        {
        printf("\n Error in image ,line:%d,line followed below\n",LineCount);
        printf("%s\n\n",line);
        }
}


static void ProcessCell()
{
	int i,j;

	for(j = 0;j< MaxCellHeight;j++)
    	{
        for (i = 0;i<MaxCellWidth;i++)
            if (Cell.c[i][j])
                {
                max_x=max(i,max_x);
                max_y=max(max_y,j);
                }
        }
}

static void ReadImage()
{
	memset(&Cell,0,sizeof Cell);
    while(Lex==ImageLex)
        {
        ReadImageLine();
        ReadLex();
        }
	AcceptLex=false;
	if (CreOutput)
        ProcessCell();
    Cell.flag.used=1;
    memcpy(ChSet+ipcn+isxbpn+ipcss,&Cell,sizeof Cell);
    isxbpn++;
}



static int AssignIfMatch(char *dst,char *match)
{
	int lmatch=strlen(match);
    int lline = strlen(line);
	if ( lline>=lmatch && memcmp(line,match,lmatch)==0 )
       {
	   memcpy(dst,line+lmatch,lline-lmatch);
       dst[lline-lmatch]=EOS;
       return 1;
       }
    return 0;
}

#if 0
static void ReadParam()
{
	if (AssignIfMatch(Pcn,TrPcn))
    	return;
    else if (AssignIfMatch(Pfn,TrPfn))
    	return;
    else if(AssignIfMatch(Pe,TrPe))
    	return;
    else if (AssignIfMatch(Pss,TrPss))
    	return;
    else if (AssignIfMatch(Pcmh,TrPcmh))
    	return;
    else if (AssignIfMatch(Pcmw,TrPcmw))
    	return;
    else if (AssignIfMatch(Pcss,TrPcss))
    	return;
    else
		AssignIfMatch(Dscs,TrDscs);
}
#endif

static void WriteSet()
{
	SixelBitPattern_ pat;
    int k,i,j;
    char *cp;
	int c,n;
    Cell_ *p;

    /* calc cel width & height */
    for(c=0,p=ChSet;c<CharSetSize;c++,p++)
    	{
        if (p->flag.used==0)
        	continue;
        OutLine[0]=EOS;
	    for (cp=OutLine,k = 0;k<(max_y/6+1);k++)
		    {
            for(i = 0; i< max_x;i++)
                {
                pat =0;
                for( j = 0;j<6;j++)
                    pat|=(p->c[i][k*6+j])<<j;/*?? 0x80 >>j */
                *cp++=pat+'?';
                }
            *cp++='/';
            }
	    if (*(cp-1)=='/') *(cp-1)=';';/* erase last '/' */
	    *cp =EOS;
        fwrite(OutLine,strlen(OutLine),1,out);
        }
}

static void ReadDcs()
{
	max_x=max_y=0;
    icmh = 0;
    icmw = 0;
	for(;;)
    	{
        ReadLex();
        switch(Lex)
        	{
            case CommentLex:
            	continue;
            case PfnLex:
            	AssignIfMatch(Pfn,TrPfn);continue;
			case PcnLex:
            	AssignIfMatch(Pcn,TrPcn);continue;
			case PeLex:
            	AssignIfMatch(Pe,TrPe);continue;
			case PcmwLex:
            	AssignIfMatch(Pcmw,TrPcmw);continue;
			case PssLex:
            	AssignIfMatch(Pss,TrPss);continue;
			case PtLex:
            	AssignIfMatch(Pt,TrPt);continue;
			case PcmhLex:
            	AssignIfMatch(Pcmh,TrPcmh);continue;
			case PcssLex:
            	AssignIfMatch(Pcss,TrPcss);continue;
			case DscsLex:
            	AssignIfMatch(Dscs,TrDscs);continue;
            default: break;
			}
        break;
		}

	if (CreOutput)
		{
        sprintf(OutLine,"%s%s;%s;%s;%s;%s;%s;%s;%s{%s",DcsStr,
				Pfn,Pcn,Pe,Pcmw,Pss,Pt,Pcmh,Pcss,Dscs);
        fwrite(OutLine,strlen(OutLine),1,out);
        }

    ipcn = atoi(Pcn);
    ipcss = atoi(Pcss);
    isxbpn = 0;
	for(;;)
    	{
        char fmt[80];
        switch(Lex)
        	{
            case CommentLex:
				ReadLex();
                continue;
			case ImageLex:
				ReadImage();
                continue;
            case ImageHdrLex:
            	{
#if 0
                int image_dst=-1;
                sprintf(fmt,"%s%%x",TrImage);
            	sscanf(line,fmt,&image_dst);
                image_dst -=' ';
                if (image_dst>=0 && image_dst<CharSetSize)
					isxbpn = image_dst-ipcn-ipcss;
            	else
                    fprintf(stderr,"Wrong 'Image for hex:' string:\n%s\n",line);
#endif
                ReadLex();
            	continue;
                }
            case CmhLex:
            	{
                int h=-1;
                sprintf(fmt,"%s%%d",TrCmh);
            	sscanf(line,fmt,&h);
                if (h>0 && h<=MaxCellHeight)
					icmh= h;
            	else
                    fprintf(stderr,"Wrong 'Cmh ...:' string:\n%s\n",line);
				ReadLex();
                }
                continue;
            case CmwLex:
            	{
                int w=-1;
                sprintf(fmt,"%s%%d",TrCmw);
            	sscanf(line,fmt,&w);
                if (w>0 && w<=MaxCellWidth)
					icmw= w;
            	else
                    fprintf(stderr,"Wrong 'Cmw ...:' string:\n%s\n",line);
				ReadLex();
                }
                continue;
        	default:
            	break;
            }
        break;
        }

	while(Lex==CommentLex)
        ReadLex();
    if (max_x<icmw)
    	max_x = icmw;
    if (max_y<icmh)
    	max_y = icmh;
	WriteSet();
	if (CreOutput)
        {
        fwrite(StStr,sizeof StStr-1,1,out);
        }

    if ( Lex!=StLex)
        {
        printf(" Warning :dcs is not endded by ST\n");
        AcceptLex=false;
        }
	else
		AcceptLex=true;
}

void ReadEsc()
{
        String_ EscSeq;
        int l,lEsc;

        l=strlen(line);
        if ( l<(lEsc=strlen(TrEsc)))
			{
        	printf(" Error,fake esc introducer\n  line:%d,line followed.\n",LineCount);
        	printf("%s\n",line);
        	}
        else
	        {
        	memcpy(EscSeq,line+lEsc,l-lEsc);
            EscSeq[l-lEsc]=EOS;
        	if (CreOutput)
				{
            	fwrite(EscStr,sizeof EscStr-1,1,out);
            	fwrite(EscSeq,strlen(EscSeq),1,out);
            	}
        	IdentifyEsc(EscSeq,stdout);
        	}
	AcceptLex=true;
}

void ReadCsi()
{
	String_ CsiSeq;
	int l,lCsi;

	l=strlen(line);
    if (l<(lCsi=strlen(TrCsi)))
		{
        printf(" Error,fake Csi introducer\n  line:%d,line followed.\n",LineCount);
        printf("%s\n",line);
        }
     else
        {
        memcpy(CsiSeq,line+lCsi,l-lCsi);
        CsiSeq[l-lCsi]=EOS;
        if (CreOutput)
            {
            fwrite(CsiStr,sizeof CsiStr-1,1,out);
            fwrite(CsiSeq,strlen(CsiSeq),1,out);
            }
        IdentifyCsi(CsiSeq,stdout);
        }
	AcceptLex=true;
}

void ReadData()
{
}


void ReadSource()
{
	int loop=1;
    InFileEof=false;
    LineCount=0;
    AcceptLex=true;
    CurrPos=1;
    line[0]= EOS;
    while(loop && !InFileEof)
    	{
        if ( AcceptLex)
         	ReadLex();
        switch(Lex)
          	{
          	case CommentLex :
				AcceptLex=true;
                break;
			case DcsLex :
               	ReadDcs();
                break;
          	case EscLex :
               	ReadEsc();
                break;
          	case CsiLex :
              	ReadCsi();
                break;
          	case StopLex :
            	loop =false;
                break;
          	default:
              	printf(" Syntax Error at line %d, lex %d\n",LineCount,Lex);
              	printf("%s\n line skipped\n",line);
              	AcceptLex=true;
			}
        }
     printf("  Total %d lines.\n",LineCount);
}

void TrFontFile()
{
    /*
    FUNCTIONAL DESCRIPTION:

    Translate font deiscription into loadable font file.
    File::= line File

    line::= comment
    comment::= blank text

    line::= control_statement
    control_statement::=!ST
            !DCS
            !ESC
            !CSI
            !data

    line::= char_image_header
    char_image_header::= TrImage %02x ....

    line::= char_image_line
    image::= |nn| blanks&stars    -nn matrix line number 1..N


    FORMAL PARAMETERS:

    IMPLICIT INPUTS:

    IMPLICIT OUTPUTS:

    ROUTINE VALUE:

    SIDE EFFECTS:
    */


    char InFileName[FILENAME_MAX+1],OutFileName[FILENAME_MAX+1];

    fprintf(stderr,"\n");
    out=NULL;
    if ( ReadStr("Enter source file name>",InFileName)==0)
        return ;

    if ((in=fopen(InFileName,"r"))==NULL)
        {
        perror(InFileName);
        return ;
        }

    if ( ReadStr("Enter output font file name or press return>",OutFileName)!=0)
        CreOutput = TRUE;

#ifdef __MSDOS__
    if (CreOutput && (out=fopen(OutFileName,"wb"))==NULL)
#endif
#ifdef VMS
    if (CreOutput && (out=fopen(OutFileName,"wb","rfm=fix","mrs=512"))==NULL)
#endif
        {
        perror(OutFileName);
        fclose(in);
        return ;
        }

    ReadSource();
    if ( CreOutput)
        {
        fclose(out);
        }
    fclose(in);
}


void main()
{
    String_ choice;

    fprintf(stderr,"%s\n",DecFntId);
    /* init data */
    CellHeight=MaxCellHeight;
    CellWidth=MaxCellWidth;
    ChSet= (Cell_ *)malloc((sizeof (Cell_))*CharSetSize);
    NewSet = (Cell_*)malloc((sizeof (Cell_))*CharSetSize);
    if ( ChSet==NULL || NewSet== NULL)
        {
#ifdef __BORLANDC__
        fprintf(stderr,"core left %lu,try to get 2*%d\n",coreleft(),(sizeof (Cell_))*CharSetSize);
#endif
        fprintf(stderr,"No core\n");
        exit(4);
        }
    memset(&Cell,0,sizeof Cell);
    memset(ChSet,0,sizeof (CharSet_));
    memset(NewSet,0,sizeof (CharSet_));

    for(;;)
        {
#if 0
        fprintf(stderr,"\n          0.Exit\n          1.List font file\n          2.Translate font source file\nEnter your choice>");
        if (scanf("%s",choice)==1)
#endif
        if (ReadStr("\n          0.Exit\n          1.List font file\n          2.Translate font source file\nEnter your choice>",
        	choice)!=0)
            {
            switch(choice[0])
               {
               case  '0' :
                   break;
               case  '1' :
                   ListFontFile();
                   continue;
               case  '2' :
				   TrFontFile();
                   continue;
               default:
               		fprintf(stderr,"Wrong choice. Try again\n");
                    continue;
               }
            }
        break;
        }
    fprintf(stderr,"\nEnd.\n");
}