/*
MODULE DESCRIPTION:
	dec soft charsDownline loadable character set utility
    Read and list font file
    font file must be in binary format,no lf,cr in dcs.
AUTHORS:
		ya
CREATION DATE:
C H A N G E   L O G
     Date     |   Name  | Description
--------------+---------+-------------------------------------------------------
20-JAN-1993 19:33:22.71 fixed some bugs in put sixels to cell
15-MAR-1993	ya	   Errors handler established during files opening
*/


#include <stdio.h>
#include <string.h>
#ifdef __BORLANDC__
#include <alloc.h>
#endif
#include <stdlib.h>
#include "decfnt.h"


#define OUT (out==NULL?stdout:out)
extern FILE *in, *out;
extern int     CellHeight,CellWidth;
extern int  ipcn,
			isxbpn,
			sxOffSet,
			ipcss,
			icmh,
			icmw;
extern Cell_    Cell;
extern Cell_    *ChSet,*NewSet;
extern wordString_    Pfn,
    Pcn,
    Pe,
    Pcmw,
    Pss,
    Pt,
    Pcmh,
    Pcss,
    Dscs;

int skip_blank_image_lines=0;

int ReadStr(char* prompt,char* dst)
{
    fputs(prompt,stdout);
    gets(dst);
    return strlen(dst);
}

static SeqDefElm_	EscList[]={
"(%5", "Designating DEC supplemental graphic to g0",
")%5", "Designating DEC supplemental graphic to g1",
"*%5", "Designating DEC supplemental graphic to g2",
"+%5", "Designating DEC supplemental graphic to g3",
"(<","Designatig user-preferred supplemental to g0",
")<","Designatig user-preferred supplemental to g1",
"*<","Designatig user-preferred supplemental to g2",
"+<","Designatig user-preferred supplemental to g3",
"(B","Designatig ASCII to g0",
")B","Designatig ASCII to g1",
"*B","Designatig ASCII tog2",
"+B","Designatig ASCII to g3",
"0","Designating DEC special graphic",
"~","Map G1 into GR",
"n","Map G2into GL",
"}","Map G2 into GR",
"o","Map G3 into GL",
"|","Map G3 into GR",
"c","Reset to initial state",
0,0
};
void IdentifyEsc(char *EscSeq,FILE* to_file)
{	SeqDefElm_  *ep;
    if (to_file==NULL) return;
	for(ep=EscList;ep->seq!=NULL;ep++)
	   {
    	if ( strcmp(ep->seq,EscSeq)==0)
    		    {
    		    	    fprintf(to_file," %s\n",ep->txt);
    		    	    return ;
    		    };
    }
}

static char CsiFinal;
static SeqDefElm_ CsiFt[]=
{
  "s","Set left and right margins Pl;Pr",
  "r","Set top and bottom margins Pt;Pb",
  "t","Set page length Pn",
 0,0
};

static SeqDefElm_ CsiTab[]=
{
   "z","Default to draft quality.",
   "!p","Soft terminal reset ",
   "5i","Set printer controller mode on",
   "4i","Set printer controller mode off",
   "?3h","Set 132 columns mode",
   "?3l","Set 80 columns mode",
   "?7h","Set autowrap mode",
   "?7l","Set truncate mode",
   "0\"z","Default to draft quality.",
   "1\"z","Selects draft printing",
   "2\"z","Selects LQ printing",
   "3\"z","Selects memo printing",
   "4\"z","Selects NLQ printing",
   "w","Set horiz pitch to default",
   "0w","Set horiz pitch to default",
   "1w","Set horiz pitch to 10 char/inch",
   "2w","Set horiz pitch to 12 char/inch",
   "4w","set horiz pitch to 16.5 char/inch",
   "11w","Set horiz pitch to 17.1 char/inch",
   "5w","Set horiz pitch to 5 char/inch",
   "6w","Set horiz pitch to 6 char/inch",
   "8w","Set horiz pitch to 8.25 char/inch",
   "12w","Set horiz pitch to 8.55 char/inch",
   "z","Set vert pitch to default",
   "0z","Set vert pitch to default",
   "1z","Set vert pitch to6 lines/inch",
   "2z","Set vert pitch to 8 lines/inch",
   "3z","Set vert pitch to 12 lines/inch",
   "4z","Set vert pitch to 2 lines/inch",
   "5z","Set vert pitch to 3 lines/inch",
   "6z","Set vert pitch to 4 lines/inch",
   "0$~","Select status line type (>vt3xx)-none",
   "1$~","Select status line type (>vt3xx)-indicator",
   "2$~","Select status line type (>vt3xx)-host-writable",
   "0$}","Select active status display (>vt3xx)- main display",
   "1$}","Select active status display (>vt3xx)- status line",
   "$}","Select active status display (>vt3xx)- main display",
   "m","Select graphic rendition: all attributes off",
   "0m","Select graphic rendition: all attributes off",
   "1m","Select graphic rendition: bold",
   "4m","Select graphic rendition: underline",
   "5m","Select graphic rendition: blinking",
   "7m","Select graphic rendition: reverse video",
   "22m","Select graphic rendition:vt400 bold off",
   "24m","Select graphic rendition:vt400 underline off",
   "25m","Select graphic rendition:vt400 blinking off",
   "27m","Select graphic rendition:vt400 reverse video off",
  NULL,NULL
};

void IdentifyCsi(char* CsiSeq,FILE* to_file)
{
    SeqDefElm_ *ep;
    if (to_file==NULL) return;
    CsiFinal=CsiSeq[strlen(CsiSeq)-1];
    for(ep=CsiTab;ep->seq!=NULL;ep++)
    	if ( strcmp(ep->seq,CsiSeq)==0)
		    {
		    fprintf(to_file," %s\n",ep->txt);
		    return ;
		    }
    for(ep=CsiFt;ep->seq!=NULL;ep++)
    	if ( ep->seq[0]==CsiFinal)
        	{
    	    fprintf(to_file," %s CSI%s\n",ep->txt,CsiSeq+1);
    	    return ;
        	}
}

static void PutSixelToCell(Cell_ *Cell,u_char c,int x,int bpn)
{
    int y,i,m;
    SixelBitPattern_ pat;

    if ( x>=CellWidth) return ;

    pat=  c-(u_char)'?';
    m= (bpn+1)*6;
    if (m>CellHeight)
        {
        m = CellHeight;
        }

    for(i=0,y=bpn*6;y<m;y++,i++)
        {
        u_char c=(pat&(1<<i))?'*':' ';
        if (c=='*')
        	icmh= max(icmh,y);
        Cell->c[x][y]= c;
        }
};

static void FillCell(Cell_ *Cell,wordString_  Sixels,int  bpn)
{
    u_char *src;
    int i=0;
    for(src=Sixels;*src!=0;src++)
        {
        if (*src>'?')
            {
            PutSixelToCell(Cell,*src,i,bpn);
            }
        if (*src>='?')
        	{
			i++;
            icmw = max(i,icmw);
            }
        }
}


static void AddCell(Cell_ *Cell)
{
    int i,j;
    int AnyToPrint,AnyPrinted=0;
    u_char line[MaxCellWidth+1];

    i = ipcn+isxbpn+sxOffSet;
    fprintf(OUT,"\n\n%s%02x '%c'\n",TrImage,i,i);

    for(j= 0;j< CellHeight;j++)
        {
        line[0]=0;
        AnyToPrint=FALSE;
        for(i = 0;i< CellWidth;i++)
            if ( (line[i]=Cell->c[i][j])>' ')
            	{
                AnyToPrint=TRUE;
                AnyPrinted++;
                }
        line[i]=0;
        /* write if empty cell image line for fnt tranlator can sense new char */
        if (AnyToPrint==FALSE)
        	{
            if (skip_blank_image_lines && ((j+1<CellHeight)|| AnyPrinted>0))
            	continue;
            }
        fprintf(OUT,"|%02d|%s\n",j,line);
        }
    fprintf(OUT,"\n");
    memcpy(&ChSet[ipcn+isxbpn],Cell,sizeof *Cell);
}

#define    LexValSize  6
#define    EscLex  ESC
typedef u_char        LexCode_;
typedef u_char LexVal_[LexValSize+1];
typedef struct
    {
    LexCode_ LexCode;
    LexVal_ LexVal,LexName;
    }LexListElm_;


static   LexListElm_ LexTab[]=
{
{ESC, {ESC},"ESC"}
,{ CAN,{CAN},"CAN"}
,{ DCS,{DCS},"DCS"}
,{ DCS,{ESC,'P'},"DCS"}
,{ CSI,{CSI},"CSI"}
,{ CSI,{ESC,'['},"CSI"}
,{ SS2,{SS2},"SS2"}
,{ SS2,{ESC,'N'},"SS2"}
,{ SS3,{SS3},"SS3"}
,{ SS3,{ESC,'O'},"SS3"}
,{ PM,{PM},"PM"}
,{ PM,{ESC,'^'},"PM"}
,{ APC,{APC},"APC"}
,{ APC,{ESC,'_'},"APC"}
,{ ST,{ST},"ST"}
,{ ST,{ESC,'\\'},"ST"}
,{ OSC,{OSC},"OSC"}
,{ OSC,{ESC,']'},"OSC"}
,{0,{0},0}
};

static     int Accept;
static     u_char ch;
static     LexCode_ Lex;
static     int LineCount;
static     char line[512];
static     int CurrPos;
static     int InFileEof;

static  u_char param[100],
               interm[100],
               final[10];
static u_char *data=NULL;

static void _write(u_char *vs)
{
    int l= strlen((char*)vs);
    while(l>80)
        {
        fprintf(OUT,"%80.80s\n",vs);
        vs+=80;
        l-= 80;
        }
    fprintf(OUT,"%s",vs);
}


static int ParseDelim(u_char **src,u_char *dst,u_char delim)
{
    u_char *str = *src;
    int done;
    for(done=0;(*dst = *str)!=0 && *dst!=delim ; dst++,str++,done++);
    *dst=0;

    *src = (*str)?++str:str;
    return done;
}


static int ParseParam(u_char *str)
{
    fprintf(OUT,"\n");
    ParseDelim(&str,Pfn,';');   fprintf(OUT,"%s%s\n",TrPfn,Pfn);
    ParseDelim(&str,Pcn,';');   fprintf(OUT,"%s%s\n",TrPcn,Pcn);
    ParseDelim(&str,Pe,';');    fprintf(OUT,"%s%s\n",TrPe,Pe);
    ParseDelim(&str,Pcmw,';');  fprintf(OUT,"%s%s\n",TrPcmw,Pcmw);
    ParseDelim(&str,Pss,';');	fprintf(OUT,"%s%s\n",TrPss,Pss);
    ParseDelim(&str,Pt,';');    fprintf(OUT,"%s%s\n",TrPt,Pt);
    ParseDelim(&str,Pcmh,';');  fprintf(OUT,"%s%s\n",TrPcmh,Pcmh);
    ParseDelim(&str,Pcss,';');	fprintf(OUT,"%s%s\n",TrPcss,Pcss);
    ipcn=0;
	sscanf((char*)Pcn,"%d",&ipcn);
    isxbpn=0;
    ipcss = atoi(Pcss);
    sxOffSet=ipcss+(int)' ';
    return true;
};


static int ParseInterm()
{
return true;
};


static int ParseData(u_char *str)
{
int bpn;
u_char *dst;
wordString_ sxbp,Sixels;
u_char *ptr;

for(dst = Dscs;(*dst++=*str++)<'0';);
*dst=0;
if (strlen((char*)Dscs)>0)
    fprintf(OUT,"\n%s%s\n",TrDscs,Dscs);


while((ParseDelim(&str,sxbp,';')))
    {
    fprintf(OUT," Sxbp:%s\n",sxbp);
    bpn=0;
    ptr= sxbp;
    memset(&Cell,' ',sizeof (Cell_));
    while(ParseDelim(&ptr,Sixels,'/'))
        {
        FillCell(&Cell,Sixels,bpn);
        bpn++;
        };
    AddCell(&Cell);
    isxbpn++;
    }
return true;
};

static int ReadChar(u_char *ch_ptr)
{
    if (fread(ch_ptr,1,1,in)>0)
        {
        return true;
        }
    else
        {
        *ch_ptr=0;
        InFileEof = true;
        return false;
        }
}

#if 0
static LexVal_ LexName(LexCode_ lex)
{
    int i;
    LexName:='';
    i:=1;
    FOR i := 1 TO LexTabAmount DO
     IF Lex=LexTab[i].LexCode
     THEN
     {
     LexName:=LexTab[i].lexName;
     GOTO lexNameExit
     };
}
#endif
static LexCode_ ReadLex()
{
    int i,recognized,n;
    LexListElm_  *lp, *last;
    u_char  buf[sizeof lp->LexVal+1], *src;
    long file_pos;

    if (Accept)
        ReadChar(&ch);

    file_pos = ftell(in);
    memset(buf,0,sizeof buf);

    recognized=n=0; last=NULL;
    for(lp=LexTab;lp->LexCode;lp++)
        {
        src = lp->LexVal;
        for(i=0;i<n && buf[i]== *src;i++,src++);
        if (i<recognized)
            continue;
        if (*src==0 && i>recognized )
            {/* another match */
            last = lp;
            recognized = i;
            continue;
            }
        while(*src >0 && ch == *src )
            {/* read while matched */
            src++;
            buf[n++]= ch;
            ReadChar(&ch);
            }
        if (*src==0)
            {/* match ok */
            last = lp;
            recognized = n;
            }
        }
    if (recognized>0 )
        {/* set file pos to last */
        fseek(in,file_pos+(recognized-1),SEEK_SET);
        }
    if (last)
        return last->LexCode;
    return AnyChar;
}


static int ReadParam(u_char *param)
{
    u_char *dst=param;
    if (Accept)
        ReadChar(&ch);
    while(!InFileEof  && ch>='0' && ch<='?')
         {
         *dst++=ch;
         ReadChar(&ch);
         }
    *dst = 0;
    Accept=false;
    if (strlen((char*)param)>0)
       return true;
    else
        return false;
}


static int ReadInterm(u_char *interm)
{
    u_char *dst=interm;
    if ( Accept)     ReadChar(&ch);
    while(!InFileEof && ch>=' ' && ch<='/')
        {
        *dst++ = ch;
        ReadChar(&ch);
        }
    *dst =0;
    Accept=false;
    if (strlen((char*)interm)>0)
        return true;
    else
        {
        return false;
        }
}


static int ReadData(u_char *data)
{
    u_char* dst=data;
    int loop=true;
    if (Accept)     ReadChar(&ch);
    while(!InFileEof && loop)
        {
        switch(ch)
            {
            case ST:
            case ESC:
            case CAN:
            case SUB:
                loop = false;
                break;
            default:
                if (ch>=128 && ch<=159)
                    {
                    loop = false;
                    }
                else
                    {
                    *dst++ = ch;
                    ReadChar(&ch);
                    }
                break;
            }
        }
    *dst = 0;
    Accept=false;
    if (strlen((char*)data)>0)
        return true;
    else
        return false;
}


static int ReadFinal(u_char *final)
{
    u_char *dst=final;
    if (Accept) ReadChar(&ch);

    if ( ch>='@' && ch<='~')
        {
        *dst++ =ch;
        *dst =0;
        Accept=true;
        return true;
        }
    else
        {
        *dst =0;
        Accept=false;
        return false;
        }
}


static int ReadEscFinal(u_char* final)
{
    u_char *dst=final;
    if (Accept) ReadChar(&ch);

    if ( ch>='0' && ch<='~')
        {
        *dst++ =ch;
        *dst =0;
        Accept=true;
        return true;
        }
    else
        {
        *dst =0;
        Accept=false;
        return false;
        }
}


static void ReadESC()
{
    char buf[MAX_ESC_BUF];

    fprintf(OUT,"\n%s",TrEsc);

/*    EscBeg=LineCount;*/
    Accept=true;

    if ( ReadInterm(interm))
        _write(interm);

    if (ReadEscFinal(final))
        {
        _write(final);fprintf(OUT,"\n");
        sprintf(buf,"%s%s",interm,final);
        IdentifyEsc(buf,OUT);
        Accept=true;
        }
    else
        {
        fprintf(OUT,"\n Error in ESC sequence :char %02x\n",ch);
        Accept=false;
        }
}


static void ReadCSI()
{
    char buf[MAX_CSI_BUF];

    fprintf(OUT,"\n%s",TrCsi);

    Accept=true;
    if (ReadParam(param))
        _write(param);

    if ( ReadInterm(interm))
        _write(interm);
    if ( ReadFinal(final))
        {
        _write(final);fputc('\n',OUT);
        sprintf(buf,"%s%s%s",param,interm,final);
        IdentifyCsi(buf,OUT);
        }
    else
        {
        fprintf(OUT,"\n Wrong CSI :char:%02x\n",ch);
        Accept=false;
        }
}


static void ReadDCS()
{
	icmh=icmw = 0;
    fprintf(OUT," DECDLD contol string: \n%s",TrDcs);

    Accept=true;

    if ( ReadParam(param))
        _write(param);

    if ( ReadInterm(interm))
        _write(interm);

    if ( ReadFinal(final))
        {
        _write(final);
        if ( final[0]=='{')
            {
            ParseParam(param);
            ParseInterm();
            }
        else
            fprintf(OUT,"\n Unrecognized dcs.\n");
        }
    else
        fprintf(OUT," No final char in DCS at char:%02x\n",ch);

    if ( ReadData(data))
    	{
        ParseData(data);
        fprintf(OUT,"%s%d\n",TrCmh,icmh);
        fprintf(OUT,"%s%d\n",TrCmw,icmw);
        }
    else
        _write(data);

    Lex = ReadLex();
    if (Lex== ST)
        {
        Accept=true;
        fprintf(OUT,"%s",TrSt);
        }
    else
        {
        fprintf(OUT,"\n Error in DCS,no ST, char:%02x\n",ch);
        Accept=false;
        }
    fputc('\n',OUT);
}


void ListFontFile()
{
    char InFileName[FILENAME_MAX+1],ListFileName[FILENAME_MAX+1];
    int Listing=0;

    fprintf(stderr,"\n");
    if (data==NULL)
       data = (u_char*)malloc(MAXDATASIZE+1);
    if (data==NULL)
        {
#ifdef __BORLANDC__
        fprintf(stderr,"core left %lu,try to get %d\n",coreleft(),(MAXDATASIZE+1));
#endif
        fprintf(stderr,"No core\n");
        return ;
        }
    if ( ReadStr("Enter file name to list>",InFileName)==0)
        return ;

    if ((in=fopen(InFileName,"rb"))==NULL)
        {
        perror(InFileName);
        return ;
        }

    out=NULL;
    if ( ReadStr("Enter listing file name or press return>",ListFileName)!=0
       && (out=fopen(ListFileName,"w"))==NULL)
        {
        perror(ListFileName);
        fclose(in);
        return ;
        }


    ReadStr("Write blank image lines(Y/N)?>",line);
    if (line[0]=='y' || line[0]=='Y')
        {
        skip_blank_image_lines=0;
        }
    else
        skip_blank_image_lines=1;

    fprintf(OUT,"     The DECFNT utility output\n    Contents of file:%s\n"
        ,InFileName);
    Listing=TRUE;

    InFileEof=FALSE;
    line[0]=0;
    CurrPos=0;LineCount=0;
    Accept=TRUE;
    memset(NewSet,0,sizeof (CharSet_));
    memset(ChSet,0,sizeof (CharSet_));

    while(!InFileEof)
        {
        if (Accept)
            Lex=ReadLex();
        if (InFileEof)
            fprintf(OUT,"\n **EOF**\n");
        else
            {
            switch(Lex)
                {
                case  ESC :
                    Accept=true;
                    ReadESC();
                    break;
                case CSI :
                    Accept=true;
                    ReadCSI();
                    break;
                case DCS:
                case OSC:
                case PM:
                case APC:
                    Accept=true;
                    ReadDCS();
                    break;
                }
            }
        };
    fclose(in);

    if (Listing)
        {
        fprintf(OUT,"     End of DECFNT.\n");
        if (out)
           fclose(out);
        }
}
