/*
**
** FACILITY:
**         miscelaneous functions
** ABSTRACT:
**         erase cr ,lf from file & write it in binary mode
** AUTHORS:
**        ya
** CREATION DATE:
**          3.11.93
** CHANGE LOG:
**
*/

#include <stdio.h>
#include <dir.h>
void main(int argc,char *argv[])
{
    char *fnam=NULL;
    long int readed,writed;
    int c;

    if (argc<2 || argc>3)
        {
            fprintf(stderr,"usage: dropcrlf infile [outfile]\n");
            exit(4);
        }
    if (freopen(argv[1],"rb",stdin)==NULL)
        {
        perror("Cann't open infile");
        exit(4);
        }
    switch(argc)
        {
        case 2:
             if ((fnam=tmpnam(NULL))==NULL)
                {
                perror("Cann't create tmpname");
                exit(4);
                }
             if (freopen(fnam,"wb",stdout)==NULL)
                {
                perror("Cann't open tmpfile");
                exit(4);
                }
             break;
        case 3:
             if (freopen(argv[2],"wb",stdout)==NULL)
                {
                perror("Cann't open outfile");
                exit(4);
                }
        }
    readed=writed=0l;
    while((c=getchar())!=EOF)
        {
#define CR  13
#define LF  10
        readed++;
        switch(c)
            {
            case CR:
            case LF:
                continue;
            default:
                putchar(c);
                writed++;
            }
        }
    if (ferror(stdin))
        {
        perror(argv[1]);
        fclose(stdout);
        if (fnam)
            {
            unlink(fnam);
            }
        else
           unlink(argv[2]);
        }
    else
        {
        fprintf(stderr,"readed %7ld\nwrited %7ld\n",readed,writed);
        fclose(stdout);
        fclose(stdin);
        if (fnam)
            {
            char drive[MAXDRIVE+1],dir[MAXDIR+1],
                 name[MAXFILE+1],ext[MAXEXT+1];
            char bak[FILENAME_MAX+1];
            fnsplit(argv[1],drive, dir,
                      name,ext);
            sprintf(bak,"%s%s%s.bak",drive,dir,name);
            unlink(bak);
            rename(argv[1],bak);
            rename(fnam,argv[1]);
            }
        }
}
