	DEVICE ZXSPECTRUM128

	ORG 0x8000

	di

	ld a,1
	out (0xfe),a
	call waitKey
	call noKey

	ld hl,0x6000		; fill sample (00,01...FE,FF,FF,FE,...,01,00)
st_1	ld (hl),l
	inc l
	jr nz,st_1
	inc h
st_2	ld a,l
	cpl
	ld (hl),a
	inc l
	jr nz,st_2

	ld a,0x28
	ld (0x5800),a

	ld hl,0x6200		; read sec 0
	ld bc,0x0000
	ld de,0x0000
	call readSec
	ld hl,0x6200		; compare with sample
	call compSec

	ld a,0x10
	ld (0x5801),a

	ld hl,0x6000		; save sample to sec 1
	ld bc,0x0000
	ld de,0x0001
	call wrSec
	ld hl,0x6400		; read sec 1
	ld bc,0x0000
	ld de,0x0001
	call readSec
	ld hl,0x6400		; compare with sample
	call compSec

	ld a,0x20
	ld (0x5802),a
	ld a,4
	out (0xfe),a
	jr $

setLBA	ld a,b
	and 0x0f
	or 0xe0		; lba, master
	out (0xd0),a
	ld a,c
	out (0xb0),a
	ld a,d
	out (0x90),a
	ld a,e
	out (0x70),a
	ret

readSec	call setLBA
	ld a,1		; 1 sec
	out (0x50),a
	ld a,0x20	; read sec
	out (0xf0),a
	ld bc,0x0010
	inir
	inir
	ret

wrSec	call setLBA
	ld a,1
	out (0x50),a
	ld a,0x30
	out (0xf0),a
	ld bc,0x0010
	otir
	otir
	ret

compSec	ld de,0x6000
	call comps0
	inc h
comps0	ld a,(de)
	cp (hl)
	jr nz,compERR
	inc de
	inc l
	jr nz,comps0
	ret

compERR	ld a,2
	out (0xfe),a
	jr $

waitKey	xor a
	in a,(0xfe)
	cpl
	and 31
	jr z,waitKey
	ret

noKey	xor a
	in a,(0xfe)
	cpl
	and 31
	jr nz,noKey
	ret

	SAVESNA "test.sna",0x8000