	DEVICE ZXSPECTRUM128

	MODULE TRACKMO

;SYSTEM_VARIABLES
        ORG	#6180
M_PAGE  EQU	#11
MUSIC   EQU	#DB00

TEK_PAGE        DEFB	M_PAGE;#10...#17
TEK_SCREEN      DEFB	#00;0-SCREEN 0
                        ;8-SCREEN 1
MUSIC_PAGE      DEFB	M_PAGE
ADR_MUSIC       DEFW	MUSIC
TEK_FX          DEFB	#01

MAIN_BLOCK

        DI	
        LD	(S_SP0+1),SP
	LD	SP,#5fff
        LD	A,#00
        LD	(COLOR+1),A
        CALL	CLS
        LD	A,M_PAGE
        CALL	PAGE
;        CALL	MUSIC
        LD	HL,#6000
        LD	DE,#6001
        LD	BC,#101
        LD	(HL),#61
        LDIR	
        LD	A,#C3
        LD	(#6161),A
        LD	HL,PRER
        LD	(#6162),HL
        LD	A,#60
        LD	I,A
        IM	2
        EI	
        CALL	INTRO
        LD	A,#02
        LD	(TEK_FX),A
        CALL	SETKA

EXIT    LD	A,(MUSIC_PAGE)
        CALL	PAGE
;        CALL	MUSIC
        LD	A,#10
        CALL	PAGE
        LD	A,#47
        LD	(COLOR+1),A
        CALL	CLS
S_SP0   LD	SP,#0000
        LD	HL,#2758
        LD	IY,#5C3A
        EXX	
        IM	1
        EI	
HANG	JP	HANG
        RET	

PRER:   PUSH	AF
        EX	AF,AF'
        PUSH	AF
        PUSH	HL
        PUSH	DE
        PUSH	BC
        EXX	
        PUSH	HL
        PUSH	DE
        PUSH	BC
        PUSH	IX
        PUSH	IY

        LD	DE,RETURN
        PUSH	DE
        LD	(SAVE_SP+1),SP

        LD	A,(TEK_FX)
        ADD	A,A
        LD	L,A
        LD	H,0
        LD	DE,IM2_FX
        ADD	HL,DE
        LD	SP,HL
        POP	HL
SAVE_SP LD	SP,#0000
        JP	(HL)
RETURN
        LD	A,(MUSIC_PAGE)
        LD	L,A
        LD	A,(TEK_SCREEN)
        OR	L
        CALL	PAGE2

;        CALL	MUSIC+6

        LD	A,(TEK_PAGE)
        LD	L,A
        LD	A,(TEK_SCREEN)
        OR	L
        CALL	PAGE

        POP	IY
        POP	IX
        POP	BC
        POP	DE
        POP	HL
        EXX	
        POP	BC
        POP	DE
        POP	HL
        POP	AF
        EX	AF,AF'
        POP	AF
        EI	
        RET	

PAGE    PUSH	BC
        LD	BC,#7FFD
        OUT	(C),A
        PUSH	AF
        AND	#17
        LD	(TEK_PAGE),A
        POP	AF
        AND	#08
        LD	(TEK_SCREEN),A
        POP	BC
        RET	

PAGE2   PUSH	BC
        LD	BC,#7FFD
        OUT	(C),A
        POP	BC
        RET	

CLS     SUB	A
        OUT	(#FE),A
        LD	HL,#4000
        LD	DE,#4001
        LD	BC,#1800
        LD	(HL),L
        LDIR	
COLOR   LD	(HL),#00
        LD	BC,#2FF
        LDIR	
        LD	A,#17
        CALL	PAGE
        LD	HL,#4000
        LD	DE,#C000
        LD	BC,#1B00
        LDIR	
        LD	A,(TEK_PAGE)
        CALL	PAGE
NO_FX   RET	


IM2_FX  DEFW	NO_FX
        DEFW	EXPLOED
        DEFW	NO_FX
        DEFW	NO_FX

EXPLOED
        CALL	INSTALL
        CALL	BORDER
        RET	

INSTALL LD	A,(MUSIC_PAGE)
        LD	L,A
        LD	A,(TEK_SCREEN)
        OR	L
        CALL	PAGE2

        LD	A,(#E073)
        CP	#04
        JR	NZ,OBHD_1
        LD	A,(#E075)
        CP	#21
        JR	Z,SET_BAIT
        CP	#97
        JR	Z,SET_BAIT

OBHD_1  LD	A,(#DF9C)
        CP	#04
        RET	NZ
        LD	A,(#DF15)
        CP	#21
        JR	Z,SET_BAIT
        CP	#97
        JR	Z,SET_BAIT
        RET	

SET_BAIT
        SUB	A
        LD	(BORDER),A
        RET	

BORDER  RET	
        LD	A,(TEK_PAGE)
        AND	7
        CP	5
        JR	NC,OBHD_P2
        LD	A,#15
        CALL	PAGE2
        JR	ADR_C

OBHD_P2 LD	A,(TEK_SCREEN)
        OR	A
        JR	NZ,OBH_P
        LD	A,#17
        CALL	PAGE2
        JR	ADR_C
OBH_P   LD	A,#1D
        CALL	PAGE2

ADR_C   LD	HL,COLOR_T
        LD	A,(HL)
        OR	A
        JR	NZ,OBHOD
        LD	HL,COLOR_T
        LD	(ADR_C+1),HL
        LD	A,#C9
        LD	(BORDER),A
        RET	

OBHOD   LD	(S_SP+1),SP
        INC	HL
        LD	(ADR_C+1),HL
        LD	L,A
        RRCA	
        RRCA	
        RRCA	
        AND	#07
        OUT	(#FE),A
        LD	DE,#D800
        LD	A,(DE)
        AND	#07
        OR	L
        LD	L,A
        LD	H,A
        LD	SP,#DB00
        LD	A,24
N_COLOR DUP	16
        PUSH	HL
        EDUP	
        DEC	A
        JR	NZ,N_COLOR
S_SP    LD	SP,#0000
        RET	

COLOR_T DEFB	#50,#48,#40,#40
        DEFB	#40,#40,#40,#00
;-----------------------------------------

SPRITE  EQU	#7000
SCR_TAB EQU	#7000
SINUS   EQU	#7400
FONT    EQU	#C000

        ORG	SPRITE
        INCBIN	"@_trackmo\bin\tfont.bin"
        ORG	SINUS
        INCBIN	"@_trackmo\bin\SINUS.bin"

INTRO   EI	
        LD	(STEK+1),SP
        LD	A,#10
        CALL	PAGE
        CALL	SET_FONT
        CALL	SET_SCR_TAB
M_INTRO EI	
        HALT	

        LD	A,(ADR_X+1)
        LD	E,A
        LD	A,(ADR_Y+1)
        LD	D,A
        PUSH	DE

ADR_MES LD	HL,MESSAGE
        LD	A,(HL)
        CP	#FE
        JR	Z,EXIT_I
        LD	(ADD_X+1),A
        INC	HL
        LD	A,(HL)
        LD	(ADR_Y2+1),A
        INC	HL
LOOP_B  LD	A,(HL)
        CP	#FF
        JR	NZ,OBHOD_T

TIME    LD	A,#40
        DEC	A
        LD	(TIME+1),A
        OR	A
        JR	NZ,OBHOD2
        LD	A,#40
        LD	(TIME+1),A
        INC	HL
        LD	(ADR_MES+1),HL
        JR	OBHOD2

OBHOD_T PUSH	HL
        CALL	SET_BUKVA
        LD	A,(ADD_X+1)
        ADD	A,2
        LD	(ADD_X+1),A
        POP	HL
        INC	HL
        JR	LOOP_B

OBHOD2  POP	DE
        LD	A,D
        ADD	A,4
        LD	(ADR_Y+1),A
        LD	A,E
        ADD	A,6
        LD	(ADR_X+1),A

        LD	A,(TIME+1)
        CP	#30
        JR	NZ,OBH_T
        SUB	A
        LD	(COLOR_UP),A
OBH_T   CP	#06
        JR	NZ,OBH_T2
        SUB	A
        LD	(COLOR_DN),A

OBH_T2  CALL	 COLOR_DN
        CALL	 COLOR_UP
STEK    LD	SP,#0000
        JP	M_INTRO
EXIT_I  LD	SP,(STEK+1)
        RET	

SET_BUKVA:
        LD	(S_SP2+1),SP
        LD	A,(HL)
        LD	L,A
        LD	H,0
        ADD	HL,HL
        ADD	HL,HL
        ADD	HL,HL
        ADD	HL,HL
        LD	E,L
        LD	D,H
        ADD	HL,HL
        ADD	HL,DE
        EX	DE,HL
ADR_X   LD	HL,SINUS
        LD	A,L
        ADD	A,#18
        LD	(ADR_X+1),A
        LD	A,(HL)
        RRA	
        RRA	
        RRA	
        AND	#1F
ADD_X   ADD	A,#4
        LD	B,A
        LD	A,(HL)
        AND	7
        ADD	A,A
        LD	C,A
        ADD	A,A
        ADD	A,A
        SUB	C
        ADD	A,#C0
        LD	H,A
        LD	L,0
        ADD	HL,DE
        PUSH	HL
ADR_Y   LD	HL,SINUS+#20
        LD	A,L
        ADD	A,#18
        LD	(ADR_Y+1),A
        LD	A,(HL)
        ADD	A,A
        LD	E,A
        LD	D,0
ADR_Y2  LD	HL,SCR_TAB+#60
        ADD	HL,DE
        POP	DE
        LD	SP,HL
        EX	DE,HL
        LD	C,#FF
        DUP	24
        POP	DE
        LD	A,E
        ADD	A,B
        LD	E,A
        LDI	
        LDI	
        EDUP	

S_SP2   LD	SP,#0000
        RET	

SET_FONT:
        CALL	SET_FIRST_FONT
        CALL	SET_NEXT_FONTS
        RET	

SET_NEXT_FONTS:
        LD	A,7
LOOP_F3 EX	AF,AF'
SOXR_HL LD	HL,FONT
SOXR_DE LD	DE,FONT+#600
        LD	BC,#600
        LDIR	
        LD	(SOXR_HL+1),HL
        LD	(SOXR_DE+1),DE
        LD	BC,768
LOOP_F2 PUSH	BC
        AND	A
        RR	(HL)
        INC	HL
        RR	(HL)
        INC	HL
        POP	BC
        DEC	BC
        LD	A,B
        OR	C
        JR	NZ,LOOP_F2
        EX	AF,AF'
        DEC	A
        JR	NZ,LOOP_F3
        LD	HL,FONT
        LD	(SOXR_HL+1),HL
        LD	DE,FONT+#600
        LD	(SOXR_DE+1),DE
        RET	

SET_FIRST_FONT:
        LD	BC,768
        LD	DE,SPRITE
        LD	HL,FONT
LOOP_F  LD	A,(DE)
        LD	(HL),A
        INC	HL
        INC	DE
        LD	(HL),#00
        INC	HL
        DEC	BC
        LD	A,B
        OR	C
        JR	NZ,LOOP_F
        RET	

SET_SCR_TAB:
        LD	HL,SCR_TAB
        LD	DE,#4000
        LD	B,192
LOOP_T  LD	(HL),E
        INC	HL
        LD	(HL),D
        INC	HL
        CALL	COR_DE
        DJNZ	LOOP_T
        RET	

COR_DE  INC	D
        LD	A,D
        AND	7
        RET	NZ
        LD	A,E
        ADD	A,#20
        LD	E,A
        RET	C
        LD	A,D
        SUB	8
        LD	D,A
        RET	

COLOR_UP:
        RET	
ADR_C1  LD	HL,C_TABLS
        LD	A,(HL)
        CP	#FF
        JR	NZ,OBH_C
        LD	A,#C9
        LD	(COLOR_UP),A
        LD	HL,C_TABLS
        LD	(ADR_C1+1),HL
        RET	
OBH_C   LD	(S_SP1+1),SP
        INC	HL
        LD	(ADR_C1+1),HL
        JR	PR_COLOR

COLOR_DN:
        RET	
ADR_C2  LD	HL,C_TABLS2
        LD	A,(HL)
        CP	#FF
        JR	NZ,OBH_C2
        LD	A,#C9
        LD	(COLOR_DN),A
        LD	HL,C_TABLS2
        LD	(ADR_C2+1),HL
        LD	HL,#4800
        LD	DE,#4801
        LD	BC,#800
        LD	(HL),L
        LDIR	
        RET	
OBH_C2  LD	(S_SP1+1),SP
        INC	HL
        LD	(ADR_C2+1),HL
        JR	PR_COLOR

PR_COLOR
        LD	HL,#5800
        LD	E,A
        LD	A,(HL)
        AND	#F8
        OR	E
        LD	L,A
        LD	H,A
        LD	SP,#5B00
        LD	A,24
N_COLO1 DUP	16
        PUSH	HL
        EDUP	
        DEC	A
        JR	NZ,N_COLO1
S_SP1   LD	SP,#0000
        RET	

C_TABLS
        DEFB	#40,#41,#42,#43,#44,#45,#FF
C_TABLS2
        DEFB	#45,#44,#43,#42,#41,#40,#FF

MESSAGE
        DEFB	#06;FLASH INC.
        DEFB	#A0
        DEFB	#05,#0B,#00,#12,#07,#1F
        DEFB	#08,#0D,#02,#1A
        DEFB	#FF

        DEFB	#01;P.R.E.S.E.N.T.S
        DEFB	#A0;
        DEFB	#0F,#1A,#11,#1A,#04,#1A,#12
        DEFB	#1A,#04,#1A,#0D,#1A,#13
        DEFB	#1A,#12
        DEFB	#FF

        DEFB	#09;TRACKMO
        DEFB	#A0
        DEFB	#13,#11,#00,#02,#0A,#0C,#0E
        DEFB	#FF

        DEFB	#00;SPECIAL TO L.A.S
        DEFB	#A0
        DEFB	#12,#0F,#04,#02,#08,#00,#0B
        DEFB	#1F,#13,#0E,#1F,#0B,#1A,#00
        DEFB	#1A,#12
        DEFB	#FF

        DEFB	#09;C O D E
        DEFB	#A0
        DEFB	#02,#1F,#0E,#1F,#03,#1F,#04
        DEFB	#FF

        DEFB	#0A;MR.NIK
        DEFB	#A0
        DEFB	#0C,#11,#1A,#0D,#08,#0A
        DEFB	#FF

        DEFB	#05;ALEX RAIDER
        DEFB	#A0
        DEFB	#00,#0B,#04,#17,#1F,#11,#00
        DEFB	#08,#03,#04,#11
        DEFB	#FF

        DEFB	#09;MYSTERY
        DEFB	#A0
        DEFB	#0C,#18,#12,#13,#04,#11,#18
        DEFB	#FF

        DEFB	#07;M U S I C
        DEFB	#A0
        DEFB	#0C,#1F,#14,#1F,#12,#1F,#08
        DEFB	#1F,#02,#FF

        DEFB	#0A;MR.NIK
        DEFB	#A0
        DEFB	#0C,#11,#1A,#0D,#08,#0A
        DEFB	#FF

        DEFB	#0B;G F X
        DEFB	#A0
        DEFB	#06,#1F,#05,#1F,#17
        DEFB	#FF

        DEFB	#0A;MR.NIK
        DEFB	#A0
        DEFB	#0C,#11,#1A,#0D,#08,#0A
        DEFB	#FF

        DEFB	#09;MYSTERY
        DEFB	#A0
        DEFB	#0C,#18,#12,#13,#04,#11,#18
        DEFB	#FF

        DEFB	#09;DR.BOND
        DEFB	#A0
        DEFB	#03,#11,#1A,#01,#0E,#0D,#03
        DEFB	#FF

        DEFB	#09;
        DEFB	#A0
        DEFB	#1F
        DEFB	#FF

        DEFB	#05;START DEMO!
        DEFB	#A0
        DEFB	#12,#13,#00,#11,#13,#1F,#03
        DEFB	#04,#0C,#0E,#1B
        DEFB	#FF
        DEFB	#FE

SETKA   EI	
        LD	(S_FX2+1),SP
        LD	A,#45
        LD	(COLOR+1),A
        CALL	CLS

        LD	HL,NET_TABLE
        LD	(POINT),HL
        CALL	TABLE_PREPARE

TOPFX2  EI	
        HALT	
        DI	

SC_PAGE LD	A,#17
        XOR	#0A
        LD	(SC_PAGE+1),A
        CALL	PAGE

        CALL	CLEAR_SCREEN
        EI	
        CALL	ENGINE_2

S_FX2   LD	SP,#0000
        LD	A,#7F
        IN	A,(#FE)
        RRA	
        JR	C,TOPFX2
        LD	A,#10
        CALL	PAGE
        RET	

CLEAR_SCREEN
        LD	(ST+1),SP
        LD	SP,#D800
        LD	B,48
        LD	HL,0
CLL
        DUP	64
        PUSH	HL
        EDUP	
        DJNZ	CLL
ST      LD	SP,0
        RET	

POINT   DEFW	0
ENGINE_2
        LD	IX,(POINT)
        LD	A,(IX)
        INC	IX
        AND	A
        CP	#FF
        JR	NZ,ENG2_P
        LD	IX,NET_TABLE
        LD	A,(IX)
        INC	IX
ENG2_P  AND	A
        CALL	NZ,DDRW
        LD	(POINT),IX
        RET	

DDRW    LD	B,A
DDRW_L  PUSH	BC
        PUSH	IX
        LD	A,(SC_PAGE+1)
        AND	#F8
        OR	#10
        CALL	PAGE
        LD	E,(IX)
        LD	D,(IX+1)
        LD	L,(IX+2)
        LD	H,(IX+3)
        LD	A,175
        SUB	D
        LD	D,A
        LD	A,175
        SUB	H
        LD	H,A
        LD	A,(SC_PAGE+1)
        CALL	PAGE
        CALL	LINE
        POP	IX
        LD	BC,4
        ADD	IX,BC
        POP	BC
        DJNZ	DDRW_L
        RET	

        INCLUDE	"@_trackmo\linev1.asm"

NET_TABLE
        INCBIN	"@_trackmo\bin\FLIP.bin"

        SAVESNA "tmp\trackmo.sna",MAIN_BLOCK
	ENDMODULE