#ifdef MAKE_DOC

<section><title id="math.crc16_init">crc16_init</title>

<variablelist><title>室:</title>
<varlistentry><term>DE</term>
<listitem>㪠⥫  ᨢ , 512 </listitem></varlistentry>
<varlistentry><term>BC</term>
<listitem>樥 童 (筮 0x1021)</listitem></varlistentry>
</variablelist>

<para>㭪 樠 ⠡  ண 
16-ࠧ來 横᪮ 筮  () 㭪樥
<link endterm="math.crc16_fast"/>.   ॣ DE ।
 ᨢ  ࠧ஬  512   ࠭ ⠭ ⠡.
 ॣ BC 㪠뢠 ஦騩 童 .
 ⥫㭨樮 ⮪ ᯮ ४
 祭: 1021h.
</para>

</section>

<section><title id="math.crc16_fast">crc16_fast</title>

<variablelist><title>室:</title>
<varlistentry><term>DE</term>
<listitem>㪠⥫  ⠭ ⠡ .</listitem></varlistentry>
<varlistentry><term>IX</term>
<listitem>㪠⥫  ᨢ </listitem></varlistentry>
<varlistentry><term>BC</term>
<listitem>ࠧ ᨢ   </listitem></varlistentry>
<varlistentry><term>HL</term>
<listitem>砫쭮 祭 </listitem></varlistentry>
</variablelist>
<variablelist><title>室:</title>
<varlistentry><term>HL</term>
<listitem>祭 </listitem></varlistentry>
</variablelist>

<para>㭪 뢠 祭     
砫 ᮬ   ॣ IX    
  ॣ BC.  ॣ DE ।  ⠡
।⥫쭮 ⠭   㭪樨
<link endterm="math.crc16_init"/>.
 ॣ HL 㪠뢠 砫쭮  ஬筮 ( 砥
᫥⥫쭮   ᪮쪨 ᨢ) 祭 .
  頥  ॣ HL.</para>
<para>
 ࠡ  㭪樨  祭
믮 㭪樨 <link endterm="math.crc16"/>,   ᯮ
࠭ ⠭ ⠡,  ६  ࠡ ⥫쭮 .</para>
<para>
ਬ ᯮ짮 㭪権 <link endterm="math.crc16_init"/> 
<link endterm="math.crc16_fast"/>    䠩 
㬥饣 楫  ⨢ :</para>
<programlisting>
<![CDATA[
	ld hl, -512-4096 ; 뤥 :
	add hl, sp	; 512   ⠡ 
	ld sp, hl	;  4096  ⥭ 䠩
			
	ex de, hl	;  ⠡  = SP+0
	ld bc, 0x1021	
	call crc16_init	; 樠 ⠡ 

	ld hl, 0	; 砫쭮 祭 
	push hl
loop:
	ld hl, 512
	add hl, sp	;   䠩 = SP+512
	push hl
	call read_file	; 뢠  䠩	

	pop ix		; :  䠩
	ld bc, 4096	; ࠧ  䠩
	ld hl, 0
	add hl, sp
	ex de, hl	;  ⠡  = SP+0
	pop hl		; ஬筮 祭 
	call crc16_fast
	push hl

	call eof	; ஢ઠ ⨦  䠩
	jr nz, loop	;   

	pop de		; 筮 祭 
	ld hl, 512+4096
	add hl, sp
	ld sp, hl	; ᢮ 

	ex de, hl	;  HL = ⠭ 祭 
	ret
]]>
</programlisting>

</section>

#else

 EXPORT	global crc16_init  ; de=*(512bytes), bc=polynom
 EXPORT	global crc16_fast  ; ix=*data, bc=size, de=tab*512, hl=crc -> hl=crc

; !
;  㭪樨  16-ࠧ來 
; ᯮ ⮫쪮 ᤢ !

	psect text
#if 0
        org 0x6000
crctab equ 0x8000
        ld de, crctab
        ld bc, 0x1021
        call crc16_init

        ld hl, 0
        ld ix, 0x3d00
        ld bc, 0x300
        ld de, 0x1021
        call crc16

        ld hl, 0
        ld ix, 0x3d00
        ld bc, 0x300
        ld de, crctab
        call crc16_fast


      ; call flatcher

        ret 
#endif 


; 㭪 樠 ⠡ CRC.
; de= ࠬ饭 ⠡ (512 ),
; bc= (0x1021 ४ CCITT).
crc16_init:
        push ix 
	db 0xdd	; IX next
        ld l, e 
        inc d 
        inc d 
	db 0xdd	; IX next
        ld h, d 
        ld e, c 
        ld d, b 
        ld c, 0
crc_i0:
        ld l, 0
        ld h, c 
        dec h 
        ld b, 8
crc_i1:
        add hl, hl 
        jr nc, crc_i2
        ld a, l 
        xor e 
        ld l, a 
        ld a, h 
        xor d 
        ld h, a 
crc_i2:  djnz crc_i1
        dec ix 
        ld (ix+0), l 
	db 0xdd	; IX next
        dec h 
        ld (ix+0), h 
	db 0xdd	; IX next
        inc h 
        dec c 
        jr nz, crc_i0
        pop ix 
        ret 

;  (⠡筠) 㭪  CRC-16,
; ॡ 樠樨 㭪樥 crc16_init
; ix=*data, bc=size,
; de=⠡ CRC, hl=砫쭮 祭
;  室 -> hl=⠭ 祭
crc16_fast:
        push de 
        exx 
        pop de 
        exx 
crc16f0:
        ld a, b 
        or c 
        ret z 
        ld a, h 
        xor (ix)
        inc ix 
        exx 
        ld l, a 
        ld h, 0
        adc hl, de 
        ld a, (hl) 
        inc h 
        exx 
        xor l 
        ld h, a 
        exx 
        ld a, (hl) 
        exx
        ld l, a 
        dec bc 
        jr crc16f0


#endif

