.include "tn2313def.inc"


.equ	freq	= 11059200
.equ	baud4800	= (freq/(16*4800))-1
.equ	baud9600	= (freq/(16*9600))-1
.equ	baud19200	= (freq/(16*19200))-1
.equ	baud38400	= (freq/(16*38400))-1
.equ	baud115200 = (freq/(16*115200))-1
.equ	TX_DAT	= 2
.equ	RX_DAT	= 3
.equ	RD_STAT	= 4
.equ	TX_READY	= 5
.equ	RX_READY	= 6

.def	null	= r0
.def	fill	= r1
.def	datain	= r2
.def	dataout	= r3
.def	statin	= r18
.def	copystat	= r5
.def	statout	= r19
.def	temp	= r16
.def	temp1	= r17
.def	flags	= r20
.def	tempsreg	= r8

	.org	0
	rjmp	reset


	.org	0x100
reset:
	ldi	temp, ramend
	out	spl, temp
	clr	null
	ser	temp
	mov	fill, temp
	ldi	temp, 0b00010100
	out	portd, temp
	ldi	temp, 0b00011100
	out	ddrd, temp
	out	ddrb, null
	ldi	temp, 0
	out	ubrrh, temp
	ldi	temp, 143
	out	ubrrl, temp
	ldi	temp, 0b00000110
	out	ucsrc, temp
	ldi	temp, 0b00011000
	out	ucsrb, temp
	clr	copystat
	
loop:
	cbi	portd, RD_STAT
	nop
	nop
	in	statin, pinb
	sbi	portd, RD_STAT
	andi	statin, 0x03
	cp	statin, copystat
	breq	nx0
	cpi	statin, 0x00
	breq	setbaud4800
	cpi	statin, 0x01
	breq	setbaud9600
	cpi	statin, 0x02
	breq	setbaud19200
	cpi	statin, 0x03
	breq	setbaud38400

nx0:
	sbic	pind, TX_READY
	rjmp	transmit
nx1:
	sbic	ucsra, rxc
	rjmp	recive
	rjmp	loop

setbaud4800:
	ldi	temp, high(baud4800)
	out	ubrrh, temp
	ldi	temp, low(baud4800)
	mov	copystat, statin
	rjmp	nx0

setbaud9600:
	ldi	temp, high(baud9600)
	out	ubrrh, temp
	ldi	temp, low(baud9600)
	mov	copystat, statin
	rjmp	nx0

setbaud19200:
	ldi	temp, high(baud19200)
	out	ubrrh, temp
	ldi	temp, low(baud19200)
	mov	copystat, statin
	rjmp	nx0

setbaud38400:
	ldi	temp, high(baud38400)
	out	ubrrh, temp
	ldi	temp, low(baud38400)
	mov	copystat, statin
	rjmp	nx0

transmit:
	sbis	ucsra, udre
	rjmp	transmit
	cbi	portd, TX_DAT
	nop
	nop
	in	temp, pinb
	sbi	portd, TX_DAT
	out	udr, temp
	rjmp	loop

recive:
	in	temp, udr
	out	ddrb, fill
	out	portb, temp
	nop
	sbi	portd, RX_DAT
	nop
	nop
	cbi	portd, RX_DAT
	out	ddrb, null
	rjmp	loop
