; -----------------------------------------------------------------------------
; NIRVANA ENGINE by Einar Saukas - early beta version
; A Bicolor (Multicolor 8x2) Full-Screen Engine
;
; To be compiled with PASMO - http://pasmo.speccy.org/
; -----------------------------------------------------------------------------

; Default location of btiles table (48 bytes per tile)
TILE_IMAGES     EQU 48000


; -----------------------------------------------------------------------------
        org     $de00

; -----------------------------------------------------------------------------
bitmaps:
; lookup table with screen coordinates
REPT 8
        dw      0
ENDM
REPT 22, ROWREPT
REPT 4, LIN2REPT
hrow   DEFL (ROWREPT+1)/8
lrow   DEFL (ROWREPT+1)%8
        dw      16384 + hrow*2048 + LIN2REPT*512 + lrow*32
ENDM
ENDM

; -----------------------------------------------------------------------------
attribs:
; lookup table with render attribute coordinates
REPT 8
        dw      0
ENDM
REPT 88, RACEREPT
        dw      race_raster + RACEREPT*83 - 51
ENDM
REPT 8
        dw      0
ENDM

; -----------------------------------------------------------------------------
; Fill specified tile position with attribute value (in 502T)
;
; Params:
;     A = attribute value (0-255)
;     D = pixel line (0-192, even values only)
;     E = char column (0-30)
;
; WARNING: Computer will crash if an interrupt occurs during execution!
; -----------------------------------------------------------------------------
fill_tile_attr:
; preserve stack pointer
        ld      (exit_fill+1), sp

; calculate first routine attribute address
        ld      hl, attribs
        ld      b, 0
        ld      c, d                    ; pixel line
        add     hl, bc
        ld      sp, hl

        ld      h, deltas/256
        ld      l, e                    ; char column
        inc     l
        ld      c, (hl)                 ; BC = 1st delta (column offset)
        inc     l
        ld      l, (hl)                 ; HL = 2nd delta (column offset)
        ld      h, b
        sbc     hl, bc
        ex      de, hl                  ; DE = difference between column offsets

; update attribute addresses to specified value
REPT 8
        pop     hl
        add     hl, bc
        ld      (hl), a
        add     hl, de
        ld      (hl), a
ENDM

exit_fill:
; restore stack pointer
        ld      sp, 0
        ret

; -----------------------------------------------------------------------------
; Draw tile at specified position (in 1746T)
;
; Params:
;     A = tile index
;     D = pixel line (0-192, even values only)
;     E = char column (0-30)
;
; WARNING: Computer will crash if an interrupt occurs during execution!
; -----------------------------------------------------------------------------
draw_tile:
; preserve stack pointer
        ld      (exit_draw+1), sp

; calculate screen bitmap lookup address
        ld      h, bitmaps/256
        ld      l, d
        ld      sp, hl

; preserve values
        ld      b, e
        ld      c, h

; calculate tile image address
        ld      h, 0
        ld      l, a
        ld      d, h
        ld      e, l
        add     hl, hl
        add     hl, de
        add     hl, hl
        add     hl, hl
        add     hl, hl
        add     hl, hl
        ld      de, TILE_IMAGES
        add     hl, de

; draw bitmap lines
REPT 8
        pop     de
        ld      a, e
        add     a, b
        ld      e, a
        ldi
        ldi
        dec     de
        dec     e
        inc     d
        ldi
        ldi
ENDM

; calculate routine attribute address
        ex      de, hl
        ld      hl, attribs-bitmaps-16
        add     hl, sp
        ld      sp, hl
        ld      h, deltas/256
        ld      l, b
        inc     l

        ld      c, (hl)
        ld      b, 0
        inc     l
        ld      a, (hl)
        ex      af, af'

; set 1st column of routine attributes
REPT 8
        pop     hl
        add     hl, bc
        ld      a, (de)
        ld      (hl), a
        inc     de
ENDM

        ex      af, af'
        add     a, c
        jr      c, last_column
        sub     c
        ld      c, a
        ld      hl, -16
        add     hl, sp
        ld      sp, hl

; set 2nd column of routine attributes
REPT 7
        pop     hl
        add     hl, bc
        ld      a, (de)
        ld      (hl), a
        inc     de
ENDM
        pop     hl
        add     hl, bc
        ld      a, (de)
        ld      (hl), a

exit_draw:
; restore stack pointer
        ld      sp, 0
        ret

last_column:
        ld      b, 26
delay_last:
        djnz    delay_last
        jr      exit_draw

; -----------------------------------------------------------------------------
main_engine:
; preserve all registers
        push    af
        push    bc
        push    de
        push    hl
        ex      af, af'
        exx
        push    af
        push    bc
        push    de
        push    hl
        push    ix
        push    iy

; draw 8 tiles
        ld      de, 0                   ; D = pixel line, E = char column
        ld      a, 0                    ; A = tile
        call    draw_tile
REPT 7
        ld      de, 0                   ; D = pixel line, E = char column
        ld      a, 0                    ; A = tile
        call    draw_tile+4
ENDM

; synchronize with the raster beam
        ld      bc, $0c06
        ld      a, 14
        jr      sync_raster
delay_128k:
        ld      b, $0f

sync_raster:
        nop                             ; extra delay
sync_raster_loop:
        djnz    sync_raster_loop
        ld      b, a
        dec     c
        ld      hl, ($4000)             ; synchronize
        jr      nz, sync_raster

; wait for the raster beam
        ld      b, 12
wait_raster:
        djnz    wait_raster

; preserve stack pointer
        ld      (exit_raster+1), sp

        ld      hl, ($4000)             ; synchronize

; race the raster beam to update attributes on screen at the right time
race_raster:
REPT 22, ROWREPT
REPT 4, LINREPT
        ld      sp, $5822+(ROWREPT*32)+5    ; reference columns 5 and 6
        ld      hl, 0                       ; columns 27 and 28(*)
        ld      de, 0                       ; columns 7 and 8(*)
        ld      bc, 0                       ; columns 9 and 10(*)
        exx
        ld      hl, 0                       ; columns 11 and 12(*)
        ld      de, 0                       ; columns 19 and 20(*)
        ld      bc, 0                       ; columns 3 and 4(*)
        ld      ix, 0                       ; columns 1 and 2(*)
        ld      iy, 0                       ; columns 5 and 6 (*)
        ld      ($5820+(ROWREPT*32)+1), ix  ; columns 1 and 2
        push    iy                          ; columns 5 and 6
        push    bc                          ; columns 3 and 4
        ld      sp, $5822+(ROWREPT*32)+19   ; reference columns 19 and 20
        ld      ix, 0                       ; columns 17 and 18(*)
        push    de                          ; columns 19 and 20
        ld      de, 0                       ; columns 13 and 14(*)
        ld      bc, 0                       ; columns 15 and 16(*)
        push    ix                          ; columns 17 and 18
        push    bc                          ; columns 15 and 16
        push    de                          ; columns 13 and 14
        push    hl                          ; columns 11 and 12
        exx
        push    bc                          ; columns 9 and 10
        push    de                          ; columns 7 and 8
        ld      sp, $5822+(ROWREPT*32)+27   ; reference columns 27 and 28
        push    hl                          ; columns 27 and 28
        ld      hl, 0                       ; columns 21 and 22(*)
        ld      de, 0                       ; columns 23 and 24(*)
        ld      bc, 0                       ; columns 25 and 26(*)
        push    bc                          ; columns 25 and 26
        push    de                          ; columns 23 and 24
        push    hl                          ; columns 21 and 22
        ld      hl, 0                       ; columns 29 and 30(*)
        ld      ($5820+(ROWREPT*32)+29), hl ; columns 29 and 30
        sbc     hl, hl                      ; extra delay
ENDM
ENDM

exit_raster:
; restore stack pointer
        ld      sp, 0

; available entry-point for additional interrupt routines
        ld      hl, 0

; restore all registers
        pop     iy
        pop     ix
        pop     hl
        pop     de
        pop     bc
        pop     af
        exx
        ex      af, af'
        pop     hl
        pop     de
        pop     bc
        pop     af
        jp      $38

; -----------------------------------------------------------------------------
; RAND USR 64995 to activate engine
        di
        ld      a, ($004c)
        and     2
        ld      (delay_128k-1), a
        ld      a, $fe
        ld      i, a
        im      2
        ei
        ret

; -----------------------------------------------------------------------------
; RAND USR 65012 to deactivate engine
        di
        ld      a, $3f
        ld      i, a
        im      1
        ei
        ret

; -----------------------------------------------------------------------------
; interrupt address at $fdfd
        jp      main_engine

; -----------------------------------------------------------------------------
; jump vector table at addresses $fe00-$ff00
REPT 257
        defb    $fd
ENDM

; -----------------------------------------------------------------------------
deltas:
; lookup table with deltas (column offsets)
        db      75, 75, 76, 71, 72, 79, 80, 58, 59, 61, 62, 65, 66, 97, 98, 100, 101
        db      93, 94, 68, 69, 115, 116, 118, 119, 121, 122, 55, 56, 127, 128, 128

; -----------------------------------------------------------------------------
