// --- [ rs232.c ] ------------------------------------------------------------
// tabwidth 3
#include <avr/io.h>
#include <avr/pgmspace.h>  
#include "rs232.h"

// ----------------------------------------------------------------------------
// 
void rs232_init(void)
{
UBRRL = TEILER;	
UBRRH = 0;
UCSRB |= (0<<RXCIE | 1<<TXEN | 0<<RXEN);
//UCSRC |= (1<<URSEL | 0<<UMSEL) | (1<<UCSZ1) | (1<<UCSZ0);
// URSEL - Achtung bei ATmega 8
UCSRC |= (0<<UMSEL) | (1<<UCSZ1) | (1<<UCSZ0);
}

// ----------------------------------------------------------------------------
// ein einzelnes Zeichen auf COM ausgeben
void put_c(uint8_t Zeichen)
{
while(!(UCSRA & (1<<UDRE)));
UDR = Zeichen;
}

// ----------------------------------------------------------------------------
// einen String auf COM ausgeben
void put_s(char *s)
{
while(*s)
	{
	put_c(*s);
	s++;
	}
}

// ----------------------------------------------------------------------------
// gibt einen String aus dem Flash aus
void puts_p(const char *progmem_s)
{
register char c;
while ( (c = pgm_read_byte(progmem_s++)) )
	{
   put_c(c);
	}
}

// ----------------------------------------------------------------------------
// wandelt Byte in Hexdarstellung um und gibt Hex auf COM aus
void print_hexbyte(unsigned char i)
{
unsigned char h;
    
h = i; // & 0xF0;              	// High nibble
h = h>>4;
h = h + '0';
    
if (h > '9') h += 7;

i &= 0x0F;         					// Low nibble
i +='0';
if (i > '9') i += 7;

put_c('0');
put_c('x');
put_c(h);
put_c(i);
put_c(' ');
}

// --- [ eof ] ----------------------------------------------------------------