// --- [ soft_spi_master.c ] --------------------------------------------------
// Software SPI, SPI-Mode 3 (CPOL = 1, CPHA = 1)
// Ruhepegel = high, Setup at falling edge, sample at rising edge

#define SPI_PORT 			PORTB		// PORT fr SPI
#define SPI_PIN			PINB		// PIN  fr SPI
#define SPI_DDR			DDRB		// DDR  fr SPI
#define SPI_SEL			PB0		// Selectpin
#define SPI_CLK 			PB1		// Clockpin
#define SPI_MOSI			PB2		// MasterOut -> Ausgang
#define SPI_MISO			PB4		// MasterIn  -> Eingang

#define SPI_WAIT			5			// Wartezeit in usec fr 1/2 Takt 
											// Takt dauert 2*5us -> 100KHz
#include <avr/io.h>
#include <util/delay.h>

void spi_wait(void);					// Warteschleife fr 1/2 Takt

// ----------------------------------------------------------------------------
// schaltet die Aus-/Eingnge fr eine Software-SPI Kommunikation als Master
void spi_master_init(void)
{											// Ausgnge schalten
SPI_DDR  |=  (1<<SPI_MOSI | 1<<SPI_SEL | 1<<SPI_CLK);
SPI_PORT |=  (1<<SPI_MOSI | 1<<SPI_SEL | 1<<SPI_CLK); // auf high ziehen
SPI_DDR  &= ~(1<<SPI_MISO);		// Eingang schalten
}

// ----------------------------------------------------------------------------
// schreibt genau ein Byte raus und liest ein Byte ein 
// (das lesen ist noch nicht getestet) 

uint8_t spi_out(uint8_t spi_out)
{
register uint8_t i;
register uint8_t spi_in = 0;
											// alle Ausgnge liegen auf high
SPI_PORT &= ~(1<<SPI_SEL);			// Select auf low legen
spi_wait();								

for (i = 0; i < 8; i++)	
	{										
	SPI_PORT &= ~(1<<SPI_CLK);		// Clock auf low
											// Datenbyte setzen whrend clock low ist
	if (spi_out & 0x01)	 			// wenn Bit.0 gesetzt
		{
		SPI_PORT |= (1<<SPI_MOSI);	// dann MOSI auf high
		}
	else
		{
		SPI_PORT &= ~(1<<SPI_MOSI);// sonst MOSI auf low
		}
	spi_out = spi_out >> 1;			// das Ausgabebyte um 1 nach rechts schieben	
	
	spi_wait();							// einen halben Takt warten

	SPI_PORT |= (1<<SPI_CLK);		// Clock auf high
	
	if (SPI_PIN & 1<<SPI_MISO)		// Datenbit ber MISO einlesen
		{
		spi_in |= 0x80;				// Bit.7 setzen
		}
	
	spi_wait();							// einen halben Takt warten

	spi_in  = spi_in  >> 1;			// das Empfangsbyte nach rechts schieben

	}										// das Ganze nun noch 7x je Byte

											// alle Pins wieder auf high
SPI_PORT |= (1<<SPI_MOSI | 1<< SPI_SEL | 1<<SPI_CLK);					

return(spi_in);
}

// ----------------------------------------------------------------------------
// 1/2 Takt warten
void spi_wait(void)
{
_delay_us(SPI_WAIT);
}

// --- [ eof ] ----------------------------------------------------------------
