// --- [ mouse.h ] ------------------------------------------------------------

												// Prescaler fr Timer0 = 64
												// (256 * 64) / 7.372.800 = 2.22ms
#define PRESCALE64	(1<<CS01 | 1<< CS00)
#define PORTDATA	PORTD					// PORT fr Clock und Data des PS2-Gertes
#define PINDATA   PIND					// PIN  fr Clock und Data des PS2-GErtes
#define DDRDATA	DDRD					// DDR  fr PORT / PIN
#define DATAPIN	PD4					// Pin  fr Data			
#define CLOCKPIN  PD2					// Pin  fr Clock


#define PS2_BUFFER 32					// muss 2^x sein (4, 8, 16, 32)
#define PS2_MASK	PS2_BUFFER - 1		// andernfalls die Logik der berlaufkontrolle ndern

#define TRUE		1
#define FALSE		0
														// Kommandos (und Antworten) der Maus
#define MS_RESET							0xFF	// CMD fr Reset der Maus (->ACK)
#define MS_RESEND							0xFE	// CMD fr letztes Zeichen erneut senden (bei Fehler)
#define MS_ERROR							0xFC	// -> Fehlermeldung anstelle eines ACK
#define MS_ACK								0xFA	// -> Besttigung der Maus
#define MS_SET_DEFAULTS					0xF6	// Standardeinstellung, Stream-Mode (->ACK)
#define MS_DISABLE_DATA_REPORTING	0xF5	// deaktivieren (->ACK)
#define MS_ENABLE_DATA_REPORTING		0xF4	// wieder aktivieren (->ACK)
#define MS_SET_SAMPLE_RATE				0xF3	// (->ACK), dann Rate senden (->ACK)
#define MS_GET_DEVICE_ID				0xF2	// (->ACK, Device-ID) =0x00 fr PS2
#define MS_SET_REMOTE_MODE				0xF0  // remote-mode (->ACK)
#define MS_SET_WRAP_MODE				0xEE	// wrap-mode (->ACK)
#define MS_RESET_WRAP_MODE				0xEC	// end wrap-mode (->ACK)
#define MS_READ_DATA						0xEB	// (->ACK + 3 Byte movement data packet)
#define MS_SET_STREAM_MODE				0XEA	// stream-mode (->ACK)
#define MS_STATUS_REQUEST				0xE9	// (->ACK + 3 Byte status packet)
#define MS_SET_RESOLUTION				0xE8	// (->ACK) dann resolution senden (->ACK)
#define MS_SET_SCALING_2_1				0xE7  // (->ACK)
#define MS_SET_SCALING_1_1				0xE6	// (->ACK)

#define Y_OVF								7		// Die Bedeutung der Bits in ms_ctrl
#define X_OVF								6
#define Y_SIGN								5
#define X_SIGN								4
#define BUTTON_M							2
#define BUTTON_R							1
#define BUTTON_L							0

#define CURSOR_LEFT						7
#define CURSOR_RIGHT						6
#define CURSOR_DOWN						5
#define CURSOR_UP							4

#ifndef EXTERN
#define EXTERN extern
#endif

EXTERN void    PS2_init(void);
EXTERN void		PS2_clear_buffer(void);
EXTERN uint8_t PS2_cmd(uint8_t cmd);
EXTERN uint8_t PS2_is_byte_in_buffer(void);
EXTERN uint8_t PS2_get_byte_from_buffer(void);

// --- [ eof ] ----------------------------------------------------------------

