#include "config.h"

// Ansteuerung eines HD44780 kompatiblen LCD im 4-Bit-Interfacemodus
// http://www.mikrocontroller.net/articles/AVR-GCC-Tutorial
//


//LCD
void lcd_data(unsigned char temp1);
void lcd_command(unsigned char temp1);
void lcd_send(unsigned char data);
void lcd_string(char *data);
void lcd_enable(void);
void lcd_init(void);
void lcd_clear(void);
void lcd_eep_string(const unsigned char *data);
void lcd_eep_customchar(const unsigned char *chardata);


//LCD-Befehle
#define CMD_SetEntryMode         0x04
#define CMD_SetDisplayAndCursor  0x08
#define CMD_SetIFOptions         0x20
#define CMD_SetCGRAMAddress      0x40    // fr Custom-Zeichen
#define CMD_SetDDRAMAddress      0x80    // zum Cursor setzen

//Makros fr LCD
#define Line1() SetCursor(1,0)	//An den Anfang der 1. Zeile springen
#define Line2() SetCursor(2,0)	//An den Anfang der 2. Zeile springen

#define SetCursor(y, x) lcd_command((uint8_t)(CMD_SetDDRAMAddress + (0x40*(y-1)) + x)) //An eine bestimmte Position springen

#define LCDLoadCustomChar(addr) lcd_command(CMD_SetCGRAMAddress | (addr<<3))	//Custom-Zeichen laden

//Eigene Zeichen
#define LCD_CHAR_DIODE  0	//Dioden-Icon; wird als Custom-Character erstellt

#ifdef LCD_CYRILLIC
	#define LCD_CHAR_OMEGA  1	//Omega-Zeichen als Custom-Zeichen erzeugen
	#define LCD_CHAR_U  2		//-Zeichen als Custom-Zeichen erzeugen
#else
	#define LCD_CHAR_OMEGA  244	//Omega-Zeichen
	#define LCD_CHAR_U  228		//-Zeichen
#endif
  
// LCD Befehle
 
#define CLEAR_DISPLAY 0x01
 
// Pinbelegung fr das LCD, an verwendete Pins anpassen
 
#define LCD_PORT      PORTB
#define LCD_DDR       DDRB
#define LCD_RS        PB4
#define LCD_EN1       PB5
