; , 26.12.2013
;    8080 exerciser by Ian Bartholomew

bdos		.equ	5

FlagK		.equ	00100000b
FlagAC		.equ	00010000b
FlagP		.equ	00000100b
FlagV		.equ	00000010b


		.org	100h

		di
		xra	a
		out	10h
		lxi	sp,100h
		mvi	a,0C3h
		sta	0
		sta	5
		lxi	h,Restart
		shld	1
		lxi	h,bdosDispatch
		shld	6

; 
		call	Cls
		mvi	a,0C9h
		sta	38h
		ei
		hlt
		lxi	h, colors+15
colorset:
		mvi	a, 88h
		out	0
		mvi	c, 15
colorset1:	mov	a, c
		out	2
		mov	a, m
		out	0Ch
		dcx	h
		out	0Ch
		out	0Ch
		dcr	c
		out	0Ch
		out	0Ch
		out	0Ch
		jp	colorset1
		mvi	a,255
		out	3

Restart:
		call	Cls
		lxi	h,0E0FFh
		shld	cursor
		lxi	d,Logo1Txt
		mvi	c,9
		call	bdos
		lxi	d,Logo2Txt
		mvi	c,9
		call	bdos
		lxi	h,Tests
TestsLoop:
		mov	a,m
		ora	a
		jz	EndTest
		xchg
		mvi	c,9
		call	bdos
		xchg
		call	SkipTillBuck
		mov	a,m
		inx	h
		cpi	2
		cz	TestType2
		cpi	6
		cz	TestType6
		cpi	7
		cz	TestType7
		cpi	8
		cz	TestType8
		jmp	TestsLoop
EndTest:
		lxi	d,EndTstTxt
		mvi	c,9
		call	bdos
neverend:
		jmp	neverend		


SkipTillBuck:
		mvi	a,'$'
		cmp	m
		inx	h
		rz
		jmp	SkipTillBuck

Tests:
		.db "arhl  $"
		.db 2		; 
		arhl		; 

		.db "rdel  $"
		.db 6		; 
		rdel		; 

		.db "dad b $"
		.db 7		; 
		dad b		; 

		.db "dsub  $"
		.db 7		; 
		dsub		; 

		.db "dsub  $"
		.db 8		; 
		dsub		; 


;  
		.db 0


TestType7:
		push	psw
		push	b
		push	d
		push	h
		mov	a,m
		sta	Tst7Instr
		call	initcrc
		lxi	h,Tst7SetOper+1
		shld	SetTst7Op1Adr+1
		lxi	h,Tst7SetOper2+1
		shld	SetTst7Op2Adr+1
		call	Tst7InstrLoop

		lxi	h,Tst7SetOper+2
		shld	SetTst7Op1Adr+1
		lxi	h,Tst7SetOper2+2
		shld	SetTst7Op2Adr+1
		call	Tst7InstrLoop

		call	PrintKV
		lxi	d,FlgACtxt
		mvi	c,9
		call	bdos
		lxi	h,crcval3
		call	phex8
		lxi	d,CRLF
		mvi	c,9
		call	bdos

		pop	h
		inx	h
		pop	d
		pop	b
		pop	psw
		ret


Tst7InstrLoop:
Tst7SetFlg:
		mvi	c,0	;
		push	b
		pop	psw
Tst7SetOper:
		lxi	h,0	; 
Tst7SetOper2:
		lxi	b,0	; 
Tst7Instr:
		nop		;   
		push	psw
		pop	b
		mov	a,c
		push	psw
		ani	FlagK
		lxi	h,crcval
		call	updcrc
		pop	psw
		push	psw
		ani	FlagV
		lxi	h,crcval2
		call	updcrc
		pop	psw
		ani	FlagAC
		lxi	h,crcval3
		call	updcrc
SetTst7Op1Adr:
		lxi	h,Tst7SetOper+1
		inr	m
		jnz	Tst7InstrLoop
SetTst7Op2Adr:
		lxi	h,Tst7SetOper2+1
		inr	m
		jnz	Tst7InstrLoop
		lxi	h,Tst7SetFlg+1
		mvi	a,255
		xra	m
		mov	m,a
		jnz	Tst7InstrLoop
		ret

TestType8:
		push	psw
		push	b
		push	d
		push	h
		mov	a,m
		sta	Tst8Instr
		call	initcrc
Tst8InstrLoop:
Tst8SetFlg:
		mvi	c,0	;
		push	b
		pop	psw
Tst8SetOper:
		lxi	h,0	; 
Tst8SetOper2:
		lxi	b,0	; 
Tst8Instr:
		nop		;   
		push	psw
		pop	b
		mov	a,c
		ani	FlagP
		lxi	h,crcval
		call	updcrc
		lhld	Tst8SetOper2+1
		inx	h
		shld	Tst8SetOper2+1
		mov	a,h
		ora	l
		jnz	Tst8InstrLoop
		lxi	h,Tst8SetFlg+1
		mvi	a,255
		xra	m
		mov	m,a
		jnz	Tst8InstrLoop
		lxi	d,FlgPtxt
		mvi	c,9
		call	bdos
		lxi	h,crcval
		call	phex8
		lxi	d,CRLF
		mvi	c,9
		call	bdos
		pop	h
		inx	h
		pop	d
		pop	b
		pop	psw
		ret


TestType2:
		push	psw
		push	b
		push	d
		push	h
		mov	a,m
		sta	Tst2Instr
		call	initcrc
Tst2InstrLoop:
Tst2SetFlg:
		mvi	c,0	;
		push	b
		pop	psw
Tst2SetOper:
		lxi	h,0	;
Tst2Instr:
		nop		;   
		push	psw
		pop	b
		mov	a,c
		push	psw
		ani	FlagK
		lxi	h,crcval
		call	updcrc
		pop	psw
		ani	FlagV
		lxi	h,crcval2
		call	updcrc
		lhld	Tst2SetOper+1
		inx	h
		shld	Tst2SetOper+1
		mov	a,h
		ora	l
		jnz	Tst2InstrLoop
		lxi	h,Tst2SetFlg+1
		mvi	a,255
		xra	m
		mov	m,a
		jnz	Tst2InstrLoop
		call	PrintKV
		pop	h
		inx	h
		pop	d
		pop	b
		pop	psw
		ret

TestType6:
		push	psw
		push	b
		push	d
		push	h
		mov	a,m
		sta	Tst6Instr
		call	initcrc
Tst6InstrLoop:
Tst6SetFlg:
		mvi	c,0	;
		push	b
		pop	psw
Tst6SetOper:
		lxi	d,0	;
Tst6Instr:
		nop		;   
		push	psw
		pop	b
		mov	a,c
		push	psw
		ani	FlagK
		lxi	h,crcval
		call	updcrc
		pop	psw
		ani	FlagV
		lxi	h,crcval2
		call	updcrc
		lhld	Tst6SetOper+1
		inx	h
		shld	Tst6SetOper+1
		mov	a,h
		ora	l
		jnz	Tst6InstrLoop
		lxi	h,Tst6SetFlg+1
		mvi	a,255
		xra	m
		mov	m,a
		jnz	Tst6InstrLoop
		call	PrintKV
		pop	h
		inx	h
		pop	d
		pop	b
		pop	psw
		ret

PrintKV:
		lxi	d,FlgKtxt
		mvi	c,9
		call	bdos
		lxi	h,crcval
		call	phex8
		lxi	d,FlgVtxt
		mvi	c,9
		call	bdos
		lxi	h,crcval2
		call	phex8
		lxi	d,CRLF
		mvi	c,9
		call	bdos
		ret


Logo1Txt	.db "8085 Flags Test Part 2",10,13,'$'
Logo2Txt	.db 127," Ivan Gorodetsky, Ufa 2013",10,13,'$'

FlgKtxt		.db " K:$"
FlgVtxt		.db " V:$"
FlgACtxt	.db "      AC:$"
FlgPtxt		.db " P:$"
;RegAtxt		.db " A:$"
CRLF		.db 13,10,'$'

EndTstTxt	.db "Tests complete$"

bdosDispatch:
		push	psw
		push	b
		push	d
		push	h
		mov	a,c
		cpi	2
		cz	PrintCharBDOS
		cpi	9
		cz	PrintText
		pop	h
		pop	d
		pop	b
		pop	psw
		ret

cursor		.dw	0E0FFh-7

PrintText:
		push	psw
		lhld	cursor
		xchg
PrintTextLoop:
		mov	a,m
		cpi	'$'
		jz	PrintTextExit
		cpi	10		;LF
		jnz	Chk13
		lxi	b,-9
		xchg\ dad b\ xchg
		inx	h
		jmp	PrintTextLoop
Chk13:
		cpi	13		;CR
		jnz	PrintC
		mvi	d,0E0h
		inx	h
		jmp	PrintTextLoop
PrintC:
		call	PrintChar
		inx	h
		inr	d
		jmp	PrintTextLoop
PrintTextExit:
		xchg
		shld	cursor
		pop	psw
		ret

PrintCharBDOS:
		push	psw
		push	h
		mov	a,e
		lhld	cursor
		xchg
		call	PrintChar
		inr	d
		xchg	
		shld	cursor
		pop	h
		pop	psw
		ret
PrintChar:
		push	psw
		push	b
		push	d
		push	h
		mov	l, a
		mvi	h, 0
		dad	h
		dad	h
		dad	h
		lxi	b, Font-256
		dad	b
		mvi	b, 8
loopchar:
		mov	a, m
		inx	h
		stax	d
		dcr	e
		dcr	b
		jnz	loopchar
		pop	h
		pop	d
		pop	b
		pop	psw
		ret

Cls:
		lxi	h,0E000h
		xra	a
ClrScr:
		mov	m,a
		inx	h
		cmp	h
		jnz	ClrScr
		ret

; display hex string (pointer in hl, byte count in b)
hexstr:	mov	a,m
	call	phex2
	inx	h
	dcr	b
	jnz	hexstr
	ret

; display hex
; display the big-endian 32-bit value pointed to by hl
phex8:	push	psw
	push	b
	push	h
	mvi	b,4
ph8lp:	mov	a,m
	call	phex2
	inx	h
	dcr	b
	jnz	ph8lp
	pop	h
	pop	b
	pop	psw
	ret

; display byte in a
phex2:	push	psw
	rrc
	rrc
	rrc
	rrc
	call	phex1
	pop	psw
; fall through	

; display low nibble in a
phex1:	push	psw
	push	b
	push	d
	push	h
	ani	0fh
	cpi	10
	jc	ph11
	adi	'A'-'9'-1
ph11:	adi	'0'
	mov	e,a
	mvi	c,2
	call	bdos
	pop	h
	pop	d
	pop	b
	pop	psw
	ret

#include "crc32.asm"

#define col 173

colors:
		.db 0,col,0,col,0,col,0,col,0,col,0,col,0,col,0,col

Font:

		.end