; , 10.01.2014
;    8080 exerciser by Ian Bartholomew

bdos		.equ	5


A0		.equ	00000001b
A1		.equ	00000010b
A2		.equ	00000100b
A3		.equ	00001000b
A4		.equ	00010000b
A5		.equ	00100000b
A6		.equ	01000000b
A7		.equ	10000000b



		.org	100h

		di
		xra	a
		out	10h
		lxi	sp,100h
		mvi	a,0C3h
		sta	0
		sta	5
		lxi	h,Restart
		shld	1
		lxi	h,bdosDispatch
		shld	6

; 
		call	Cls
		mvi	a,0C9h
		sta	38h
		ei
		hlt
		lxi	h, colors+15
colorset:
		mvi	a, 88h
		out	0
		mvi	c, 15
colorset1:	mov	a, c
		out	2
		mov	a, m
		out	0Ch
		dcx	h
		out	0Ch
		out	0Ch
		dcr	c
		out	0Ch
		out	0Ch
		out	0Ch
		jp	colorset1
		mvi	a,255
		out	3

Restart:
		call	Cls
		lxi	h,0E0FFh
		shld	cursor
		lxi	d,Logo1Txt
		mvi	c,9
		call	bdos
		lxi	d,Logo2Txt
		mvi	c,9
		call	bdos
		lxi	h,Tests
TestsLoop:
		mov	a,m
		ora	a
		jz	EndTest
		xchg
		mvi	c,9
		call	bdos
		xchg
		call	SkipTillBuck
		mov	a,m
		inx	h
		cpi	9
		cz	TestType9
		jmp	TestsLoop
EndTest:
		lxi	d,EndTstTxt
		mvi	c,9
		call	bdos
neverend:
		jmp	neverend		


SkipTillBuck:
		mvi	a,'$'
		cmp	m
		inx	h
		rz
		jmp	SkipTillBuck

Tests:
		.db "simrim$"
		.db 9		; 


;  
		.db 0


Tst9InstrLoop:
Tst9SetOper:
		mvi	a,0	;
		sim
		rim
		push	psw
		ani	A0
		lxi	h,crcval0
		call	updcrc

		pop	psw
		push	psw
		ani	A1
		lxi	h,crcval1
		call	updcrc

		pop	psw
		push	psw
		ani	A2
		lxi	h,crcval2
		call	updcrc

		pop	psw
		push	psw
		ani	A3
		lxi	h,crcval3
		call	updcrc

		pop	psw
		push	psw
		ani	A4
		lxi	h,crcval4
		call	updcrc

		pop	psw
		push	psw
		ani	A5
		lxi	h,crcval5
		call	updcrc

		pop	psw
		push	psw
		ani	A6
		lxi	h,crcval6
		call	updcrc

		pop	psw
		ani	A7
		lxi	h,crcval7
		call	updcrc

		lxi	h,Tst9SetOper+1
		inr	m
		jnz	Tst9InstrLoop
		ret


TestType9:
		push	psw
		push	b
		push	d
		push	h
		call	initcrc

		call	Tst9InstrLoop

		lxi	h,0C9FBh
		shld	38h
		ei

		call	Tst9InstrLoop


		lxi	d,A7txt
		mvi	c,9
		call	bdos
		lxi	h,crcval7
		call	phex8

		lxi	d,A6txt
		mvi	c,9
		call	bdos
		lxi	h,crcval6
		call	phex8
		lxi	d,CRLF
		mvi	c,9
		call	bdos

		lxi	d,A5txt
		mvi	c,9
		call	bdos
		lxi	h,crcval5
		call	phex8

		lxi	d,A4txt
		mvi	c,9
		call	bdos
		lxi	h,crcval4
		call	phex8
		lxi	d,CRLF
		mvi	c,9
		call	bdos

		lxi	d,A3txt
		mvi	c,9
		call	bdos
		lxi	h,crcval3
		call	phex8

		lxi	d,A2txt
		mvi	c,9
		call	bdos
		lxi	h,crcval2
		call	phex8
		lxi	d,CRLF
		mvi	c,9
		call	bdos

		lxi	d,A1txt
		mvi	c,9
		call	bdos
		lxi	h,crcval1
		call	phex8

		lxi	d,A0txt
		mvi	c,9
		call	bdos
		lxi	h,crcval0
		call	phex8
		lxi	d,CRLF
		mvi	c,9
		call	bdos

		pop	h
		pop	d
		pop	b
		pop	psw
		ret


Logo1Txt	.db "8085 Flags Test Part 3",10,13,'$'
Logo2Txt	.db 127," Ivan Gorodetsky, Ufa 2014",10,13,'$'

A7txt		.db "A7:$"
A6txt		.db " A6:$"
A5txt		.db "      A5:$"
A4txt		.db " A4:$"
A3txt		.db "      A3:$"
A2txt		.db " A2:$"
A1txt		.db "      A1:$"
A0txt		.db " A0:$"
CRLF		.db 13,10,'$'


EndTstTxt	.db "Tests complete$"

bdosDispatch:
		push	psw
		push	b
		push	d
		push	h
		mov	a,c
		cpi	2
		cz	PrintCharBDOS
		cpi	9
		cz	PrintText
		pop	h
		pop	d
		pop	b
		pop	psw
		ret

cursor		.dw	0E0FFh-7

PrintText:
		push	psw
		lhld	cursor
		xchg
PrintTextLoop:
		mov	a,m
		cpi	'$'
		jz	PrintTextExit
		cpi	10		;LF
		jnz	Chk13
		lxi	b,-9
		xchg\ dad b\ xchg
		inx	h
		jmp	PrintTextLoop
Chk13:
		cpi	13		;CR
		jnz	PrintC
		mvi	d,0E0h
		inx	h
		jmp	PrintTextLoop
PrintC:
		call	PrintChar
		inx	h
		inr	d
		jmp	PrintTextLoop
PrintTextExit:
		xchg
		shld	cursor
		pop	psw
		ret

PrintCharBDOS:
		push	psw
		push	h
		mov	a,e
		lhld	cursor
		xchg
		call	PrintChar
		inr	d
		xchg	
		shld	cursor
		pop	h
		pop	psw
		ret
PrintChar:
		push	psw
		push	b
		push	d
		push	h
		mov	l, a
		mvi	h, 0
		dad	h
		dad	h
		dad	h
		lxi	b, Font-256
		dad	b
		mvi	b, 8
loopchar:
		mov	a, m
		inx	h
		stax	d
		dcr	e
		dcr	b
		jnz	loopchar
		pop	h
		pop	d
		pop	b
		pop	psw
		ret

Cls:
		lxi	h,0E000h
		xra	a
ClrScr:
		mov	m,a
		inx	h
		cmp	h
		jnz	ClrScr
		ret

; display hex string (pointer in hl, byte count in b)
hexstr:	mov	a,m
	call	phex2
	inx	h
	dcr	b
	jnz	hexstr
	ret

; display hex
; display the big-endian 32-bit value pointed to by hl
phex8:	push	psw
	push	b
	push	h
	mvi	b,4
ph8lp:	mov	a,m
	call	phex2
	inx	h
	dcr	b
	jnz	ph8lp
	pop	h
	pop	b
	pop	psw
	ret

; display byte in a
phex2:	push	psw
	rrc
	rrc
	rrc
	rrc
	call	phex1
	pop	psw
; fall through	

; display low nibble in a
phex1:	push	psw
	push	b
	push	d
	push	h
	ani	0fh
	cpi	10
	jc	ph11
	adi	'A'-'9'-1
ph11:	adi	'0'
	mov	e,a
	mvi	c,2
	call	bdos
	pop	h
	pop	d
	pop	b
	pop	psw
	ret

#include "crc32.asm"

#define col 173

colors:
		.db 0,col,0,col,0,col,0,col,0,col,0,col,0,col,0,col

Font:

		.end