; 32-bit crc routine
; entry: a contains next byte, hl points to crc
; exit:  crc updated
updcrc:	push	psw
	push	b
	push	d
	push	h
	push	h
	inx	h
	inx	h
	inx	h	; point to low byte of old crc
	xra	m	; xor with new byte
	mov	l,a
	mvi	h,0
	dad	h	; use result as index into table of 4 byte entries
	dad	h
	lxi	d,crctab
	dad	d	; point to selected entry in crctab
	xchg
	pop	h

	ldax	d
	mov	b,m
	mov	m,a
	inx	d
	inx	h

	ldax	d
	xra	b
	mov	b,m
	mov	m,a
	inx	d
	inx	h

	ldax	d
	xra	b
	mov	b,m
	mov	m,a
	inx	d
	inx	h

	ldax	d
	xra	b
	mov	m,a
	pop	h
	pop	d
	pop	b
	pop	psw
	ret

initcrc:push	psw
	push	b
	push	h
	lxi	h,crcval
	mvi	a,0ffh
	mvi	b,4*8		;  8 
icrclp:	mov	m,a
	inx	h
	dcr	b
	jnz	icrclp
	pop	h
	pop	b
	pop	psw
	ret

crcval:
crcval0:	.ds	4
crcval1:	.ds	4
crcval2:	.ds	4
crcval3:	.ds	4
crcval4:	.ds	4
crcval5:	.ds	4
crcval6:	.ds	4
crcval7:	.ds	4


crctab:	.db	000h,000h,000h,000h
	.db	077h,007h,030h,096h
	.db	0eeh,00eh,061h,02ch
	.db	099h,009h,051h,0bah
	.db	007h,06dh,0c4h,019h
	.db	070h,06ah,0f4h,08fh
	.db	0e9h,063h,0a5h,035h
	.db	09eh,064h,095h,0a3h
	.db	00eh,0dbh,088h,032h
	.db	079h,0dch,0b8h,0a4h
	.db	0e0h,0d5h,0e9h,01eh
	.db	097h,0d2h,0d9h,088h
	.db	009h,0b6h,04ch,02bh
	.db	07eh,0b1h,07ch,0bdh
	.db	0e7h,0b8h,02dh,007h
	.db	090h,0bfh,01dh,091h
	.db	01dh,0b7h,010h,064h
	.db	06ah,0b0h,020h,0f2h
	.db	0f3h,0b9h,071h,048h
	.db	084h,0beh,041h,0deh
	.db	01ah,0dah,0d4h,07dh
	.db	06dh,0ddh,0e4h,0ebh
	.db	0f4h,0d4h,0b5h,051h
	.db	083h,0d3h,085h,0c7h
	.db	013h,06ch,098h,056h
	.db	064h,06bh,0a8h,0c0h
	.db	0fdh,062h,0f9h,07ah
	.db	08ah,065h,0c9h,0ech
	.db	014h,001h,05ch,04fh
	.db	063h,006h,06ch,0d9h
	.db	0fah,00fh,03dh,063h
	.db	08dh,008h,00dh,0f5h
	.db	03bh,06eh,020h,0c8h
	.db	04ch,069h,010h,05eh
	.db	0d5h,060h,041h,0e4h
	.db	0a2h,067h,071h,072h
	.db	03ch,003h,0e4h,0d1h
	.db	04bh,004h,0d4h,047h
	.db	0d2h,00dh,085h,0fdh
	.db	0a5h,00ah,0b5h,06bh
	.db	035h,0b5h,0a8h,0fah
	.db	042h,0b2h,098h,06ch
	.db	0dbh,0bbh,0c9h,0d6h
	.db	0ach,0bch,0f9h,040h
	.db	032h,0d8h,06ch,0e3h
	.db	045h,0dfh,05ch,075h
	.db	0dch,0d6h,00dh,0cfh
	.db	0abh,0d1h,03dh,059h
	.db	026h,0d9h,030h,0ach
	.db	051h,0deh,000h,03ah
	.db	0c8h,0d7h,051h,080h
	.db	0bfh,0d0h,061h,016h
	.db	021h,0b4h,0f4h,0b5h
	.db	056h,0b3h,0c4h,023h
	.db	0cfh,0bah,095h,099h
	.db	0b8h,0bdh,0a5h,00fh
	.db	028h,002h,0b8h,09eh
	.db	05fh,005h,088h,008h
	.db	0c6h,00ch,0d9h,0b2h
	.db	0b1h,00bh,0e9h,024h
	.db	02fh,06fh,07ch,087h
	.db	058h,068h,04ch,011h
	.db	0c1h,061h,01dh,0abh
	.db	0b6h,066h,02dh,03dh
	.db	076h,0dch,041h,090h
	.db	001h,0dbh,071h,006h
	.db	098h,0d2h,020h,0bch
	.db	0efh,0d5h,010h,02ah
	.db	071h,0b1h,085h,089h
	.db	006h,0b6h,0b5h,01fh
	.db	09fh,0bfh,0e4h,0a5h
	.db	0e8h,0b8h,0d4h,033h
	.db	078h,007h,0c9h,0a2h
	.db	00fh,000h,0f9h,034h
	.db	096h,009h,0a8h,08eh
	.db	0e1h,00eh,098h,018h
	.db	07fh,06ah,00dh,0bbh
	.db	008h,06dh,03dh,02dh
	.db	091h,064h,06ch,097h
	.db	0e6h,063h,05ch,001h
	.db	06bh,06bh,051h,0f4h
	.db	01ch,06ch,061h,062h
	.db	085h,065h,030h,0d8h
	.db	0f2h,062h,000h,04eh
	.db	06ch,006h,095h,0edh
	.db	01bh,001h,0a5h,07bh
	.db	082h,008h,0f4h,0c1h
	.db	0f5h,00fh,0c4h,057h
	.db	065h,0b0h,0d9h,0c6h
	.db	012h,0b7h,0e9h,050h
	.db	08bh,0beh,0b8h,0eah
	.db	0fch,0b9h,088h,07ch
	.db	062h,0ddh,01dh,0dfh
	.db	015h,0dah,02dh,049h
	.db	08ch,0d3h,07ch,0f3h
	.db	0fbh,0d4h,04ch,065h
	.db	04dh,0b2h,061h,058h
	.db	03ah,0b5h,051h,0ceh
	.db	0a3h,0bch,000h,074h
	.db	0d4h,0bbh,030h,0e2h
	.db	04ah,0dfh,0a5h,041h
	.db	03dh,0d8h,095h,0d7h
	.db	0a4h,0d1h,0c4h,06dh
	.db	0d3h,0d6h,0f4h,0fbh
	.db	043h,069h,0e9h,06ah
	.db	034h,06eh,0d9h,0fch
	.db	0adh,067h,088h,046h
	.db	0dah,060h,0b8h,0d0h
	.db	044h,004h,02dh,073h
	.db	033h,003h,01dh,0e5h
	.db	0aah,00ah,04ch,05fh
	.db	0ddh,00dh,07ch,0c9h
	.db	050h,005h,071h,03ch
	.db	027h,002h,041h,0aah
	.db	0beh,00bh,010h,010h
	.db	0c9h,00ch,020h,086h
	.db	057h,068h,0b5h,025h
	.db	020h,06fh,085h,0b3h
	.db	0b9h,066h,0d4h,009h
	.db	0ceh,061h,0e4h,09fh
	.db	05eh,0deh,0f9h,00eh
	.db	029h,0d9h,0c9h,098h
	.db	0b0h,0d0h,098h,022h
	.db	0c7h,0d7h,0a8h,0b4h
	.db	059h,0b3h,03dh,017h
	.db	02eh,0b4h,00dh,081h
	.db	0b7h,0bdh,05ch,03bh
	.db	0c0h,0bah,06ch,0adh
	.db	0edh,0b8h,083h,020h
	.db	09ah,0bfh,0b3h,0b6h
	.db	003h,0b6h,0e2h,00ch
	.db	074h,0b1h,0d2h,09ah
	.db	0eah,0d5h,047h,039h
	.db	09dh,0d2h,077h,0afh
	.db	004h,0dbh,026h,015h
	.db	073h,0dch,016h,083h
	.db	0e3h,063h,00bh,012h
	.db	094h,064h,03bh,084h
	.db	00dh,06dh,06ah,03eh
	.db	07ah,06ah,05ah,0a8h
	.db	0e4h,00eh,0cfh,00bh
	.db	093h,009h,0ffh,09dh
	.db	00ah,000h,0aeh,027h
	.db	07dh,007h,09eh,0b1h
	.db	0f0h,00fh,093h,044h
	.db	087h,008h,0a3h,0d2h
	.db	01eh,001h,0f2h,068h
	.db	069h,006h,0c2h,0feh
	.db	0f7h,062h,057h,05dh
	.db	080h,065h,067h,0cbh
	.db	019h,06ch,036h,071h
	.db	06eh,06bh,006h,0e7h
	.db	0feh,0d4h,01bh,076h
	.db	089h,0d3h,02bh,0e0h
	.db	010h,0dah,07ah,05ah
	.db	067h,0ddh,04ah,0cch
	.db	0f9h,0b9h,0dfh,06fh
	.db	08eh,0beh,0efh,0f9h
	.db	017h,0b7h,0beh,043h
	.db	060h,0b0h,08eh,0d5h
	.db	0d6h,0d6h,0a3h,0e8h
	.db	0a1h,0d1h,093h,07eh
	.db	038h,0d8h,0c2h,0c4h
	.db	04fh,0dfh,0f2h,052h
	.db	0d1h,0bbh,067h,0f1h
	.db	0a6h,0bch,057h,067h
	.db	03fh,0b5h,006h,0ddh
	.db	048h,0b2h,036h,04bh
	.db	0d8h,00dh,02bh,0dah
	.db	0afh,00ah,01bh,04ch
	.db	036h,003h,04ah,0f6h
	.db	041h,004h,07ah,060h
	.db	0dfh,060h,0efh,0c3h
	.db	0a8h,067h,0dfh,055h
	.db	031h,06eh,08eh,0efh
	.db	046h,069h,0beh,079h
	.db	0cbh,061h,0b3h,08ch
	.db	0bch,066h,083h,01ah
	.db	025h,06fh,0d2h,0a0h
	.db	052h,068h,0e2h,036h
	.db	0cch,00ch,077h,095h
	.db	0bbh,00bh,047h,003h
	.db	022h,002h,016h,0b9h
	.db	055h,005h,026h,02fh
	.db	0c5h,0bah,03bh,0beh
	.db	0b2h,0bdh,00bh,028h
	.db	02bh,0b4h,05ah,092h
	.db	05ch,0b3h,06ah,004h
	.db	0c2h,0d7h,0ffh,0a7h
	.db	0b5h,0d0h,0cfh,031h
	.db	02ch,0d9h,09eh,08bh
	.db	05bh,0deh,0aeh,01dh
	.db	09bh,064h,0c2h,0b0h
	.db	0ech,063h,0f2h,026h
	.db	075h,06ah,0a3h,09ch
	.db	002h,06dh,093h,00ah
	.db	09ch,009h,006h,0a9h
	.db	0ebh,00eh,036h,03fh
	.db	072h,007h,067h,085h
	.db	005h,000h,057h,013h
	.db	095h,0bfh,04ah,082h
	.db	0e2h,0b8h,07ah,014h
	.db	07bh,0b1h,02bh,0aeh
	.db	00ch,0b6h,01bh,038h
	.db	092h,0d2h,08eh,09bh
	.db	0e5h,0d5h,0beh,00dh
	.db	07ch,0dch,0efh,0b7h
	.db	00bh,0dbh,0dfh,021h
	.db	086h,0d3h,0d2h,0d4h
	.db	0f1h,0d4h,0e2h,042h
	.db	068h,0ddh,0b3h,0f8h
	.db	01fh,0dah,083h,06eh
	.db	081h,0beh,016h,0cdh
	.db	0f6h,0b9h,026h,05bh
	.db	06fh,0b0h,077h,0e1h
	.db	018h,0b7h,047h,077h
	.db	088h,008h,05ah,0e6h
	.db	0ffh,00fh,06ah,070h
	.db	066h,006h,03bh,0cah
	.db	011h,001h,00bh,05ch
	.db	08fh,065h,09eh,0ffh
	.db	0f8h,062h,0aeh,069h
	.db	061h,06bh,0ffh,0d3h
	.db	016h,06ch,0cfh,045h
	.db	0a0h,00ah,0e2h,078h
	.db	0d7h,00dh,0d2h,0eeh
	.db	04eh,004h,083h,054h
	.db	039h,003h,0b3h,0c2h
	.db	0a7h,067h,026h,061h
	.db	0d0h,060h,016h,0f7h
	.db	049h,069h,047h,04dh
	.db	03eh,06eh,077h,0dbh
	.db	0aeh,0d1h,06ah,04ah
	.db	0d9h,0d6h,05ah,0dch
	.db	040h,0dfh,00bh,066h
	.db	037h,0d8h,03bh,0f0h
	.db	0a9h,0bch,0aeh,053h
	.db	0deh,0bbh,09eh,0c5h
	.db	047h,0b2h,0cfh,07fh
	.db	030h,0b5h,0ffh,0e9h
	.db	0bdh,0bdh,0f2h,01ch
	.db	0cah,0bah,0c2h,08ah
	.db	053h,0b3h,093h,030h
	.db	024h,0b4h,0a3h,0a6h
	.db	0bah,0d0h,036h,005h
	.db	0cdh,0d7h,006h,093h
	.db	054h,0deh,057h,029h
	.db	023h,0d9h,067h,0bfh
	.db	0b3h,066h,07ah,02eh
	.db	0c4h,061h,04ah,0b8h
	.db	05dh,068h,01bh,002h
	.db	02ah,06fh,02bh,094h
	.db	0b4h,00bh,0beh,037h
	.db	0c3h,00ch,08eh,0a1h
	.db	05ah,005h,0dfh,01bh
	.db	02dh,002h,0efh,08dh
