TOTAL_ROWS = 22

org 32768


ld d,16+8*8
ld e,1
ld bc,00000
call NIRVANA_paintC


ld d,16+4*8
ld e, 8
ld c,2*8
call NIRVANA_fillC

ld hl,main_Engine
call IMON



;loooooop
loop:
        halt
        jp loop

ret

main_Engine
      ; preserve all registers
        push    af
        push    bc
        push    de
        push    hl
        ex      af, af'
        exx
        push    af
        push    bc
        push    de
        push    hl
        push    ix
        push    iy

      ;delays

      ld b,249
      delay01
        ld (00000),hl
        ld (00000),hl
        ld (00000),hl
        nop
        nop
        nop
        nop
        djnz delay01

      ;nop testing :)
      
        dup 35 ;25
        nop
        edup
        
      ;save stack
      ld      (exit_raster+1), sp

      race_raster:
      ROWREPT = 0
      N=0
      
        dup TOTAL_ROWS
        dup 4
        LD SP,$5822+ROWREPT*32+5    ; reference columns 5 and 6
        LD HL,256*N+N     ; columns 9 and 10 (*)
        LD DE,256*N+N     ; columns 11 and 12 (*)
        LD BC,256*N+N     ; columns 13 and 14 (*)
        EXX
        LD HL,256*N+N     ; columns 1 and 2 (*)
        LD DE,256*N+N     ; columns 3 and 4 (*)
        LD BC,256*N+N     ; columns 5 and 6 (*)
        PUSH BC      ; columns 5 and 6
        PUSH DE      ; columns 3 and 4
        PUSH HL      ; columns 1 and 2
        LD SP,$5822+ROWREPT*32+19   ; reference columns 19 and 20
        LD HL,256*N+N     ; columns 15 and 16 (*)
        LD DE,256*N+N     ; columns 17 and 18 (*)
        LD BC,256*N+N     ; columns 19 and 20 (*)
        PUSH BC      ; columns 19 and 20
        PUSH DE      ; columns 17 and 18
        PUSH HL      ; columns 15 and 16
        EXX
        PUSH BC      ; columns 13 and 14
        PUSH DE      ; columns 11 and 12
        PUSH HL      ; columns 9 and 10
        LD HL,256*N+N     ; columns 7 and 8 (*)
        PUSH HL      ; columns 7 and 8
        LD SP,$5822+ROWREPT*32+25   ; reference columns 25 and 26
        LD HL,256*N+N     ; columns 21 and 22 (*)
        LD DE,256*N+N     ; columns 23 and 24 (*)
        LD BC,256*N+N     ; columns 25 and 26 (*)
        PUSH BC      ; columns 25 and 26
        PUSH DE      ; columns 23 and 24
        PUSH HL      ; columns 21 and 22
        LD HL,256*N+N     ; columns 27 and 28 (*)
        LD ($5820+(ROWREPT*32)+27),HL   ; columns 27 and 28
        LD HL,256*N+N     ; columns 29 and 30 (*)
        LD ($5820+(ROWREPT*32)+29),HL   ; columns 29 and 30
        LD BC,5
        
        DEC C
        JR NZ,$-1
        
        N=N+8
        IF N=128 then N=0 ENDIF

        edup
        ROWREPT = ROWREPT+1
        edup
        
exit_raster:
; restore stack pointer
  ld      sp, 0

  ; restore registers
        pop     iy
        pop     ix
        pop     hl
        pop     de
        pop     bc
        pop     af
        exx
        ex      af, af'
        pop     hl
        pop     de
        pop     bc
        pop     af

        jp      38h

RET




attribs:
; lookup table with render attribute coordinates
dup 8
        defw      0
edup

RACEREPT = 0

dup 4*TOTAL_ROWS

        defw      race_raster + RACEREPT*81 - 57

        RACEREPT = RACEREPT+1
edup

dup 4*(22-TOTAL_ROWS)
        defw      0
edup

dup 8
        defw      0
edup

        
IMON
       LD    A,24        ;  JR
       LD    (65535),A
       LD    A,195       ;  JP
       LD    (65524),A
       LD    (65525),HL  ; HL -   
       LD    HL,FE00h    ;    
       LD    DE,FE01h
       LD    BC,256      ;   1
       LD    (HL),FFh    ;  #FFFF (65535)
       LD    A,H         ;    
       LDIR              ; 
       DI                ;   
                         ;   
       LD    I,A         ;   I   
                         ;    
       IM2           ;   
       EI                ; 
       RET


IMOFF  DI
       LD    A,63
       LD    I,A
       IM1
       EI

       RET

; ============ NIRVANA =============

; -----------------------------------------------------------------------------
; Paint specified 8x8 block with a sequence of 4 attribute values (in 214T)
;
; Params:
;     BC = attributes address
;     D = pixel line (16-184, even values only)
;     E = char column (1-30)
;
; -----------------------------------------------------------------------------
NIRVANA_paintC:
; calculate initial routine attribute address
        ld      h, 0
        ld      l, d
        ld      d, deltas / 256
        inc     e
        ld      a, (de)
        ld      de, attribs
        add     hl, de
        add     a, (hl)
        ld      e, a
        inc     l
        ld      a, (hl)
        adc     a, 0
        ld      d, a
        ex      de, hl

; update attributes
        ld      de, 81
dup 3
        ld      a, (bc)
        ld      (hl), a
        inc     bc
        add     hl, de
edup
        ld      a, (bc)
        ld      (hl), a
        ret

        
; -----------------------------------------------------------------------------
; Fill specified 8x8 block with attribute value (in 164T)
;
; Params:
;     C = attribute value (0-255)
;     D = pixel line (16-184, even values only)
;     E = char column (1-30)
;
; -----------------------------------------------------------------------------
NIRVANA_fillC:
; calculate initial routine attribute address
        ld      h, 0
        ld      l, d
        ld      d, deltas / 256
        inc     e
        ld      a, (de)
        ld      de, attribs
        add     hl, de
        add     a, (hl)
        ld      e, a
        inc     l
        ld      a, (hl)
        adc     a, 0
        ld      d, a
        ex      de, hl

; update attributes
        ld      de, 81
dup 3
        ld      (hl), c
        add     hl, de
edup
        ld      (hl), c
        ret

; -----------------------------------------------------------------------------

       
org 65281-256*4
deltas
     defb 71, 71, 72, 74, 75, 77, 78, 102, 103, 61, 62, 64, 65, 67, 68, 86, 87
     defb 89, 90, 92, 93, 109, 110, 112, 113, 115, 116, 121, 122, 127, 128, 128
