/*
-86

1.  (0x00)							256 
2.  (0xE6)					1 
3.   (.)			2 
4.   (.)			2 
5. 
6. 								2 
7.  (0xE6)					1 
8.   "" (.)	2 

T = 0.9 
 1 - 01
 0 - 10
*/

#include <avr/io.h>
#include <avr/pgmspace.h>
#include <string.h>
#include "key.c"
#include "lcd1100.c"
#include "SRAM64.c"
//#include "ccsbcs.c"
#include "ff.h"


#define HI(x) ((x)>>8)
#define LO(x) ((x)&0xFF)
#define ADDR0 (WORD)0x7000
#define LCD_ROWS 8
#define TYPEPORT PORTD
#define TYPEDDR DDRD
#define T_OUT 0
#define T_OUT0 cbi(TYPEPORT,T_OUT)
#define T_OUT1 sbi(TYPEPORT,T_OUT)
#define RAM_ON cbi(PORTB,PB4)
#define RAM_OFF sbi(PORTB,PB4)
#define LIST 0
#define PLAY 1


FATFS FatFs;		/* FatFs work area needed for each volume */
FIL Fil;			/* File object needed for each open file */
FILINFO Finfo;

BYTE Buff[128];
volatile WORD fsize;
volatile WORD AccFiles=(WORD)0;
volatile unsigned char fl[32];
volatile WORD Indx=(WORD)0;
volatile BYTE cursor=0;
BYTE mode;


void Type_Init(void)
{
	TYPEDDR |= (1<<T_OUT);
	T_OUT0;
}

void RK86_Tape_Out(BYTE b)
{
	unsigned char i;
	for(i=0;i<8;i++)
	{
		if(b & 0x80)
		{
			T_OUT0;
			_delay_us(450);
			T_OUT1;
			_delay_us(450);
		}
		else
		{
			T_OUT1;
			_delay_us(450);
			T_OUT0;
			_delay_us(450);
		}
		b <<= 1;
	}
}


static FRESULT scan_files (char* path)
{
	DIR dirs;
	FRESULT res;
	unsigned char *f;
	WORD addr;
	WORD addrH;
	int i;
	int j;
	BYTE c;
#if _USE_LFN
	static char lfn[_MAX_LFN + 1];
	Finfo.lfname = &lfn;
	Finfo.lfsize = sizeof(lfn);
	dirs.lfn=&lfn;
#endif
	addr=0x7200;
	AccFiles=0;
	addrH=ADDR0;
	res = f_opendir(&dirs, path);
	if (res == FR_OK) {
		i = strlen(path);
		while (((res = f_readdir(&dirs, &Finfo)) == FR_OK) && Finfo.fname[0])
		{
			if (_FS_RPATH && Finfo.fname[0] == '.') continue;
#if _USE_LFN
			f = *Finfo.lfname ? Finfo.lfname : Finfo.fname;
#else
			f = Finfo.fname;
#endif
			if (Finfo.fattrib & AM_DIR) {
				path[i] = '/'; 	strcpy(path+i+1, f);
				res = scan_files(path);
				path[i] = '\0';
				if (res != FR_OK) break;
			} else 
			{
				addrH=(ADDR0+0x0002)+(AccFiles << 1);
				SRAM64_WRITE_W(addrH,addr);	
				j=0;
				do
				{
					c=f[j];
					SRAM64_WRITE(addr,c);	
					addr++;
				} while (f[j++]);
				AccFiles++;
			}
		}
		SRAM64_WRITE_W(ADDR0, AccFiles);	
	}
	return res;
}

void show_list()
{
	unsigned char fn[32];
	WORD addr;
	BYTE y=0;
	BYTE i;
	WORD pos;
	lcd_clear();
	pos=Indx;
	do{
		addr=SRAM64_READ_W((ADDR0+0x0002)+(pos << 1));
		i=0;
		for(;;)
		{
			fn[i]=SRAM64_READ(addr);
			if (fn[i]==0) break;
			addr++;
			i++;
		}
		if (cursor==y)
		{
			lcd_print_string_inv(0,y,fn);
			i=0;
			for(;;)
			{
				fl[i]=fn[i];
				if (fl[i]==0) break;
				i++;
			}
		}
		else
		{
			lcd_print_string(0,y,fn);
		}
		y++;
		pos++;
	}while ((y<LCD_ROWS));
}

void move_up(void)
{
	if (mode==PLAY) return;
	if ((cursor==0)&&(Indx==0)) return;
	if (cursor==0)
	{
		Indx--;
	}
	else
	{
		cursor--;
	}
	show_list();
}


void move_down(void)
{
	if (mode==PLAY) return;
	if ((cursor==(LCD_ROWS-1))&&((Indx+LCD_ROWS)==(AccFiles))) return;
	if (cursor==(LCD_ROWS-1))
	{
		Indx++;
	}
	else
	{
		cursor++;
	}
	show_list();
}


void load_file(void)
{
	lcd_clear();
	lcd_print_string_f(0,0,PSTR("File:"));
	lcd_print_string(0,1,fl);
	lcd_print_string_f(0,3,PSTR("Opening..."));
	FRESULT res;
	BYTE y=0;
	UINT s2=0,i=0;
	WORD cnt=0;
	WORD addr=0;
	cnt= sizeof(Buff);
	res = f_open(&Fil, fl,  FA_OPEN_EXISTING | FA_READ);
    if (res != FR_OK) 
	{
		lcd_print_string_f(0,3,PSTR("Error     "));
    }
	else
	{
		lcd_print_string_f(0,3,PSTR("Loading..."));
		do
		{
			f_read(&Fil, Buff, cnt, &s2);
			for (i=0;i<s2;i++)
			{
				SRAM64_WRITE(addr,Buff[i]);
				addr++;
			}
		}while(s2 == cnt);
		f_close(&Fil);
		fsize=addr;
		while (fl[y] != '.')
		{
			y++;
		}
		y=y+2;
		if (fl[y]=='K')
		{
			lcd_print_string_f(0,3,PSTR("Playing..."));
			for (cnt=0;cnt<256;cnt++)
			{
				RK86_Tape_Out(0);
			}
			RK86_Tape_Out(0xE6);	
			for (cnt=0;cnt<addr;cnt++)
			{
				y=SRAM64_READ(cnt);
				RK86_Tape_Out(y);
			}
		}
		lcd_print_string_f(0,3,PSTR("All right "));
	}
	lcd_print_string_f(0,5,PSTR("Press Ok for"));
	lcd_print_string_f(0,6,PSTR("load a new file"));
}

int main (void)
{
	FRESULT res;
	PORTA = 0x00;
	DDRA  = 0x00;
	PORTB = 0xFF;
	DDRB  = 0xBF; //MISO line i/p, rest o/p
	PORTC = 0x00;
	DDRC  = 0x00;
	PORTD = 0x00;
	DDRD  = 0xFF;	
	RAM_ON;
	init_kb();
	lcd_init();
	lcd_clear();
	SRAM64_INIT();	
	Type_Init();
	mode=PLAY;
	fsize=0;
	lcd_print_string_f(3,0,PSTR("Radio-86RK"));
	lcd_hline(1,0x0A);
	lcd_print_string_f(4,2,PSTR("ROM-disk"));
	lcd_print_string_f(7,3,PSTR("&"));
	lcd_print_string_f(2,4,PSTR("audio player"));
	lcd_print_string_f(4,5,PSTR("emulator"));
	lcd_print_string_f(0,7,PSTR("Press Ok"));
	//lcd_hline(8,0x01);
	//lcd_vline(0);
	//lcd_vline(95);
//	lcd_print_string_f(0,3,PSTR("Press Ok"));
//	lcd_print_string_f(0,4,PSTR("Press Ok"));
	res=f_mount(&FatFs, "", 0);
	if (res == FR_OK) 
	{
		while(1)
		{
			switch (get_key())
			{
				case 1: 
					move_down();
					break;
				case 2: 
					if (mode==LIST)
					{
						mode=PLAY;
						load_file();
						RAM_OFF;
					}
					else 
					{
						RAM_ON;
						if ((fsize == 0)||(fsize > ADDR0))
						{
							lcd_clear();
							lcd_print_string_f(0,0,PSTR("Scaning..."));
							scan_files("");
							Indx=0;
							cursor=0;
						}
						show_list();
						mode=LIST;
					}
					break;
				case 4: 
					move_up();
			}
			
		};
	}
	else
	{
		lcd_print_string(0,0,"Mount Error");
		while(1){};
	}
}
