﻿package {
	
	/*
	/
	/ Example for FYM Player 1.07 freeware
	/ (c) 2008-2009 Mikhail Vostrikov aka MixailV [monster-sage@mail.ru]
	/ 
	*/

	import com.fastlibs.media.YMPlayer
	import flash.display.Sprite
	import flash.events.Event
	
	public class Main extends Sprite {
		
		public var player:YMPlayer
		
		public function Main():void  {
			//
			// создадим екземпляр плеера
			//
			player = new YMPlayer()
			//
			// зададим свойство зацикливания трека по кругу
			// остальные доступные свойства смотрите в начале класса YMPlayer.as
			//
			player.loop = true
			player.stereoEnhance = true
			player.bassBoost = true
			//
			// добавим всех возможных слушателей событий для примера
			//
			player.addEventListener("load start", start)
			player.addEventListener("load success", success)
			player.addEventListener("load error", error)
			player.addEventListener("data empty", end)
			player.addEventListener("play", play)
			player.addEventListener("continue", cont)
			player.addEventListener("stop", stop)
			//
			// загрузим трек в формате fym, на входе два файла и флаг автовоспроизведения
			// два файла - это старый вариант загрузки turbo sound треков из двух независимых файлов
			// в новом варианте оба трека "склеены" в один файл
			// если требуется выставить флаг автовоспроизведения в false, а второй файл не нужен,
			// то можно просто задать пустую строку - ""
			//
			player.load("test.fym")
		}

		public function start(event:Event):void {
			trace("Начало загрузки трека.")
		}		
		
		public function success(event:Event):void {
			trace("Трек удачно загружен.")
			trace("    имя трека: " + player.songName)
			trace("    автор трека: " + player.songAuthor)
		}
		
		public function error(event:Event):void {
			trace("Ошибка, трек не удалось загрузить!")
		}
		
		public function end(event:Event):void {
			trace("Проигрывание трека завершено (все данные воспроизведены).")
		}
		
		public function play(event:Event):void {
			trace("Проигрывание трека начато (вызван метод play).")
		}
		
		public function cont(event:Event):void {
			trace("Проигрывание трека продолжено с позиции: " + player.position + " %")
		}
		
		public function stop(event:Event):void {
			trace("Проигрывание трека завершено (вызвана команда остановки).")
		}

	}
}
