﻿package com.fastlibs.media {
	
	/*
	/
	/ Internal class for FYM Player
	/ (c) 2008-2009 Mikhail Vostrikov aka MixailV [monster-sage@mail.ru]
	/
	/ Methods:
	/		load(path:String):void			// load fym-file
	/		close():void					// stop loading
	/
	/ Properties:
	/		data :Array						// get data from current position and increase current position
	/		isEmpty :Boolead				// get flag, return true if data empty (all readed from buffer)
	/		ready :Boolean					// get flag, return true if data ready for reading (loaded without errors)
	/		position :Number	   			// set/get position in samples
	/		positionRelative :Number		// set/get relative position in percent (0-100)
	/		loop :Number					// set/get loop in samples
	/		length :Number					// get samples qty
	/		loopMode :Boolean				// get/set loop mode (if true then data looped)
	/		chipFrequency :uint				// get chip frequency from data (fym-file)
	/		frameFrequency :uint			// get frame frequency from data (fym-file)
	/		songName :String				// get song name from data (fym-file)
	/		songAuthor :String				// get song author from data (fym-file)
	/
	*/
	
	import flash.events.*
	import flash.net.*
	import flash.utils.*

	public class YMData extends EventDispatcher {
		public var loopMode:Boolean = false
		public var chipFrequency:uint = 0
		public var frameFrequency:uint = 0
		public var songName:String = ""
		public var songAuthor:String = ""
		public var ready:Boolean = false
		public var isEmpty:Boolean = false
		public var turbo:Boolean = false
		public var binaryData:ByteArray
		
		protected var samplesCount:uint = 0
		protected var loader:URLLoader
		protected var closed:Boolean = true
		protected var _data:Array
		protected var _position:uint = 0
		protected var _loop:uint = 0
		protected var _count:uint = 0

		public function YMData() {
			loader = new URLLoader()
			loader.dataFormat = URLLoaderDataFormat.BINARY
			loader.addEventListener(Event.COMPLETE, success)
			loader.addEventListener(IOErrorEvent.IO_ERROR, error)
		}
		
		public function load(path:String):void {
			ready = false
			isEmpty = false
			close()
			try {
				loader.load( new URLRequest(path) )
				closed = false
			} catch (error:Error) {
				dispatchEvent( new Event("error") )
			}
		}
		
		public function close():void {
			if (!closed) {
				loader.close()
				closed = true
			}
		}
		
		protected function success(event:Event):void {
			closed = true
			binaryData = loader.data
			binaryData.uncompress()
			binaryData.endian = Endian.LITTLE_ENDIAN
			var head:uint = binaryData.readUnsignedInt()
			_count = binaryData.readUnsignedInt()
			turbo = (head+_count*14)<binaryData.length
			binaryData.position = 0
			create( binaryData )
			dispatchEvent( new Event("success") )
		}
		
		protected function error(error:IOErrorEvent):void {
			closed = true
			_data = new Array()
			_position = 0
			_loop = 0
			_count = 0
			samplesCount = 0
			chipFrequency = 0
			frameFrequency = 0
			songName = ""
			songAuthor = ""
			dispatchEvent( new Event("error") )
		}
		
		public function create(d:ByteArray):void {
			var ipos:uint = d.position
			d.endian = Endian.LITTLE_ENDIAN
			var head:uint = d.readUnsignedInt()
			_count = d.readUnsignedInt()
			_loop = d.readUnsignedInt()
			chipFrequency = d.readUnsignedInt()
			frameFrequency = d.readUnsignedInt()
			songName = ay_readString(d)
			songAuthor = ay_readString(d)
			samplesCount = _count + 1
			_position = 0
			_data = new Array()
			var st:uint = ipos + head
			for (var i:uint = 0; i < _count; i++) {
				var s:uint = st + i
				d.position = s; s += _count;
				var t0_lo:uint = d.readUnsignedByte()
				d.position = s; s += _count;
				var t0_hi:uint = d.readUnsignedByte()
				d.position = s; s += _count;
				var t1_lo:uint = d.readUnsignedByte()
				d.position = s; s += _count;
				var t1_hi:uint = d.readUnsignedByte()
				d.position = s; s += _count;
				var t2_lo:uint = d.readUnsignedByte()
				d.position = s; s += _count;
				var t2_hi:uint = d.readUnsignedByte()
				d.position = s; s += _count;
				var n:uint = d.readUnsignedByte()
				d.position = s; s += _count;
				var m:uint = d.readUnsignedByte()
				d.position = s; s += _count;
				var va:uint = d.readUnsignedByte()
				d.position = s; s += _count;
				var vb:uint = d.readUnsignedByte()
				d.position = s; s += _count;
				var vc:uint = d.readUnsignedByte()
				d.position = s; s += _count;
				var te_lo:uint = d.readUnsignedByte()
				d.position = s; s += _count;
				var te_hi:uint = d.readUnsignedByte()
				d.position = s;
				var es:uint = d.readUnsignedByte()
				var a:Array = new Array()
				a[0] = (t0_hi << 8) + t0_lo
				a[1] = (t1_hi << 8) + t1_lo
				a[2] = (t2_hi << 8) + t2_lo
				a[3] = n
				a[4] = m
				a[5] = va
				a[6] = vb
				a[7] = vc
				a[8] = (te_hi << 8) + te_lo
				a[9] = es
				_data[i] = a
			}
			a = new Array()
			a[0] = 0
			a[1] = 0
			a[2] = 0
			a[3] = 0
			a[4] = 0
			a[5] = 0
			a[6] = 0
			a[7] = 0
			a[8] = 0
			a[9] = 0
			_data[_count] = a
			ready = true
			isEmpty = false
		}
		
		public function set position(p:Number):void {
			_position = (uint(p)<0 || uint(p)>(_count-1)) ? _count : uint(p)
		}
		public function get position():Number {
			return Number(_position)
		}
		
		public function set positionRelative(p:Number):void {
			if (p>100) p=100
			if (p<0) p=0
			_position = (_count>0) ? Math.round(p/100.0*Number(_count)) : 0
		}
		public function get positionRelative():Number {
			return ( (_count>0) ? Number(_position)/Number(_count)*100 : 0 )
		}	
		
		public function set loop(p:Number):void {
			_loop = (uint(p)<0 || uint(p)>(_count-1)) ? _count : uint(p)
		}
		public function get loop():Number {
			return Number(_loop)
		}
		
		public function get length():Number {
			return Number(_count-1)
		}
		public function set length(n:Number):void {
			_count = uint(n)+1
		}
		
		public function get data():Array {
			if (ready) {
				var a:Array = _data[_position]
				_position++
				if (_position >= _count) {
					if (loopMode) {
						_position = _loop
					} else {
						if (_position > _count) {
							_position = _count
							isEmpty = true
						}
					}
				}
				return a
			} else {
				return new Array(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
			}
		}
		public function set data(d:Array):void { }
		
		protected function ay_readString(d:ByteArray):String {
			var str:String = ""
			var t:uint = d.position
			for (var i:uint=0; i<64; i++) {
				var char:uint = d.readUnsignedByte()
				if (char==0) { break }
			}
			d.position = t
			if (i>0) {
				str = d.readMultiByte(i, "windows-1251")
				d.position++
			}	
			return str
		}
		
	}	
}