﻿package com.fastlibs.media {
	
	/*
	/
	/ FYM Player 1.07 freeware
	/ (c) 2008-2009 Mikhail Vostrikov aka MixailV [monster-sage@mail.ru]
	/ 
	/ Methods:
	/		load(file0:String, file1:String, autoPlay:Boolean = true):void
	/		play(position:Number):void		// 0.0...100.0
	/		stop():void
	/
	/ Properties:
	/		position:Number			(0.0 - 100.0)
	/ 		volume:Number			(0.0 - 1.0)
	/ 		quality:Number			(0-low, 1-high)
	/ 		mixer:String 			("YM ABC", "AY ACB", ...)
	/ 		loop:Boolean
	/		stereoEnhance:Boolean
	/		bassBoost:Boolean
	/		mono:Boolean
	/ 		songName:String
	/ 		songAuthor:String
	/		cpu:Number				(0.0 - 1.0)
	/
	*/
	
	import flash.events.*
	import com.fastlibs.media.YMSound
	import com.fastlibs.media.YMData

	public class YMPlayer extends EventDispatcher {
		public static const NODATA:Number = 0
		public static const STOPPED:Number = 1
		public static const PLAYED:Number = 2
		public var turbo:Boolean
		public var mode:Number = NODATA
		public var file0:String = ""
		public var file1:String = ""
		public var sound:YMSound
		
		protected var data0:YMData
		protected var data1:YMData
		protected var turboCount:Number
		protected var _autoPlay:Boolean

		public function YMPlayer():void {
			sound = new YMSound(update)
			data0 = new YMData()
			data0.addEventListener( "success", success )
			data0.addEventListener( "error", error )
			data1 = new YMData()
			data1.addEventListener( "success", success )
			data1.addEventListener( "error", error )
			quality = 0
			loop = false
			volume = 1
		}
		
		public function load( path0:String, path1:String="", autoPlay:Boolean = true ):void {
			sound.stop(true)
			mode = NODATA
			_autoPlay = autoPlay
			file0 = trim(path0)
			file1 = trim(path1)
			data0.load(file0)			
			if (path1.length>0) {
				turbo = true
				turboCount = 0
				data1.load(file1)
			} else {
				turbo = false
			}
			dispatchEvent( new Event("load start") )
		}
		
		public function play(position:Number=0):Number {
			if (mode==STOPPED) {
				data0.position = 0
				data1.position = 0
				sound.turbo = turbo
				sound.start()
				dispatchEvent( new Event("play") )
				mode = PLAYED
			}
			if (mode==PLAYED) {
				data0.positionRelative = position
				data1.position = data0.position
				dispatchEvent( new Event("continue") )
			}
			return mode
		}
		
		public function stop(reset:Boolean=true):Number {
			if (mode==PLAYED) {
				sound.stop(reset)
				dispatchEvent( new Event("stop") )
				mode = STOPPED
			}
			return mode
		}
		
		public function set stereoEnhance(v:Boolean):void {
			sound.stereoEnhance(v)
		}
		public function get stereoEnhance():Boolean {
			return sound.echo_enabled
		}
		
		public function set bassBoost(v:Boolean):void {
			sound.bassBoost(v)
		}
		public function get bassBoost():Boolean {
			return sound.bb_enabled
		}
		
		public function set mono(v:Boolean):void {
			sound.mono = v
		}
		public function get mono():Boolean {
			return sound.mono
		}
		
		public function set quality(q:Number):void {
			sound.quality = (q == 0) ? 1 : 5
		}
		public function get quality():Number {
			return (sound.quality==1) ? 0 : 1		
		}
		
		public function set loop(l:Boolean ):void {
			data0.loopMode = l 
			data1.loopMode = l 
		}
		public function get loop():Boolean {
			return data0.loopMode	
		}
		
		public function set volume(v:Number):void {
			sound.volume = v 
		}
		public function get volume():Number {
			return sound.volume	
		}
		
		public function set position(p:Number):void {
			data0.positionRelative = p
			data1.position = data0.position
		}
		public function get position():Number {
			return data0.positionRelative
		}
		
		public function set mixer(m:String):void {
			sound.mixer = m
		}
		public function get mixer():String {
			return sound.mixer
		}
		
		public function get songName():String {
			return trim(data0.songName)
		}
		
		public function get songAuthor():String {
			return trim(data0.songAuthor)		
		}
		
		public function get cpu():Number {
			return Math.max(0,Math.min(100,sound.cpu))
		}
		
		protected function success(event:Event):void {
			var len:Number
			var loop:Number
			if (turbo) {
				turboCount++;
				if (turboCount == 2) {
					sound.chipFrequency = data0.chipFrequency
					sound.frameFrequency = data0.frameFrequency
					len = Math.min(data0.length,data1.length)
					data0.length = len
					data1.length = len
					loop = Math.min(data0.loop,data1.loop)
					data0.loop = loop
					data1.loop = loop
					mode = STOPPED
					dispatchEvent( new Event("load success") )
					if (_autoPlay) play()
				}
			} else {
				sound.chipFrequency = data0.chipFrequency
				sound.frameFrequency = data0.frameFrequency
				if (data0.turbo) {
					turbo = true
					data1.create( data0.binaryData )
					len = Math.min(data0.length,data1.length)
					data0.length = len
					data1.length = len
					loop = Math.min(data0.loop,data1.loop)
					data0.loop = loop
					data1.loop = loop
				}	
				mode = STOPPED
				dispatchEvent( new Event("load success") )
				if (_autoPlay) play()
			}
		}
		
		protected function error(event:Event):void {
			dispatchEvent( new Event("load error") )
		}
		
		protected function update(processor0:YMProcessor, processor1:YMProcessor):void {
			if (data0.isEmpty) {
				stop()
				dispatchEvent( new Event("data empty") )
			} else {
				processor0.registers = data0.data
				if (turbo) processor1.registers = data1.data
			}
		}
		
		protected function ltrim (s:String):String {
			var l:int = -1
			while (s.charCodeAt(++l) < 33) {}
			return s.substring(l)
		}
		
		protected function rtrim (s:String):String {
			var l:int = s.length
			while (s.charCodeAt(--l) < 33) {}
			return s.substring(0, ++l)
		}
		
		protected function trim (s:String):String {
			return rtrim(ltrim(s))
		}
		
	}		
}