﻿package com.fastlibs.media {
	
	/*
	/
	/ Internal class for FYM Player
	/ (c) 2008-2009 Mikhail Vostrikov aka MixailV [monster-sage@mail.ru]
	/
	/ Properties:
	/		registers:Array
	/			0 - A channel tone
	/			1 - B channel tone
	/			2 - C channel tone
	/			3 - Noise channel
	/			4 - Mixer flags
	/			5 - A channel volume
	/			6 - B channel volume
	/			7 - C channel volume
	/			8 - Envelope tone
	/			9 - Envalope shape
	/
	/		left:Number
	/		right:Number
	/		frequency:Number
	/		quality:Number
	/		mix:String
	/
	/ Methods:
	/		reset()
	/
	*/
	
	public class YMProcessor {

		protected var update_flags:uint = 3
		protected var _quality:uint = 1
		protected var _qualityTemp:uint = 1

		protected var r_sum:Number = 0
		protected var l_sum:Number = 0
		protected var r_old:Number = 0
		protected var r_old0:Number = 0
		protected var r_old1:Number = 0
		protected var r_old2:Number = 0
			
		protected var l_old:Number = 0
		protected var l_old0:Number = 0
		protected var l_old1:Number = 0
		protected var l_old2:Number = 0

		protected var chipFrequency:Number = 1750000.0
		protected var chipFrequencyTemp:Number = 1750000.0
		protected var chipStep:Number  = (chipFrequency/8.0) / (44100.0 * _quality)

		protected var a_result:Number=0
		protected var b_result:Number=0
		protected var c_result:Number=0
		protected var ta_count:Number=0
		protected var ta_step:Number=0
		protected var ta_value:uint=0
		protected var ta_mix:uint=0
		protected var tb_count:Number=0
		protected var tb_step:Number=0
		protected var tb_value:uint=0
		protected var tb_mix:uint=0
		protected var tc_count:Number=0
		protected var tc_step:Number=0
		protected var tc_value:uint=0
		protected var tc_mix:uint=0
		protected var va_value:Number=0
		protected var vb_value:Number=0
		protected var vc_value:Number = 0
		
		protected var v_table:Array
		protected var v_tableTemp:Array
		protected var v_table_YM:Array = new Array(0, 0, 0xF8, 0x1C2, 0x29E, 0x33A, 0x3F2, 0x4D7, 0x610, 0x77F, 0x90A, 0xA42, 0xC3B, 0xEC2, 0x1137, 0x13A7, 0x1750, 0x1BF9, 0x20DF, 0x2596, 0x2C9D, 0x3579, 0x3E55, 0x4768, 0x54FF, 0x6624, 0x773B, 0x883F, 0xA1DA, 0xC0FC, 0xE094, 0xFFFF)	// Hacker KAY
		protected var v_table_AY:Array = new Array(0, 0, 836, 836, 1212, 1212, 1773, 1773, 2619, 2619, 3875, 3875, 5397, 5397, 8823, 8823, 10392, 10392, 16706, 16706, 23339, 23339, 29292, 29292, 36969, 36969, 46421, 46421, 55195, 55195, 65535, 65535)	// Hacker KAY

		protected var n_value:uint=0
		protected var n_count:Number=0
		protected var n_step:Number=0
		protected var na_mix:uint=0
		protected var nb_mix:uint=0
		protected var nc_mix:uint=0
		protected var n_sample:Vector.<uint> = new Vector.<uint>(131072,true)
		protected var k_sin:Vector.<Number> = new Vector.<Number>(5,true)

		protected var e_shapes:Array
		protected var e_sample:Vector.<Number>
		protected var e_loop:Boolean=false
		protected var e_value:Number=0
		protected var e_count:Number=0
		protected var e_step:Number=0
		protected var ea_mix:uint=0
		protected var eb_mix:uint=0
		protected var ec_mix:uint = 0
		protected var k_mixUpdate:Boolean = false
		protected var k_mixTemp:Number = 0
		protected var k_mixA:Array
		protected var k_mixS:String = "YM ABC"
		protected var k_mix:uint=0
		protected var k_mixBase:Number = 512.0 * 1.8		//891   //438
		protected var k_mix00:Number = 235.0 / k_mixBase
		protected var k_mix01:Number = 157.0 / k_mixBase
		protected var k_mix02:Number =  46.0 / k_mixBase
		protected var k_mix10:Number =  46.0 / k_mixBase
		protected var k_mix11:Number = 157.0 / k_mixBase
		protected var k_mix12:Number = 235.0 / k_mixBase
		protected var k_filter:Number = 0.9995
		protected var register:Array = new Array()
		protected var temp:uint = 0
		
		protected var e_sample0:Vector.<Number> = new Vector.<Number>(64,true)
		protected var e_sample1:Vector.<Number> = new Vector.<Number>(64,true)
		protected var e_sample2:Vector.<Number> = new Vector.<Number>(64,true)
		protected var e_sample3:Vector.<Number> = new Vector.<Number>(64,true)
		protected var e_sample4:Vector.<Number> = new Vector.<Number>(64,true)
		protected var e_sample5:Vector.<Number> = new Vector.<Number>(64,true)
		protected var e_sample6:Vector.<Number> = new Vector.<Number>(64,true)
		protected var e_sample7:Vector.<Number> = new Vector.<Number>(64,true)
		
		public function YMProcessor():void {
			
			for (var i:uint = 0; i < 32; i++) {
				v_table_YM[i] /= 65535.0
				v_table_AY[i] /= 65535.0
			}
			
			for (i = 1; i < 6; i++) {
				k_sin[i-1] = 0.26 * Math.sin( Number(i) / 7.0 * Math.PI )
			}
			
			k_mixA = new Array(
				new Array(235.0, 157.0, 46.0,  46.0, 157.0, 235.0, "YM ABC"),
				new Array(235.0, 46.0, 157.0,  46.0, 235.0, 157.0, "YM ACB"),
				new Array(157.0, 235.0, 46.0,  157.0, 46.0, 235.0, "YM BAC"),
				new Array(157.0, 46.0, 235.0,  157.0, 235.0, 46.0, "YM BCA"),
				new Array(46.0, 235.0, 157.0,  235.0, 46.0, 157.0, "YM CAB"),
				new Array(46.0, 157.0, 235.0,  235.0, 157.0, 46.0, "YM CBA"),
				
				new Array(219.0, 146.0, 73.0,  73.0, 146.0, 219.0, "AY ABC"),
				new Array(219.0, 73.0, 146.0,  73.0, 219.0, 146.0, "AY ACB"),
				new Array(146.0, 219.0, 73.0,  146.0, 73.0, 219.0, "AY BAC"),
				new Array(146.0, 73.0, 219.0,  146.0, 219.0, 73.0, "AY BCA"),
				new Array(73.0, 219.0, 146.0,  219.0, 73.0, 146.0, "AY CAB"),
				new Array(73.0, 146.0, 219.0,  219.0, 146.0, 73.0, "AY CBA")
			)
			v_table = v_table_YM
			
			var nc:uint=0;
			var na:uint=0;
			var nb:uint=0;
			for (var j:uint=0; j<131072; j++) {
				n_sample[j] = (nc >> 16) & 1;
				nc <<= 1;
				na = (nc >> 13 ) & 1;
				nb = (nc >> 16 ) & 1;
				nc |= ((na ^ nb)^1);
			}

			generate_envelope()
			e_shapes = new Array(
				new Array(e_sample0,false),
				new Array(e_sample0,false),
				new Array(e_sample0,false),
				new Array(e_sample0,false),
				new Array(e_sample1,false),
				new Array(e_sample1,false),
				new Array(e_sample1,false),
				new Array(e_sample1,false),
				new Array(e_sample6,true ),
				new Array(e_sample0,false),
				new Array(e_sample3,true ),
				new Array(e_sample4,false),
				new Array(e_sample7,true ),
				new Array(e_sample5,false),
				new Array(e_sample2,true ),
				new Array(e_sample1,false)
			)
			e_sample=e_shapes[0][0]
			e_loop = e_shapes[0][1]
			
			reset()
		}
		
		//
		// set registers:
		//		0 - A channel tone
		//		1 - B channel tone
		//		2 - C channel tone
		//		3 - Noise channel
		//		4 - Mixer flags
		//		5 - A channel volume
		//		6 - B channel volume
		//		7 - C channel volume
		//		8 - Envelope tone
		//		9 - Envelope shape
		//
		
		public function set registers(a:Array):void {
			if (_qualityTemp!=_quality||chipFrequency!=chipFrequencyTemp) {
				_quality = _qualityTemp
				chipFrequency = chipFrequencyTemp
				chipStep = (chipFrequency/8) / (44100 * _quality)
				r_old = r_sum
					r_old0 = r_sum
					r_old1 = r_sum
					r_old2 = r_sum
				l_old = l_sum
					l_old0 = l_sum
					l_old1 = l_sum
					l_old2 = l_sum
			}
			if (k_mixUpdate) {
				k_mix00 = k_mixA[k_mixTemp][0] / k_mixBase
				k_mix01 = k_mixA[k_mixTemp][1] / k_mixBase
				k_mix02 = k_mixA[k_mixTemp][2] / k_mixBase
				k_mix10 = k_mixA[k_mixTemp][3] / k_mixBase
				k_mix11 = k_mixA[k_mixTemp][4] / k_mixBase
				k_mix12 = k_mixA[k_mixTemp][5] / k_mixBase
				k_mixS = k_mixA[k_mixTemp][6]
				v_table = v_tableTemp
				generate_envelope()
				k_mixUpdate = false
			}
			register[0] = Math.max(Math.min(Number(a[0]), 4095), 1)
			register[1] = Math.max(Math.min(Number(a[1]), 4095), 1)
			register[2] = Math.max(Math.min(Number(a[2]), 4095), 1)
			register[3] = Math.max(Math.min(Number(a[3]), 31), 0)
			register[4] = a[4]
			register[5] = Math.max(Math.min(Number(a[5]), 31), 0)
			register[6] = Math.max(Math.min(Number(a[6]), 31), 0)
			register[7] = Math.max(Math.min(Number(a[7]), 31), 0)
			register[8] = Math.max(Math.min(Number(a[8]), 65535), 1)
			register[9] = Math.max(Math.min(Number(a[9]), 255), 0)
			ta_step = chipStep / register[0]
			tb_step = chipStep / register[1]
			tc_step = chipStep / register[2]
			n_step  = (chipStep * 0.5) / (register[3] + 1)
			e_step  = chipStep / register[8]
			temp = register[4]
			ta_mix = (temp & 1) ^ 1
			temp >>= 1
			tb_mix = (temp & 1) ^ 1
			temp >>= 1
			tc_mix = (temp & 1) ^ 1
			temp >>= 1
			na_mix = (temp & 1) ^ 1
			temp >>= 1
			nb_mix = (temp & 1) ^ 1
			temp >>= 1
			nc_mix = (temp & 1) ^ 1
			temp = register[5] & 15
			va_value = v_table[ (temp << 1) + 1 ]
			ea_mix = register[5] & 16
			temp = register[6] & 15
			vb_value = v_table[ (temp << 1) + 1 ]
			eb_mix = register[6] & 16
			temp = register[7] & 15
			vc_value = v_table[ (temp << 1) + 1 ]
			ec_mix = register[7] & 16
			if (register[9] != 255) {
				e_count = 0
				e_sample = e_shapes[register[9] & 15][0]
				e_loop = e_shapes[register[9] & 15][1]
			}
		}
		public function get registers():Array {
			return register
		}
		
		public function reset():void {
			registers = new Array(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
		}
		
		public function get left():Number {
			if (update_flags==3) {
				update()
				update_flags = 0
			}
			update_flags |= 1
			return l_sum
		}
		public function set left(v:Number):void { }
		
		public function get right():Number {
			if (update_flags==3) {
				update()
				update_flags = 0
			}
			update_flags |= 2
			return r_sum
		}
		public function set right(v:Number):void { }
		
		public function get quality():Number {
			return Number(_quality);
		}
		public function set quality(q:Number):void {
			_qualityTemp = uint( (q == 1) ? 1 : 5 )
		}
		
		public function get frequency():Number {
			return Number(chipFrequency);
		}
		public function set frequency(q:Number):void {
			chipFrequencyTemp = (q < 1) ? 1 : q
		}
		
		public function set mixer(m:String):void {
			m = m.toUpperCase()
			for (var i:uint = (k_mixA.length-1); i>=0 ; i--) {
				if (k_mixA[i][6] == m) break
			}
			k_mixTemp = i
			v_tableTemp = (i < 6) ? v_table_YM : v_table_AY
			k_mixUpdate = true
			k_mixS = k_mixA[k_mixTemp][6]
		}
		public function get mixer():String {
			return k_mixS
		}
		
		private function update():void {
			r_sum = 0
			l_sum = 0
			for (var i:uint = 0; i < _quality; i++) {
				ta_value = uint(ta_count) & 1
				ta_count = ( ta_count += ta_step ) % 8192
				tb_value = uint(tb_count) & 1
				tb_count = ( tb_count += tb_step ) % 8192
				tc_value = uint(tc_count) & 1
				tc_count = ( tc_count += tc_step ) % 8192
				n_value = n_sample[uint(n_count)]
				n_count = ( n_count += n_step ) % 131071
				e_value = e_sample[uint(e_count) & 63]
				if (e_loop) {
					e_count = ( e_count += e_step ) % 8192
				} else {
					if ((e_count += e_step)>63) e_count=63
				}
				k_mix = (ta_mix) ? ta_value : 1
				if (na_mix) k_mix &= n_value
				a_result = k_mix * ((ea_mix) ? e_value : va_value)
				k_mix = (tb_mix) ? tb_value : 1
				if (nb_mix) k_mix &= n_value
				b_result = k_mix * ((eb_mix) ? e_value : vb_value)
				k_mix = (tc_mix) ? tc_value : 1
				if (nc_mix) k_mix &= n_value
				c_result = k_mix * ((ec_mix) ? e_value : vc_value)
				if (_quality>1) {
					r_old += ( (k_sin[i] * ( a_result * k_mix00 + b_result * k_mix01 + c_result * k_mix02 )) - r_old) * k_filter
					r_old0 += (r_old  - r_old0) * k_filter
					r_old1 += (r_old0 - r_old1) * k_filter
					r_old2 += (r_old1 - r_old2) * k_filter
					l_old += ( (k_sin[i] * ( a_result * k_mix10 + b_result * k_mix11 + c_result * k_mix12 )) - l_old) * k_filter
					l_old0 += (l_old  - l_old0) * k_filter
					l_old1 += (l_old0 - l_old1) * k_filter
					l_old2 += (l_old1 - l_old2) * k_filter
					r_sum += r_old2
					l_sum += l_old2
				} else {
					r_sum = ( a_result * k_mix00 + b_result * k_mix01 + c_result * k_mix02 )
					l_sum = ( a_result * k_mix10 + b_result * k_mix11 + c_result * k_mix12 )
				}
			}				
		}
		
		private function generate_envelope():void {
			for (var j0:uint = 0; j0 < 32; j0++) {
				var j1:uint = j0 + 32
				e_sample0[j0] = v_table[31 - j0]
				e_sample0[j1] = v_table[0]
				e_sample1[j0] = v_table[j0]
				e_sample1[j1] = v_table[0]
				e_sample2[j0] = v_table[j0]
				e_sample2[j1] = v_table[31 - j0]
				e_sample3[j0] = v_table[31 - j0]
				e_sample3[j1] = v_table[j0]
				e_sample4[j0] = v_table[31 - j0]
				e_sample4[j1] = v_table[31]
				e_sample5[j0] = v_table[j0]
				e_sample5[j1] = v_table[31]
				e_sample6[j0] = v_table[31 - j0]
				e_sample6[j1] = v_table[31 - j0]
				e_sample7[j0] = v_table[j0]
				e_sample7[j1] = v_table[j0]
			}
		}
		
	}
}