﻿package com.fastlibs.media {
	
	/*
	/
	/ Internal class for FYM Player
	/ (c) 2008-2009 Mikhail Vostrikov aka MixailV [monster-sage@mail.ru]
	/
	/ Methods:
	/		start():void
	/		stop():void
	/
	/ Properties:
	/		turbo:Boolean		// single-turbo
	/		quality:Number
	/		volume:Number
	/		chipFrequency:Number
	/		frameFrequency:Number
	/		updateCallback:Function
	/		time:int	// delta time
	/		cpu:Number	// cpu 0.0 - 1.0
	/
	*/
	
	import com.fastlibs.media.YMProcessor
	import flash.utils.getTimer
	import flash.media.Sound
	import flash.media.SoundChannel
	import flash.media.SoundTransform
	import flash.events.SampleDataEvent

	public class YMSound extends Sound {

		public var time:int = 0
		public var cpu:Number = 0
		public var turbo:Boolean = false
		public var updateCallback:Function = null
		public var chipFrequency:Number = 1750000.0
		public var quality:Number = 1
		public var ym0:YMProcessor
		public var ym1:YMProcessor
		protected var playMode:Boolean = false
		protected var soundListener:Boolean = false
		protected var soundChannel:SoundChannel = null
		protected var soundTransform:SoundTransform
		protected var volumeTemp:Number = 1.0
		protected var frameCountMax:int = 881
		protected var frameCount:int = frameCountMax+1
		protected var frameFrequencyTemp:Number = 50
		protected var timeTemp:int = 0
		protected var timeCurrent:int = 0
		protected var right:Number = 0.0
		protected var left:Number = 0.0

		public var echo_enabled:Boolean = false
		protected var echo_update:Boolean = false
		protected var echo_delayMax:uint = 44100
		protected var echo_delay:uint = 529
		protected var echo_r:Vector.<Number> = new Vector.<Number>(echo_delay + 1,true)
		protected var echo_l:Vector.<Number> = new Vector.<Number>(echo_delay + 1,true)
		protected var echo_p:uint = 0
		protected var echo_tempR:Number = 0
		protected var echo_tempL:Number = 0
		protected var echo_mix:Number = 0.65
		protected var echo_filter:Number = 0.5
		
		public var bb_enabled:Boolean = false
		protected var bb_filter:Number = 2.0 * Math.sin(Math.PI * (250.0 / 44100.0))
		protected var bb_amp:Number = 2.9
		protected var bb_mix:Number = 0.67
		protected var bb_mixA:Number = bb_mix * 0.5 * bb_amp
		protected var bb_mixB:Number = (1.0 - bb_mix) * bb_amp
		
		protected var bb_v0:Number = 0.0
		protected var bb_v1:Number = 0.0
		protected var bb_v2:Number = 0.0
		protected var bb_v3:Number = 0.0
		protected var bb_v4:Number = 0.0
		protected var bb_v5:Number = 0.0
		protected var bb_v6:Number = 0.0
		
		protected var pp_filter:Number = 2.0 * Math.sin(Math.PI * (20.0 / 44100.0))
		protected var pp_v0:Number = 0.0
		protected var pp_v1:Number = 0.0
		protected var pp_v2:Number = 0.0
		protected var pp_v3:Number = 0.0
		protected var pp_v4:Number = 0.0
		protected var pp_v5:Number = 0.0
		protected var pp_v6:Number = 0.0
		
		public var mono:Boolean = false

		public function YMSound(update:Function=null) {
			ym0 = new YMProcessor()
			ym1 = new YMProcessor()
			updateCallback = update
		}
		
		public function set frameFrequency(q:Number):void {
			q = Math.max(Math.min(q, 100), 10)
			frameCountMax = uint(44100.0/q)+1
			frameFrequencyTemp = q
		}
		public function get frameFrequency():Number {
			return frameFrequencyTemp 
		}
		
		public function set volume(v:Number):void {
			volumeTemp = Math.max(Math.min(v, 1), 0)
			if (soundChannel!=null) { soundChannel.soundTransform = new SoundTransform(volumeTemp,0) }
		}
		public function get volume():Number {
			return volumeTemp
		}
		
		public function set mixer(m:String):void {
			ym0.mixer = m
			ym1.mixer = m
		}
		public function get mixer():String {
			return ym0.mixer
		}	
		
		protected function updateBuffer(event:SampleDataEvent):void {
			timeCurrent = getTimer()
			time = timeCurrent - timeTemp
			timeTemp = timeCurrent
			for ( var i:int=0; i<4096; i++ ) {
				if (playMode) {
					
					frameCount++
					if (frameCount>frameCountMax) {
						ym0.quality = quality
						ym0.frequency = chipFrequency
						ym1.quality = quality
						ym1.frequency = chipFrequency
						if (updateCallback != null) { updateCallback(ym0, ym1) }
						frameCount = -1
					}
					
					if (turbo) {
						right = (ym0.right + ym1.right) * 0.5
						left  = (ym0.left + ym1.left) * 0.5
					} else {
						right = ym0.right
						left  = ym0.left
					}					

					if (echo_enabled) {
						echo_tempR = right + echo_l[echo_p] * echo_mix
						echo_tempL = left  + echo_r[echo_p] * echo_mix
						echo_r[echo_p] += (right - echo_r[echo_p]) * echo_filter
						echo_l[echo_p] += (left  - echo_l[echo_p]) * echo_filter
						if (++echo_p==echo_delay) echo_p=0
						right = echo_tempR
						left  = echo_tempL
					}
		
					if (bb_enabled) {
						bb_v0 += bb_filter * ( right + left - bb_v0)
						bb_v1 += bb_filter * (bb_v0 - bb_v1)
						bb_v2 += bb_filter * (bb_v1 - bb_v2)
						bb_v3 += bb_filter * (bb_v2 - bb_v3)
						bb_v4 += bb_filter * (bb_v3 - bb_v4)
						bb_v5 += bb_filter * (bb_v4 - bb_v5)
						bb_v6 += bb_filter * (bb_v5 - bb_v6)
						right = bb_v6 * bb_mixA + right * bb_mixB
						left  = bb_v6 * bb_mixA + left  * bb_mixB
					}
					
					pp_v0 += pp_filter * ( (right + left) * 0.5 - pp_v0)
					pp_v1 += pp_filter * (pp_v0 - pp_v1)
					pp_v2 += pp_filter * (pp_v1 - pp_v2)
					pp_v3 += pp_filter * (pp_v2 - pp_v3)
					pp_v4 += pp_filter * (pp_v3 - pp_v4)
					pp_v5 += pp_filter * (pp_v4 - pp_v5)
					pp_v6 += pp_filter * (pp_v5 - pp_v6)
					right -= pp_v6
					left  -= pp_v6
					
					if (mono) {
						var tmp:Number = (right + left)*0.5
						right = tmp
						left  = tmp
					}

					event.data.writeFloat( right )
					event.data.writeFloat( left  )

				} else {
					event.data.writeFloat( 0 )
					event.data.writeFloat( 0 )
				}
			}
			cpu = 100.0 * Number(getTimer()-timeTemp)/Number(time)
		}
		
		public function stereoEnhance(enabled:Boolean, mixer:Number = -1, filter:Number = -1, delay:Number = -1):void {
			echo_enabled = enabled
			if (mixer>0 && filter>0 && delay>0) {
				echo_delay = uint(delay * Number(echo_delayMax))
				if (echo_delay < 10) echo_delay = 10
				if (echo_delay >= echo_delayMax) echo_delay = echo_delayMax-1
				if (echo_enabled) {
					echo_r = new Vector.<Number>(echo_delay + 1,true)
					echo_l = new Vector.<Number>(echo_delay + 1,true)
				}
				echo_mix = mixer
				echo_filter = filter
				echo_p = 0
			}
		}
		
		public function bassBoost(enabled:Boolean, mixer:Number = -1, filter:Number = -1, amplify:Number =-1):void {
			bb_enabled = enabled
			if (mixer>0 && filter>0 && amplify>0) {
				bb_filter = 2.0 * Math.sin(Math.PI * (filter / 44100.0))
				bb_amp = amplify
				bb_mix = mixer
				bb_mixA = bb_mix * 0.5 * bb_amp
				bb_mixB = (1.0 - bb_mix) * bb_amp
			}
			if (bb_enabled) { bb_v0 = bb_v1 = bb_v2 = bb_v3 = bb_v4 = bb_v5 = bb_v6 = 0.0 }
		}
		
		public function start():void {
			if (!soundListener) {
				this.addEventListener("sampleData",updateBuffer)
				soundListener = true
			}
			if (soundChannel==null) { soundChannel = this.play() }
			if (soundChannel!=null) { soundChannel.soundTransform = new SoundTransform(volumeTemp,0) }
			frameCount = frameCountMax+1
			
				bb_v0 = bb_v1 = bb_v2 = bb_v3 = bb_v4 = bb_v5 = bb_v6 = 0.0
				pp_v0 = pp_v1 = pp_v2 = pp_v3 = pp_v4 = pp_v5 = pp_v6 = 0.0
				echo_r = new Vector.<Number>(echo_delay + 1,true)
				echo_l = new Vector.<Number>(echo_delay + 1,true)
				echo_p = 0
				
			playMode = true
		}
		
		public function stop(reset:Boolean=true):void {
			playMode = false
			frameCount = -1
			if (reset) {
				ym0.reset()
				ym1.reset()
			}
			if (soundChannel!=null) { soundChannel.soundTransform = new SoundTransform(0,0) }
		}
		
	}	
}