#include <avr/io.h>
#include <util/delay.h>

#define HI(x) ((x)>>8)
#define LO(x) ((x)&0xFF)

#define DATAPORT PORTC
#define DATADDR DDRC
#define DATAIN PINC
#define ADDRPORT PORTA
#define ADDRDDR DDRA
#define CONTROLPORT PORTB
#define CONTROLDDR DDRB
#define WE 0
#define OE 1
#define ALE 2
#define WE0 cbi(CONTROLPORT,WE)
#define WE1 sbi(CONTROLPORT,WE)
#define OE0 cbi(CONTROLPORT,OE)
#define OE1 sbi(CONTROLPORT,OE)
#define ALE0 cbi(CONTROLPORT,ALE)
#define ALE1 sbi(CONTROLPORT,ALE)

void SRAM64_INIT (void)
{
	CONTROLPORT |= (1<<WE)|(1<<OE);
	CONTROLPORT &= ~(1<<ALE);
	CONTROLDDR |= (1<<WE)|(1<<OE)|(1<<ALE);
	ADDRPORT = 0xFF;
	ADDRDDR = 0xFF;
	DATAPORT = 0xFF;
	DATADDR = 0xFF;
}

void SRAM64_SET_ADDR (unsigned int addr)
{
	ADDRPORT = LO(addr);
	ALE1;
	//_delay_us(10);
	ALE0;
	ADDRPORT = HI(addr);
}

void SRAM64_WRITE_DATA (unsigned char data)
{
	DATADDR = 0xFF;
	DATAPORT = data;
	WE0;
	WE1;
	DATAPORT=0xFF;
}

unsigned char SRAM64_READ_DATA (void)
{
	unsigned char data;
	DATAPORT = 0xFF;
	DATADDR = 0x00;
	OE0;
	_delay_us(5);
	data=DATAIN;
	OE1;
	return data;
}

void SRAM64_WRITE (unsigned int addr, unsigned char data)
{
	SRAM64_SET_ADDR (addr);
	SRAM64_WRITE_DATA(data);
}

unsigned char SRAM64_READ (unsigned int addr)
{
	SRAM64_SET_ADDR (addr);
	return SRAM64_READ_DATA();
}

void SRAM64_WRITE_W (unsigned int addr, unsigned int data)
{
	SRAM64_SET_ADDR (addr);
	SRAM64_WRITE_DATA(LO(data));
	SRAM64_SET_ADDR (addr+1);
	SRAM64_WRITE_DATA(HI(data));
}

unsigned int SRAM64_READ_W (unsigned int addr)
{
	unsigned char l;
	unsigned char h;
	SRAM64_SET_ADDR (addr);
	l=SRAM64_READ_DATA();
	SRAM64_SET_ADDR (addr+1);
	h=SRAM64_READ_DATA();
	return (((unsigned int)h<<8)|(unsigned int)l);
}