#if 0
The MIT License (MIT)

Copyright (c) 2014 inmensabolademanteca@gmail.com

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
#endif

; ----------------------------------------------------------------------------
; CIDLESA's Altair arcade (1981) port to the ZX Spectrum.
;
; Constants.
; ----------------------------------------------------------------------------

; If master version, the wicth of the back buffer (ABUFW) cannot be changed.
; If not, its value can be changed IF the function cbpos is changed as well.
MASTER_VERSION	.equ 1

; Colors
BLACK	.equ 0
BLUE	.equ 1
RED	.equ 2
MAGENT	.equ 3
GREEN	.equ 4
CYAN	.equ 5
YELLOW	.equ 6
WHITE	.equ 7
PBLACK	.equ BLACK << 3
PBLUE	.equ BLUE << 3
PRED	.equ RED << 3
PMAGENT	.equ MAGENT << 3
PGREEN	.equ GREEN << 3
PCYAN	.equ CYAN << 3
PYELLOW	.equ YELLOW << 3
PWHITE	.equ WHITE << 3
LIT	.equ $40
FLASH	.equ $80

; Video RAM.
vram	.equ $4000

; Size of Attribute Video RAM.
ARAMW	.equ 32
ARAMH	.equ 24
ARAMSZ	.equ ARAMW*ARAMH

; Size of Video RAM.
VRAMSZ	.equ ARAMSZ*8

; Attribute ram.
aram	.equ vram + VRAMSZ

; Number of lines of 8 pixel height in Back Buffer or,
; number of lines in Attribute Buffer.
; This, multiplied by 8, must be multiple of 6 (height of aliens).
ABUFH	.equ 21

; Width of Back Buffer in bytes.
; Warning: this must be 24 due to 'cbpos' algorithm!
ABUFW	.equ 24

; Attribute Buffer Size.
ABUFSZ .equ ABUFW*ABUFH

; Height of Back Buffer in pixels (bytes).
BBUFH	.equ ABUFH*8

; Width of Back Buffer in pixels.
BBUFW	.equ ABUFW*8

; Back Buffer Size in bytes.
BBUFSZ	.equ ABUFSZ*8

; Start x character position to center the Back Buffer on the screen.
BBUFX	.equ (32-ABUFW)/2

; Start y character position of Back Buffer on screen.
BBUFY	.equ 2

; Color to clear Attribute Buffer.
ABUFCLR	.equ BLUE

; ------------
; Sprite Table
; ------------

MINE_SP_SLOT		.equ 0
MINE_SP_SLOTS		.equ 12
EXPLOSION_SP_SLOT	.equ MINE_SP_SLOT+MINE_SP_SLOTS
EXPLOSION_SP_SLOTS	.equ 6
SHIP_SHOT_SP_SLOT	.equ EXPLOSION_SP_SLOT+EXPLOSION_SP_SLOTS
SHIP_SHOT_SP_SLOTS	.equ 2
SHIP_SP_SLOT		.equ SHIP_SHOT_SP_SLOT+SHIP_SHOT_SP_SLOTS
SHIP_SP_SLOTS		.equ 5
ALIEN_SHOT_SP_SLOT	.equ SHIP_SP_SLOT+SHIP_SP_SLOTS
ALIEN_SHOT_SP_SLOTS	.equ 6
ALIEN_SP_SLOT		.equ ALIEN_SHOT_SP_SLOT+ALIEN_SHOT_SP_SLOTS
ALIEN_SP_SLOTS		.equ 6
BIRD_SHIELD_SP_SLOT	.equ ALIEN_SP_SLOT+ALIEN_SP_SLOTS
BIRD_SHIELD_SP_SLOTS	.equ 1
HOUSE_SP_SLOT		.equ BIRD_SHIELD_SP_SLOT+BIRD_SHIELD_SP_SLOTS
HOUSE_SP_SLOTS		.equ 2
NSPRS			.equ HOUSE_SP_SLOT+HOUSE_SP_SLOTS

; Careful, for the bird we are reusing the sprites form ALIEN_SHOT_SP_SLOTS
BIRD_NSPS		.equ 13
BIRD_SP_SLOT		.equ ALIEN_SHOT_SP_SLOT
BIRD_SP_SLOTS		.equ BIRD_NSPS
BIRD_EXPLOSION_SP_SLOT	.equ HOUSE_SP_SLOT

#if (BIRD_NSPS > (ALIEN_SHOT_SP_SLOTS + ALIEN_SP_SLOTS + BIRD_SHIELD_SP_SLOTS))
	.echo "Error: too many bird sprites."
#endif

; Maximum number of rects that the Rect List can contain.
MAXRECS	.equ NSPRS*2

; Object slots.
; Function.
OB_FUL	.equ 0
OB_FUH	.equ 1
; Sprite pointer.
OB_SPL	.equ 2
OB_SPH	.equ 3
; Dimensions.
OB_DX	.equ 4
OB_DY	.equ 5
; Other sprite
OB_SP2L	.equ 4
OB_SP2H	.equ 5
; Counters.
OB_CNT0	.equ 4
OB_CNT1	.equ 5
OB_CNT3	.equ 2
OBJSZ	.equ 6

; -------------
; Sprite Struct
; -------------

; Address of Image Table.
SP_ITL	.equ 0
SP_ITH	.equ 1
; Position in pixels.
SP_PX	.equ 2
SP_PY	.equ 3
; Color if SP_COH is 0, otherwise address of Color Pattern.
SP_COL	.equ 4
SP_COH	.equ 5
; Animation address, 0 no animation.
SP_ANL	.equ 6
SP_ANH	.equ 7
; Speed and speed counter for animation.
SP_SPE	.equ 8
SP_SPC	.equ 9
; Frame of animation.
SP_FRA	.equ 10
; If looped or not.
SP_LOP	.equ 11
SPRSZ	.equ 12

; Image Slots.
; Dimensions.
IM_WID	.equ 0
IM_HEI	.equ 1

; Image constants.
SHIP_IM_WC	.equ 3
SHIP_IM_W	.equ SHIP_IM_WC*8
SHIP_IM_H	.equ 16
SHIP_IM_HC	.equ SHIP_IM_H/8
HOUSE_IM_WC	.equ 3
ALIEN_IM_H	.equ 6
ALIEN_IM_WC	.equ 2
ALIEN_IM_W	.equ ALIEN_IM_WC*8
EXPLOSION_IM_H	.equ 12
EXPLOSION_OFFS	.equ (EXPLOSION_IM_H - ALIEN_IM_H) / 2
BIRD_WC		.equ 6
BIRD_HC		.equ 7

; Starting positions.
HOUSE_LPOS	.equ 8
HOUSE_MPOS	.equ 8 * ((ABUFW - HOUSE_IM_WC) / 2)
HOUSE_RPOS	.equ 8 * (ABUFW - HOUSE_IM_WC - 1)
SHIP_LPOS	.equ 8
SHIP_MPOS	.equ 8 * ((ABUFW - SHIP_IM_WC) / 2)
SHIP_RPOS	.equ 8 * (ABUFW - SHIP_IM_WC - 1)

BIRD_LEVEL	.equ 7

;
SHIP_SHOT_SPEED		.equ 4
ALIEN_SHOT_SPEED	.equ 4

HOUSE_YPOS	.equ 8

; Main program states.
STATE_NONE	.equ -1
STATE_MENU	.equ 0
STATE_GAMEPLAY	.equ 1
STATE_ATTRACT	.equ 2
STATE_OPTIONS	.equ 3
STATE_KILLED	.equ 4
STATE_ROUND	.equ 5
STATE_NAME	.equ 6
STATE_DISCLAIMER	.equ 7
STATE_DEDICATE	.equ 8
STATE_GAMEOVER	.equ 9

; Beeper ROM routine address.
BEEP	.equ	$03b5

; Interrupt JP address.
INTERR	.equ $fdfd
INTTAB	.equ $fe00

; End of line.
EOF	.equ 2
