#if 0
The MIT License (MIT)

Copyright (c) 2014 inmensabolademanteca@gmail.com

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
#endif

; ----------------------------------------------------------------------------
; CIDLESA's Altair arcade (1981) port to the ZX Spectrum.
;
; Disclaimer text.
; ----------------------------------------------------------------------------

txdisclaim
	.db "ALTAIR ES UN JUEGO DE 1981 PARA", 0
	.db "MAQUINAS RECREATIVAS, DESARRO-", 0
	.db "LLADO POR LA EMPRESA CIDELSA.", 0
	.db "ESTA ES LA VERSION PARA ZX", 0
	.db "SPECTRUM 48K, PROGRAMADA EN EL", 0
	.db "2014.", 0
	.db " ", 0
	.db "ESTA VERSION MUESTRA EL NOMBRE", 0
	.db "DE CIDELSA EN VARIAS PANTALLAS.", 0
	.db "ESTO ES PARA IMITAR AL JUEGO", 0
	.db "ORIGINAL Y COMO HOMENAJE, Y NO", 0
	.db "INIDICA LA PARTICIPACION DE", 0
	.db "CIDELSA EN LA PRESENTE VERSION.", 0
	.db EOF

; ---------------------
; 'enter_disclaimer_st'
; ---------------------

enter_disclaimer_st
	ld a,0
	call clrscr

	ld hl,txdisclaim
	call drtext
	ret

; ----------------------
; 'update_disclaimer_st'
; ----------------------

update_disclaimer_st
	call pollk
	call getkey
	or a
	ret z

	ld a,STATE_DEDICATE
	call set_state
	ret

; ----------------------
; 'drtext' Draws a text.
; ----------------------
;	Draws a series of lines centered and full screen.
;
; In	HL first string address.

drtext

; Count lines and save in C for the rest of the algorithm.

	push hl
	call cntlines
	ld c,b
	pop hl

; Calc start y position.

	ld a,ARAMH
	sub b
	srl a
	ld d,a
	ld e,0

; Now draw the lines.

drtext_next

; Calc centered x position.

	push hl
	call strlen
	ld a,ARAMW
	sub b
	srl a
	ld e,a
	pop hl

	ld a,WHITE|PBLACK
	push bc
	push de
	push hl
	call drstr
	pop hl
	pop de
	pop bc

	dec c
	inc d
	ret z

	call nextline
	jr nc,drtext_next 
	ret

; ----------
; 'nextline'
; ----------
;	If HL points to a string, it finds the next one.
;
; In	HL address of string.
; Out	HL address of new string if CY=0. Or no more lines if CY=1.
; Saves	BC, DE.

nextline

	ld a,(hl)
	inc hl
	cp EOF
	jr z,next_line_eof
	or a
	jr nz,nextline
	ld a,(hl)
	cp EOF
	jr z,next_line_eof
	ret

next_line_eof
	scf
	ret

; ----------------------
; 'cntlines' Count lines
; ----------------------
;	Counts lines in a text ended by code EOF.
;
; In	HL address of text.
; Out	B number of lines.
; Saves	DE, C.

cntlines

	ld b,0

cntlines1

	ld a,(hl)
	inc hl
	cp EOF
	ret z
	or a
	jr nz,cntlines1
	inc b
	jr cntlines1
