#if 0
The MIT License (MIT)

Copyright (c) 2014 inmensabolademanteca@gmail.com

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
#endif

; ----------------------------------------------------------------------------
; CIDLESA's Altair arcade (1981) port to the ZX Spectrum.
;
; Code for preprocessing image tables.
; ----------------------------------------------------------------------------

; This images are incomplete, their right side will be built mirrored.
pmir0	.dw alim00
	.dw alim01
	.dw alim10
	.dw alim11
	.dw alim20
	.dw alim21
	.dw alim30
	.dw alim40
	.dw alim41
	.dw alim50
	.dw alim51
	.dw alim60
	.dw bird_up
	.dw bird_center
	.dw 0

; ----------------------
; 'mirims' Mirror Images
; ----------------------
;	Runs through a null terminated list of image pointers, takes each
;	image and builds its right side by mirroring its left side.
;
; In	HL address of a table of pointer to Images.

mirims	ld e,(hl)
	inc hl
	ld d,(hl)
	inc hl
	ld a,d
	or e
	ret z
	push hl
	ex de,hl
	call mirror
	pop hl
	jr mirims

; ----------------------------
; 'preimt' Prepare Image Table
; ----------------------------
;	Prepares an Image Table. Takes the first image, copies into the second
;	with one extra column on the right, shifts one pixel left this second
;	one and builds the rest each one shifted one more position to the
;	right.
;
; In	HL Image Table pointer.

preimt

; Set IX as Image Table.

	push hl
	pop ix

; Get first image address.

	ld e,(hl)
	inc hl
	ld d,(hl)
	ex de,hl

; Expand first image into second.

	inc ix
	inc ix
	ld e,(ix+0)
	ld d,(ix+1)
	push de
	ld a,1
	call cppad
	pop hl

; Rotate once, then copy and rotate.

	ld b,7
	push bc
	jr preimt1

; Copy.

preimt2	push bc
	inc ix
	inc ix
	ld e,(ix+0)
	ld d,(ix+1)
	push de
	xor a
	call cppad
	pop hl

; Rotate.

preimt1	push hl
	call rotar
	pop hl
	pop bc
	djnz preimt2
	ret

; ---------------
; 'mirror' Mirror
; ---------------
;	Mirrors the left side of an image into the left side.
;
; In	HL image address.

mirror	

; Load A,C height, width.

	ld c,(hl)
	inc hl
	ld a,(hl)
	inc hl

; BC is width.

	ld b,0

; Save height counter and first position in line.

mirror3	push af
	push hl

; Point DE to first byte in line, HL to last.

	ld d,h
	ld e,l
	add hl,bc
	dec hl

; Bytes to mirror on a line in B (careful when width is odd).

	push bc
	ld a,c
	or a
	rra
	ld b,a

; Mirror line.

mirror2	push bc
	ld a,(de)
	inc de
	ld b,8
mirror1	rlca
	rr c
	djnz mirror1
	ld (hl),c
	dec hl
	pop bc
	djnz mirror2
	pop bc

; Go to next line.

	pop hl
	add hl,bc
	pop af
	dec a
	jr nz,mirror3
	ret

; -------------------------
; 'cppad' Copy with padding
; -------------------------
;	Copies one image src into image dst. Height of the src
;	must be less or equal than the width of dst.
;	The width of the dst image must equal the width src image if
;	we are copying, or it has to be the width of src plus one if we
;	want padding.
;
; In	HL source image. DE dest image.
;	A 0 for copy, 1 for copying with padding.
; Saves	A.

cppad

; Take width and height of source.

	ld c, (hl)
	inc hl
	ld b, (hl)
	inc hl

; Point to dest image data.

	inc de
	inc de

; Put a 0 in A'.

	ex af,af'
	xor a
	ex af,af'

; Copy all lines.

cppad1	push bc
	ld b,0
	ldir
	or a
	jr z,cppad2

; Put a 0 on last row byte if padding.

	ex af,af'
	ld (de),a
	inc de
	ex af,af'

; For all rows.

cppad2	pop bc
	djnz cppad1
	ret

; --------------------
; 'rotar' Rotate Right
; --------------------
;	Shifts an image one pixel to the right.
;
; In	HL Image address.

rotar

; Load B width, C height.

	ld b,(hl)
	inc hl
	ld c,(hl)
	inc hl

; Shift each line to the right.

	ld a,b
rotar2	or a
rotar1	rr (hl)
	inc hl
	djnz rotar1
	ld b,a
	dec c
	jr nz,rotar2
	ret

; -----------------------
; 'flipv' Vertically flip
; -----------------------
;	Flips and image vertically.
;
; In	HL Image address.

flipv	ld c,(hl)	
	inc hl
	ld b,(hl)
	inc hl

; If only one row, nothing to do.

	ld a,1
	cp b
	ret z

; Point DE to start of last image row.

	push hl
	ld a,b
	ld d,0
	ld e,c
	jr flipv3
flipv2	add hl,de
flipv3	dec a
	jr nz,flipv2
	ex de,hl
	pop hl

; How many lines to swap?

	srl b

; Swap one line.

flipv4	push bc
	ld b,c
flipv1	ld c,(hl)
	ld a,(de)
	ld (hl),a
	ld a,c
	ld (de),a
	inc hl
	inc de
	djnz flipv1
	pop bc

; All lines served.

	dec b
	ret z

; Go to next lines.
; HL already pointing to next line. Fix DE.

	push hl
	ex de,hl
	ld d,0
	ld e,c
	xor a
	sbc hl,de
	sbc hl,de
	ex de,hl
	pop hl
	jr flipv4

