#include <avr/io.h>

#define KBOUT PORTD
#define KBIN PIND
#define KBDDR DDRD
#define BTN1 1
#define BTN2 2
#define BTN3 3

volatile unsigned char kb_on;

void init_kb(void)
{
	KBOUT |= (1<<BTN1)|(1<<BTN2)|(1<<BTN3);
	KBDDR &= ~((1<<BTN1)|(1<<BTN2)|(1<<BTN3));
	kb_on = 0;
}

unsigned char get_key(void)
{
	unsigned char data;
	data = KBIN | ~((1<<BTN1)|(1<<BTN2)|(1<<BTN3));
	if((data != 0xFF) && (kb_on==0))
	{
		kb_on=1;
		data=data >> 1;
		data = data | 0x80;
		return ~data;
	}
	if(data == 0xFF) 	kb_on=0;		
	return 0;
}