#**************************************************************
# Time Information
#**************************************************************

set_time_format -unit ns -decimal_places 3

#**************************************************************
# Create Clock
#**************************************************************

create_clock -name {clk_50} -period 20.000 -waveform { 0.000 0.500 } [get_ports {clk50mhz}]

#**************************************************************
# Create Generated Clock
#**************************************************************

derive_pll_clocks
create_generated_clock -name sd1clk_pin -source [get_pins {clockmaker|vector_xtal|altpll_component|pll|clk[2]}] [get_ports {DRAM_CLK}]

#**************************************************************
# Set Clock Uncertainty
#**************************************************************

derive_clock_uncertainty;

#**************************************************************
# Set Input Delay
#**************************************************************

set_input_delay -clock sd1clk_pin -max 6.0 [get_ports DRAM_DQ*]
set_input_delay -clock sd1clk_pin -min 1.0 [get_ports DRAM_DQ*]

#**************************************************************
# Set Output Delay
#**************************************************************

set_output_delay -clock sd1clk_pin -max 1.5 [get_ports DRAM_*]
set_output_delay -clock sd1clk_pin -min -0.8 [get_ports DRAM_*]

