
// Standard Input/Output functions
#include <stdio.h>
#include <intrz80.h>
#include <string.h>
#include "conio.h"


extern unsigned char * SCR_XY2PTR(void);
extern unsigned char * ATTR_XY2PTR(void);
//extern void gotoxy(char x, char y);
extern void _low_put_scr(unsigned char);
extern unsigned char curs_x,curs_y,curs_c;

const unsigned char cp866[128] = {
	0x3F, 0x3F, 0x27, 0x3F, 0x22, 0x3A, 0xC5, 0xD8, 0x3F, 0x25, 0x3F, 0x3C, 0x3F, 0x3F, 0x3F, 0x3F, 
	0x30, 0x3F, 0x27, 0x27, 0x22, 0x22, 0x07, 0x2D, 0x2D, 0x54, 0x3F, 0x3E, 0x3F, 0x3F, 0x3F, 0x3F, 
	0xFF, 0xF6, 0xF7, 0x3F, 0xFD, 0x3F, 0xB3, 0x15, 0xF0, 0x63, 0xF2, 0x3C, 0xBF, 0x2D, 0x52, 0xF4, 
	0xF8, 0x2B, 0x3F, 0xB3, 0x3F, 0xE7, 0x14, 0xFA, 0xF1, 0xFC, 0xF3, 0x3E, 0x3F, 0x3F, 0x3F, 0xF5, 
	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F, 
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D, 0x9E, 0x9F, 
	0xA0, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF, 
	0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF
};                 
// keyboard scan codes (without & with shift key pressed)


const unsigned char scodes[] = {
//	0x0 0x1 0x2 0x3 0x4 0x5 0x6 0x7 0x8 0x9 0xa 0xb 0xc 0xd 0xe 0xf
//	  0, F9,  0, F5, F3, F1, F2,F12,  0,F10, F8, F6, F4,TAB,'`',  0,
	  0, 76,  0, 72, 70, 68, 69, 79,  0, 77, 75, 73, 71, 67, 33,  0, //0x00
//	  0,  0,  0,  0,  0,'q','1',  0,  0,  0,'z','s','a','w','2',  0, 
	  0,  0,  0,  0,  0, 17, 39,  0,  0,  0, 26, 19,  1, 23, 40,  0, //0x10
//	  0,'c','x','d','e','4','3',  0,  0,' ','v','f','t','r','5',  0, 
	  0,  3, 24,  4,  5, 42, 41,  0,  0, 48, 22,  6, 20, 18, 43,  0, //0x20
//	  0,'n','b','h','g','y','6',  0,  0,  0,'m','j','u','7','8',  0, 
	  0, 14,  2,  8,  7, 25, 44,  0,  0,  0, 13, 10, 21, 45, 46,  0, //0x30
//	  0,',','k','i','o','0','9',  0,  0,'.','/','l',';','p','-',  0, 
	  0, 31, 11,  9, 15, 38, 47,  0,  0, 32, 35, 12, 29, 16, 36,  0, //0x40
//	  0,  0,  ',  0,'[','=',  0,  0,  0,  0,ENT,']',  0,  \,  0,  0,
	  0,  0, 30,  0, 27, 37,  0,  0,  0,  0, 49, 28,  0, 34,  0,  0, //0x50
//	  0,  0,  0,  0,  0,  0, BS,  0,  0,'1',  0,'4','7',  0,  0,  0,
	  0,  0,  0,  0,  0,  0,127,  0,  0, 51,  0, 54, 57,  0,  0,  0, //0x60
//	'0','.','2','5','6','8',ESC,  0,F11,'+','3','-','*','9',  0,  0,
	 50, 65, 52, 55, 56, 58, 66,  0, 78, 64, 53, 63, 62, 59,  0,  0, //0x70
//	  0,  0,  0, F7		 								
	  0,  0,  0, 74};		 								


const unsigned char unmod[] = " \n0123456789 /*-+.";
const unsigned char stand[] = "[];\',.`\\/-="; 
const unsigned char stand_sh[] = "{}:\"<>~|?_+)!@#$%^&*(";
const unsigned char rust[] = {
	'','','','','','','','',
	'','','','','','','','',
	'','','','','','','','',
	'',''+1,'','','','','','',
	'','\\','.','-','='};
const unsigned char rust_sh[] = "ި/,_+)!\";%:?*(";

static unsigned char is_up=0, shift = 0, mode = 0, rus=0, alt=0;

#define KEY_MODE_NONE	0x00
#define KEY_MODE_RUS	0x01
#define KEY_MODE_SHIFT	0x02
#define KEY_MODE_ALT	0x04
#define KEY_MODE_CTRL	0x08
#define KEY_MODE_UP		0x10
#define KEY_MODE_E0		0x20

static unsigned int cur_key=0;

static unsigned char save_page;
static unsigned char save_bits;

static unsigned char inv=0;
void set_txt_page(void){
	save_page=input(0x05be);
	save_bits=(save_page&0x3f) | ((input(0x08be) & 0x20)|((input(0x09be)&0x20)<<1))<<1;
  	output(0x7ff7,0x77);
}
void res_txt_page(void){
  	output(0x7ff7,save_bits);
  	if(save_bits&0x40)output(0x77f7,save_page);
}
void DelayMs(unsigned char nFactor)   
{    
   
    while(nFactor--)   
    {   
    	unsigned int j=0x012c;   
        while(j--);  
    } 
} 
//***********************************************
// decode scan code
unsigned char get_scan(void)
{
	unsigned char sc;
    output(0xdef7,0xf0);
    sc=input(0xbef7);
    if(sc==0xff){
      set_evo_rtc(0x0c,1);
      sc = 0;
    }
    return sc;
}
int decode(unsigned char sc) {
   	if (!(mode&KEY_MODE_UP)){
      	switch (sc) {
         case 0xF0 :// The up-key identifier
            mode|=KEY_MODE_UP;
            break;
         case 0x12 :// Left SHIFT 
         case 0x59 :// Right SHIFT
            mode|=KEY_MODE_SHIFT;
            if(mode&KEY_MODE_ALT)
            	mode^=KEY_MODE_RUS;
            mode&=~KEY_MODE_E0;
            break;
         case 0x11 :// Alt  
            mode=(mode|KEY_MODE_ALT)&(~KEY_MODE_E0);
            if(mode&KEY_MODE_SHIFT)
            	mode^=KEY_MODE_RUS;
            break;
         case 0xe0 :
            mode|=KEY_MODE_E0;
            break;
         default:
            if(mode&KEY_MODE_E0){
            	mode&=~KEY_MODE_E0;
            	return 0x0100|sc;
            }
            sc=scodes[sc];
            if(!sc) return 0;
            else if (sc>65) return sc;
            else if (sc>47) return unmod[sc-48];
            //sc--;
            switch(mode&(KEY_MODE_RUS|KEY_MODE_SHIFT)){
         		case KEY_MODE_NONE :
         			if(sc<27)return (sc+'a'-1);
         			else if (sc>37) return (sc+'0'-38);
            		return stand[sc-27];
         		case KEY_MODE_SHIFT :
         			if(sc<27)return (sc+'A'-1);
            		return stand_sh[sc-27];
         		case KEY_MODE_RUS :
         			if(sc<38)return rust[sc-1];
         			return (sc+'0'-38);
         		case (KEY_MODE_SHIFT|KEY_MODE_RUS) :
            		return rust_sh[sc-1];
            }
   		}
   }
   else {
      switch (sc) {
         case 0x12 :// Left SHIFT
            mode&=~KEY_MODE_SHIFT;
            break;
         case 0xe0 :
            return 0;
         case 0x59 :// Right SHIFT
            mode&=~KEY_MODE_SHIFT;
            break;
         case 0x11 :// Alt 
            mode&=~KEY_MODE_ALT;
            break;
      }
      mode&=~(KEY_MODE_UP|KEY_MODE_E0);// Two 0xF0 in a row not allowed
   }
   return 0;
}                                               

int _kbhit(void)
{
	if (cur_key) return cur_key;
	
    if(!(cur_key=get_scan())) return 0;
    
    cur_key=decode(cur_key);
    return cur_key;
}

int getchar(void)
{
  int data;
  while (!cur_key)_kbhit();
  data=cur_key;
  cur_key=0;
  return data;
}
//------------------------------------------------------------------------
void clrscr(void)
{
  	output(0x7ff7,0x77);
    memset((char*)0x41c0,' ', 1664);
    memset((char*)0x51c0,' ', 1664);
    memset((char*)0x61c0,curs_c,1664);
    memset((char*)0x71c0,curs_c,1664);
	curs_x=curs_y=0;
  	output(0x7ff7,0x3f);
}

void clreol(void)
{
	unsigned char x=curs_x;
	while(curs_x!=80) _putch(' ');
	curs_x=x;
}

void gotoy(char y){
	curs_y=y;
}

void textcolor(unsigned char color){
	curs_c=(curs_c&0xf8)|(color&0x07);
}
void textbackground(unsigned char color){
	curs_c=(curs_c&0xc7)|((color&0x07)<<3);
}
void textattr(unsigned char color){
	curs_c=(color&0x07)|((color&0x70)>>1);
}
void _putch(unsigned char c) {

	if(c=='\r') {
		//curs_y++;
		curs_x=0;
	}
	else if(c=='\n') 
		curs_y++;
	else 
	{
  		//output(0x7ff7,0x77);
  		set_txt_page();
		_low_put_scr(c);
  		//output(0x7ff7,0x3f);
  		res_txt_page();
	}
}              


int putchar(int val)
{  
  if (val == '\n')		/* Convert EOL to CR/LF */
   _putch('\r');
  _putch(val);
  return val;
}        


void _puts(ROMDEF char *ptr){
	//char * ptr=(char *)s;
	while(*ptr){
		_putch(*ptr&0x80 ? cp866[*ptr&0x7f] : *ptr);
		ptr++;
	}
}

char * gets(char *str)  
{
	char *tstr=str;
	unsigned char tx=curs_x;
	while(curs_x!=80)
	{
		int ch=getchar();
		if(ch==127){
			if(curs_x==tx) continue;
			curs_x--;
			_putch(' ');
			curs_x--;
			tstr--;
			continue;
		}
		if(ch&0x0100) continue;
		if(curs_x==80) continue;
		_putch(ch&0x80 ? cp866[ch&0x7f] : ch);
		if (ch=='\n') break;
		*tstr=ch;
		tstr++;
		
	}
	*tstr=0;
	return str;
}
//---------------------------------------------------

void MCU_Init(void)
{                             
        output8(0xbf, 0);
        output(0xeff7,0);
        output8(0xbf, 1);
        output(0xff77,0x0f);
        output(0x7ff7,0x77);
        
        set_evo_rtc(0xf0,2);
        
  		output(0x7ff7,0x3f); 
  		enable_interrupt();         
}

void mcu_soft_reset(void)
{
	while(1);
} 

unsigned char get_evo_rtc(unsigned char addr)
{
	output(0xdef7,addr);
	return input(0xbef7);
}       
