
#ifndef _INC_CONIO
#define _INC_CONIO

#include <intrz80.h>
#define EVO_KEYB_REG    0x0f
#define set_evo_rtc(rtc_ad,rtc_val)     {output((unsigned short)0xdef7,rtc_ad); output((unsigned short)0xbef7,rtc_val);}
//#define get_evo_rtc(rtc_ad)             {output((unsigned short)0xdef7,rtc_ad); input((unsigned short)0xbef7);}


#if !defined(__COLORS)
#define __COLORS
// Compatible with DOS/WIN CONIO.H
enum COLORS {
    BLACK = 0,          /* dark colors */
    CYAN,
    RED,
    MAGENTA, 
    GREEN,
    BLUE,
    BROWN,
    LIGHTGRAY,
    DARKGRAY,       /* light colors */
    LIGHTCYAN,
    LIGHTRED,
    LIGHTMAGENTA,
    LIGHTGREEN,
    LIGHTBLUE,
    YELLOW,
    WHITE
};

#define BLINK 128
#endif

//defines max coordinates for checking overflow
#define MAX_X 80
#define MAX_Y 25

// Compatible with Unix Curses
#define ACS_ULCORNER	(0xDA)	/* upper left corner */
#define ACS_LLCORNER	(0xC0)	/* lower left corner */
#define ACS_URCORNER	(0xBF)	/* upper right corner */
#define ACS_LRCORNER	(0xD9)	/* lower right corner */
#define ACS_HLINE		(0xC4)	/* horizontal line */
#define ACS_VLINE		(0xB3)	/* vertical line */
#define ACS_LTEE		(0xc3)	/* tee pointing right */
#define ACS_RTEE		(0xb4)	/* tee pointing left */
#define ACS_BTEE		(0xc1)	/* tee pointing up */
#define ACS_TTEE		(0xc2)	/* tee pointing down */
#define ACS_PLUS		(0xc5)	/* large plus or crossover */
#define ACS_S1		(acs_map['o'])	/* scan line 1 */
#define ACS_S9		(acs_map['s'])	/* scan line 9 */
#define ACS_DIAMOND	(acs_map['`'])	/* diamond */
#define ACS_CKBOARD	(acs_map['a'])	/* checker board (stipple) */
#define ACS_DEGREE	(acs_map['f'])	/* degree symbol */
#define ACS_PLMINUS	(acs_map['g'])	/* plus/minus */
#define ACS_BULLET	(acs_map['~'])	/* bullet */
/* Teletype 5410v1 symbols begin here */
#define ACS_LARROW	(acs_map[','])	/* arrow pointing left */
#define ACS_RARROW	(acs_map['+'])	/* arrow pointing right */
#define ACS_DARROW	(acs_map['.'])	/* arrow pointing down */
#define ACS_UARROW	(acs_map['-'])	/* arrow pointing up */
#define ACS_BOARD	(acs_map['h'])	/* board of squares */
#define ACS_LANTERN	(acs_map['i'])	/* lantern symbol */
#define ACS_BLOCK	(acs_map['0'])	/* solid square block */

#define ROMDEF const


void _putch (unsigned char ch);	/* Writes a character directly to the console. */
int getchar (void); 	/* Reads a character directly from the console, without echo. */
int _kbhit (void);       /* Determines if a keyboard key was pressed.*/


/*
 Standard conio routines
 Hardware/architecture/compiler independent
*/
void _puts(ROMDEF char *s);		/* Outputs a string directly to the console. */
#define _cputs _puts
char* gets(char *s);                   /* Gets a string directly from the console.  */
//#define _cgets gets

void clrscr(void);
void clreol(void);

void _low_gotoxy(unsigned char x,unsigned char y);
#define gotoxy _low_gotoxy
void gotoy(char y);

//void cursoron(void);
#define cursoron()
//void cursoroff(void);
#define cursoroff()


void textcolor(unsigned char color);
//#define textcolor(c)
void textbackground(unsigned char color);
//#define textbackground(c)
void textattr(unsigned char attr);
//#define textattr(c)

#define _getch getchar

void MCU_Init(void);
void mcu_soft_reset(void);
unsigned char get_evo_rtc(unsigned char addr);
void kbd_read(void);  
void DelayMs(unsigned char nFactor); 
struct keybuffer{
	unsigned char * ptr;
	unsigned char buf[256];
};  


#endif  /* _INC_CONIO */
