#include <stdio.h>
#include <string.h>

#define MAX_LABELS 512
#define STR 128
#define PAR 128
#define OBJ 4096
#define DLN 260

#define CLEARSBUF strcpy((char *)tStr, "")
#define CLEARPBUF strcpy((char *)tPar, "")
#define CURADR tAdr-tOrg

int isHex(char *s)
{
  int i, iFlag = 1;
  for (i = 0; i < strlen(s); i++) if ((s[i] < '0' || s[i] > '9') && (s[i] < 'A' || s[i] > 'F') == 1) iFlag = 0;
  return iFlag;
}

int main(int argc, char *argv[])
{
  char *tStr[STR], *tPar[PAR], *termn;
  unsigned int tAdr, tOrg, i, j;
  short int tObj[OBJ], tFlag, gBt;
  int tLabCnt, tUnrCnt;
  FILE *in, *out;
  struct Labels
  {
    char *Lab[16];
    unsigned int Adr;
  } tLab[MAX_LABELS];
  struct Unres
  {
    char *Nam[16];
    unsigned int Loc;
  } tUnr[MAX_LABELS];
  struct Tokens
  {
    char *Tok[8];
    int Byt;
    short int Btln;
  } tTok[DLN] =
  {
    {"NOP"}, {"LXIB,"}, {"STAXB"}, {"INXB"}, {"INRB"}, {"DCRB"}, {"MVIB,"}, {"RLC"}, {"???"}, {"DADB"}, {"LDAXB"}, {"DCXB"}, {"INRC"}, {"DCRC"}, {"MVIC,"}, {"RRC"},
    {"???"}, {"LXID"}, {"STAXD"}, {"INXD"}, {"INRD"}, {"DCRD"}, {"MVID,"}, {"RAL"}, {"???"}, {"DADD"}, {"LDAXD"}, {"DCXD"}, {"INRE"}, {"DCRE"}, {"MVIE,"}, {"RAR"},
    {"???"}, {"LXIH"}, {"SHLD"}, {"INXH"}, {"INRH"}, {"DCRH"}, {"MVIH,"}, {"DAA"}, {"???"}, {"DADH"}, {"LHLD"}, {"DCXH"}, {"INRL"}, {"DCRL"}, {"MVIL,"}, {"CMA"},
    {"???"}, {"LXISP,"}, {"STA"}, {"INXSP"}, {"INRM"}, {"DCRM"}, {"MVIM,"}, {"STC"}, {"???"}, {"DADSP"}, {"LDA"}, {"DCXSP"}, {"INRA"}, {"DCRA"}, {"MVIA,"}, {"CMC"},
    {"MOVB,B"}, {"MOVB,C"}, {"MOVB,D"}, {"MOVB,E"}, {"MOVB,H"}, {"MOVB,L"}, {"MOVB,M"}, {"MOVB,A"}, {"MOVC,B"}, {"MOVC,C"}, {"MOVC,D"}, {"MOVC,E"}, {"MOVC,H"}, {"MOVC,L"}, {"MOVC,M"}, {"MOVC,A"},
    {"MOVD,B"}, {"MOVD,C"}, {"MOVD,D"}, {"MOVD,E"}, {"MOVD,H"}, {"MOVD,L"}, {"MOVD,M"}, {"MOVD,A"}, {"MOVE,B"}, {"MOVE,C"}, {"MOVE,D"}, {"MOVE,E"}, {"MOVE,H"}, {"MOVE,L"}, {"MOVE,M"}, {"MOVE,A"},
    {"MOVH,B"}, {"MOVH,C"}, {"MOVH,D"}, {"MOVH,E"}, {"MOVH,H"}, {"MOVH,L"}, {"MOVH,M"}, {"MOVH,A"}, {"MOVL,B"}, {"MOVL,C"}, {"MOVL,D"}, {"MOVL,E"}, {"MOVL,H"}, {"MOVL,L"}, {"MOVL,M"}, {"MOVL,A"},
    {"MOVM,B"}, {"MOVM,C"}, {"MOVM,D"}, {"MOVM,E"}, {"MOVM,H"}, {"MOVM,L"}, {"HLT"}, {"MOVM,A"}, {"MOVA,B"}, {"MOVA,C"}, {"MOVA,D"}, {"MOVA,E"}, {"MOVA,H"}, {"MOVA,L"}, {"MOVA,M"}, {"MOVA,A"},
    {"ADDB"}, {"ADDC"}, {"ADDD"}, {"ADDE"}, {"ADDH"}, {"ADDL"}, {"ADDM"}, {"ADDA"}, {"ADCB"}, {"ADCC"}, {"ADCD"}, {"ADCE"}, {"ADCH"}, {"ADCL"}, {"ADCM"}, {"ADCA"},
    {"SUBB"}, {"SUBC"}, {"SUBD"}, {"SUBE"}, {"SUBH"}, {"SUBL"}, {"SUBM"}, {"SUBA"}, {"SBBB"}, {"SBBC"}, {"SBBD"}, {"SBBE"}, {"SBBH"}, {"SBBL"}, {"SBBM"}, {"SBBA"},
    {"ANAB"}, {"ANAC"}, {"ANAD"}, {"ANAE"}, {"ANAH"}, {"ANAL"}, {"ANAM"}, {"ANAA"}, {"XRAB"}, {"XRAC"}, {"XRAD"}, {"XRAE"}, {"XRAH"}, {"XRAL"}, {"XRAM"}, {"XRAA"},
    {"ORAB"}, {"ORAC"}, {"ORAD"}, {"ORAE"}, {"ORAH"}, {"ORAL"}, {"ORAM"}, {"ORAA"}, {"CMPB"}, {"CMPC"}, {"CMPD"}, {"CMPE"}, {"CMPH"}, {"CMPL"}, {"CMPM"}, {"CMPA"},
    {"RNZ"}, {"POPB"}, {"JNZ"}, {"JMP"}, {"CNZ"}, {"PUSHB"}, {"ADI"}, {"RST0"}, {"RZ"}, {"RET"}, {"JZ"}, {"???"}, {"CZ"}, {"CALL"}, {"ACI"}, {"RST1"},
    {"RNC"}, {"POPD"}, {"JNC"}, {"OUT"}, {"CNC"}, {"PUSHD"}, {"SUI"}, {"RST2"}, {"RC"}, {"???"}, {"JC"}, {"IN"}, {"CC"}, {"???"}, {"SBI"}, {"RST3"},
    {"RPO"}, {"POPH"}, {"JPO"}, {"XTHL"}, {"CPO"}, {"PUSHH"}, {"ANI"}, {"RST4"}, {"RPE"}, {"PCHL"}, {"JPE"}, {"XCHG"}, {"CPE"}, {"???"}, {"XRI"}, {"RST5"},
    {"RP"}, {"POPPSW"}, {"JP"}, {"DI"}, {"CP"}, {"PUSHPSW"}, {"ORI"}, {"RST6"}, {"RM"}, {"SPHL"}, {"JM"}, {"EI"}, {"CM"}, {"???"}, {"CPI"}, {"RST7"},
    {"DB"}, {"DW"}, {"DS"}, {"END"}
  };
  short int tLen[DLN] =
  {
    1, 3, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1,
    1, 3, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1,
    1, 3, 3, 1, 1, 1, 2, 1, 1, 1, 3, 1, 1, 1, 2, 1,
    1, 3, 3, 1, 1, 1, 2, 1, 1, 1, 3, 1, 1, 1, 2, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 3, 3, 3, 1, 2, 1, 1, 1, 3, 3, 3, 3, 2, 1,
    1, 1, 3, 2, 3, 1, 2, 1, 1, 1, 3, 2, 3, 3, 2, 1,
    1, 1, 3, 1, 3, 1, 2, 1, 1, 1, 3, 1, 3, 3, 2, 1,
    1, 1, 3, 1, 3, 1, 2, 1, 1, 1, 3, 1, 3, 3, 2, 1,
    0, 0, 0, 0
  };
  for (i = 0; i < DLN; i++)
  {
    tTok[i].Byt = i;
    tTok[i].Btln = tLen[i];
  }
  printf("OnePassA v.01\n");
  if ((argv[1][0] == '?') || (argc != 4))
  {
    printf("Usage: onepassa <INFILENAME> <OUTFILENAME> <HEXORG>\n");
    return 0;
  }
  tOrg = (unsigned int)strtol(argv[3], &termn, 16);
  printf("ORG=%d (&h%x)\n", tOrg, tOrg);
  for (i = 0; i < OBJ; i++) tObj[i] = 0x0;
  for (i = 0; i < MAX_LABELS; i++) strcpy((char *)tLab[i].Lab, 0x00);
  for (i = 0; i < MAX_LABELS; i++) strcpy((char *)tUnr[i].Nam, 0x00);
  tAdr = tOrg;
  CLEARSBUF;
  CLEARPBUF;
  //for (i = 0; i < STR; i++) tStr[i] = 0x0;
  //for (i = 0; i < PAR; i++) tPar[i] = 0x0;
  printf("reading input file %s\n", argv[1]);
  if ((in = fopen(argv[1], "rb")) == NULL)
  {
    printf("Can't open input file %s to read\n", argv[1]);
    return -1;
  }
  printf("write to %s\n", argv[2]);
  if ((out = fopen(argv[2], "wt")) == NULL)
  {
    printf ("Can't open output file %s to write\n", argv[2]);
    return -2;
  }
  CLEARSBUF;
  tLabCnt = 0;
  tUnrCnt = 0;
  printf("-------------------------\n");
  while ((gBt = fgetc(in)) != EOF)
  {
    if (gBt == ':')
    {
      printf("tLab[%d].Lab = %s (&h%x)\n", tLabCnt, tStr, tAdr);
      strcpy((char *)tLab[tLabCnt].Lab, (char *)tStr);
      tLab[tLabCnt].Adr = tAdr;
      tLabCnt++;
      for (i = 0; i < tUnrCnt; i++)
      {
	if (strcmp((char *)tUnr[i].Nam, (char *)tStr) == 0)
	{
	  printf("tUnr[%d].Loc = %s - resolved\n", i, tUnr[i].Nam);
	  tObj[tUnr[i].Loc-tOrg] = (short int)(tAdr & 0x00FF);
	  tObj[tUnr[i].Loc+1-tOrg] = (short int)(tAdr >> 8);
	  strcpy((char *)tUnr[i].Nam, "\0");
	}
      }
      CLEARSBUF;
    }
    if (gBt == ';') while ((gBt = fgetc(in)) != '\n');
    if ((gBt != ' ') && (gBt != '\t') && (gBt != ':'))
    {
      gBt = toupper(gBt);
      strcat((char *)tStr, (char *)&gBt);
      if (strcmp((char *)tStr, "JP") == 0 || strcmp((char *)tStr, "CP") == 0 || strcmp((char *)tStr, "JM") == 0 || strcmp((char *)tStr, "CM") == 0)
      {
	if ((gBt = fgetc(in)) != ' ')
	{
	  gBt = toupper(gBt);
	  strcat((char *)tStr, (char *)&gBt);
	}
      }
      for (i = 0; i < DLN; i++)
      {
	if (strcmp((char *)tStr, *tTok[i].Tok) == 0)
	{
	  if (strcmp((char *)tStr, "END") == 0) goto E;
	  if (strcmp((char *)tStr, "DB") == 0)
	  {
	    CLEARSBUF;
	    while ((gBt = fgetc(in)) != '\n') strcat((char *)tStr, (char *)&gBt);
	    printf("%x DB=%x\n", tAdr, (short int)strtol(tStr, &termn, 16));
	    tObj[CURADR] = (short int)strtol(tStr, &termn, 16);
	    tAdr++;
	    CLEARSBUF;
	  }
	  else if (strcmp((char *)tStr, "DW") == 0)
	  {
	    CLEARSBUF;
	    while ((gBt = fgetc(in)) != '\n') strcat((char *)tStr, (char *)&gBt);
	    printf("%x DW=%x\n", tAdr, (unsigned int)strtol(tStr, &termn, 16));
	    j = (unsigned int)strtol(tStr, &termn, 16);
	    tObj[CURADR] = (short int)(j & 0x00FF);
	    tAdr++;
	    tObj[CURADR] = (short int)(j >> 8);
	    tAdr++;
	    CLEARSBUF;
	  }
	  else if (strcmp((char *)tStr, "DS") == 0)
	  {
	    CLEARSBUF;
	    gBt = fgetc(in);
	    printf("%x DS=", tAdr);
	    while ((gBt = fgetc(in)) != '\n')
	    {
	      if (gBt == ';')
	      {
		while ((gBt = fgetc(in)) != '\n');
		break;
	      }
	      printf("%c", gBt);
	      tObj[CURADR] = (short int)gBt;
	      tAdr++;
	    }
	    printf("\n");
	  }
	  else
	  {
	    if (tTok[i].Btln == 1)
	    {
	      printf("%x %s\n", tAdr, *tTok[i].Tok);
	      tObj[CURADR] = tTok[i].Byt;
	      tAdr++;
	      CLEARSBUF;
	      while ((gBt = getc(in)) != '\n');
	    }
	    else if (tTok[i].Btln == 2)
	    {
	      printf("%x %s ", tAdr, *tTok[i].Tok);
	      tObj[CURADR] = tTok[i].Byt;
	      tAdr++;
	      while ((gBt = getc(in)) != '\n')
	      {
		strcat((char *)tPar, (char *)&gBt);
	      }
	      printf("%x\n", (short int)strtol(tPar, &termn, 16));
	      tObj[CURADR] = (short int)strtol(tPar, &termn, 16);
	      tAdr++;
	      CLEARSBUF;
	      CLEARPBUF;
	    }
	    else if (tTok[i].Btln == 3)
	    {
	      printf("%x %s ", tAdr, *tTok[i].Tok);
	      tObj[CURADR] = tTok[i].Byt;
	      tAdr++;
	      while ((gBt = getc(in)) != '\n')
	      {
		if (gBt == ';')
		{
		  while ((gBt = fgetc(in)) != '\n');
		  break;
		}
		if (gBt > ' ')
		{
		  gBt = toupper(gBt);
		  strcat((char *)tPar, (char *)&gBt);
		}
	      }
	      if (isHex((char *)tPar) == 1)
	      {
		j = (unsigned int)strtol(tPar, &termn, 16);
		printf("%x\n", j);
		tObj[CURADR] = (short int)(j & 0x00FF);
		tAdr++;
		tObj[CURADR] = (short int)(j >> 8);
		tAdr++;
		CLEARSBUF;
		CLEARPBUF;
	      }
	      else
	      {
		tFlag = 0;
		for (j = 0; j < tLabCnt; j++)
		{
		  if (strcmp((char *)tLab[j].Lab, (char *)tPar) == 0)
		  {
		    printf("%x\n", tLab[j].Adr);
		    tObj[CURADR] = (short int)(tLab[j].Adr & 0x00FF);
		    tAdr++;
		    tObj[CURADR] = (short int)(tLab[j].Adr >> 8);
		    tAdr++;
		    CLEARSBUF;
		    CLEARPBUF;
		    tFlag = 1;
		  }
		}
		if (tFlag != 1)
		{
		  printf("\?\?\?\? (%s)\n", tPar);
		  strcat((char *)tUnr[tUnrCnt].Nam, (char *)tPar);
		  tUnr[tUnrCnt].Loc = tAdr;
		  tObj[CURADR] = 0x00;
		  tAdr++;
		  tObj[CURADR] = 0x00;
		  tAdr++;
		  tUnrCnt++;
		  CLEARSBUF;
		  CLEARPBUF;
		}
	      }
	    }
	  }
	}
      }
    }
  }
E:fclose(in);
  for (i = 0; i < CURADR; i++)
  {
    fprintf(out, "%c", tObj[i]);
  }
  fclose(out);
  printf("-------------------------\n");
  printf("Labels:\n");
  for (i = 0; i < tLabCnt; i++)
  {
    printf("tLab[%d] = %s (&h%x)\n", i, tLab[i].Lab, tLab[i].Adr);
  }
  printf("-------------------------\n");
  printf("Unresolved labels:\n");
  for (i = 0; i < tUnrCnt; i++)
  {
    if (strcmp((char *)tUnr[i].Nam, 0x00) != 0) printf("tUnr[%d] = %s (&h%x)\n", i, tUnr[i].Nam, tUnr[i].Loc);
  }
  printf("-------------------------\n");
  printf("Done!\n");
  return 0;
}