/* * * * * * * * * * * * * * * * * * * * * * * */
/*    TR-DOS  SDCC  		   */
/*     */
/* SDCC interface for TR-DOS functions         */
/* Absolutely free for noncommercial use	   */
/* (c) 2013 Amxgris/Red Triangle/Mother Russia */
/* * * * * * * * * * * * * * * * * * * * * * * */

#ifndef ts-ports
	#include <ts-ports.h>
#endif

//     , -   ""  
#define trdosFileOperationSign 0x5CF9
#define trdosFileLoadVerifySign 0x5d10
#define trdosFileName 0x5cdd
#define trdosCheckSymbolsNum 0x5d06
#define trdosDeletedFilesNum 0x5d07
#define trdosErrorCode 0x5d0f
#define trdosFoundFileNum 0x5d1e

//     ,    c  .
#define infbuffer 0x6000 //      TR-DOS  -     0x8000.   0x6000  0x7fff  
						 //  ,     -   ,   SDCC   .
#define infbuflen 0x1000 //      4 .
//       .						 
//---

//    TR-DOS:
struct trdosFDSP {
			 char  trFName[9]; //    
	unsigned char *trFStart;   // .  TR-DOS
	unsigned int   trFByteLen;
	unsigned char  trFSectLen;
	unsigned char  trFSector;
	unsigned char  trFTrack;};

//  :	
	
//  #01 TR-DOS:
// 				 drive name ('a','b','c','d'),    
void DriveSel(char); 

//  #00 TR-DOS:
void trdosInit(void);

//  #18 TR-DOS:
void DiskTune(void);

//  #05 TR-DOS:
// 						destptr, 	  track pos, 	 sector pos,    len in sectors
void ReadSectors(unsigned char*, unsigned char, unsigned char, unsigned char);

//  #08 TR-DOS:
// 					  destptr, 	       file number
void ReadFileDSP(unsigned char *, unsigned char);

//  #06 TR-DOS:
// 						srctptr, 	  track pos, 	 sector pos,    len in sectors
void WriteSectors(unsigned char*, unsigned char, unsigned char, unsigned char);

//  #09 TR-DOS:
// 					   srctptr, 	    file number
void WriteFileDSP(unsigned char *, unsigned char);

//  #0A TR-DOS:
//							name ptr  name len
unsigned char FindFile(char *, unsigned char);

//  #0B TR-DOS:
//					name ptr	data ptr		 file data len
void WriteFile(char *,		unsigned char *, unsigned int);

//  #12 TR-DOS:
//					FDSP ptr
void EraseFile(char *);
//  #0E TR-DOS, (23801) = 0:
//					name ptr	dest ptr	  file data len
void LoadFile	(char *, unsigned char *, unsigned int);

// ..      .
//							dst_pg		  src_trck		src_sector	   sectors
void ReadSectorsDMA(unsigned char, unsigned char, unsigned char, unsigned int);

// ..    5-     ,
// ..,  TR-DOS.    CPU0  1     
void CloseTRDOS()

// ..    5-     ,
// ..,  TR-DOS,          . :)
void OpenTRDOS()

#define TR_DOS 1