#include <stdio.h>
#include <string.h>
#include "integer.h"

/***********************************************************************************
 *                                                                                 *
 *    ,              *
 * wildcards,             *
 *   .                                                             *
 *                                                                                 *
 * :  "*"                                              *
 *          "?"                                                 *
 *                                                                                 *
 *         ,      *
 *     .  , : "*"   :  *
 * "*"  "?",     : "".    *
 * wildcards    .                                                  *
 ***********************************************************************************/

BOOL Res;

BOOL Identical (char* FLine, char* SLine)
{
  if ((strcmp(FLine, "*")==0) || (strcmp(SLine, "*")==0) || (strcmp(FLine, SLine)==0))
    return TRUE;
  else
    return FALSE;
}

BOOL Different (char* FLine, char* SLine)
{
  BOOL Diff = FALSE;
  if ((FLine[0]!=0) && (SLine[0]!=0)) {
     if ((FLine[0]!='*') && (SLine[0]!='*') &&
         (FLine[0]!='?') && (SLine[0]!='?') &&
         (FLine[0]!=SLine[0])) Diff = TRUE;
  } else {
    if ((FLine[0]==0) && (strcmp(SLine, "*") != 0)) Diff = TRUE;
    if ((SLine[0]==0) && (strcmp(FLine, "*") != 0)) Diff = TRUE;
  }
  return Diff;
}

BOOL WildCompare (char* FLine, char* SLine)
{
  int k;

  if (Identical(FLine,SLine)) return TRUE;

  if (Different(FLine,SLine)) return FALSE;

  if (FLine[0] == '*') 
    for (k=0; k<strlen(SLine); k++) 
      if ((SLine[k]=='*') || (SLine[k]==FLine[1]) || (SLine[k]=='?'))
        Res = Res || WildCompare((char*)(FLine+1), (char*)(SLine+k));

  if (SLine[0] == '*') 
    for (k=0; k<strlen(FLine); k++)
      if ((FLine[k]=='*') || (FLine[k]==SLine[1]) || (FLine[k]=='?'))
        Res = Res || WildCompare((char*)(FLine+k), (char*)(SLine+1));

  if ((FLine[0] != '*') && (SLine[0] != '*') &&
      ((FLine[0] == SLine[0]) || ((FLine[0]=='?') || (SLine[0]=='?')))) 
    Res = Res || WildCompare((char*)(FLine+1), (char*)(SLine+1));
  return Res;
}

char* DoResultLine (char* TLine)
{
  int i = 0;

  while (i<strlen(TLine))
    if (( (TLine[i]=='*')&&(TLine[i+1]=='*') ) ||
        ( (TLine[i]=='*')&&(TLine[i+1]=='?') ) ||
        ( (TLine[i]=='?')&&(TLine[i+1]=='*') ) ) {
      TLine[i]=0;
      strcat(strcat(TLine, "*"), (char*)(TLine+i+2));
      i = 0;
    }
    else i++;
  return TLine;
}

BOOL WildStringCompare(char* Str1, char* Str2)
{
  char FirstString[255], SecondString[255];

  Res = FALSE;
  strcpy(FirstString,  Str1);
  strcpy(SecondString, Str2);
  return WildCompare(DoResultLine(FirstString), DoResultLine(SecondString));
}

