#ifndef _FDISK2

#include <stdio.h>
#include "integer.h"

/* derived from FatFs */

#define BS_FilSysType		54
#define BS_55AA			510
#define BPB_ExtFlags		40
#define BS_FilSysType32		82
#define MBR_PART_TYPE		4

/*
#define DEBUG_FDISK
*/

#define O_RDWR   1
#define O_RDONLY 2
#define O_CREAT  4

#define _DRIVES 2	/* Master,Slave */

#define pt_size 66	/* Partition Table Size in Bytes */
#define bc_size 446	/* Boot Code Size in Bytes */
#define sector_size 512	/* Sector Size in Bytes */

/* Definitions for the menus */
#define MM   0x00       /* Main Menu                     */

#define CP   0x10         /* Create partition             */

#define CPF  0x11           /* Create Primary FAT Partition */
#define CPC  0x12           /* Create Primary CPM Partition */
#define CPFF 0x13           /* Create FAT filesystem on Partition */
#define CPCF 0x14           /* Create CPM filesystem on Partition */
#define CPCS 0x15           /* Sysgen CPM from a file */

#define SAP  0x20         /* Set Active Partition          */

#define DP   0x30         /* Delete partition or LDD       */

#define MBR  0x40         /* MBR Functions                 */

#define BMBR 0x41           /* Write standard MBR to drive */
#define FMBR 0x42           /* Create MBR using the file   */
#define SMBR 0x43           /* Save MBR to file            */
#define RMBR 0x44           /* Remove MBR from disk        */

#define CD   0x50         /* Change Drive                  */


int cpm_copy(char **argv);	/* copy [count] sectors from beginning of [Source] to [Destination]*/

typedef struct {
  BOOL  IsDrv;  	/* TRUE=DRIVE, FALSE=CPM_file  */
  FILE* fileCPM;	/* CP/M file descriptor */
  int   drive;  	/* IDE drive = (0,1) */
  DWORD LBAbeg;		/* partition begin offset for IDE drive */
  DWORD LBAsize;	/* partition size in 512b blocks */
  DWORD LBAaddr;	/* partition current offset for IDE drive */
} DFILE;

void xmenu();

int dopen(char* path, int mode);                                   /* MBR/partition or file open*/
int dclose(int FileObject);                                        /* file close*/
int dread(int FileObject, BYTE* buffer, int sec_size);             /* partition or file read  */
int dwrite(int FileObject, BYTE* buffer, int sec_size, int val);   /* partition or file write */
int pread(int FileObject, BYTE* buffer, int sec_size);             /* MBR or file read */
int pwrite(int FileObject, BYTE* buffer, int sec_size, int val);   /* MBR or file write */
void FillPartitionBufCHS(BYTE* buf, WORD bh, WORD bs, WORD bc, WORD eh, WORD es, WORD ec);
void CheckIDE();
void bc_hexdump(BYTE* buf);

DWORD strtoul(char* st, char* endptr, int base);
char UpCase(char ch);
void bcopy(BYTE* src, BYTE* dst, int cnt);

#define _FDISK2
#endif

